@extends('layouts.dashboard.superadminapp')

@section('title', 'RFQ Registration')

@section('styles')
<style>
    .section-card {
        border: none;
        border-radius: 0.5rem;
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.1);
        margin-bottom: 1.5rem;
    }
    .section-card .card-header {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
        color: #fff;
        font-weight: 600;
        padding: 0.75rem 1rem;
        border-radius: 0.5rem 0.5rem 0 0 !important;
    }
    .section-card .card-header.bg-info-gradient {
        background: linear-gradient(135deg, #36b9cc 0%, #258391 100%);
    }
    .section-card .card-header.bg-success-gradient {
        background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
    }
    .section-card .card-header.bg-warning-gradient {
        background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%);
    }
    .form-label {
        font-weight: 600;
        color: #5a5c69;
        font-size: 0.85rem;
        margin-bottom: 0.25rem;
    }
    .required-star {
        color: #e74a3b;
    }
    .material-row {
        background: #f8f9fc;
        border: 1px solid #e3e6f0;
        border-radius: 0.5rem;
        padding: 0.5rem 0.75rem;
        margin-bottom: 0.5rem;
    }
    .material-row .input-group {
        align-items: center;
    }
    .material-row .form-control {
        border-radius: 0.35rem 0 0 0.35rem !important;
    }
    .material-row .input-group-append {
        margin-left: -1px;
        margin-top: -50px;
    }
    .material-row .input-group-append .btn {
        border-radius: 0 0.35rem 0.35rem 0 !important;
        height: 38px;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .file-preview {
        display: flex;
        flex-wrap: wrap;
        gap: 0.5rem;
        margin-top: 0.5rem;
    }
    .file-preview img {
        max-width: 100px;
        max-height: 80px;
        border-radius: 0.25rem;
        border: 1px solid #e3e6f0;
    }
    .file-preview a {
        font-size: 0.8rem;
    }
</style>
@endsection

@section('content')
    <!-- Page Heading -->
    <div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h5 mb-0 text-gray-800">UEPL | Request For Quotation</h1>
        <div class="display-date">
            <span id="day">day</span>,
            <span id="daynum">00</span>
            <span id="month">month</span>
            <span id="year">0000</span>
        </div>
        <div class="display-time"></div>
    </div>

    <!-- Alerts -->
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif
    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle mr-2"></i>{{ session('error') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif
    @if ($errors->any())
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <strong><i class="fas fa-exclamation-triangle mr-2"></i>Please fix the following errors:</strong>
            <ul class="mb-0 mt-2">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <form id="rfqform" action="{{ route('superadmin.salesbom.rfq.store') }}" method="POST" enctype="multipart/form-data">
        @csrf

        <!-- Basic Information Card -->
        <div class="card section-card">
            <div class="card-header">
                <i class="fas fa-file-alt mr-2"></i>RFQ Basic Information
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3 mb-3">
                        <label class="form-label">RFQ ID <span class="required-star">*</span></label>
                        <input type="text" id="rfqNo" name="rfqNo" class="form-control" required readonly>
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="form-label">RFQ Date <span class="required-star">*</span></label>
                        <input type="date" id="rfqDate" name="rfqDate" class="form-control" required>
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Customer <span class="required-star">*</span></label>
                        <select id="customer" name="customer" class="form-control" required>
                            <option value="">Select Customer</option>
                            @foreach ($customers as $customer)
                                <option value="{{ $customer->id }}">{{ $customer->company }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Customer Ref. No</label>
                        <input type="text" id="cusRefNo" name="cusRefNo" class="form-control" placeholder="Reference number">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-3 mb-3">
                        <label class="form-label">RFQ Type <span class="required-star">*</span></label>
                        <select id="rfqType" name="rfqType" class="form-control" required>
                            <option value="">Select RFQ Type</option>
                            @foreach($rfqTypes as $type)
                                <option value="{{ $type->rfqtype }}">{{ $type->rfqtype }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Product Type <span class="required-star">*</span></label>
                        <select id="productType" name="productType" class="form-control" required>
                            <option value="">Select Product</option>
                            @foreach($productTypes as $type)
                                <option value="{{ $type->name }}">{{ $type->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Part No</label>
                        <input type="text" id="partNo" name="partNo" class="form-control" placeholder="Part number">
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Project/Material No</label>
                        <input type="text" id="project-materialNo" name="project_materialNo" class="form-control" placeholder="Project/Material number">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Description</label>
                        <input type="text" id="description" name="description" class="form-control" placeholder="Item description">
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Quantity <span class="required-star">*</span></label>
                        <input type="number" id="quantity" name="quantity" class="form-control" required min="1" placeholder="Enter quantity">
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="form-label">UOM <span class="required-star">*</span></label>
                        <input type="text" id="uom" name="uom" class="form-control" required placeholder="Unit of measure">
                    </div>
                </div>
            </div>
        </div>

        <!-- Drawing Details Card -->
        <div class="card section-card">
            <div class="card-header bg-info-gradient">
                <i class="fas fa-drafting-compass mr-2"></i>Drawing Details
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4 mb-3">
                        <label class="form-label">Drawing No</label>
                        <input type="text" id="drawingNo" name="drawingNo" class="form-control" placeholder="Drawing number">
                    </div>
                    <div class="col-md-4 mb-3">
                        <label class="form-label">Drawing Revision</label>
                        <input type="text" id="drawingRev" name="drawingRev" class="form-control" placeholder="Revision">
                    </div>
                    <div class="col-md-4 mb-3">
                        <label class="form-label">Drawing Files</label>
                        <input type="file" id="drawingFiles" name="drawingFiles[]" class="form-control" multiple accept=".pdf,image/*">
                        <div id="drawingFiles_preview" class="file-preview"></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Attachments Card -->
        <div class="card section-card">
            <div class="card-header bg-warning-gradient">
                <i class="fas fa-paperclip mr-2"></i>Attachments
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4 mb-3">
                        <label class="form-label">Material Specification Files</label>
                        <input type="file" id="materialSpecificationFiles" name="materialSpecificationFiles[]" class="form-control" multiple accept=".pdf,image/*">
                        <div id="materialSpecificationFiles_preview" class="file-preview"></div>
                    </div>
                    <div class="col-md-4 mb-3">
                        <label class="form-label">RFQ Form Files</label>
                        <input type="file" id="rfqFormFiles" name="rfqFormFiles[]" class="form-control" multiple accept=".pdf,image/*">
                        <div id="rfqFormFiles_preview" class="file-preview"></div>
                    </div>
                    <div class="col-md-4 mb-3">
                        <label class="form-label">Annexure Files</label>
                        <input type="file" id="annexureFiles" name="annexureFiles[]" class="form-control" multiple accept=".pdf,image/*">
                        <div id="annexureFiles_preview" class="file-preview"></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Raw Materials Card -->
        <div class="card section-card">
            <div class="card-header bg-success-gradient">
                <i class="fas fa-cubes mr-2"></i>Raw Materials <span class="required-star">*</span>
            </div>
            <div class="card-body">
                <div id="materials-wrapper">
                    <div class="material-row">
                        <div class="input-group">
                            <select name="rawmaterials[]" class="form-control raw-material-select" required>
                                <option value="">Select Raw Material</option>
                            </select>
                            <div class="input-group-append">
                                <button type="button" class="btn btn-danger remove-material" title="Remove">
                                    <i class="fas fa-trash-alt"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="mt-3">
                    <button type="button" id="add-material" class="btn btn-primary btn-sm">
                        <i class="fas fa-plus mr-1"></i> Add Material
                    </button>
                    <button type="button" class="btn btn-outline-secondary btn-sm ml-2" data-toggle="modal" data-target="#addRawMaterialModal">
                        <i class="fas fa-plus-circle mr-1"></i> New Raw Material
                    </button>
                </div>
            </div>
        </div>

        <!-- Notes Card -->
        <div class="card section-card">
            <div class="card-header" style="background: linear-gradient(135deg, #858796 0%, #60616f 100%);">
                <i class="fas fa-sticky-note mr-2"></i>Additional Notes
            </div>
            <div class="card-body">
                <textarea id="note" name="note" class="form-control" rows="3" placeholder="Any additional notes or comments..."></textarea>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="d-flex justify-content-between mb-4">
            <a href="{{ route('superadmin.salesbom.rfq.rfqdetails') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left mr-1"></i> Back to List
            </a>
            <div>
                <button class="btn btn-danger mr-2" type="reset" id="clearBtn">
                    <i class="fas fa-undo mr-1"></i> Clear
                </button>
                <button class="btn btn-success" type="submit" id="submitBtn">
                    <span class="spinner-border spinner-border-sm d-none" role="status" id="submitSpinner"></span>
                    <i class="fas fa-save mr-1" id="submitIcon"></i>
                    <span id="submitText">Save RFQ</span>
                </button>
            </div>
        </div>
    </form>

    <!-- Modal for Adding Raw Material -->
    <div class="modal fade" id="addRawMaterialModal" tabindex="-1" aria-labelledby="addRawMaterialLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <form id="addRawMaterialForm">
                <div class="modal-content border-0 shadow">
                    <div class="modal-header py-2 bg-success text-white">
                        <h6 class="modal-title mb-0">
                            <i class="fas fa-plus-circle mr-2"></i>Add New Raw Material
                        </h6>
                        <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                            <span>&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group mb-3">
                            <label class="form-label">Raw Material Name <span class="required-star">*</span></label>
                            <input type="text" name="name" class="form-control" required placeholder="Enter material name">
                        </div>
                        <div class="form-group mb-3">
                            <label class="form-label">ISO Specification <span class="required-star">*</span></label>
                            <input type="text" name="iso_specification" class="form-control" required placeholder="ISO specification">
                        </div>
                        <div class="form-group mb-3">
                            <label class="form-label">Material Density</label>
                            <input type="text" name="density" class="form-control" placeholder="Density (optional)">
                        </div>
                        <div class="form-group mb-0">
                            <label class="form-label">Mechanical Properties</label>
                            <input type="text" name="mechanical_properties" class="form-control" placeholder="Mechanical properties (optional)">
                        </div>
                    </div>
                    <div class="modal-footer py-2 bg-light">
                        <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-success btn-sm" id="addMaterialBtn">
                            <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                            <span class="btn-text">Add Material</span>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    // Set today's date
    const today = new Date();
    const formattedDate = today.toISOString().split('T')[0];
    $('#rfqDate').val(formattedDate);

    // Generate RFQ ID
    $.ajax({
        url: "{{ route('superadmin.salesbom.rfq.generateId') }}",
        method: 'GET',
        success: function(response) {
            $('#rfqNo').val(response.rfqId);
        },
        error: function() {
            showToast('error', 'Failed to generate RFQ ID.');
        }
    });

    // Load raw materials
    function loadRawMaterials(select = null, callback = null) {
        $.get('{{ route('superadmin.salesbom.rawmaterials.list') }}', function(data) {
            $('.raw-material-select').each(function() {
                var selectedVal = $(this).val();
                $(this).empty().append('<option value="">Select Raw Material</option>');
                $.each(data, function(_, mat) {
                    $(this).append(
                        `<option value="${mat.id}" ${selectedVal == mat.id ? 'selected' : ''}>${mat.rm_grade} (${mat.iso_specification})</option>`
                    );
                }.bind(this));
                if (selectedVal) $(this).val(selectedVal);
            });
            if (select) {
                $(select).empty().append('<option value="">Select Raw Material</option>');
                $.each(data, function(_, mat) {
                    $(select).append(
                        `<option value="${mat.id}">${mat.rm_grade} (${mat.iso_specification})</option>`
                    );
                });
            }
            setTimeout(disableDuplicateOptions, 100);
            if (callback) callback();
        });
    }

    function disableDuplicateOptions() {
        let selectedVals = [];
        $('.raw-material-select').each(function() {
            let val = $(this).val();
            if (val) selectedVals.push(val);
        });
        $('.raw-material-select').each(function() {
            let currentVal = $(this).val();
            $(this).find('option').each(function() {
                let optVal = $(this).val();
                if (optVal && optVal !== currentVal && selectedVals.includes(optVal)) {
                    $(this).prop('disabled', true);
                } else {
                    $(this).prop('disabled', false);
                }
            });
        });
    }

    // Initial load
    loadRawMaterials();

    // On change, re-enforce uniqueness
    $(document).on('change', '.raw-material-select', function() {
        disableDuplicateOptions();
    });

    // Add material row
    $('#add-material').click(function() {
        var $newRow = $(`
            <div class="material-row">
                <div class="input-group">
                    <select name="rawmaterials[]" class="form-control raw-material-select" required>
                        <option value="">Select Raw Material</option>
                    </select>
                    <div class="input-group-append">
                        <button type="button" class="btn btn-danger remove-material" title="Remove">
                            <i class="fas fa-trash-alt"></i>
                        </button>
                    </div>
                </div>
            </div>
        `);
        $('#materials-wrapper').append($newRow);
        loadRawMaterials($newRow.find('select'), disableDuplicateOptions);
    });

    // Remove material row
    $(document).on('click', '.remove-material', function() {
        if ($('.material-row').length > 1) {
            $(this).closest('.material-row').remove();
            disableDuplicateOptions();
        } else {
            showToast('error', 'At least one raw material is required.');
        }
    });

    // Add new raw material via modal
    $('#addRawMaterialForm').submit(function(e) {
        e.preventDefault();
        var $btn = $('#addMaterialBtn');
        var $spinner = $btn.find('.spinner-border');
        var $text = $btn.find('.btn-text');

        $btn.prop('disabled', true);
        $spinner.removeClass('d-none');
        $text.text('Adding...');

        $.ajax({
            url: '{{ route('superadmin.salesbom.rawmaterials.store') }}',
            method: 'POST',
            data: $(this).serialize(),
            headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
            success: function(response) {
                if (response.success) {
                    var newMaterialId = response.material.id;
                    $('#addRawMaterialModal').modal('hide');
                    $('#addRawMaterialForm')[0].reset();
                    loadRawMaterials(null, function() {
                        $('.raw-material-select').last().val(newMaterialId);
                        disableDuplicateOptions();
                    });
                    showToast('success', 'Raw material added successfully!');
                }
            },
            error: function(xhr) {
                showToast('error', 'Error adding raw material.');
            },
            complete: function() {
                $btn.prop('disabled', false);
                $spinner.addClass('d-none');
                $text.text('Add Material');
            }
        });
    });

    // Form submit validation
    $('#rfqform').on('submit', function(e) {
        let values = [];
        let duplicate = false;
        $('.raw-material-select').each(function() {
            let val = $(this).val();
            if (val) {
                if (values.includes(val)) {
                    duplicate = true;
                    return false;
                }
                values.push(val);
            }
        });
        if (duplicate) {
            showToast('error', 'Each Raw Material must be unique. Please select different materials.');
            e.preventDefault();
            return false;
        }

        // Show loading state
        $('#submitBtn').prop('disabled', true);
        $('#submitSpinner').removeClass('d-none');
        $('#submitIcon').addClass('d-none');
        $('#submitText').text('Saving...');
    });

    // Clear button
    $('#clearBtn').on('click', function() {
        $('.file-preview').empty();
        // Reload RFQ ID
        $.ajax({
            url: "{{ route('superadmin.salesbom.rfq.generateId') }}",
            method: 'GET',
            success: function(response) {
                $('#rfqNo').val(response.rfqId);
            }
        });
    });

    // File preview
    const previewFileInputs = ['drawingFiles', 'materialSpecificationFiles', 'rfqFormFiles', 'annexureFiles'];
    previewFileInputs.forEach(function(inputId) {
        const input = document.getElementById(inputId);
        if (input) {
            input.addEventListener('change', function(event) {
                const previewContainer = document.getElementById(inputId + '_preview');
                previewContainer.innerHTML = '';
                const files = event.target.files;
                if (files.length > 0) {
                    Array.from(files).forEach(file => {
                        const fileType = file.type;
                        if (fileType.startsWith('image/')) {
                            const reader = new FileReader();
                            reader.onload = function(e) {
                                const img = document.createElement('img');
                                img.src = e.target.result;
                                previewContainer.appendChild(img);
                            };
                            reader.readAsDataURL(file);
                        } else {
                            const link = document.createElement('a');
                            link.href = URL.createObjectURL(file);
                            link.target = '_blank';
                            link.innerHTML = '<i class="fas fa-file-pdf text-danger mr-1"></i>' + file.name;
                            link.classList.add('d-block', 'small');
                            previewContainer.appendChild(link);
                        }
                    });
                }
            });
        }
    });

    // Toast notification helper
    function showToast(type, message) {
        var bgClass = type === 'success' ? 'bg-success' : 'bg-danger';
        var icon = type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle';

        var toastHtml = `
            <div class="toast ${bgClass} text-white" role="alert" aria-live="assertive" aria-atomic="true" data-delay="3000" style="position: fixed; top: 20px; right: 20px; z-index: 9999; min-width: 280px;">
                <div class="toast-body d-flex align-items-center">
                    <i class="fas ${icon} mr-2"></i>
                    <span>${message}</span>
                    <button type="button" class="ml-auto close text-white" data-dismiss="toast" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            </div>
        `;

        var $toast = $(toastHtml);
        $('body').append($toast);
        $toast.toast('show');

        $toast.on('hidden.bs.toast', function() {
            $(this).remove();
        });
    }
});
</script>
@endsection
