@extends('layouts.dashboard.superadminapp')

@section('title', 'View Sales Order')

@section('styles')
<style>
    .detail-card {
        border: none;
        border-radius: 0.5rem;
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.1);
        margin-bottom: 1.5rem;
    }
    .detail-card .card-header {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
        color: #fff;
        font-weight: 600;
        padding: 0.75rem 1rem;
        border-radius: 0.5rem 0.5rem 0 0 !important;
    }
    .detail-card .card-header.bg-success-gradient {
        background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
    }
    .detail-card .card-header.bg-info-gradient {
        background: linear-gradient(135deg, #36b9cc 0%, #258391 100%);
    }
    .detail-card .card-header.bg-warning-gradient {
        background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%);
    }
    .detail-card .card-header.bg-secondary-gradient {
        background: linear-gradient(135deg, #858796 0%, #60616f 100%);
    }
    .detail-row {
        display: flex;
        padding: 0.5rem 0;
        border-bottom: 1px solid #f1f1f1;
    }
    .detail-row:last-child {
        border-bottom: none;
    }
    .detail-label {
        font-weight: 600;
        color: #5a5c69;
        min-width: 160px;
        font-size: 0.85rem;
    }
    .detail-value {
        color: #2e2e2e;
        font-size: 0.85rem;
        word-break: break-word;
    }
    .order-header {
        background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
        color: white;
        padding: 1.5rem;
        border-radius: 0.5rem;
        margin-bottom: 1.5rem;
    }
    .info-card {
        background: #f8f9fc;
        border-radius: 0.5rem;
        padding: 1rem;
        height: 100%;
    }
    .info-card-title {
        font-size: 0.75rem;
        text-transform: uppercase;
        color: #858796;
        font-weight: 700;
        margin-bottom: 0.5rem;
    }
    .info-card-value {
        font-size: 1.1rem;
        font-weight: 600;
        color: #2e2e2e;
    }
    .items-table {
        font-size: 0.85rem;
    }
    .items-table th {
        background-color: #f8f9fc;
        font-weight: 600;
        font-size: 0.8rem;
        white-space: nowrap;
    }
    .items-table td, .items-table th {
        padding: 0.5rem;
        vertical-align: middle;
    }
    .totals-box {
        background: #f8f9fc;
        border-radius: 0.5rem;
        padding: 1rem;
    }
    .totals-box .row {
        padding: 0.35rem 0;
    }
    .totals-box .total-label {
        font-weight: 600;
        color: #5a5c69;
        font-size: 0.85rem;
    }
    .totals-box .total-value {
        text-align: right;
        font-weight: 600;
        font-size: 0.85rem;
    }
    .grand-total {
        font-size: 1.2rem;
        color: #1cc88a;
    }
    .status-badge {
        font-size: 0.9rem;
        padding: 0.4rem 1rem;
    }
</style>
@endsection

@section('content')
    <!-- Page Heading -->
    <div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h5 mb-0 text-gray-800">UEPL | View Sales Order</h1>
        <div class="display-date">
            <span id="day">day</span>,
            <span id="daynum">00</span>
            <span id="month">month</span>
            <span id="year">0000</span>
        </div>
        <div class="display-time"></div>
    </div>

    <!-- Order Header Card -->
    <div class="order-header">
        <div class="row align-items-center">
            <div class="col-md-6">
                <h4 class="mb-1 font-weight-bold">{{ $order->sales_order_no }}</h4>
                <p class="mb-0 opacity-75">
                    <i class="fas fa-calendar-alt mr-1"></i> {{ \Carbon\Carbon::parse($order->sales_order_date)->format('d M Y') }}
                    @if($order->customer)
                        <span class="mx-2">|</span>
                        <i class="fas fa-building mr-1"></i> {{ $order->customer->company }}
                    @endif
                </p>
            </div>
            <div class="col-md-6 text-md-right mt-3 mt-md-0">
                @if($order->status === 'approved')
                    <span class="badge badge-success status-badge"><i class="fas fa-check-circle mr-1"></i> Approved</span>
                @elseif($order->status === 'rejected')
                    <span class="badge badge-danger status-badge"><i class="fas fa-times-circle mr-1"></i> Rejected</span>
                @else
                    <span class="badge badge-warning status-badge"><i class="fas fa-clock mr-1"></i> Pending</span>
                @endif
                <div class="mt-2">
                    <a href="{{ route('superadmin.sales.order.edit', $order->id) }}" class="btn btn-light btn-sm">
                        <i class="fas fa-edit mr-1"></i> Edit
                    </a>
                    <a href="{{ route('superadmin.sales.order.print', $order->id) }}" class="btn btn-light btn-sm" target="_blank">
                        <i class="fas fa-print mr-1"></i> Print
                    </a>
                    <a href="{{ route('superadmin.sales.salesdetails') }}" class="btn btn-light btn-sm">
                        <i class="fas fa-arrow-left mr-1"></i> Back
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Info Cards -->
    <div class="row mb-4">
        <div class="col-md-3 mb-3">
            <div class="info-card">
                <div class="info-card-title">Grand Total</div>
                <div class="info-card-value text-success">₹{{ number_format($order->grand_total, 2) }}</div>
            </div>
        </div>
        <div class="col-md-3 mb-3">
            <div class="info-card">
                <div class="info-card-title">Quotation No</div>
                <div class="info-card-value">{{ $order->quotation_no ?? '-' }}</div>
            </div>
        </div>
        <div class="col-md-3 mb-3">
            <div class="info-card">
                <div class="info-card-title">RFQ No</div>
                <div class="info-card-value">{{ $order->rfq_no ?? '-' }}</div>
            </div>
        </div>
        <div class="col-md-3 mb-3">
            <div class="info-card">
                <div class="info-card-title">Product Type</div>
                <div class="info-card-value">{{ $order->product_type ?? '-' }}</div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Left Column -->
        <div class="col-lg-6">
            <!-- Order Information -->
            <div class="card detail-card">
                <div class="card-header">
                    <i class="fas fa-file-invoice mr-2"></i> Order Information
                </div>
                <div class="card-body">
                    <div class="detail-row">
                        <span class="detail-label">Sales Order No:</span>
                        <span class="detail-value font-weight-bold">{{ $order->sales_order_no }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Order Date:</span>
                        <span class="detail-value">{{ \Carbon\Carbon::parse($order->sales_order_date)->format('d M Y') }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">GRN No:</span>
                        <span class="detail-value">{{ $order->grn_no ?? '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Customer Ref No:</span>
                        <span class="detail-value">{{ $order->customer_ref_no ?? '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Quotation No:</span>
                        <span class="detail-value">{{ $order->quotation_no ?? '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Quotation Date:</span>
                        <span class="detail-value">{{ $order->quotation_date ? \Carbon\Carbon::parse($order->quotation_date)->format('d M Y') : '-' }}</span>
                    </div>
                </div>
            </div>

            <!-- Customer Information -->
            <div class="card detail-card">
                <div class="card-header bg-success-gradient">
                    <i class="fas fa-user mr-2"></i> Customer Information
                </div>
                <div class="card-body">
                    <div class="detail-row">
                        <span class="detail-label">Company Name:</span>
                        <span class="detail-value font-weight-bold">{{ $order->customer->company ?? '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Address:</span>
                        <span class="detail-value">{{ $order->company_address ?? '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">GST No:</span>
                        <span class="detail-value">{{ $order->company_gstn ?? '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Phone:</span>
                        <span class="detail-value">{{ $order->company_phone ?? '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Email:</span>
                        <span class="detail-value">{{ $order->company_email ?? '-' }}</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Right Column -->
        <div class="col-lg-6">
            <!-- RFQ & Product Information -->
            <div class="card detail-card">
                <div class="card-header bg-info-gradient">
                    <i class="fas fa-box mr-2"></i> RFQ & Product Information
                </div>
                <div class="card-body">
                    <div class="detail-row">
                        <span class="detail-label">RFQ No:</span>
                        <span class="detail-value">{{ $order->rfq_no ?? '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">RFQ Date:</span>
                        <span class="detail-value">{{ $order->rfq_date ? \Carbon\Carbon::parse($order->rfq_date)->format('d M Y') : '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Part No:</span>
                        <span class="detail-value">{{ $order->part_no ?? '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Project/Material No:</span>
                        <span class="detail-value">{{ $order->project_material_no ?? '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Drawing No:</span>
                        <span class="detail-value">{{ $order->drawing_no ?? '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Drawing Rev:</span>
                        <span class="detail-value">{{ $order->drawing_rev ?? '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Product Type:</span>
                        <span class="detail-value">{{ $order->product_type ?? '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Description:</span>
                        <span class="detail-value">{{ $order->description ?? '-' }}</span>
                    </div>
                </div>
            </div>

            <!-- Billing & Shipping -->
            <div class="card detail-card">
                <div class="card-header bg-secondary-gradient">
                    <i class="fas fa-shipping-fast mr-2"></i> Billing & Shipping
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h6 class="font-weight-bold text-muted mb-2"><i class="fas fa-file-invoice-dollar mr-1"></i> Bill To</h6>
                            <p class="mb-0" style="font-size: 0.85rem;">{{ $order->bill_address ?? '-' }}</p>
                        </div>
                        <div class="col-md-6">
                            <h6 class="font-weight-bold text-muted mb-2"><i class="fas fa-truck mr-1"></i> Ship To</h6>
                            <p class="mb-0" style="font-size: 0.85rem;">{{ $order->ship_address ?? '-' }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Product Items Table -->
    <div class="card detail-card">
        <div class="card-header bg-warning-gradient">
            <i class="fas fa-list mr-2"></i> Product Items
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover items-table">
                    <thead>
                        <tr class="text-center">
                            <th>#</th>
                            <th>Material Code</th>
                            <th>HSN Code</th>
                            <th>Description</th>
                            <th>Additional Details</th>
                            <th>Req By Date</th>
                            <th>Qty</th>
                            <th>UOM</th>
                            <th>Unit Rate</th>
                            <th>Discount</th>
                            <th>Value</th>
                            <th>SGST</th>
                            <th>CGST</th>
                            <th>IGST</th>
                            <th>Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($order->items as $item)
                            <tr>
                                <td class="text-center">{{ $item->sl_no }}</td>
                                <td>{{ $item->material_code ?? '-' }}</td>
                                <td>{{ $item->hsn_code ?? '-' }}</td>
                                <td>{{ $item->material_description ?? '-' }}</td>
                                <td>{{ $item->additional_details ?? '-' }}</td>
                                <td class="text-center">{{ $item->required_by_date ? \Carbon\Carbon::parse($item->required_by_date)->format('d M Y') : '-' }}</td>
                                <td class="text-center">{{ $item->quantity }}</td>
                                <td class="text-center">{{ $item->uom }}</td>
                                <td class="text-right">₹{{ number_format($item->unit_rate, 2) }}</td>
                                <td class="text-center">{{ $item->discount }}%</td>
                                <td class="text-right">₹{{ number_format($item->value, 2) }}</td>
                                <td class="text-center">{{ $item->sgst }}%</td>
                                <td class="text-center">{{ $item->cgst }}%</td>
                                <td class="text-center">{{ $item->igst }}%</td>
                                <td class="text-right font-weight-bold">₹{{ number_format($item->amount, 2) }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="15" class="text-center text-muted">No items found</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Summary & Totals -->
    <div class="card detail-card">
        <div class="card-header">
            <i class="fas fa-rupee-sign mr-2"></i> Summary & Totals
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <h6 class="font-weight-bold text-muted mb-2">Grand Total in Words</h6>
                    <p class="font-weight-bold" style="font-size: 0.95rem;">{{ $order->inr_in_words ?? '-' }}</p>
                </div>
                <div class="col-md-6">
                    <div class="totals-box">
                        <div class="row">
                            <div class="col-6 total-label">Sub Total:</div>
                            <div class="col-6 total-value">₹{{ number_format($order->subtotal, 2) }}</div>
                        </div>
                        <div class="row">
                            <div class="col-6 total-label">SGST Amount:</div>
                            <div class="col-6 total-value">₹{{ number_format($order->sgst_amount, 2) }}</div>
                        </div>
                        <div class="row">
                            <div class="col-6 total-label">CGST Amount:</div>
                            <div class="col-6 total-value">₹{{ number_format($order->cgst_amount, 2) }}</div>
                        </div>
                        <div class="row">
                            <div class="col-6 total-label">IGST Amount:</div>
                            <div class="col-6 total-value">₹{{ number_format($order->igst_amount, 2) }}</div>
                        </div>
                        <div class="row">
                            <div class="col-6 total-label">Round Up:</div>
                            <div class="col-6 total-value">₹{{ number_format($order->round_up, 2) }}</div>
                        </div>
                        <hr class="my-2">
                        <div class="row">
                            <div class="col-6 total-label grand-total">Grand Total:</div>
                            <div class="col-6 total-value grand-total">₹{{ number_format($order->grand_total, 2) }}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Action Buttons -->
    <div class="card detail-card">
        <div class="card-body">
            <div class="d-flex justify-content-between">
                <a href="{{ route('superadmin.sales.salesdetails') }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left mr-1"></i> Back to List
                </a>
                <div>
                    <a href="{{ route('superadmin.sales.order.edit', $order->id) }}" class="btn btn-warning mr-2">
                        <i class="fas fa-edit mr-1"></i> Edit Order
                    </a>
                    <a href="{{ route('superadmin.sales.order.print', $order->id) }}" class="btn btn-info" target="_blank">
                        <i class="fas fa-print mr-1"></i> Print Order
                    </a>
                </div>
            </div>
        </div>
    </div>
@endsection
