@extends('layouts.dashboard.superadminapp')

@section('title', 'Machine Report')

@section('styles')
<style>
    div.dt-buttons {
        float: left;
        display: flex !important;
    }
    .dataTable {
        overflow-x: auto !important;
        display: table !important;
    }
    .dt-buttons .btn {
        margin-right: 0.5rem !important;
        padding: 0.25rem 0.75rem !important;
        font-size: 0.95rem !important;
    }
    .stat-card {
        border-radius: 10px;
        padding: 20px;
        text-align: center;
        color: #fff;
        transition: transform 0.2s;
    }
    .stat-card:hover {
        transform: translateY(-3px);
    }
    .stat-card .stat-value {
        font-size: 1.8rem;
        font-weight: bold;
    }
    .stat-card .stat-label {
        font-size: 0.85rem;
        opacity: 0.9;
    }
    .bg-total { background: linear-gradient(135deg, #4e73df 0%, #224abe 100%); }
    .bg-active { background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%); }
    .bg-process { background: linear-gradient(135deg, #36b9cc 0%, #258391 100%); }
    .bg-hours { background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%); }
    .bg-idle { background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%); }
</style>
@endsection

@section('content')

<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">UEPL | Machine Report</h1>
    <div class="display-date">
        <span id="day">day</span>,
        <span id="daynum">00</span>
        <span id="month">month</span>
        <span id="year">0000</span>
    </div>
    <div class="display-time"></div>
</div>

<!-- Alerts -->
@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
@endif
@if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-circle mr-2"></i>{{ session('error') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
@endif

<!-- Filter Card -->
<div class="card shadow mb-4">
    <div class="card-header py-3" style="background: linear-gradient(135deg, #6c757d 0%, #495057 100%);">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-filter mr-2"></i> Filter Options
                    <thead class="thead-light">
                        <tr>
                            <th>Machine</th>
                            <th class="text-center">Processes</th>
                            <th class="text-center">Total Cycle Time</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $activeMachines = $machines->filter(fn($m) => $m->routeProcesses->count() > 0)->take(5);
                        @endphp
                        @forelse($activeMachines as $machine)
                            @php
                                $machineHours = 0;
                                $machineMinutes = 0;
                                foreach($machine->routeProcesses as $proc) {
                                    $machineHours += (int)($proc->cycle_hours ?? 0);
                                    $machineMinutes += (int)($proc->cycle_minutes ?? 0);
                                }
                                $machineHours += floor($machineMinutes / 60);
                                $machineMinutes = $machineMinutes % 60;
                            @endphp
                            <tr>
                                <td>{{ $machine->machine_name }}</td>
                                <td class="text-center">
                                    <span class="badge badge-primary">{{ $machine->routeProcesses->count() }}</span>
                                </td>
                                <td class="text-center">
                                    <span class="badge badge-info">{{ $machineHours }}h {{ $machineMinutes }}m</span>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="3" class="text-center text-muted">No active machines</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card shadow mb-4">
            <div class="card-header py-3" style="background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-exclamation-triangle mr-2"></i> Idle Machines (No Process)
                </h6>
            </div>
            <div class="card-body p-0">
                <table class="table table-sm mb-0">
                    <thead class="thead-light">
                        <tr>
                            <th>Machine</th>
                            <th>Serial No</th>
                            <th>Make/Model</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $idleMachines = $machines->filter(fn($m) => $m->routeProcesses->count() == 0)->take(5);
                        @endphp
                        @forelse($idleMachines as $machine)
                            <tr>
                                <td>{{ $machine->machine_name }}</td>
                                <td>{{ $machine->machine_sl_no ?? '-' }}</td>
                                <td>{{ $machine->make ?? '-' }} / {{ $machine->model_type ?? '-' }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="3" class="text-center text-muted">All machines are active</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script>
$(document).ready(function() {
    $('#machineTable').DataTable({
        dom: 'Bfrtip',
        buttons: [
            { extend: 'copy', className: 'btn btn-secondary btn-sm' },
            { extend: 'csv', className: 'btn btn-secondary btn-sm' },
            { extend: 'excel', className: 'btn btn-secondary btn-sm' },
            { extend: 'pdf', className: 'btn btn-secondary btn-sm' },
            { extend: 'print', className: 'btn btn-secondary btn-sm' },
            { extend: 'colvis', className: 'btn btn-secondary btn-sm' }
        ],
        pageLength: 25,
        responsive: true,
        order: [[0, 'asc']],
        language: {
            emptyTable: "No machine records found"
        }
    });

    // Export Excel logic
    $('#exportExcelBtn').click(function() {
        let form = $('#machineReportFilters');
        let originalAction = form.attr('action');
        form.attr('action', '{{ route('superadmin.report.machinereport.export') }}');
        form.attr('target', '_blank');
        form.submit();
        setTimeout(function() {
            form.attr('action', originalAction);
            form.removeAttr('target');
        }, 100);
    });
});
</script>
@endsection
