@extends('layouts.dashboard.superadminapp')
@section('title', 'Quality Control Management')

@push('styles')
<style>
    :root {
        --primary-gradient: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
        --card-shadow: 0 10px 15px -3px rgba(0,0,0,0.1), 0 4px 6px -2px rgba(0,0,0,0.05);
        --hover-shadow: 0 20px 25px -5px rgba(0,0,0,0.1), 0 10px 10px -5px rgba(0,0,0,0.04);
        --text-dark: #2d3748;
        --text-muted: #718096;
    }

    body {
        background-color: #f8f9fa;
        font-family: 'Inter', sans-serif;
    }

    /* Gradient Header */
    .page-header-gradient {
        background: var(--primary-gradient);
        color: white;
        padding: 2rem 2.5rem;
        border-radius: 20px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        position: relative;
        z-index: 10;
        margin-bottom: 2rem;
    }

    .breadcrumb-item + .breadcrumb-item::before {
        color: rgba(255, 255, 255, 0.6);
    }
    .breadcrumb-item.active {
        color: rgba(255, 255, 255, 0.9);
    }

    /* Premium Card */
    .premium-card {
        background: white;
        border: none;
        border-radius: 16px;
        box-shadow: var(--card-shadow);
        transition: all 0.3s ease;
        height: 100%;
        display: flex;
        flex-direction: column;
        overflow: hidden;
    }

    .premium-card:hover {
        transform: translateY(-5px);
        box-shadow: var(--hover-shadow);
    }

    .card-header-stripe {
        height: 6px;
        background: var(--primary-gradient);
        width: 100%;
    }

    .card-body-content {
        padding: 1.5rem;
        flex-grow: 1;
        display: flex;
        flex-direction: column;
    }

    .rc-number {
        font-size: 1.25rem;
        font-weight: 700;
        color: var(--text-dark);
        margin-bottom: 0.25rem;
    }

    .company-name {
        font-size: 0.95rem;
        color: var(--text-muted);
        margin-bottom: 1rem;
        font-weight: 500;
    }

    .detail-row {
        display: flex;
        justify-content: space-between;
        margin-bottom: 0.75rem;
        font-size: 0.9rem;
    }

    .detail-label {
        color: var(--text-muted);
    }

    .detail-value {
        font-weight: 600;
        color: var(--text-dark);
    }

    .btn-action-primary {
        background: var(--primary-gradient);
        border: none;
        color: white;
        padding: 0.6rem 1rem;
        border-radius: 8px;
        font-weight: 600;
        width: 100%;
        transition: opacity 0.2s;
        display: block;
        text-align: center;
        margin-top: auto;
    }
    .btn-action-primary:hover {
        opacity: 0.95;
        color: white;
        text-decoration: none;
    }
    
    .qc-badge {
        background-color: #e0f2f1;
        color: #00695c;
        padding: 0.35em 0.8em;
        border-radius: 20px;
        font-size: 0.8rem;
        font-weight: 600;
    }
</style>
@endpush

@section('content')
<meta name="csrf-token" content="{{ csrf_token() }}">

<!-- Gradient Header -->
<div class="page-header-gradient">
    <div class="container-fluid">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h1 class="h3 font-weight-bold mb-1">Quality Control Management</h1>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb bg-transparent p-0 m-0">
                        <li class="breadcrumb-item"><a href="{{ url('superadmin/dashboard') }}" class="text-white-50">Dashboard</a></li>
                        <li class="breadcrumb-item active" aria-current="page">QC Management</li>
                    </ol>
                </nav>
            </div>
             <!-- Optional: Add Search or Filter button here -->
             <!-- 
            <div>
                 <button class="btn btn-sm btn-light shadow-sm" style="opacity:0.9">
                     <i class="fas fa-filter mr-1"></i> Filter
                 </button>
            </div>
             -->
        </div>
    </div>
</div>

<div class="container-fluid" style="position: relative; z-index: 20; padding-top: 0;">
    <div class="row">
        @forelse($routeCards as $rc)
            <div class="col-12 col-md-6 col-lg-4 mb-4">
                <div class="premium-card">
                    <div class="card-header-stripe"></div>
                    <div class="card-body-content">
                        <div class="d-flex justify-content-between align-items-start mb-2">
                            <div>
                                <div class="rc-number">{{ $rc->route_no }}</div>
                                <div class="company-name"><i class="far fa-building mr-1"></i> {{ \Illuminate\Support\Str::limit($rc->company_name, 25) }}</div>
                            </div>
                            <span class="qc-badge">
                                <i class="fas fa-tasks mr-1"></i> {{ $rc->qc_count }} Steps
                            </span>
                        </div>

                        <div class="detail-row">
                            <span class="detail-label">Project No:</span>
                            <span class="detail-value">{{ $rc->project_no ?: '-' }}</span>
                        </div>
                         <!-- 
                        <div class="detail-row">
                            <span class="detail-label">Material No:</span>
                            <span class="detail-value text-break" style="max-width:150px;">{{ $rc->material_no ?: '-' }}</span>
                        </div>
                        -->
                         <div class="detail-row">
                            <span class="detail-label">Route Date:</span>
                            <span class="detail-value">{{ $rc->route_date ? date('d M Y', strtotime($rc->route_date)) : '-' }}</span>
                        </div>

                        <a href="{{ url('superadmin/quality/qualitycontrol/'.$rc->id) }}" class="btn-action-primary shadow-sm mt-3">
                            <i class="fas fa-eye mr-1"></i> Open QC Board
                        </a>
                    </div>
                </div>
            </div>
        @empty
            <div class="col-12 text-center py-5">
                <div class="card border-0 shadow-sm p-5" style="border-radius:16px;">
                    <i class="fas fa-clipboard-check fa-3x text-muted mb-3"></i>
                    <h5 class="text-muted">No QC Projects Found</h5>
                    <p class="text-muted">Projects requiring Quality Control will appear here.</p>
                </div>
            </div>
        @endforelse
    </div>
</div>
@endsection
