@extends('layouts.dashboard.superadminapp')

@section('title', 'Edit RFQ')

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

@section('content')

<style>

    /* Force Select2 dropdown above everything */
    .select2-container {
        z-index: 999999 !important;
    }

</style>

<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">UEPL | Edit Request For Quotation</h1>
    <div class="display-date">
        <span id="day">day</span>,
        <span id="daynum">00</span>
        <span id="month">month</span>
        <span id="year">0000</span>
    </div>
    <div class="display-time"></div>
</div>

@if (session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
@endif
@if (session('error'))
    <div class="alert alert-danger">{{ session('error') }}</div>
@endif

<div class="card shadow mb-4">
    <div class="card-header py-3" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-edit mr-2"></i> Edit Request For Quotation
        </h6>
    </div>
    <div class="card-body">
        <form id="rfqform" action="{{ route('superadmin.purchasebom.rfq.update', $rfq->id) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">RFQ ID <span class="text-danger">*</span></label>
                    <input type="text" id="rfqNo" name="rfqNo" class="form-control" required readonly value="{{ old('rfqNo', $rfq->rfq_no) }}">
                </div>
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">RFQ Date <span class="text-danger">*</span></label>
                    <input type="date" id="rfqDate" name="rfqDate" class="form-control" required value="{{ $rfq->rfq_date ? \Illuminate\Support\Carbon::parse($rfq->rfq_date)->format('Y-m-d') : '' }}">
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">Vendor <span class="text-danger">*</span></label>
                    <select id="vendor" name="vendor" class="form-control" required>
                        <option value="">Select Vendor</option>
                        @foreach ($vendors as $vendor)
                            <option value="{{ $vendor->id }}" {{ old('vendor', $rfq->vendor_id) == $vendor->id ? 'selected' : '' }}>
                                {{ $vendor->company }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">Vendor Reference No</label>
                    <input type="text" id="venRefNo" name="venRefNo" class="form-control" value="{{ old('venRefNo', $rfq->vendor_reference_no) }}">
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">RFQ Type <span class="text-danger">*</span></label>
                    <select id="rfqType" name="rfqType" class="form-control" required>
                        <option value="">Select RFQ Type</option>
                        @foreach($rfqTypes as $type)
                            <option value="{{ $type->rfqtype }}" {{ old('rfqType', $rfq->rfq_type) == $type->rfqtype ? 'selected' : '' }}>
                                {{ $type->rfqtype }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">Annexure Files</label>
                    @php
                        $annexureFiles = $rfq->rfqFiles->where('file_type', 'annexure');
                    @endphp
                    @if ($annexureFiles && $annexureFiles->count())
                        <div class="mb-2">
                            @foreach ($annexureFiles as $file)
                                <div class="d-flex align-items-center mb-1" id="fileRow_{{ $file->id }}">
                                    <a href="{{ asset('storage/' . $file->file_path) }}" target="_blank" class="text-primary mr-2">
                                        <i class="fas fa-file mr-1"></i>{{ $file->file_name }}
                                    </a>
                                    <button type="button" onclick="deleteRfqFile({{ $file->id }})" class="btn btn-danger btn-sm">
                                        <i class="fas fa-times"></i>
                                    </button>
                                </div>
                            @endforeach
                        </div>
                    @endif
                    <input type="file" id="annexureFiles" name="annexureFiles[]" class="form-control" multiple accept=".pdf,image/*">
                    <div id="annexureFiles_preview" class="mt-2"></div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">Note I</label>
                    <input type="text" id="description" name="description_main" class="form-control" value="{{ old('description_main', $rfq->description) }}">
                </div>
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">Delivery Terms</label>
                    <input type="text" id="deliveryTerms" name="deliveryTerms" class="form-control" value="{{ old('deliveryTerms', $rfq->delivery_terms) }}">
                </div>
            </div>

            <div class="row">
                <div class="col-md-12 mb-3">
                    <label class="small font-weight-bold">Note II</label>
                    <textarea id="note" name="note" class="form-control" rows="3">{{ old('note', $rfq->note) }}</textarea>
                </div>
            </div>

            <hr>

            <h6 class="font-weight-bold text-primary mb-3"><i class="fas fa-list mr-2"></i>RFQ Items</h6>

            <div class="table-responsive">
                <table id="rfqTable" class="table table-bordered table-sm">
                    <thead class="thead-light">
                        <tr>
                            <th width="60">Sl.No</th>
                            <th>Item</th>
                            <th>Description</th>
                            <th width="100">Quantity</th>
                            <th width="100">UOM</th>
                            <th width="140">Required By</th>
                            <th width="50"></th>
                        </tr>
                    </thead>
                    <tbody>
                        @if ($rfq->items && $rfq->items->count())
                            @foreach ($rfq->items as $index => $item)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>
                                        <select class="form-control item-select w-100" name="item[]" required>
                                            <option value="">Select Item</option>
                                            @foreach ($stock_items as $stockItem)
                                                <option value="{{ $stockItem->id }}"
                                                    {{ (string) old('item.' . $index, $item->item_id) === (string) $stockItem->id ? 'selected' : '' }}>
                                                    {{ $stockItem->item_name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </td>
                                    <td><input type="text" name="description[]" class="form-control" value="{{ old('description.' . $index, $item->description) }}"></td>
                                    <td><input type="number" name="quantity[]" class="form-control" min="1" value="{{ old('quantity.' . $index, $item->quantity) }}"></td>
                                    <td><input type="text" name="uom[]" class="form-control" value="{{ old('uom.' . $index, $item->uom) }}"></td>
                                    <td><input type="date" name="requiredBy[]" class="form-control" value="{{ old('requiredBy.' . $index, $item->required_by ? \Carbon\Carbon::parse($item->required_by)->format('Y-m-d') : '') }}"></td>
                                    <td>
                                        <button type="button" class="btn btn-danger btn-sm" onclick="deleteRow(this)">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                        @else
                            <tr><td colspan="7" class="text-center text-muted">No RFQ items found.</td></tr>
                        @endif
                    </tbody>
                </table>
            </div>

            <button type="button" class="btn btn-primary btn-sm mb-4" onclick="addRow()">
                <i class="fa fa-plus mr-1"></i> Add Row
            </button>

            <hr>

            <div class="d-flex justify-content-end">
                <a href="{{ route('superadmin.purchasebom.rfq.rfqdetails') }}" class="btn btn-secondary mr-2">
                    <i class="fas fa-arrow-left mr-1"></i> Back
                </a>
                <button class="btn btn-success" type="submit">
                    <i class="fas fa-save mr-1"></i> Update RFQ
                </button>
            </div>
        </form>
    </div>
</div>

@endsection

@section('scripts')

<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>

    const rfqItems = @json($rfq->items);
    
    // Delete a row from RFQ table
    function deleteRow(btn) {
        const row = btn.closest('tr');
        row.remove();
        updateSlNo();
    }

    // Update Serial Numbers after deletion
    function updateSlNo() {
        const rows = document.querySelectorAll("#rfqTable tbody tr");
        rows.forEach((row, index) => {
            row.cells[0].textContent = index + 1;
        });
    }

    // Delete RFQ File AJAX call
    function deleteRfqFile(fileId) {
        if (!confirm('Are you sure you want to delete this file?')) {
            return;
        }
    
        let route = "{{ route('superadmin.purchasebom.rfq.deletefile', ['id' => '__file_id__']) }}";
        route = route.replace('__file_id__', fileId);
    
        fetch(route, {
            method: 'DELETE',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                document.getElementById('fileRow_' + fileId).remove();
                alert('File deleted successfully.');
            } else {
                alert('Error deleting file.');
            }
        })
        .catch(error => {
            console.error(error);
            alert('Something went wrong while deleting the file.');
        });
    }
    
    //added here
    
    function initializeSelect2() {
        $('.item-select').each(function () {
            const $this = $(this);
            if ($this.hasClass("select2-hidden-accessible")) {
                $this.select2('destroy');
            }
            $this.select2({
                dropdownParent: $('#rfqform'),
                width: 'resolve',
                placeholder: "Select Item",
                allowClear: true
            });
        });
    }

    // Initialize existing selects on page load
    $(document).ready(function () {
        initializeSelect2();
        
        // Apply selected values explicitly from JSON (ensures correctness)
        rfqItems.forEach((item, index) => {
            const select = $(`select[name='item[]']`).eq(index);
            
            console.log(select.length, rfqItems, item.item);
            if (select.length) {
                select.val(String(item.item)).trigger('change.select2');
            }
        });
    });

    // Modify addRow() to call initializeSelect2
    function addRow() {
        const tbody = document.querySelector("#rfqTable tbody");
        const rowCount = tbody.rows.length;
        const stockItems = @json($stock_items);

        const tr = document.createElement('tr');

        tr.innerHTML = `
            <td>${rowCount + 1}</td>
            <td>
                <select name="item[]" class="form-select item-select w-100" required>
                    <option value="">Select Item</option>
                    ${stockItems.map(item => `<option value="${item.id}">${item.item_name}</option>`).join('')}
                </select>
            </td>
            <td><input type="text" name="description[]" class="form-control" /></td>
            <td><input type="number" name="quantity[]" class="form-control" min="1" /></td>
            <td><input type="text" name="uom[]" class="form-control" /></td>
            <td><input type="date" name="requiredBy[]" class="form-control" /></td>
            <td><button type="button" class="btn btn-danger" onclick="deleteRow(this)">
                <i class="fa fa-trash"></i></button>
            </td>
        `;

        tbody.appendChild(tr);
        initializeSelect2(); // Reinitialize for new dropdown
    }

</script>

@endsection
