@extends('layouts.dashboard.superadminapp')
@section('title', 'Purchase Order')

@section('styles')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <style>
        .select2-container { z-index: 999999 !important; }
        #productTable input.form-control { padding: 0.25rem 0.5rem; font-size: 0.875rem; }
        #productTable select.form-control { padding: 0.25rem 0.5rem; font-size: 0.875rem; }
    </style>
@endsection

@section('content')

    <!-- Page Heading -->
    <div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h5 mb-0 text-gray-800">UEPL | Purchase Order </h1>
        <div class="display-date">
            <span id="day">day</span>,
            <span id="daynum">00</span>
            <span id="month">month</span>
            <span id="year">0000</span>
        </div>
        <div class="display-time"></div>
    </div>

    <!-- Alerts -->
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif
    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle mr-2"></i>{{ session('error') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <!-- Content Row -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex justify-content-between align-items-center" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
            <h6 class="m-0 font-weight-bold text-white">
                <i class="fas fa-shopping-cart mr-2"></i> Create Purchase Order
            </h6>
            <a href="{{ route('superadmin.purchase.purchasedetails') }}" class="btn btn-light btn-sm">
                <i class="fa fa-arrow-left mr-1"></i> Back to List
            </a>
        </div>
        <div class="card-body">
            <form id="soForm">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="small font-weight-bold">Purchase Order No. <span class="text-danger">*</span></label>
                        <input type="text" id="sOrderNo" required class="form-control" readonly>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="small font-weight-bold">Quotation ID</label>
                        <select id="quotationSelect" name="quotationSelect" class="form-control">
                            <option value="">Select Quotation</option>
                        </select>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="small font-weight-bold">Purchase Date <span class="text-danger">*</span></label>
                        <input type="date" id="sOrderDate" required class="form-control">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="small font-weight-bold">Quotation Date</label>
                        <input type="date" id="quotationDate" class="form-control">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="small font-weight-bold">Vendor Company Name</label>
                        <input type="text" id="soCompanyName" name="soCompanyName" class="form-control">
                        <input type="hidden" id="soCompanyId" name="soCompanyId">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="small font-weight-bold">Vendor Reference No.</label>
                        <input type="text" id="custRefNo" name="custRefNo" class="form-control">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="small font-weight-bold">Address</label>
                        <input type="text" id="soCompanyAddress" class="form-control">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="small font-weight-bold">GSTN</label>
                        <input type="text" id="soCompanyGSTN" class="form-control">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="small font-weight-bold">Phone</label>
                        <input type="tel" id="soCompanyPhone" class="form-control">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="small font-weight-bold">Email</label>
                        <input type="email" id="soCompanyEmail" class="form-control">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="small font-weight-bold">RFQ No</label>
                        <input type="text" id="rfqNo" class="form-control">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="small font-weight-bold">RFQ Date</label>
                        <input type="date" id="rfqDate" class="form-control">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="small font-weight-bold">Note I</label>
                        <input type="text" id="projectDescription" name="projectDescription" class="form-control">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="small font-weight-bold">Delivery Terms</label>
                        <input type="text" id="deliveryTerms" name="deliveryTerms" class="form-control">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="small font-weight-bold">Additional Charges</label>
                        <input type="text" id="additionalCharges" name="additionalCharges" class="form-control">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="small font-weight-bold">Note II</label>
                        <textarea id="note" name="note" rows="2" class="form-control"></textarea>
                    </div>
                </div>

                <hr>

                <h6 class="font-weight-bold text-primary mb-3"><i class="fas fa-map-marker-alt mr-2"></i>Billing & Shipping</h6>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="small font-weight-bold">Bill To</label>
                        <textarea name="billAddress" id="billAddress" class="form-control" rows="2"></textarea>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="small font-weight-bold">Ship To</label>
                        <textarea name="shipAddress" id="shipAddress" class="form-control" rows="2"></textarea>
                    </div>
                </div>

                <hr>

                <h6 class="font-weight-bold text-primary mb-3"><i class="fas fa-cubes mr-2"></i>Product Details</h6>
                <div class="table-responsive">
                    <table id="productTable" class="table table-bordered table-sm">
                        <thead class="thead-light">
                            <tr>
                                <th width="50">Sl No.</th>
                                <th>Item</th>
                                <th>Description</th>
                                <th width="110">Req By Date</th>
                                <th width="80">Qty</th>
                                <th width="70">UOM</th>
                                <th width="90">Unit Rate</th>
                                <th width="70">TDS %</th>
                                <th width="70">Disc %</th>
                                <th width="90">Value</th>
                                <th width="70">SGST %</th>
                                <th width="70">CGST %</th>
                                <th width="70">IGST %</th>
                                <th width="100">Amount</th>
                                <th width="50"></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>1</td>
                                <td>
                                    <select class="form-control item-select" name="item[]" required>
                                        <option value="">Select Item</option>
                                        @foreach ($stock_items as $item)
                                            <option value="{{ $item->id }}">{{ $item->item_name }}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td><input type="text" name="description" class="form-control" /></td>
                                <td><input type="date" name="req_by_date" class="form-control" /></td>
                                <td><input type="number" name="quantity" class="form-control" step="1" min="0" /></td>
                                <td><input type="text" name="uom" class="form-control" /></td>
                                <td><input type="number" name="unit_rate" class="form-control" step="0.01" /></td>
                                <td><input type="number" name="tds" class="form-control" step="0.01" /></td>
                                <td><input type="number" name="discount" class="form-control" step="0.01" /></td>
                                <td><input type="number" name="value" class="form-control" step="0.01" readonly /></td>
                                <td><input type="number" name="sgst" class="form-control" step="0.01" /></td>
                                <td><input type="number" name="cgst" class="form-control" step="0.01" /></td>
                                <td><input type="number" name="igst" class="form-control" step="0.01" /></td>
                                <td><input type="number" name="amount" class="form-control" step="0.01" readonly /></td>
                                <td>
                                    <button type="button" class="btn btn-danger btn-sm" onclick="deleteRow(this)">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <div class="mb-3">
                    <button type="button" class="btn btn-primary btn-sm" id="addRowBtn">
                        <i class="fa fa-plus mr-1"></i> Add Row
                    </button>
                </div>

                <hr>

                <h6 class="font-weight-bold text-primary mb-3"><i class="fas fa-calculator mr-2"></i>Summary</h6>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="small font-weight-bold">Grand Total in Words (INR)</label>
                        <input type="text" id="inr_in_words" name="inr_in_words" readonly class="form-control">
                    </div>
                    <div class="col-md-6">
                        <table class="table table-sm table-borderless">
                            <tr>
                                <td class="text-right small font-weight-bold">Sub Total:</td>
                                <td width="150"><input type="text" id="totalAmount" readonly class="form-control form-control-sm text-right"></td>
                            </tr>
                            <tr>
                                <td class="text-right small">SGST Amount:</td>
                                <td><input type="text" id="sgstA" readonly class="form-control form-control-sm text-right"></td>
                            </tr>
                            <tr>
                                <td class="text-right small">CGST Amount:</td>
                                <td><input type="text" id="cgstA" readonly class="form-control form-control-sm text-right"></td>
                            </tr>
                            <tr>
                                <td class="text-right small">IGST Amount:</td>
                                <td><input type="text" id="IgstA" readonly class="form-control form-control-sm text-right"></td>
                            </tr>
                            <tr>
                                <td class="text-right small">Round Up:</td>
                                <td><input type="text" id="roundUp" readonly class="form-control form-control-sm text-right"></td>
                            </tr>
                            <tr class="border-top">
                                <td class="text-right small font-weight-bold text-primary">Grand Total:</td>
                                <td><input type="text" id="grandTotal" readonly class="form-control form-control-sm text-right font-weight-bold"></td>
                            </tr>
                        </table>
                    </div>
                </div>

                <hr>

                <div class="d-flex justify-content-end">
                    <button class="btn btn-success btn-sm mr-2" type="submit" onclick="saveSO(event)">
                        <i class="fa fa-save mr-1"></i> Save
                    </button>
                    <button class="btn btn-secondary btn-sm mr-2" type="reset" onclick="resetForm()">
                        <i class="fa fa-times mr-1"></i> Clear
                    </button>
                    <a href="{{ route('superadmin.purchase.purchasedetails') }}" class="btn btn-outline-secondary btn-sm">
                        <i class="fa fa-arrow-left mr-1"></i> Back
                    </a>
                </div>
            </form>
        </div>
    </div>
    @endsection
    @section('scripts')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- Load jQuery FIRST -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- Then Select2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    
    <!-- Bootstrap JS (required by Bootstrap Select) -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Bootstrap Select JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/js/bootstrap-select.min.js"></script>

    <script>
    
        const stockItems = @json($stock_items);
        
        // Initialize existing selects on page load
        $(document).ready(function () {
            initializeSelect2();
            
            // Apply selected values explicitly from JSON (ensures correctness)
            rfqItems.forEach((item, index) => {
                const select = $(`select[name='item[]']`).eq(index);
                
                console.log(select.length, stockItems, item.item);
                if (select.length) {
                    select.val(String(item.item)).trigger('change.select2');
                }
            });
        });
        
        document.addEventListener("DOMContentLoaded", async function() {

            // ==== 1. Populate Quotation Dropdown ====
            try {
                const response = await fetch("{{ url('/superadmin/purchase/quotations') }}");
                const quotations = await response.json();
                const select = document.getElementById("quotationSelect");
                quotations.forEach(q => {
                    const opt = document.createElement("option");
                    opt.value = q.id;
                    opt.textContent = q.quotation_no;
                    select.appendChild(opt);
                });
            } catch (err) {
                console.error("Failed to load quotations:", err);
            }

            // ==== 2. On Quotation Select, Autofill All Fields ====
            document.getElementById("quotationSelect").addEventListener("change", async function() {
                const quotationId = this.value;
                if (!quotationId) return;
                try {
                    const response = await fetch(
                        `{{ url('/superadmin/purchase/quotation') }}/${quotationId}`);
                    const data = await response.json();
                    if (data.error) {
                        alert(data.error);
                        return;
                    }
                    // Autofill header fields
                    //document.getElementById("quotationDate").value = data.quotation_date || "";
                    document.getElementById("quotationDate").value = formatDate(data.quotation_date);
                    document.getElementById("soCompanyName").value = data.vendor_name || "";
                    document.getElementById("soCompanyId").value = data.vendor_id || "";
                    document.getElementById("soCompanyAddress").value = data.address || "";
                    document.getElementById("soCompanyGSTN").value = data.gst || "";
                    document.getElementById("soCompanyPhone").value = data.phone || "";
                    document.getElementById("soCompanyEmail").value = data.email || "";
                    document.getElementById("billAddress").value = data.address || "";
                    document.getElementById("shipAddress").value = data.address || "";
                    document.getElementById("custRefNo").value = data.vendor_reference_no || "";
                    document.getElementById("rfqNo").value = data.rfq_no || "";
                    //document.getElementById("rfqDate").value = data.rfq_date || "";
                    document.getElementById("rfqDate").value = formatDate(data.rfq_date);
                    document.getElementById("projectDescription").value = data.description || "";
                    document.getElementById("deliveryTerms").value = data.delivery_terms || "";
                    document.getElementById("additionalCharges").value = data.additional_charges || "";
                    document.getElementById("note").value = data.note || "";

                    // Fill product table using raw_materials array
                    fillProductTableFromQuotation(data.items);
                    // Totals and financials
                    document.getElementById("totalAmount").value = data.sub_total || "";
                    document.getElementById("grandTotal").value = data.grand_total || "";
                    document.getElementById("roundUp").value = data.round_up || "";
                    calculateAllTotals();
                } catch (err) {
                    console.error("Failed to load quotation data:", err);
                }
            });

            // ==== 3. On Page Load: Set Dates, Generate SO Number, Setup Initial Row ====
            try {
                const soResponse = await fetch("{{ url('superadmin/generate-po-id') }}");
                const soData = await soResponse.json();
                document.getElementById('sOrderNo').value = soData.so_id;
            } catch (error) {
                document.getElementById('sOrderNo').value = 'UEPL/PO/0001';
            }
            document.getElementById('sOrderDate').value = new Date().toISOString().split('T')[0];

            // Setup event listeners for initial row
            document.querySelectorAll("#productTable tbody tr").forEach(row => {
                addRowEventListeners(row);
            });

            // ==== 4. Add/Remove Product Rows, Calculation Logic ====
        
            window.addRow = function () {
                const table = document.getElementById("productTable").querySelector("tbody");
                const idx = table.rows.length + 1;
                const row = document.createElement("tr");

                row.innerHTML = `
                    <td>${idx}</td>
                    <td>
                        <select class="form-control item-select" name="item[]" required>
                            <option value="">Select Item</option>
                            @foreach ($stock_items as $item)
                                <option value="{{ $item->id }}">{{ $item->item_name }}</option>
                            @endforeach
                        </select>
                    </td>
                    <td><input type="text" name="description" class="form-control" /></td>
                    <td><input type="date" name="req_by_date" class="form-control" /></td>
                    <td><input type="number" name="quantity" class="form-control" step="1" min="0" /></td>
                    <td><input type="text" name="uom" class="form-control" /></td>
                    <td><input type="number" name="unit_rate" class="form-control" step="0.01" /></td>
                    <td><input type="number" name="tds" class="form-control" step="0.01" /></td>
                    <td><input type="number" name="discount" class="form-control" step="0.01" /></td>
                    <td><input type="number" name="value" class="form-control" step="0.01" readonly /></td>
                    <td><input type="number" name="sgst" class="form-control" step="0.01" /></td>
                    <td><input type="number" name="cgst" class="form-control" step="0.01" /></td>
                    <td><input type="number" name="igst" class="form-control" step="0.01" /></td>
                    <td><input type="number" name="amount" class="form-control" step="0.01" readonly /></td>
                    <td>
                        <button type="button" class="btn btn-danger btn-sm" onclick="deleteRow(this)">
                            <i class="fa fa-trash"></i>
                        </button>
                    </td>
                `;

        
                table.appendChild(row);
        
                addRowEventListeners(row); // attach input listeners
                const itemSelect = row.querySelector('.item-select');
                if (itemSelect) {
                    initializeSelect2OnElement(itemSelect);
                }
            };
            
            document.getElementById("addRowBtn").addEventListener("click", addRow);

            function initializeSelect2OnElement(element) {
                if (!$(element).hasClass("select2-hidden-accessible")) {
                    $(element).select2({
                        dropdownParent: $('#soForm'),
                        width: 'resolve',
                        placeholder: "Select Item",
                        allowClear: true
                    });
                }
            }
        
            window.deleteRow = function (btn) {
                btn.closest("tr").remove();
                updateRowNumbers();
                calculateAllTotals();
            };

            function updateRowNumbers() {
                const rows = document.querySelectorAll("#productTable tbody tr");
                rows.forEach((row, i) => row.cells[0].textContent = i + 1);
            }
            
            function addRowEventListeners(row) {    
                ["quantity", "unit_rate", "discount","tds", "sgst", "cgst", "igst"].forEach(name => {
                    row.querySelector(`[name="${name}"]`).addEventListener("input", () => calculateRowValue(row));
                });
            }

            function calculateRowValue(row) {
                const quantity = parseFloat(row.querySelector('[name="quantity"]').value) || 0;
                const rate = parseFloat(row.querySelector('[name="unit_rate"]').value) || 0;
                const discount = parseFloat(row.querySelector('[name="discount"]').value) || 0;
                const sgst = parseFloat(row.querySelector('[name="sgst"]').value) || 0;
                const cgst = parseFloat(row.querySelector('[name="cgst"]').value) || 0;
                const igst = parseFloat(row.querySelector('[name="igst"]').value) || 0;
                const tds = parseFloat(row.querySelector('[name="tds"]').value) || 0;
            
                // Base after discount
                const base = quantity * rate * (1 - discount / 100);
                const gstTotal = base * (sgst + cgst + igst) / 100;
                const tdsAmount = base * (tds / 100);
            
                const total = base + gstTotal - tdsAmount;
            
                row.querySelector('[name="value"]').value = base.toFixed(2);
                row.querySelector('[name="amount"]').value = total.toFixed(2);
            
                calculateAllTotals();
            }

        
            function calculateAllTotals() {
                let subtotal = 0, sgstTotal = 0, cgstTotal = 0, igstTotal = 0, tdsTotal = 0;
            
                document.querySelectorAll("#productTable tbody tr").forEach(row => {
                    const value = parseFloat(row.querySelector('[name="value"]').value) || 0;
                    const sgst = parseFloat(row.querySelector('[name="sgst"]').value) || 0;
                    const cgst = parseFloat(row.querySelector('[name="cgst"]').value) || 0;
                    const igst = parseFloat(row.querySelector('[name="igst"]').value) || 0;
                    const tds = parseFloat(row.querySelector('[name="tds"]').value) || 0;
            
                    subtotal += value;
                    sgstTotal += value * sgst / 100;
                    cgstTotal += value * cgst / 100;
                    igstTotal += value * igst / 100;
                    tdsTotal += value * tds / 100;
                });
            
                const rawGrand = subtotal + sgstTotal + cgstTotal + igstTotal - tdsTotal;
                const round = Math.ceil(rawGrand) - rawGrand;
                const grand = rawGrand + round;
            
                document.getElementById("totalAmount").value = subtotal.toFixed(2);
                document.getElementById("sgstA").value = sgstTotal.toFixed(2);
                document.getElementById("cgstA").value = cgstTotal.toFixed(2);
                document.getElementById("IgstA").value = igstTotal.toFixed(2);
                document.getElementById("roundUp").value = round.toFixed(2);
                document.getElementById("grandTotal").value = grand.toFixed(2);
                document.getElementById("inr_in_words").value = convertNumberToWords(grand.toFixed(0));
            }

        
            function convertNumberToWords(num) {
                const a = ['', 'One', 'Two', 'Three', 'Four', 'Five', 'Six', 'Seven', 'Eight', 'Nine', 'Ten',
                    'Eleven', 'Twelve', 'Thirteen', 'Fourteen', 'Fifteen', 'Sixteen', 'Seventeen', 'Eighteen', 'Nineteen'];
                const b = ['', '', 'Twenty', 'Thirty', 'Forty', 'Fifty', 'Sixty', 'Seventy', 'Eighty', 'Ninety'];
        
                if (num === 0) return 'Zero Only';
        
                function inWords(n) {
                    if (n < 20) return a[n];
                    if (n < 100) return b[Math.floor(n / 10)] + (n % 10 ? ' ' + a[n % 10] : '');
                    if (n < 1000) return a[Math.floor(n / 100)] + ' Hundred ' + (n % 100 ? 'and ' + inWords(n % 100) : '');
                    if (n < 100000) return inWords(Math.floor(n / 1000)) + ' Thousand ' + (n % 1000 ? inWords(n % 1000) : '');
                    if (n < 10000000) return inWords(Math.floor(n / 100000)) + ' Lakh ' + (n % 100000 ? inWords(n % 100000) : '');
                    return inWords(Math.floor(n / 10000000)) + ' Crore ' + (n % 10000000 ? inWords(n % 10000000) : '');
                }
        
                return inWords(Math.floor(num)) + " Only";
            }
        
            // ==== 5. Fill product table from quotation data ====
            function fillProductTableFromQuotation(items) {
                const tbody = document.querySelector("#productTable tbody");
                tbody.innerHTML = ""; // clear existing rows
                items.forEach((rm, i) => {
                    const row = document.createElement("tr");
                    row.innerHTML = `
                        <td>${i + 1}</td>
                        <td>
                            <select class="form-control item-select" name="item[]" required>
                                <option value="">Select Item</option>
                                ${stockItems.map(si => `
                                    <option value="${si.id}" ${rm.stock_item == si.id ? 'selected' : ''}>${si.item_name}</option>
                                `).join('')}
                            </select>
                        </td>
                        <td><input type="text" name="description" class="form-control" value="${rm.description || ''}" /></td>
                        <td><input type="date" name="req_by_date" class="form-control" value="${rm.req_by_date || ''}" /></td>
                        <td><input type="number" name="quantity" class="form-control" step="1" min="0" value="${rm.quantity || 0}" /></td>
                        <td><input type="text" name="uom" class="form-control" value="${rm.uom || ''}" /></td>
                        <td><input type="number" name="unit_rate" class="form-control" step="0.01" value="${rm.unit_rate || 0}" /></td>
                        <td><input type="number" name="tds" class="form-control" step="0.01" value="${rm.tds || 0}" /></td>
                        <td><input type="number" name="discount" class="form-control" step="0.01" value="${rm.discount || 0}" /></td>
                        <td><input type="number" name="value" class="form-control" step="0.01" readonly value="0" /></td>
                        <td><input type="number" name="sgst" class="form-control" step="0.01" value="${rm.sgst || 0}" /></td>
                        <td><input type="number" name="cgst" class="form-control" step="0.01" value="${rm.cgst || 0}" /></td>
                        <td><input type="number" name="igst" class="form-control" step="0.01" value="${rm.igst || 0}" /></td>
                        <td><input type="number" name="amount" class="form-control" step="0.01" readonly value="0" /></td>
                        <td><button type="button" class="btn btn-danger btn-sm" onclick="deleteRow(this)"><i class="fa fa-trash"></i></button></td>
                    `;
                    tbody.appendChild(row);
                    addRowEventListeners(row);
                    calculateRowValue(row);
                });
                updateRowNumbers();

                initializeItemSelects();
            }

            window.printSO = function() {
                window.print();
            }

            // Function to convert numbers to words
            function convertNumberToWords(num) {
                var a = [
                    '', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'ten',
                    'eleven', 'twelve', 'thirteen', 'fourteen', 'fifteen', 'sixteen', 'seventeen', 'eighteen', 'nineteen'
                ];
                var b = ['', '', 'twenty', 'thirty', 'forty', 'fifty', 'sixty', 'seventy', 'eighty', 'ninety'];
            
                if ((num = num.toString()).length > 9) return 'Overflow';
                if (parseInt(num) === 0) return 'Zero';
            
                num = ('000000000' + num).substr(-9);
                var n = [
                    parseInt(num.substr(0, 2), 10),  // crore
                    parseInt(num.substr(2, 2), 10),  // lakh
                    parseInt(num.substr(4, 2), 10),  // thousand
                    parseInt(num.substr(6, 1), 10),  // hundred
                    parseInt(num.substr(7, 2), 10)   // rest
                ];
            
                var str = '';
                if (n[0] !== 0) {
                    str += (n[0] < 20) ? a[n[0]] : b[Math.floor(n[0] / 10)] + ' ' + a[n[0] % 10];
                    str += ' crore ';
                }
                if (n[1] !== 0) {
                    str += (n[1] < 20) ? a[n[1]] : b[Math.floor(n[1] / 10)] + ' ' + a[n[1] % 10];
                    str += ' lakh ';
                }
                if (n[2] !== 0) {
                    str += (n[2] < 20) ? a[n[2]] : b[Math.floor(n[2] / 10)] + ' ' + a[n[2] % 10];
                    str += ' thousand ';
                }
                if (n[3] !== 0) {
                    str += a[n[3]] + ' hundred ';
                }
                if (n[4] !== 0) {
                    if (str !== '') str += 'and ';
                    str += (n[4] < 20) ? a[n[4]] : b[Math.floor(n[4] / 10)] + ' ' + a[n[4] % 10];
                    str += ' ';
                }
                str = str.replace(/\s+/g, ' ').trim();
                return str.charAt(0).toUpperCase() + str.slice(1);
            }
            
            function getTableData(tableId) {
                const table = document.getElementById(tableId);
                const rows = table.getElementsByTagName("tbody")[0].getElementsByTagName("tr");
                const data = [];
                let slNo = 1;
            
                for (let row of rows) {
                    const itemSelect = row.cells[1].querySelector("select");
                    const rowData = {
                        sl_no: slNo++,
                        item: itemSelect ? itemSelect.value : "",
                        description: row.cells[2].querySelector("input")?.value || "",
                        req_by_date: row.cells[3].querySelector("input")?.value || "",
                        quantity: row.cells[4].querySelector("input")?.value || "",
                        uom: row.cells[5].querySelector("input")?.value || "",
                        unit_rate: row.cells[6].querySelector("input")?.value || "",
                        tds: row.cells[7].querySelector("input")?.value || "",
                        discount: row.cells[8].querySelector("input")?.value || "",
                        value: row.cells[9].querySelector("input")?.value || "",
                        sgst: row.cells[10].querySelector("input")?.value || "",
                        cgst: row.cells[11].querySelector("input")?.value || "",
                        igst: row.cells[12].querySelector("input")?.value || "",
                        amount: row.cells[13].querySelector("input")?.value || ""
                    };
                    data.push(rowData);
                }
            
                return data;
            }


            
            // --- Save SO function ---
            window.saveSO = async function(event) {
                event.preventDefault();
                Swal.fire({
                    title: 'Please wait...',
                    text: 'Saving Purchase Order...',
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading();
                    }
                });
                
                calculateAllTotals();
            
                // Collect form data
                const formData = {
                    
                    sOrderNo: document.getElementById('sOrderNo').value,
                    sOrderDate: document.getElementById('sOrderDate').value,
                    quotationNo2: document.getElementById('quotationSelect').selectedOptions[0].text === 'Select Quotation' 
                        ? null 
                        : document.getElementById('quotationSelect').selectedOptions[0].text,
                    quotationId: document.getElementById('quotationSelect').value,
                    quotationDate: document.getElementById('quotationDate').value,
                    billAddress: document.getElementById('billAddress').value,
                    shipAddress: document.getElementById('shipAddress').value,
                
                    soCompanyId: document.getElementById('soCompanyId').value,
                    soCompanyName: document.getElementById('soCompanyName').value,
                
                    soCompanyAddress: document.getElementById('soCompanyAddress').value,
                    soCompanyGSTN: document.getElementById('soCompanyGSTN').value,
                    soCompanyPhone: document.getElementById('soCompanyPhone').value,
                    soCompanyEmail: document.getElementById('soCompanyEmail').value,
                
                    custRefNo: document.getElementById('custRefNo').value,
                    
                    rfqNo: document.getElementById('rfqNo').value,
                    rfqDate: document.getElementById('rfqDate').value,
                    projectDescription: document.getElementById('projectDescription').value,
                    deliveryTerms: document.getElementById('deliveryTerms').value,
                    additionalCharges: document.getElementById('additionalCharges').value,
                    note: document.getElementById('note').value,
                
                    tableProducts: getTableData("productTable"),
                    inr_in_words: document.getElementById('inr_in_words').value,
                    totalAmount: document.getElementById('totalAmount').value,
                    sgstA: document.getElementById('sgstA').value,
                    cgstA: document.getElementById('cgstA').value,
                    IgstA: document.getElementById('IgstA').value,
                    roundUp: document.getElementById('roundUp').value,
                    grandTotal: document.getElementById('grandTotal').value
                };

            
                // Debug log
                console.log("[saveSO] FormData to send:", formData);
            
                try {
                    const response = await fetch("{{ route('superadmin.purchase.order.store') }}", {
                        method: "POST",
                        headers: {
                            "Content-Type": "application/json",
                            "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]')
                                .getAttribute('content')
                        },
                        body: JSON.stringify(formData)
                    });
                    
                    const data = await response.json();
                    console.log("[saveSO] Response:", data);
            
                    Swal.close();
            
                    if (data.message && data.message.includes('Purchase Order saved')) {
                        Swal.fire('Success!', data.message, 'success').then(() =>
                            window.location.href = "{{ url('superadmin/purchaseorder') }}"
                        );
                    } else {
                        Swal.fire('Error!', data.message || data.error ||
                            'Something went wrong.', 'error');
                    }
                } catch (err) {
                    Swal.close();
                    Swal.fire('Error!', 'Failed to save purchase order.', 'error');
                    console.error("[saveSO] Exception:", err);
                }
            }


            // --- Make the form submit use saveSO ---
            document.getElementById('soForm').addEventListener('submit', window.saveSO);

            // Calculate totals initially
            calculateAllTotals();

        });
        
        function initializeItemSelects() {
            $('.item-select').each(function () {
                const $this = $(this);
        
                // Initialize only if not already initialized
                if (!$this.hasClass("select2-hidden-accessible")) {
                    $this.select2({
                        dropdownParent: $('#soForm'),
                        width: 'resolve',
                        placeholder: "Select Item",
                        allowClear: true
                    });
                }
            });
        }


        $(document).ready(function () {
            initializeItemSelects();
        });
      
        function formatDate(dateString) {
            if (!dateString) return "";
            const date = new Date(dateString);
            const year = date.getFullYear();
            const month = String(date.getMonth() + 1).padStart(2, '0'); // months are 0-indexed
            const day = String(date.getDate()).padStart(2, '0');
            return `${year}-${month}-${day}`;
        }
    </script>

@endsection
