@extends('layouts.dashboard.superadminapp')

@section('title', 'Manage Stock Items')
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap4.min.css">

<style>
    div.dt-buttons {
        float: left;
        display: flex !important;
    }

    .dataTable {
        overflow-x: auto !important;
        display: table !important;
    }

    .dt-buttons .btn {
        margin-right: 0.5rem !important;
        padding: 0.25rem 0.75rem !important;
        font-size: 0.95rem !important;
    }
</style>

@section('content')
<div class="container-fluid">
    <div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h5 mb-0 text-gray-800">UEPL / Stock Items</h1>
        <div class="display-date">
            <span id="day">day</span>, <span id="daynum">00</span> <span id="month">month</span> <span id="year">0000</span>
        </div>
        <div class="display-time"></div>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header d-flex justify-content-between align-items-center gap-3">
            <span class="fw-bold">Manage Items</span>
            <!-- Action buttons -->
            <div style="float: right;">
                <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#categoryModal">Add Category</button>
                <button class="btn btn-success btn-sm" data-bs-toggle="modal" data-bs-target="#itemModal">Add Item</button>
                <form action="{{ route('superadmin.stockitems.import') }}" method="POST" enctype="multipart/form-data" class="d-flex gap-2 mt-2">
                    @csrf
                    <input type="file" name="excel_file" class="form-control form-control-sm" required>
                    <button type="submit" class="btn btn-dark btn-sm">Import Excel</button>
                </form>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="stockItemsTable">
                    <thead class="table-light">
                        <tr class="text-center align-middle">
                            <th>Sl No</th>
                            <th>Item</th>
                            <th>Category</th>
                            <th>UOM</th>
                            <th>SGST</th>
                            <th>CGST</th>
                            <th>IGST</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($stockItems as $item)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $item->item_name }}</td>
                                <td>{{ $item->category->name }}</td>
                                <td>{{ $item->uom }}</td>
                                <td>{{ $item->sgst }}</td>
                                <td>{{ $item->cgst }}</td>
                                <td>{{ $item->igst }}</td>
                                <td>
                                    <button 
                                        class="btn btn-info btn-sm editItemBtn"
                                        data-id="{{ $item->id }}"
                                        data-item_name="{{ $item->item_name }}"
                                        data-category_id="{{ $item->category_id }}"
                                        data-uom="{{ $item->uom }}"
                                        data-sgst="{{ $item->sgst }}"
                                        data-cgst="{{ $item->cgst }}"
                                        data-igst="{{ $item->igst }}"
                                        data-bs-toggle="modal" 
                                        data-bs-target="#editItemModal" title="Edit">
                            <i class="fas fa-edit"></i>
                                    </button>

                                    <form action="{{ route('superadmin.stockitems.destroy', $item->id) }}" method="POST" style="display:inline;">
                                        @csrf 
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Delete this item?')" title="Delete">
                            <i class="fas fa-trash-alt"></i></button>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- CATEGORY MODAL -->
    <div class="modal fade" id="categoryModal" tabindex="-1">
        <div class="modal-dialog">
            <form action="{{ route('superadmin.categories.store') }}" method="POST" class="modal-content">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Add Category</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <span>x</span>
                    </button>
                </div>
                <div class="modal-body">
                    @if ($errors->has('name'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            {{ $errors->first('name') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                               
                            </button>
                        </div>
                    @endif
    
                    <label for="categoryName">Category Name</label>
                    <input
                        type="text"
                        name="name"
                        id="categoryName"
                        class="form-control"
                        required
                        value="{{ old('name') }}"
                    >
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Save Category</button>
                </div>
            </form>
        </div>
    </div>

    <!-- ADD ITEM MODAL -->
    <div class="modal fade" id="itemModal" tabindex="-1">
        <div class="modal-dialog">
            <form action="{{ route('superadmin.stockitems.store') }}" method="POST" class="modal-content">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Add Item</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"> <span>x</span></button>
                </div>
                <div class="modal-body">
                    {{-- Show error alert --}}
                    @if ($errors->any() && session('show_main_modal'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            {{ $errors->first() }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif
                    
                    <label>Category</label>
                    <select name="category_id" class="form-control" required>
                        @foreach($categories as $cat)
                            <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                        @endforeach
                    </select>

                    <label class="mt-2">Item Name</label>
                    <input type="text" name="item_name" class="form-control" required>

                    <label class="mt-2">UOM</label>
                    <input type="text" name="uom" class="form-control">

                    <label class="mt-2">SGST</label>
                    <input type="number" step="0.01" name="sgst" class="form-control">

                    <label class="mt-2">CGST</label>
                    <input type="number" step="0.01" name="cgst" class="form-control">

                    <label class="mt-2">IGST</label>
                    <input type="number" step="0.01" name="igst" class="form-control">
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">Save Item</button>
                </div>
            </form>
        </div>
    </div>

    <!-- EDIT ITEM MODAL -->
    <div class="modal fade" id="editItemModal" tabindex="-1">
        <div class="modal-dialog">
            <form method="POST" id="editItemForm" class="modal-content">
                @csrf
                @method('PUT')
                <div class="modal-header">
                    <h5 class="modal-title">Edit Item</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
    
                <div class="modal-body">
                    {{-- Show error alert --}}
                    @if ($errors->any() && session('edit_item_id'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            {{ $errors->first() }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif
    
                    <label>Category</label>
                    <select name="category_id" id="edit_category_id" class="form-control" required>
                        @foreach($categories as $cat)
                            <option value="{{ $cat->id }}"
                                {{ old('category_id') == $cat->id ? 'selected' : '' }}>
                                {{ $cat->name }}
                            </option>
                        @endforeach
                    </select>
    
                    <label class="mt-2">Item Name</label>
                    <input type="text" name="item_name" id="edit_item_name" class="form-control"
                        value="{{ old('item_name') }}" required>
    
                    <label class="mt-2">UOM</label>
                    <input type="text" name="uom" id="edit_uom" class="form-control"
                        value="{{ old('uom') }}">
    
                    <label class="mt-2">SGST</label>
                    <input type="number" step="0.01" name="sgst" id="edit_sgst" class="form-control"
                        value="{{ old('sgst') }}">
    
                    <label class="mt-2">CGST</label>
                    <input type="number" step="0.01" name="cgst" id="edit_cgst" class="form-control"
                        value="{{ old('cgst') }}">
    
                    <label class="mt-2">IGST</label>
                    <input type="number" step="0.01" name="igst" id="edit_igst" class="form-control"
                        value="{{ old('igst') }}">
                </div>
    
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Update Item</button>
                </div>
            </form>
        </div>
    </div>

</div>
@endsection

@push('scripts')
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Bootstrap Bundle JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <!-- DataTables JS -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap4.min.js"></script>

    <script>
        $(document).ready(function () {
            // Initialize DataTable
            const table = $('#stockItemsTable').DataTable();  

            // Use event delegation for edit buttons (works with pagination)
            $(document).on('click', '.editItemBtn', function () {
                const id = $(this).data('id');
                
                // Construct the update route
                const updateRoute = "{{ route('superadmin.stockitems.update', ':id') }}";
                $('#editItemForm').attr('action', updateRoute.replace(':id', id));

                // Populate form fields
                $('#edit_item_name').val($(this).data('item_name'));
                $('#edit_category_id').val($(this).data('category_id'));
                $('#edit_uom').val($(this).data('uom'));
                $('#edit_sgst').val($(this).data('sgst'));
                $('#edit_cgst').val($(this).data('cgst'));
                $('#edit_igst').val($(this).data('igst'));
            });
        });
    </script>
    @if ($errors->has('name'))
        <script>
            $(document).ready(function() {
                $('#categoryModal').modal('show');
            });
        </script>
    @endif
    
    @if ($errors->any() && session('edit_item_id'))
        <script>
            $(document).ready(function () {
                $('#editItemModal').modal('show');
            });
        </script>
    @endif
    
    @if ($errors->any() && session('show_main_modal'))
        <script>
            $(document).ready(function() {
                $('#itemModal').modal('show');
            });
        </script>
    @endif
@endpush