@extends('layouts.dashboard.superadminapp')

@section('title', 'Production In Progress')

@push('styles')
    <style>
        :root {
            /* Standard Blue Gradient matching Planning Page */
            --primary-gradient: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
            --card-shadow: 0 10px 15px -3px rgba(0,0,0,0.1), 0 4px 6px -2px rgba(0,0,0,0.05);
            --hover-shadow: 0 20px 25px -5px rgba(0,0,0,0.1), 0 10px 10px -5px rgba(0,0,0,0.04);
            --text-dark: #2d3748;
            --text-muted: #718096;
            --bg-light: #f8f9fa;
        }

        body {
            background-color: var(--bg-light);
            font-family: 'Inter', sans-serif;
        }

        /* Gradient Header */
        .page-header-gradient {
            background: var(--primary-gradient);
            color: white;
            padding: 2rem 2.5rem;
            border-radius: 20px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            position: relative;
            z-index: 10;
            margin-bottom: 2rem;
        }

        .breadcrumb-item + .breadcrumb-item::before {
            color: rgba(255, 255, 255, 0.6);
        }
        .breadcrumb-item.active {
            color: rgba(255, 255, 255, 0.9);
        }

        /* Premium Card */
        .premium-card {
            background: white;
            border: none;
            border-radius: 16px;
            box-shadow: var(--card-shadow);
            transition: all 0.3s ease;
            height: 100%;
            display: flex;
            flex-direction: column;
            overflow: hidden;
            border: 1px solid rgba(0,0,0,0.02);
        }

        .premium-card:hover {
            transform: translateY(-5px);
            box-shadow: var(--hover-shadow);
        }

        .card-header-stripe {
            height: 6px;
            background: var(--primary-gradient);
            width: 100%;
        }

        .card-body-content {
            padding: 1.5rem;
            flex-grow: 1;
            display: flex;
            flex-direction: column;
        }

        .rc-number {
            font-size: 1.2rem;
            font-weight: 700;
            color: var(--text-dark);
            margin-bottom: 0.2rem;
        }

        .company-name {
            font-size: 0.95rem;
            color: var(--text-muted);
            margin-bottom: 1rem;
            font-weight: 500;
        }

        .detail-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 0.6rem;
            font-size: 0.9rem;
        }

        .detail-label {
            color: var(--text-muted);
        }

        .detail-value {
            font-weight: 600;
            color: var(--text-dark);
        }

        /* Progress Bar */
        .progress-container {
            margin: 1rem 0;
        }
        .progress {
            height: 8px;
            border-radius: 4px;
            background-color: #edf2f7;
            overflow: hidden;
        }
        .progress-bar-custom {
            background: var(--primary-gradient);
        }

        /* Buttons */
        .btn-action-primary {
            background: var(--primary-gradient);
            border: none;
            color: white;
            padding: 0.6rem 1rem;
            border-radius: 8px;
            font-weight: 600;
            width: 100%;
            transition: opacity 0.2s;
            display: block;
            text-align: center;
        }
        .btn-action-primary:hover {
            opacity: 0.95;
            color: white;
            text-decoration: none;
        }
        
        .btn-sm-glass {
            background: rgba(255,255,255,0.2);
            border: 1px solid rgba(255,255,255,0.3);
            color: white;
            font-size: 0.85rem;
            border-radius: 6px;
        }
        .btn-sm-glass:hover {
            background: rgba(255,255,255,0.3);
            color: white;
        }
        
        .status-badge {
            background: #e3f2fd;
            color: #1565c0;
            padding: 0.25rem 0.6rem;
            border-radius: 20px;
            font-size: 0.75rem;
            font-weight: 700;
            text-transform: uppercase;
        }

        .empty-state {
            padding: 3rem;
            text-align: center;
            background: white;
            border-radius: 16px;
            box-shadow: var(--card-shadow);
        }
    </style>
@endpush

@section('content')
    <!-- Gradient Header -->
    <div class="page-header-gradient">
        <div class="container-fluid">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="h3 font-weight-bold mb-1">Production In Progress</h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb bg-transparent p-0 m-0">
                            <li class="breadcrumb-item"><a href="{{ url('superadmin/dashboard') }}" class="text-white-50">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ url('superadmin/manufacturing/planning') }}" class="text-white-50">Planning</a></li>
                            <li class="breadcrumb-item active" aria-current="page">In Progress</li>
                        </ol>
                    </nav>
                </div>
                <div>
                    <a href="{{ url('superadmin/manufacturing/planning') }}" class="btn btn-sm-glass shadow-sm">
                        <i class="fas fa-arrow-left mr-1"></i> Back to Planning
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="container-fluid" style="position: relative; z-index: 20; padding-top: 0;">
        <div class="row">
            @forelse($routeCards as $rc)
                @php
                    // Calculate Progress
                    $total = $rc->processes->count();
                    $completed = $rc->processes->where('status', 'completed')->count(); // Or 'approved' based on logic
                    // If logic uses 'approved' for completion, adjust here. 
                    // Usually 'completed' or 'approved' signifies done. 
                    // Checking controller logic: startProcess -> qc -> approved. So 'approved' is done.
                    $approvedCount = $rc->processes->where('status', 'approved')->count();
                    $percent = $total > 0 ? round(($approvedCount / $total) * 100) : 0;
                @endphp
                <div class="col-12 col-md-6 col-lg-4 mb-4">
                    <div class="premium-card">
                        <div class="card-header-stripe"></div>
                        <div class="card-body-content">
                            <div class="d-flex justify-content-between align-items-start mb-2">
                                <div>
                                    <div class="rc-number">{{ $rc->route_no }}</div>
                                    <div class="company-name"><i class="far fa-building mr-1"></i> {{Str::limit($rc->company_name, 25) }}</div>
                                </div>
                                <span class="status-badge">
                                    In Production
                                </span>
                            </div>

                            <div class="detail-row">
                                <span class="detail-label">RC Date:</span>
                                <span class="detail-value">{{ $rc->route_date ? date('d M Y', strtotime($rc->route_date)) : '-' }}</span>
                            </div>

                            <!-- Progress Section -->
                            <div class="progress-container">
                                <div class="d-flex justify-content-between small mb-1">
                                    <span class="text-muted">Production Progress</span>
                                    <span class="font-weight-bold {{ $percent == 100 ? 'text-success' : 'text-primary' }}">{{ $percent }}%</span>
                                </div>
                                <div class="progress">
                                    <div class="progress-bar progress-bar-custom" role="progressbar" style="width: {{ $percent }}%"></div>
                                </div>
                            </div>
                            
                            <div class="mt-auto">
                               <div class="detail-row align-items-center mb-3">
                                     <span class="detail-label"><i class="fas fa-user-shield mr-1"></i> Planned By:</span>
                                     <span class="detail-value" style="font-size:0.85rem;">
                                        {{ $rc->approved_by ?? 'Admin' }}
                                     </span>
                                </div>

                                <a href="{{ route('superadmin.production.board', $rc->id) }}" class="btn-action-primary shadow-sm">
                                    <i class="fas fa-cogs mr-1"></i> View Production Board
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            @empty
                <div class="col-12">
                    <div class="empty-state">
                        <i class="fas fa-industry fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted">No production lines active.</h5>
                        <p class="text-muted mb-0">Moves Route Cards here from "Ready to Production".</p>
                    </div>
                </div>
            @endforelse
        </div>
    </div>
@endsection
