@extends('layouts.dashboard.superadminapp')
@section('title', 'Production Schedule')

@push('styles')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/frappe-gantt/0.6.1/frappe-gantt.css">
<style>
    :root {
        --primary-gradient: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
    }
    
    body {
        background-color: #f8f9fa;
        font-family: 'Inter', sans-serif;
    }

    /* Gradient Header */
    .page-header-gradient {
        background: var(--primary-gradient);
        color: white;
        padding: 2rem 2.5rem;
        border-radius: 20px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        margin-bottom: 2rem;
    }

    .card {
        border-radius: 16px;
         box-shadow: 0 10px 15px -3px rgba(0,0,0,0.1), 0 4px 6px -2px rgba(0,0,0,0.05);
         border:none;
    }

    /* Gantt Customization */
    .gantt .bar-progress {
        fill: #4e73df;
    }
    .gantt-project .bar {
        fill: #2d3748;
    }
    .gantt-project .bar-progress {
        fill: #4a5568;
    }
    
    .gantt-process-pending .bar { fill: #cbd5e0; }
    .gantt-process-pending .bar-progress { fill: #a0aec0; }
    
    .gantt-process-in-running .bar { fill: #bfdbfe; }
    .gantt-process-in-running .bar-progress { fill: #3b82f6; }
    
    .gantt-process-is-completed .bar { fill: #bbf7d0; }
    .gantt-process-is-completed .bar-progress { fill: #22c55e; }

    .gantt .bar-label {
        fill: #fff;
        font-weight: 500;
        font-size: 12px;
    }
    
    .filter-bar {
        background: white;
        padding: 1rem;
        border-radius: 12px;
        margin-bottom: 1.5rem;
        display: flex;
        gap: 1rem;
        align-items: center;
        box-shadow: 0 2px 5px rgba(0,0,0,0.05);
    }
</style>
@endpush

@section('content')
<div class="page-header-gradient">
    <div class="d-flex justify-content-between align-items-center">
        <div>
            <h1 class="h3 font-weight-bold mb-1">Production Schedule</h1>
            <p class="mb-0 text-white-50">Timeline view of all planned projects and processes.</p>
        </div>
         <a href="{{ url('superadmin/routecard/routecarddetails') }}" class="btn btn-sm-glass shadow-sm" style="background: rgba(255,255,255,0.2); border: 1px solid rgba(255,255,255,0.3); color: white;">
            <i class="fas fa-list mr-1"></i> List View
        </a>
    </div>
</div>

<div class="container-fluid" style="margin-top:-1rem;">
    
    <div class="filter-bar">
        <label class="font-weight-bold mb-0 text-dark mr-2"><i class="fas fa-filter mr-1"></i> View Mode:</label>
        <div class="btn-group btn-group-toggle" data-toggle="buttons">
            <label class="btn btn-light active border">
                <input type="radio" name="view_mode" value="Day" checked onchange="changeViewMode('Day')"> Day
            </label>
            <label class="btn btn-light border">
                <input type="radio" name="view_mode" value="Week" onchange="changeViewMode('Week')"> Week
            </label>
            <label class="btn btn-light border">
                 <input type="radio" name="view_mode" value="Month" onchange="changeViewMode('Month')"> Month
            </label>
        </div>
        
        <div class="ml-auto">
             <button class="btn btn-primary" onclick="loadGantt()"><i class="fas fa-sync-alt"></i> Refresh</button>
        </div>
    </div>

    <div class="card">
        <div class="card-body p-0">
            <div id="gantt"></div>
            <div id="empty-state" class="text-center p-5 d-none">
                <img src="https://img.freepik.com/free-vector/no-data-concept-illustration_114360-536.jpg" style="max-width: 200px; opacity:0.8;">
                <h5 class="mt-3 text-muted">No scheduled tasks found</h5>
            </div>
        </div>
    </div>

</div>
@endsection

@push('scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/frappe-gantt/0.6.1/frappe-gantt.min.js"></script>
<script>
    let ganttChart;
    let tasksData = [];

    function loadGantt() {
        $('#gantt').html('<div class="text-center p-5"><div class="spinner-border text-primary"></div></div>');
        
        fetch("{{ url('superadmin/manufacturing/gantt-data') }}")
            .then(r => r.json())
            .then(data => {
                tasksData = data;
                if(data.length === 0) {
                    $('#gantt').html('');
                    $('#empty-state').removeClass('d-none');
                    return;
                }
                $('#empty-state').addClass('d-none');
                $('#gantt').html(''); 
                
                ganttChart = new Gantt("#gantt", tasksData, {
                    header_height: 50,
                    column_width: 30,
                    step: 24,
                    view_modes: ['Quarter Day', 'Half Day', 'Day', 'Week', 'Month'],
                    bar_height: 25,
                    bar_corner_radius: 3,
                    arrow_curve: 5,
                    padding: 18,
                    view_mode: 'Day',
                    date_format: 'YYYY-MM-DD',
                    custom_popup_html: function(task) {
                        return `
                          <div class="popover fade show bs-popover-right" role="tooltip" style="position:static; min-width:200px; box-shadow: 0 5px 15px rgba(0,0,0,0.1);">
                            <div class="arrow"></div>
                            <h3 class="popover-header">${task._full_name || task.name}</h3>
                            <div class="popover-body">
                                <div><strong>Start:</strong> ${task.start}</div>
                                <div><strong>End:</strong> ${task.end}</div>
                                <div><strong>Progress:</strong> ${task.progress}%</div>
                                ${task.description ? `<div class="mt-2 small text-muted">${task.description}</div>` : ''}
                            </div>
                          </div>
                        `;
                    }
                });
            });
    }

    function changeViewMode(mode) {
        if(ganttChart) {
            ganttChart.change_view_mode(mode);
        }
    }

    $(document).ready(function() {
        loadGantt();
    });
</script>
@endpush
