@extends('layouts.dashboard.superadminapp')
@section('title', 'Edit GRN Order')

@section('styles')
<style>
    #productTable input.form-control { padding: 0.25rem 0.5rem; font-size: 0.875rem; }
</style>
@endsection

@section('content')

<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">UEPL | Edit Goods Received Note</h1>
    <div class="display-date">
        <span id="day">day</span>,
        <span id="daynum">00</span>
        <span id="month">month</span>
        <span id="year">0000</span>
    </div>
    <div class="display-time"></div>
</div>

<!-- Alerts -->
@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
@endif
@if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-circle mr-2"></i>{{ session('error') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
@endif
@if ($errors->any())
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-circle mr-2"></i>
        <ul class="mb-0">
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
@endif

<div class="card shadow mb-4">
    <div class="card-header py-3 d-flex justify-content-between align-items-center" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-edit mr-2"></i> Edit Goods Received Note
        </h6>
        <a href="{{ route('superadmin.grn.grndetails') }}" class="btn btn-light btn-sm">
            <i class="fa fa-arrow-left mr-1"></i> Back to List
        </a>
    </div>
    <div class="card-body">
        <form method="POST" action="{{ route('superadmin.grn.update', $grn->id) }}" enctype="multipart/form-data" id="grnForm">
            @csrf

            <div class="row">
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">GRN ID <span class="text-danger">*</span></label>
                    <input type="text" id="grnNo" name="grn_no" class="form-control" value="{{ $grn->grn_no }}" readonly>
                </div>
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">GRN Date <span class="text-danger">*</span></label>
                    <input type="date" id="grnDate" name="grn_date" class="form-control" value="{{ $grn->grn_date }}" required>
                </div>
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">Order ID <span class="text-danger">*</span></label>
                    <input type="text" id="orderNo" name="order_no" class="form-control" value="{{ $grn->order_no }}" required>
                </div>
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">Order Date <span class="text-danger">*</span></label>
                    <input type="date" id="orderDate" name="order_date" class="form-control" value="{{ $grn->order_date }}" required>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">Order Company Name <span class="text-danger">*</span></label>
                    <select id="companyNameSelect" name="company_name" class="form-control" onchange="fillCompanyDetails(this)" required>
                        <option value="">Select Company</option>
                        @foreach ($companies as $company)
                            <option value="{{ $company->company }}"
                                data-address="{{ $company->billing_Address }}"
                                data-gst="{{ $company->gstno }}"
                                data-email="{{ $company->email }}"
                                data-phone="{{ $company->mobile }}"
                                {{ $grn->company_name == $company->company ? 'selected' : '' }}>
                                {{ $company->company }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">Order Reference No</label>
                    <input type="text" id="orderRefNo" name="order_ref_no" class="form-control" value="{{ $grn->order_ref_no }}">
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">Address</label>
                    <input type="text" id="companyAddress" name="company_address" class="form-control" value="{{ $grn->company_address }}">
                </div>
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">GST No</label>
                    <input type="text" id="companyGSTN" name="company_gst" class="form-control" value="{{ $grn->company_gst }}">
                </div>
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">Email</label>
                    <input type="email" id="companyEmail" name="company_email" class="form-control" value="{{ $grn->company_email }}">
                </div>
            </div>

            <div class="row">
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">Contact Number</label>
                    <input type="tel" id="companyPhone" name="company_phone" class="form-control" value="{{ $grn->company_phone }}">
                </div>
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">Quotation ID</label>
                    <input type="text" id="quotationNo" name="quotation_no" class="form-control" value="{{ $grn->quotation_no }}">
                </div>
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">Quotation Date</label>
                    <input type="date" id="quotationDate" name="quotation_date" class="form-control" value="{{ $grn->quotation_date }}">
                </div>
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">RFQ No</label>
                    <input type="text" id="rfqNo" name="rfq_no" class="form-control" value="{{ $grn->rfq_no }}">
                </div>
            </div>

            <div class="row">
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">RFQ Date</label>
                    <input type="date" id="rfqDate" name="rfq_date" class="form-control" value="{{ $grn->rfq_date }}">
                </div>
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">Part No</label>
                    <input type="text" id="partNo" name="part_no" class="form-control" value="{{ $grn->part_no }}">
                </div>
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">Project Material No</label>
                    <input type="text" id="project-materialNo" name="project_material_no" class="form-control" value="{{ $grn->project_material_no }}">
                </div>
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">Drawing No</label>
                    <input type="text" id="drawingNo" name="drawing_no" class="form-control" value="{{ $grn->drawing_no }}">
                </div>
            </div>

            <div class="row">
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">Drawing Revision</label>
                    <input type="text" id="drawingRev" name="drawing_rev" class="form-control" value="{{ $grn->drawing_rev }}">
                </div>
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">Upload Challan (PDF)</label>
                    <input type="file" id="grnChallan" name="challan" accept=".pdf" class="form-control">
                    @if($grn->challan_file)
                        <small class="text-muted">Current: <a href="{{ asset('storage/' . $grn->challan_file) }}" target="_blank">View</a></small>
                    @endif
                </div>
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">Description</label>
                    <textarea id="description" name="description" rows="2" class="form-control">{{ $grn->description }}</textarea>
                </div>
            </div>

            <hr>

            <h6 class="font-weight-bold text-primary mb-3"><i class="fas fa-boxes mr-2"></i>Product Details</h6>

            <div class="row">
                <div class="col-md-4 mb-3">
                    <label class="small font-weight-bold">Product Type</label>
                    <input type="text" id="productType" name="product_type" class="form-control" value="{{ $grn->product_type }}">
                </div>
            </div>

            <div class="table-responsive">
                <table id="productTable" class="table table-bordered table-sm">
                    <thead class="thead-light">
                        <tr>
                            <th width="50">Sl No.</th>
                            <th>Description</th>
                            <th width="100">Quantity</th>
                            <th width="80">UOM</th>
                            <th width="130">Date</th>
                            <th>Supplier</th>
                            <th>Remarks</th>
                            <th width="50"></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($grn->products as $index => $product)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td><input type="text" name="products[{{ $index }}][description]" class="description form-control" value="{{ $product->description }}" required></td>
                            <td><input type="number" name="products[{{ $index }}][quantity]" class="quantity form-control" value="{{ $product->quantity }}" required></td>
                            <td><input type="text" name="products[{{ $index }}][unit]" class="unit form-control" value="{{ $product->unit }}" required></td>
                            <td><input type="date" name="products[{{ $index }}][date]" class="date form-control" value="{{ $product->date }}" required></td>
                            <td><input type="text" name="products[{{ $index }}][supplier]" class="supplier form-control" value="{{ $product->supplier }}"></td>
                            <td><input type="text" name="products[{{ $index }}][remarks]" class="remarks form-control" value="{{ $product->remarks }}"></td>
                            <td><button class="btn btn-danger btn-sm" type="button" onclick="deleteRow(this)"><i class="fa fa-trash"></i></button></td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <div class="mb-3">
                <button type="button" class="btn btn-primary btn-sm" onclick="addRow()">
                    <i class="fa fa-plus mr-1"></i> Add Row
                </button>
            </div>

            <hr>

            <div class="d-flex justify-content-end">
                <button type="submit" class="btn btn-success btn-sm mr-2" id="save-GRN">
                    <i class="fa fa-save mr-1"></i> Update
                </button>
                <a href="{{ route('superadmin.grn.grndetails') }}" class="btn btn-outline-secondary btn-sm">
                    <i class="fa fa-arrow-left mr-1"></i> Back
                </a>
            </div>
        </form>
    </div>
</div>

<script>
function addRow() {
    const table = document.querySelector("#productTable tbody");
    const index = table.rows.length;
    const row = document.createElement("tr");
    row.innerHTML = `
        <td>${index + 1}</td>
        <td><input type="text" name="products[${index}][description]" class="description form-control" required></td>
        <td><input type="number" name="products[${index}][quantity]" class="quantity form-control" required></td>
        <td><input type="text" name="products[${index}][unit]" class="unit form-control" required></td>
        <td><input type="date" name="products[${index}][date]" class="date form-control" required></td>
        <td><input type="text" name="products[${index}][supplier]" class="supplier form-control"></td>
        <td><input type="text" name="products[${index}][remarks]" class="remarks form-control"></td>
        <td><button class="btn btn-danger btn-sm" type="button" onclick="deleteRow(this)"><i class="fa fa-trash"></i></button></td>
    `;
    table.appendChild(row);
}

function deleteRow(button) {
    const row = button.closest("tr");
    row.remove();
    // Re-index remaining rows
    const rows = document.querySelectorAll("#productTable tbody tr");
    rows.forEach((tr, i) => {
        tr.querySelectorAll("input").forEach(input => {
            const name = input.name.replace(/products\[\d+\]/, `products[${i}]`);
            input.name = name;
        });
        tr.querySelector("td").textContent = i + 1;
    });
}

function fillCompanyDetails(select) {
    const selected = select.options[select.selectedIndex];
    document.getElementById('companyAddress').value = selected.getAttribute('data-address') || '';
    document.getElementById('companyGSTN').value = selected.getAttribute('data-gst') || '';
    document.getElementById('companyEmail').value = selected.getAttribute('data-email') || '';
    document.getElementById('companyPhone').value = selected.getAttribute('data-phone') || '';
}
</script>
@endsection
