@extends('layouts.dashboard.superadminapp')

@section('title', 'Attendance Matrix')

@section('styles')
<style>
    .matrix-table td, .matrix-table th {
        font-size: 11px;
        text-align: center;
        min-width: 30px;
        padding: 4px 2px;
        vertical-align: middle;
    }
    .matrix-table thead th {
        background: #e9ecef;
        font-weight: 600;
    }
    .present { background: #28a745 !important; color: #fff !important; }
    .absent { background: #dc3545 !important; color: #fff !important; }
    .lop { background: #fd7e14 !important; color: #fff !important; }
    .leave { background: #ffc107 !important; color: #222 !important; }
    .unknown { background: #e9ecef !important; color: #6c757d !important; }
    .sticky-col {
        position: sticky;
        left: 0;
        background: #fff;
        z-index: 2;
        border-right: 2px solid #dee2e6 !important;
    }
    .sticky-header {
        position: sticky;
        left: 0;
        background: #e9ecef !important;
        z-index: 3;
        border-right: 2px solid #dee2e6 !important;
    }
    .legend-badge {
        font-size: 0.8rem;
        font-weight: 500;
        border-radius: 10px;
        margin-right: 8px;
        padding: 4px 10px;
        display: inline-block;
    }
    .matrix-table {
        margin-bottom: 0;
    }
    .table-responsive {
        max-height: 600px;
        overflow: auto;
    }
    .sunday-col {
        background: #f8d7da !important;
    }
</style>
@endsection

@section('content')

<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">UEPL | Attendance Matrix</h1>
    <div class="display-date">
        <span id="day">day</span>,
        <span id="daynum">00</span>
        <span id="month">month</span>
        <span id="year">0000</span>
    </div>
    <div class="display-time"></div>
</div>

<!-- Alerts -->
@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
@endif
@if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-circle mr-2"></i>{{ session('error') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
@endif

<!-- Filter Card -->
<div class="card shadow mb-4">
    <div class="card-header py-3" style="background: linear-gradient(135deg, #6c757d 0%, #495057 100%);">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-filter mr-2"></i> Filter Options
        </h6>
    </div>
    <div class="card-body">
        <form method="GET" class="row align-items-end">
            <div class="col-md-4 mb-3 mb-md-0">
                <label class="small font-weight-bold">Select Month <span class="text-danger">*</span></label>
                <input type="month" name="month" class="form-control" value="{{ $month }}">
            </div>
            <div class="col-md-4 mb-3 mb-md-0">
                <button type="submit" class="btn btn-primary btn-sm">
                    <i class="fas fa-filter mr-1"></i> Apply Filter
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Matrix Card -->
<div class="card shadow mb-4">
    <div class="card-header py-3 d-flex justify-content-between align-items-center" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-th mr-2"></i> Attendance Matrix - {{ \Carbon\Carbon::parse($month.'-01')->format('F Y') }}
        </h6>
        <div>
            <a href="{{ route('superadmin.employee.employeecalendar') }}" class="btn btn-light btn-sm">
                <i class="fas fa-calendar-alt mr-1"></i> Calendar View
            </a>
            <a href="{{ route('superadmin.employee.employeedailyreport') }}" class="btn btn-light btn-sm ml-2">
                <i class="fas fa-list mr-1"></i> Daily Reports
            </a>
        </div>
    </div>
    <div class="card-body">
        <!-- Legend -->
        <div class="mb-3">
            <span class="legend-badge badge present">Present</span>
            <span class="legend-badge badge leave">CL/SL/PL</span>
            <span class="legend-badge badge lop">LOP</span>
            <span class="legend-badge badge absent">Absent</span>
            <span class="legend-badge badge" style="background:#f8d7da;color:#721c24;">Sunday</span>
        </div>

        <!-- Summary Stats -->
        <div class="row mb-3">
            <div class="col-md-12">
                <small class="text-muted">
                    <i class="fas fa-users mr-1"></i> Total Employees: <strong>{{ count($employees) }}</strong>
                    &nbsp;|&nbsp;
                    <i class="fas fa-calendar-day mr-1"></i> Days in Month: <strong>{{ count($dates) }}</strong>
                </small>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table table-bordered table-sm matrix-table" id="matrixTable">
                <thead>
                    <tr>
                        <th class="sticky-header" style="min-width:150px;">Employee</th>
                        @foreach($dates as $date)
                            @php
                                $dayOfWeek = \Carbon\Carbon::parse($date)->dayOfWeek;
                                $isSunday = $dayOfWeek === 0;
                            @endphp
                            <th class="{{ $isSunday ? 'sunday-col' : '' }}" title="{{ \Carbon\Carbon::parse($date)->format('l, d M Y') }}">
                                {{ \Carbon\Carbon::parse($date)->format('d') }}
                                <br>
                                <small class="text-muted">{{ \Carbon\Carbon::parse($date)->format('D')[0] }}</small>
                            </th>
                        @endforeach
                        <th style="min-width:50px;background:#d4edda;">P</th>
                        <th style="min-width:50px;background:#fff3cd;">L</th>
                        <th style="min-width:50px;background:#f8d7da;">A</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($employees as $emp)
                        @php
                            $presentCount = 0;
                            $leaveCount = 0;
                            $absentCount = 0;
                        @endphp
                        <tr>
                            <td class="sticky-col text-left">
                                <strong>{{ $emp->name }}</strong>
                                <br>
                                <span class="text-muted" style="font-size:10px;">{{ $emp->employee_id }}</span>
                            </td>
                            @foreach($dates as $date)
                                @php
                                    $status = $matrix[$emp->employee_id][$date] ?? '';
                                    $dayOfWeek = \Carbon\Carbon::parse($date)->dayOfWeek;
                                    $isSunday = $dayOfWeek === 0;

                                    $class = 'unknown';
                                    if ($status == 'Present') {
                                        $class = 'present';
                                        $presentCount++;
                                    } elseif (in_array($status, ['CL','SL','PL'])) {
                                        $class = 'leave';
                                        $leaveCount++;
                                    } elseif ($status == 'LOP') {
                                        $class = 'lop';
                                        $absentCount++;
                                    } elseif ($status == 'Absent') {
                                        $class = 'absent';
                                        $absentCount++;
                                    }

                                    if ($isSunday && $class == 'unknown') {
                                        $class = '';
                                    }
                                @endphp
                                <td class="{{ $class }} {{ $isSunday && $class == '' ? 'sunday-col' : '' }}" title="{{ $status ?: ($isSunday ? 'Sunday' : 'No Data') }}">
                                    @if($status == 'Present')
                                        <i class="fas fa-check"></i>
                                    @elseif(in_array($status, ['CL','SL','PL']))
                                        {{ $status }}
                                    @elseif($status == 'LOP')
                                        L
                                    @elseif($status == 'Absent')
                                        <i class="fas fa-times"></i>
                                    @else
                                        @if($isSunday)
                                            <span class="text-muted">S</span>
                                        @else
                                            &ndash;
                                        @endif
                                    @endif
                                </td>
                            @endforeach
                            <td style="background:#d4edda;font-weight:bold;">{{ $presentCount }}</td>
                            <td style="background:#fff3cd;font-weight:bold;">{{ $leaveCount }}</td>
                            <td style="background:#f8d7da;font-weight:bold;">{{ $absentCount }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script>
$(document).ready(function() {
    // Optional: Add hover effect for better readability
    $('.matrix-table tbody tr').hover(
        function() { $(this).css('background-color', '#f5f5f5'); },
        function() { $(this).css('background-color', ''); }
    );
});
</script>
@endsection
