@extends('layouts.dashboard.superadminapp')

@section('title', 'Stock Dashboard')

@section('styles')
<style>
    .stat-card {
        border-radius: 12px;
        padding: 24px;
        color: #fff;
        transition: transform 0.2s, box-shadow 0.2s;
        position: relative;
        overflow: hidden;
    }
    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 30px rgba(0,0,0,0.15);
    }
    .stat-card .stat-icon {
        position: absolute;
        right: 20px;
        top: 50%;
        transform: translateY(-50%);
        font-size: 3.5rem;
        opacity: 0.3;
    }
    .stat-card .stat-value {
        font-size: 2.5rem;
        font-weight: 700;
        line-height: 1;
    }
    .stat-card .stat-label {
        font-size: 0.9rem;
        opacity: 0.9;
        margin-top: 5px;
        text-transform: uppercase;
        letter-spacing: 1px;
    }
    .stat-card .stat-info {
        font-size: 0.8rem;
        margin-top: 10px;
        opacity: 0.8;
    }
    .bg-gradient-primary { background: linear-gradient(135deg, #4e73df 0%, #224abe 100%); }
    .bg-gradient-success { background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%); }
    .bg-gradient-danger { background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%); }
    .bg-gradient-warning { background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%); }
    .bg-gradient-info { background: linear-gradient(135deg, #36b9cc 0%, #258391 100%); }
    .bg-gradient-secondary { background: linear-gradient(135deg, #858796 0%, #5a5c69 100%); }

    .chart-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        margin-bottom: 24px;
    }
    .chart-card .card-header {
        border-radius: 12px 12px 0 0;
        padding: 16px 20px;
    }
    .chart-card .card-body {
        padding: 20px;
    }

    .quick-link-card {
        background: #fff;
        border-radius: 10px;
        padding: 20px;
        text-align: center;
        transition: all 0.2s;
        border: 2px solid transparent;
    }
    .quick-link-card:hover {
        border-color: #4e73df;
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(78,115,223,0.2);
    }
    .quick-link-card i {
        font-size: 2rem;
        margin-bottom: 10px;
    }
    .quick-link-card .link-title {
        font-weight: 600;
        color: #333;
    }

    .progress-stat {
        margin-bottom: 15px;
    }
    .progress-stat .progress-label {
        display: flex;
        justify-content: space-between;
        margin-bottom: 5px;
        font-weight: 500;
    }
    .progress {
        height: 8px;
        border-radius: 4px;
    }

    .stock-item {
        padding: 12px 15px;
        border-bottom: 1px solid #eee;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }
    .stock-item:last-child {
        border-bottom: none;
    }
    .stock-item .item-name {
        font-weight: 600;
        color: #333;
    }
    .stock-item .item-category {
        font-size: 0.85rem;
        color: #666;
    }

    .filter-btn {
        padding: 5px 15px;
        border-radius: 20px;
        font-size: 0.85rem;
        transition: all 0.2s;
    }
    .filter-btn.active {
        background: #4e73df;
        color: #fff;
        border-color: #4e73df;
    }
</style>
@endsection

@section('content')

<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">UEPL | Stock Dashboard</h1>
    <div class="display-date">
        <span id="day">day</span>,
        <span id="daynum">00</span>
        <span id="month">month</span>
        <span id="year">0000</span>
    </div>
    <div class="display-time"></div>
</div>

@php
    $inStockItems = $totalItems - $lowStock - $outOfStock;
    $inStockPercent = $totalItems > 0 ? round(($inStockItems / $totalItems) * 100, 1) : 0;
    $lowStockPercent = $totalItems > 0 ? round(($lowStock / $totalItems) * 100, 1) : 0;
    $outOfStockPercent = $totalItems > 0 ? round(($outOfStock / $totalItems) * 100, 1) : 0;
@endphp

<!-- Summary Statistics -->
<div class="row mb-4">
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="stat-card bg-gradient-primary shadow">
            <i class="fas fa-boxes stat-icon"></i>
            <div class="stat-value">{{ number_format($totalItems) }}</div>
            <div class="stat-label">Total Items</div>
            <div class="stat-info">
                <i class="fas fa-database mr-1"></i> All SKU items in inventory
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="stat-card bg-gradient-success shadow">
            <i class="fas fa-check-circle stat-icon"></i>
            <div class="stat-value">{{ number_format($inStockItems) }}</div>
            <div class="stat-label">In Stock</div>
            <div class="stat-info">
                <i class="fas fa-chart-line mr-1"></i> {{ $inStockPercent }}% of total items
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="stat-card bg-gradient-warning shadow">
            <i class="fas fa-exclamation-triangle stat-icon"></i>
            <div class="stat-value">{{ number_format($lowStock) }}</div>
            <div class="stat-label">Low Stock</div>
            <div class="stat-info">
                <i class="fas fa-arrow-down mr-1"></i> {{ $lowStockPercent }}% below minimum level
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="stat-card bg-gradient-danger shadow">
            <i class="fas fa-times-circle stat-icon"></i>
            <div class="stat-value">{{ number_format($outOfStock) }}</div>
            <div class="stat-label">Out of Stock</div>
            <div class="stat-info">
                <i class="fas fa-exclamation mr-1"></i> {{ $outOfStockPercent }}% requires reorder
            </div>
        </div>
    </div>
</div>

<!-- Stock Status Overview -->
<div class="card shadow mb-4">
    <div class="card-header py-3" style="background: linear-gradient(135deg, #6c757d 0%, #495057 100%);">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-chart-pie mr-2"></i> Stock Status Overview
        </h6>
    </div>
    <div class="card-body">
        <div class="row align-items-center">
            <div class="col-md-8">
                <div class="progress-stat">
                    <div class="progress-label">
                        <span><i class="fas fa-circle text-success mr-1"></i> In Stock</span>
                        <span>{{ number_format($inStockItems) }} ({{ $inStockPercent }}%)</span>
                    </div>
                    <div class="progress">
                        <div class="progress-bar bg-success" style="width: {{ $inStockPercent }}%"></div>
                    </div>
                </div>
                <div class="progress-stat">
                    <div class="progress-label">
                        <span><i class="fas fa-circle text-warning mr-1"></i> Low Stock</span>
                        <span>{{ number_format($lowStock) }} ({{ $lowStockPercent }}%)</span>
                    </div>
                    <div class="progress">
                        <div class="progress-bar bg-warning" style="width: {{ $lowStockPercent }}%"></div>
                    </div>
                </div>
                <div class="progress-stat mb-0">
                    <div class="progress-label">
                        <span><i class="fas fa-circle text-danger mr-1"></i> Out of Stock</span>
                        <span>{{ number_format($outOfStock) }} ({{ $outOfStockPercent }}%)</span>
                    </div>
                    <div class="progress">
                        <div class="progress-bar bg-danger" style="width: {{ $outOfStockPercent }}%"></div>
                    </div>
                </div>
            </div>
            <div class="col-md-4 text-center">
                <div class="h1 font-weight-bold {{ $inStockPercent >= 70 ? 'text-success' : ($inStockPercent >= 40 ? 'text-warning' : 'text-danger') }}">
                    {{ $inStockPercent }}%
                </div>
                <p class="text-muted mb-0">Stock Health Rate</p>
            </div>
        </div>
    </div>
</div>

<!-- Charts Row -->
<div class="row">
    <!-- Stock Movement Chart -->
    <div class="col-lg-8 mb-4">
        <div class="chart-card shadow">
            <div class="card-header d-flex justify-content-between align-items-center" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-chart-area mr-2"></i> Stock Movement (Last 30 Days)
                </h6>
                <div>
                    <button class="btn btn-sm btn-light filter-btn active" data-filter="daily">Daily</button>
                    <button class="btn btn-sm btn-outline-light filter-btn" data-filter="weekly">Weekly</button>
                </div>
            </div>
            <div class="card-body">
                <canvas id="movementChart" height="120"></canvas>
            </div>
        </div>
    </div>

    <!-- Stock Distribution Chart -->
    <div class="col-lg-4 mb-4">
        <div class="chart-card shadow">
            <div class="card-header" style="background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-chart-pie mr-2"></i> Stock by Category
                </h6>
            </div>
            <div class="card-body">
                <canvas id="distributionChart" height="200"></canvas>
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="card shadow mb-4">
    <div class="card-header py-3" style="background: linear-gradient(135deg, #36b9cc 0%, #258391 100%);">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-link mr-2"></i> Quick Actions
        </h6>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-2 col-sm-4 col-6 mb-3">
                <a href="{{ route('superadmin.sku.skumaster') }}" class="text-decoration-none">
                    <div class="quick-link-card shadow-sm">
                        <i class="fas fa-boxes text-primary"></i>
                        <div class="link-title">SKU Master</div>
                    </div>
                </a>
            </div>
            <div class="col-md-2 col-sm-4 col-6 mb-3">
                <a href="{{ route('superadmin.sku.skumovement') }}" class="text-decoration-none">
                    <div class="quick-link-card shadow-sm">
                        <i class="fas fa-exchange-alt text-success"></i>
                        <div class="link-title">Stock Movement</div>
                    </div>
                </a>
            </div>
            <div class="col-md-2 col-sm-4 col-6 mb-3">
                <a href="{{ route('superadmin.sku.skuapproval') }}" class="text-decoration-none">
                    <div class="quick-link-card shadow-sm">
                        <i class="fas fa-clipboard-check text-warning"></i>
                        <div class="link-title">SKU Approvals</div>
                    </div>
                </a>
            </div>
            <div class="col-md-2 col-sm-4 col-6 mb-3">
                <a href="{{ route('superadmin.grn.grnorder') }}" class="text-decoration-none">
                    <div class="quick-link-card shadow-sm">
                        <i class="fas fa-truck-loading text-info"></i>
                        <div class="link-title">GRN</div>
                    </div>
                </a>
            </div>
            <div class="col-md-2 col-sm-4 col-6 mb-3">
                <a href="{{ route('superadmin.report.inventoryreport') }}" class="text-decoration-none">
                    <div class="quick-link-card shadow-sm">
                        <i class="fas fa-chart-bar text-danger"></i>
                        <div class="link-title">Inventory Report</div>
                    </div>
                </a>
            </div>
            <div class="col-md-2 col-sm-4 col-6 mb-3">
                <a href="{{ route('superadmin.purchase.index') }}" class="text-decoration-none">
                    <div class="quick-link-card shadow-sm">
                        <i class="fas fa-shopping-cart text-secondary"></i>
                        <div class="link-title">Purchase</div>
                    </div>
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Stock Summary Cards -->
<div class="row">
    <div class="col-md-6">
        <div class="card shadow mb-4">
            <div class="card-header py-3" style="background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-exclamation-triangle mr-2"></i> Stock Alerts
                </h6>
            </div>
            <div class="card-body">
                @if($outOfStock > 0)
                    <div class="alert alert-danger mb-3">
                        <i class="fas fa-times-circle mr-2"></i>
                        <strong>{{ $outOfStock }} item(s)</strong> are out of stock and need immediate reorder.
                    </div>
                @endif

                @if($lowStock > 0)
                    <div class="alert alert-warning mb-3">
                        <i class="fas fa-exclamation-triangle mr-2"></i>
                        <strong>{{ $lowStock }} item(s)</strong> are below minimum stock level.
                    </div>
                @endif

                @if($outOfStock == 0 && $lowStock == 0)
                    <div class="alert alert-success mb-0">
                        <i class="fas fa-check-circle mr-2"></i>
                        <strong>All items</strong> are adequately stocked. No alerts.
                    </div>
                @endif

                @if($inStockPercent < 50)
                    <div class="alert alert-info mt-3 mb-0">
                        <i class="fas fa-info-circle mr-2"></i>
                        Stock health is at <strong>{{ $inStockPercent }}%</strong>. Consider reviewing inventory levels.
                    </div>
                @endif
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card shadow mb-4">
            <div class="card-header py-3" style="background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-list-alt mr-2"></i> Category Distribution
                </h6>
            </div>
            <div class="card-body p-0">
                <table class="table table-sm mb-0">
                    <thead class="thead-light">
                        <tr>
                            <th>Category</th>
                            <th class="text-center">Stock Qty</th>
                            <th class="text-center">Percentage</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $totalStock = array_sum($distribution);
                        @endphp
                        @forelse($distribution as $category => $qty)
                            @php
                                $percentage = $totalStock > 0 ? round(($qty / $totalStock) * 100, 1) : 0;
                            @endphp
                            <tr>
                                <td class="font-weight-bold">{{ $category ?: 'Uncategorized' }}</td>
                                <td class="text-center">
                                    <span class="badge badge-primary">{{ number_format($qty) }}</span>
                                </td>
                                <td class="text-center">{{ $percentage }}%</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="3" class="text-center text-muted">No category data available</td>
                            </tr>
                        @endforelse
                    </tbody>
                    @if(count($distribution) > 0)
                    <tfoot class="thead-light">
                        <tr class="font-weight-bold">
                            <td>Total</td>
                            <td class="text-center"><span class="badge badge-success">{{ number_format($totalStock) }}</span></td>
                            <td class="text-center">100%</td>
                        </tr>
                    </tfoot>
                    @endif
                </table>
            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/moment@2.29.1/moment.min.js"></script>
<script>
    // Pass PHP data to JS
    window.movementData = @json($movementData ?? []);
    window.distribution = @json($distribution ?? []);

    // Stock Movement Chart
    const movementLabels = [];
    const movementValues = [];

    // Generate last 30 days labels
    for (let i = 29; i >= 0; i--) {
        const date = moment().subtract(i, 'days').format('YYYY-MM-DD');
        movementLabels.push(moment(date).format('DD MMM'));
        movementValues.push(window.movementData[date] || 0);
    }

    const movementCtx = document.getElementById('movementChart').getContext('2d');
    const movementChart = new Chart(movementCtx, {
        type: 'line',
        data: {
            labels: movementLabels,
            datasets: [{
                label: 'Net Stock Movement',
                data: movementValues,
                fill: true,
                backgroundColor: 'rgba(78, 115, 223, 0.1)',
                borderColor: 'rgba(78, 115, 223, 1)',
                borderWidth: 2,
                tension: 0.4,
                pointBackgroundColor: 'rgba(78, 115, 223, 1)',
                pointBorderColor: '#fff',
                pointBorderWidth: 2,
                pointRadius: 3,
                pointHoverRadius: 6
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            plugins: {
                legend: { display: false }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    grid: { color: 'rgba(0,0,0,0.05)' }
                },
                x: {
                    grid: { display: false },
                    ticks: {
                        maxTicksLimit: 10
                    }
                }
            }
        }
    });

    // Stock Distribution Doughnut Chart
    const distLabels = Object.keys(window.distribution).map(c => c || 'Uncategorized');
    const distData = Object.values(window.distribution);

    const distCtx = document.getElementById('distributionChart').getContext('2d');
    new Chart(distCtx, {
        type: 'doughnut',
        data: {
            labels: distLabels,
            datasets: [{
                data: distData,
                backgroundColor: [
                    '#4e73df', '#1cc88a', '#36b9cc', '#f6c23e', '#e74a3b',
                    '#858796', '#5a5c69', '#6f42c1', '#fd7e14', '#20c9a6'
                ],
                borderWidth: 2,
                borderColor: '#fff'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: { padding: 15, usePointStyle: true }
                }
            },
            cutout: '60%'
        }
    });

    // Filter buttons functionality
    document.querySelectorAll('.filter-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            document.querySelectorAll('.filter-btn').forEach(b => b.classList.remove('active'));
            this.classList.add('active');
            // Add filter logic here if needed
        });
    });

    // Dynamic Date/Time
    function updateDateTime() {
        const now = new Date();
        document.getElementById('day').textContent = now.toLocaleString('en-us', { weekday: 'long' });
        document.getElementById('daynum').textContent = now.getDate();
        document.getElementById('month').textContent = now.toLocaleString('en-us', { month: 'long' });
        document.getElementById('year').textContent = now.getFullYear();
        document.querySelector('.display-time').textContent = now.toLocaleTimeString();
    }
    updateDateTime();
    setInterval(updateDateTime, 1000);
</script>
@endsection
