@extends('layouts.dashboard.superadminapp')

@section('title', 'Customer/Vendor Details')

@section('styles')
<style>
    .detail-card {
        border: none;
        border-radius: 0.5rem;
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.1);
    }
    .detail-card .card-header {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
        color: #fff;
        font-weight: 600;
        padding: 0.75rem 1rem;
        border-radius: 0.5rem 0.5rem 0 0 !important;
    }
    .detail-row {
        display: flex;
        padding: 0.5rem 0;
        border-bottom: 1px solid #f1f1f1;
    }
    .detail-row:last-child {
        border-bottom: none;
    }
    .detail-label {
        font-weight: 600;
        color: #5a5c69;
        min-width: 140px;
        font-size: 0.85rem;
    }
    .detail-value {
        color: #2e2e2e;
        font-size: 0.85rem;
        word-break: break-word;
    }
    .company-header {
        background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
        color: white;
        padding: 1.5rem;
        border-radius: 0.5rem;
        margin-bottom: 1.5rem;
    }
    .company-logo {
        width: 80px;
        height: 80px;
        border-radius: 50%;
        object-fit: cover;
        border: 3px solid rgba(255,255,255,0.3);
        background: white;
    }
    .company-logo-placeholder {
        width: 80px;
        height: 80px;
        border-radius: 50%;
        background: rgba(255,255,255,0.2);
        display: flex;
        align-items: center;
        justify-content: center;
        border: 3px solid rgba(255,255,255,0.3);
    }
    .company-logo-placeholder i {
        font-size: 2rem;
        color: rgba(255,255,255,0.7);
    }
    .info-card {
        background: #f8f9fc;
        border-radius: 0.5rem;
        padding: 1rem;
        height: 100%;
    }
    .info-card-title {
        font-size: 0.75rem;
        text-transform: uppercase;
        color: #858796;
        font-weight: 700;
        margin-bottom: 0.5rem;
    }
    .info-card-value {
        font-size: 1.1rem;
        font-weight: 600;
        color: #2e2e2e;
    }
    .section-title {
        font-size: 0.9rem;
        font-weight: 700;
        color: #4e73df;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        margin-bottom: 1rem;
        padding-bottom: 0.5rem;
        border-bottom: 2px solid #4e73df;
    }
    .contact-card {
        background: #fff;
        border: 1px solid #e3e6f0;
        border-radius: 0.5rem;
        padding: 1rem;
        margin-bottom: 1rem;
        transition: all 0.2s;
    }
    .contact-card:hover {
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
    }
    .contact-avatar {
        width: 45px;
        height: 45px;
        border-radius: 50%;
        background: linear-gradient(135deg, #36b9cc 0%, #258391 100%);
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-weight: 700;
        font-size: 1rem;
    }
</style>
@endsection

@section('content')
    <!-- Page Heading -->
    <div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h5 mb-0 text-gray-800">UEPL | Customer/Vendor Details</h1>
        <div class="display-date">
            <span id="day">day</span>,
            <span id="daynum">00</span>
            <span id="month">month</span>
            <span id="year">0000</span>
        </div>
        <div class="display-time"></div>
    </div>

    <!-- Company Header Card -->
    <div class="company-header">
        <div class="row align-items-center">
            <div class="col-auto">
                @if ($customer->image)
                    <img src="{{ asset('storage/' . $customer->image) }}" alt="Logo" class="company-logo">
                @else
                    <div class="company-logo-placeholder">
                        <i class="fas fa-building"></i>
                    </div>
                @endif
            </div>
            <div class="col">
                <h3 class="mb-1">{{ $customer->company }}</h3>
                @if($customer->company_nickname)
                    <p class="mb-1 opacity-75">{{ $customer->company_nickname }}</p>
                @endif
                <div class="d-flex flex-wrap align-items-center mt-2">
                    @if($customer->company_role == 'Customer')
                        <span class="badge badge-light mr-2"><i class="fas fa-user mr-1"></i> Customer</span>
                    @elseif($customer->company_role == 'Vendor')
                        <span class="badge badge-light mr-2"><i class="fas fa-truck mr-1"></i> Vendor</span>
                    @else
                        <span class="badge badge-light mr-2"><i class="fas fa-handshake mr-1"></i> Customer & Vendor</span>
                    @endif
                    @if ($customer->status == 1)
                        <span class="badge badge-success"><i class="fas fa-check-circle mr-1"></i> Active</span>
                    @else
                        <span class="badge badge-danger"><i class="fas fa-times-circle mr-1"></i> Inactive</span>
                    @endif
                </div>
            </div>
            <div class="col-auto">
                <a href="{{ route('superadmin.customer.edit', $customer->id) }}" class="btn btn-light btn-sm mr-2">
                    <i class="fas fa-edit mr-1"></i> Edit
                </a>
                <a href="{{ route('superadmin.customer.customerlist') }}" class="btn btn-outline-light btn-sm">
                    <i class="fas fa-arrow-left mr-1"></i> Back
                </a>
            </div>
        </div>
    </div>

    <!-- Quick Info Cards -->
    <div class="row mb-4">
        <div class="col-md-3 mb-3">
            <div class="info-card">
                <div class="info-card-title"><i class="fas fa-envelope mr-1"></i> Email</div>
                <div class="info-card-value">{{ $customer->email }}</div>
            </div>
        </div>
        <div class="col-md-3 mb-3">
            <div class="info-card">
                <div class="info-card-title"><i class="fas fa-phone mr-1"></i> Mobile</div>
                <div class="info-card-value">{{ $customer->mobile }}</div>
            </div>
        </div>
        <div class="col-md-3 mb-3">
            <div class="info-card">
                <div class="info-card-title"><i class="fas fa-id-card mr-1"></i> GST No</div>
                <div class="info-card-value">{{ $customer->gstno }}</div>
            </div>
        </div>
        <div class="col-md-3 mb-3">
            <div class="info-card">
                <div class="info-card-title"><i class="fas fa-building mr-1"></i> Company Type</div>
                <div class="info-card-value">{{ $customer->company_type }}</div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Company Details Card -->
        <div class="col-lg-6 mb-4">
            <div class="card detail-card h-100">
                <div class="card-header">
                    <i class="fas fa-building mr-2"></i> Company Information
                </div>
                <div class="card-body">
                    <div class="detail-row">
                        <span class="detail-label">Company Name</span>
                        <span class="detail-value">{{ $customer->company }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Acronym</span>
                        <span class="detail-value">{{ $customer->company_nickname ?: '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Email</span>
                        <span class="detail-value">
                            <a href="mailto:{{ $customer->email }}">{{ $customer->email }}</a>
                        </span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Mobile</span>
                        <span class="detail-value">{{ $customer->mobile }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Secondary Mobile</span>
                        <span class="detail-value">{{ $customer->secondary_mobile ?: '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Company Type</span>
                        <span class="detail-value">{{ $customer->company_type }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">GST No</span>
                        <span class="detail-value"><code>{{ $customer->gstno }}</code></span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">PAN No</span>
                        <span class="detail-value"><code>{{ $customer->panno }}</code></span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">MSME/Udyam</span>
                        <span class="detail-value">{{ $customer->msmeno ?: '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">IEC</span>
                        <span class="detail-value">{{ $customer->iecno ?: '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Website</span>
                        <span class="detail-value">
                            @if ($customer->url)
                                <a href="{{ $customer->url }}" target="_blank">{{ $customer->url }} <i class="fas fa-external-link-alt fa-xs"></i></a>
                            @else
                                -
                            @endif
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Bank Details Card -->
        <div class="col-lg-6 mb-4">
            <div class="card detail-card h-100">
                <div class="card-header" style="background: linear-gradient(135deg, #36b9cc 0%, #258391 100%);">
                    <i class="fas fa-university mr-2"></i> Bank Account Details
                </div>
                <div class="card-body">
                    @if($customer->bank_name)
                        <div class="detail-row">
                            <span class="detail-label">Bank Name</span>
                            <span class="detail-value">{{ $customer->bank_name }}</span>
                        </div>
                        <div class="detail-row">
                            <span class="detail-label">Branch</span>
                            <span class="detail-value">{{ $customer->branch_name ?: '-' }}</span>
                        </div>
                        <div class="detail-row">
                            <span class="detail-label">Account Number</span>
                            <span class="detail-value"><code>{{ $customer->account_number }}</code></span>
                        </div>
                        <div class="detail-row">
                            <span class="detail-label">Account Type</span>
                            <span class="detail-value">{{ $customer->account_type ?: '-' }}</span>
                        </div>
                        <div class="detail-row">
                            <span class="detail-label">Account Holder</span>
                            <span class="detail-value">{{ $customer->account_holder_name ?: '-' }}</span>
                        </div>
                        <div class="detail-row">
                            <span class="detail-label">Currency</span>
                            <span class="detail-value">{{ $customer->account_currency ?? 'INR' }}</span>
                        </div>
                        <div class="detail-row">
                            <span class="detail-label">IFSC Code</span>
                            <span class="detail-value"><code>{{ $customer->ifsc_code ?: '-' }}</code></span>
                        </div>
                        <div class="detail-row">
                            <span class="detail-label">SWIFT/BIC</span>
                            <span class="detail-value">{{ $customer->swift_code ?: '-' }}</span>
                        </div>
                    @else
                        <div class="text-center text-muted py-4">
                            <i class="fas fa-university fa-3x mb-3 opacity-50"></i>
                            <p class="mb-0">No bank details available</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Address Section -->
    <div class="row">
        <div class="col-lg-6 mb-4">
            <div class="card detail-card h-100">
                <div class="card-header" style="background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%);">
                    <i class="fas fa-file-invoice mr-2"></i> Billing Address
                </div>
                <div class="card-body">
                    @if($customer->billing_address)
                        <p class="mb-0">{{ $customer->billing_address }}</p>
                    @else
                        <p class="text-muted mb-0"><i class="fas fa-info-circle mr-1"></i> No billing address provided</p>
                    @endif
                </div>
            </div>
        </div>
        <div class="col-lg-6 mb-4">
            <div class="card detail-card h-100">
                <div class="card-header" style="background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%);">
                    <i class="fas fa-shipping-fast mr-2"></i> Shipping Address
                </div>
                <div class="card-body">
                    @if($customer->shipping_address)
                        <p class="mb-0">{{ $customer->shipping_address }}</p>
                    @else
                        <p class="text-muted mb-0"><i class="fas fa-info-circle mr-1"></i> No shipping address provided</p>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Contact Persons Section -->
    <div class="card detail-card mb-4">
        <div class="card-header" style="background: linear-gradient(135deg, #858796 0%, #60616f 100%);">
            <i class="fas fa-users mr-2"></i> Contact Persons
        </div>
        <div class="card-body">
            @if ($customer->contactPersons->count())
                <div class="row">
                    @foreach ($customer->contactPersons as $contact)
                        <div class="col-md-6 col-lg-4">
                            <div class="contact-card">
                                <div class="d-flex align-items-center">
                                    <div class="contact-avatar mr-3">
                                        {{ strtoupper(substr($contact->name ?? 'C', 0, 1)) }}
                                    </div>
                                    <div>
                                        <h6 class="mb-0 font-weight-bold">{{ $contact->name ?: '-' }}</h6>
                                        <small class="text-muted">{{ $contact->designation ?: 'Contact Person' }}</small>
                                    </div>
                                </div>
                                <hr class="my-2">
                                <div class="small">
                                    @if($contact->email)
                                        <div class="mb-1">
                                            <i class="fas fa-envelope text-muted mr-2"></i>
                                            <a href="mailto:{{ $contact->email }}">{{ $contact->email }}</a>
                                        </div>
                                    @endif
                                    @if($contact->mobile)
                                        <div>
                                            <i class="fas fa-phone text-muted mr-2"></i>
                                            {{ $contact->mobile }}
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <div class="text-center text-muted py-4">
                    <i class="fas fa-users fa-3x mb-3 opacity-50"></i>
                    <p class="mb-0">No contact persons available</p>
                </div>
            @endif
        </div>
    </div>

    <!-- Action Buttons -->
    <div class="d-flex justify-content-between mb-4">
        <a href="{{ route('superadmin.customer.customerlist') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left mr-1"></i> Back to List
        </a>
        <a href="{{ route('superadmin.customer.edit', $customer->id) }}" class="btn btn-primary">
            <i class="fas fa-edit mr-1"></i> Edit Customer
        </a>
    </div>
@endsection
