@extends('layouts.dashboard.superadminapp')

@section('title', 'Customer/Vendor List')

@section('styles')
<style>
    #customerTable {
        width: 100% !important;
        table-layout: fixed;
    }
    #customerTable th, #customerTable td {
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
        font-size: 0.85rem;
        padding: 0.5rem !important;
    }
    #customerTable td.text-left {
        white-space: normal;
        word-wrap: break-word;
    }
    .table-actions .btn {
        padding: 0.2rem 0.4rem;
        font-size: 0.75rem;
    }
    .badge {
        font-size: 0.7rem;
    }
</style>
@endsection

@section('content')
    <!-- Page Heading -->
    <div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h5 mb-0 text-gray-800">UEPL | Customer & Vendor List</h1>
        <div class="display-date">
            <span id="day">day</span>,
            <span id="daynum">00</span>
            <span id="month">month</span>
            <span id="year">0000</span>
        </div>
        <div class="display-time"></div>
    </div>

    <!-- Alerts -->
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif
    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle mr-2"></i>{{ session('error') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif
    @if (session('errorRows'))
        <div class="alert alert-warning alert-dismissible fade show" role="alert">
            <strong><i class="fas fa-exclamation-triangle mr-2"></i>Import Errors:</strong>
            <ul class="mb-0 mt-2">
                @foreach (session('errorRows') as $errorRow)
                    <li>{{ $errorRow }}</li>
                @endforeach
            </ul>
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <!-- Summary Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Total Records</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $customers->count() }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-building fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Customers</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $customers->where('company_role', 'Customer')->count() }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-users fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Vendors</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $customers->where('company_role', 'Vendor')->count() }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-truck fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Both</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $customers->where('company_role', 'Both')->count() }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-handshake fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Card with DataTable -->
    <div class="card shadow mb-4">
        <div class="card-header d-flex justify-content-between align-items-center">
            <span class="font-weight-bold"><i class="fas fa-table mr-2"></i>Customer & Vendor Data</span>
            <div class="d-flex">
                <button class="btn btn-success btn-sm mr-2" data-toggle="modal" data-target="#bulkImportModal" title="Bulk Import">
                    <i class="fas fa-upload mr-1"></i> Import
                </button>
                <a href="{{ route('superadmin.customer.addcustomer') }}" class="btn btn-primary btn-sm" title="Add New">
                    <i class="fa fa-plus-square mr-1"></i> Add New
                </a>
            </div>
        </div>

        <div class="card-body">
            <table class="table table-bordered table-hover text-dark" id="customerTable">
                <thead class="table-light">
                    <tr class="text-center">
                        <th style="width: 4%;">#</th>
                        <th style="width: 8%;">Role</th>
                        <th style="width: 22%;">Company</th>
                        <th style="width: 18%;">Contact</th>
                        <th style="width: 12%;">Type</th>
                        <th style="width: 14%;">GST</th>
                        <th style="width: 8%;">Status</th>
                        <th style="width: 14%;">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($customers as $index => $customer)
                        <tr id="row-{{ $customer->id }}" class="text-center align-middle">
                            <td>{{ $index + 1 }}</td>
                            <td>
                                @if($customer->company_role == 'Customer')
                                    <span class="badge badge-success">Customer</span>
                                @elseif($customer->company_role == 'Vendor')
                                    <span class="badge badge-info">Vendor</span>
                                @else
                                    <span class="badge badge-warning">Both</span>
                                @endif
                            </td>
                            <td class="text-left">
                                <strong title="{{ $customer->company }}">{{ Str::limit($customer->company, 25) }}</strong>
                                @if($customer->company_nickname)
                                    <br><small class="text-muted">{{ $customer->company_nickname }}</small>
                                @endif
                            </td>
                            <td class="text-left">
                                <small>
                                    {{ $customer->email }}<br>
                                    <span class="text-muted">{{ $customer->mobile }}</span>
                                </small>
                            </td>
                            <td><small>{{ $customer->company_type }}</small></td>
                            <td><small>{{ $customer->gstno }}</small></td>
                            <td>
                                @if ($customer->status == 1)
                                    <span class="badge badge-success">Active</span>
                                @else
                                    <span class="badge badge-secondary">Inactive</span>
                                @endif
                            </td>
                            <td>
                                <div class="btn-group table-actions" role="group">
                                    <a href="{{ route('superadmin.customer.show', $customer->id) }}"
                                       class="btn btn-info btn-sm" title="View">
                                        <i class="fa fa-eye"></i>
                                    </a>
                                    <a href="{{ route('superadmin.customer.edit', $customer->id) }}"
                                       class="btn btn-warning btn-sm" title="Edit">
                                        <i class="fa fa-edit"></i>
                                    </a>
                                    <button class="btn btn-danger btn-sm delete-btn"
                                            data-id="{{ $customer->id }}"
                                            data-name="{{ $customer->company }}"
                                            title="Delete">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <!-- Bulk Import Modal -->
    <div class="modal fade" id="bulkImportModal" tabindex="-1" aria-labelledby="bulkImportModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <form method="POST" action="{{ route('superadmin.customer.import') }}" enctype="multipart/form-data" id="importForm">
                @csrf
                <div class="modal-content border-0 shadow">
                    <div class="modal-header py-2 bg-success text-white">
                        <h6 class="modal-title mb-0">
                            <i class="fas fa-upload mr-2"></i>Bulk Upload Customers/Vendors
                        </h6>
                        <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                            <span>&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group mb-3">
                            <label for="excel_file" class="small font-weight-bold">Upload Excel File (.xlsx)</label>
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" id="excel_file" name="excel_file" accept=".xlsx" required>
                                <label class="custom-file-label" for="excel_file">Choose file...</label>
                            </div>
                        </div>
                        <div class="alert alert-info py-2 mb-0">
                            <small>
                                <i class="fas fa-info-circle mr-1"></i>
                                <strong>Note:</strong> Only XLSX format allowed.
                                <a href="{{ asset('templates/customer_vendor_import_template.xlsx') }}" download class="alert-link">
                                    <i class="fas fa-download"></i> Download Template
                                </a>
                            </small>
                        </div>
                    </div>
                    <div class="modal-footer py-2 bg-light">
                        <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-success btn-sm" id="importBtn">
                            <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                            <span class="btn-text"><i class="fas fa-upload mr-1"></i> Import</span>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-danger text-white py-2">
                    <h6 class="modal-title mb-0"><i class="fas fa-exclamation-triangle mr-2"></i>Delete Customer/Vendor</h6>
                    <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                        <span>&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="mb-1">Are you sure you want to delete this customer/vendor?</p>
                    <p class="mb-0"><strong id="deleteItemName"></strong></p>
                    <small class="text-muted">This action cannot be undone. All related contact persons will also be deleted.</small>
                </div>
                <div class="modal-footer py-2">
                    <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-danger btn-sm" id="confirmDeleteBtn">
                        <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                        <span class="btn-text">Delete</span>
                    </button>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    // Initialize DataTable
    var table = $('#customerTable').DataTable({
        pageLength: 10,
        lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "All"]],
        order: [[0, 'asc']],
        autoWidth: false,
        columnDefs: [
            { orderable: false, targets: [7] }
        ],
        language: {
            emptyTable: "No customers/vendors found"
        }
    });

    // Custom file input label update
    $('.custom-file-input').on('change', function() {
        var fileName = $(this).val().split('\\').pop();
        $(this).next('.custom-file-label').html(fileName || 'Choose file...');
    });

    // Import form submit
    $('#importForm').on('submit', function() {
        var $btn = $('#importBtn');
        $btn.prop('disabled', true);
        $btn.find('.spinner-border').removeClass('d-none');
        $btn.find('.btn-text').text('Importing...');
    });

    // Delete button click - show confirmation modal
    var deleteId = null;
    $(document).on('click', '.delete-btn', function() {
        deleteId = $(this).data('id');
        $('#deleteItemName').text($(this).data('name'));
        $('#deleteModal').modal('show');
    });

    // Confirm delete
    $('#confirmDeleteBtn').on('click', function() {
        if (!deleteId) return;

        var $btn = $(this);
        var $spinner = $btn.find('.spinner-border');
        var $text = $btn.find('.btn-text');

        $btn.prop('disabled', true);
        $spinner.removeClass('d-none');
        $text.text('Deleting...');

        $.ajax({
            url: '{{ url("superadmin/customers") }}/' + deleteId,
            type: 'DELETE',
            data: { '_token': '{{ csrf_token() }}' },
            success: function(response) {
                $('#deleteModal').modal('hide');
                table.row('#row-' + deleteId).remove().draw(false);
                showToast('success', response.message || 'Customer/Vendor deleted successfully!');
                // Update summary counts would require page reload
            },
            error: function(xhr) {
                showToast('error', xhr.responseJSON?.message || 'Could not delete customer/vendor.');
            },
            complete: function() {
                $btn.prop('disabled', false);
                $spinner.addClass('d-none');
                $text.text('Delete');
                deleteId = null;
            }
        });
    });

    // Toast notification helper
    function showToast(type, message) {
        var bgClass = type === 'success' ? 'bg-success' : 'bg-danger';
        var icon = type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle';

        var toastHtml = `
            <div class="toast ${bgClass} text-white" role="alert" aria-live="assertive" aria-atomic="true" data-delay="3000" style="position: fixed; top: 20px; right: 20px; z-index: 9999; min-width: 250px;">
                <div class="toast-body d-flex align-items-center">
                    <i class="fas ${icon} mr-2"></i>
                    <span>${message}</span>
                    <button type="button" class="ml-auto close text-white" data-dismiss="toast" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            </div>
        `;

        var $toast = $(toastHtml);
        $('body').append($toast);
        $toast.toast('show');

        $toast.on('hidden.bs.toast', function() {
            $(this).remove();
        });
    }
});
</script>
@endsection
