@extends('layouts.dashboard.managerapp')

@section('title', 'Sales Order Details')

@section('content')
    <style>
        .so-view-card {
            background: linear-gradient(120deg, #f6d365 0%, #fda085 100%);
            border-radius: 1.2rem;
            box-shadow: 0 4px 24px rgba(0, 0, 0, 0.09);
            overflow: hidden;
            border: none;
        }

        .so-header {
            background: linear-gradient(120deg, #84fab0 0%, #8fd3f4 100%);
            padding: 1.5rem 2rem 1rem 2rem;
            color: #222;
            border-top-left-radius: 1.2rem;
            border-top-right-radius: 1.2rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .so-header h3 {
            margin-bottom: 0;
            font-weight: 700;
            letter-spacing: 0.5px;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .so-body {
            background: #fff;
            border-bottom-left-radius: 1.2rem;
            border-bottom-right-radius: 1.2rem;
            padding: 2rem;
        }

        .so-label {
            color: #4f4f4f;
            font-weight: 600;
        }

        .so-value {
            color: #2b2b2b;
            font-weight: 700;
        }

        .so-detail-row {
            margin-bottom: 1rem;
        }

        .so-back-btn {
            min-width: 130px;
            border-radius: 2rem;
            font-size: 1.1rem;
            font-weight: 600;
            box-shadow: 0 3px 18px rgba(253, 160, 133, 0.09);
        }

        @media (max-width: 991px) {
            .so-body {
                padding: 1.2rem;
            }

            .so-header {
                padding: 1rem 1rem 0.7rem 1rem;
            }
        }
    </style>

    <div class="container-fluid">
        <div class="row justify-content-center py-4">
            <div class="col-12 col-lg-11">
                <div class="card so-view-card">
                    <div class="so-header">
                        <h3>
                            <i class="fas fa-file-invoice-dollar"></i> Sales Order Details
                        </h3>
                        <a href="{{ route('manager.sales.salesdetails') }}" class="btn btn-light so-back-btn">
                            <i class="fa fa-arrow-left"></i> Back to Sales Orders List
                        </a>
                    </div>
                    <div class="so-body">
                        <div class="row">
                            <div class="col-md-6 so-detail-row">
                                <span class="so-label">Sales Order No:</span>
                                <div class="so-value">{{ $order->sales_order_no }}</div>
                            </div>
                            <div class="col-md-6 so-detail-row">
                                <span class="so-label">Date:</span>
                                <div class="so-value">{{ \Carbon\Carbon::parse($order->sales_order_date)->format('d M Y') }}</div>
                            </div>
                            <div class="col-md-6 so-detail-row">
                                <span class="so-label">GRN No:</span>
                                <div class="so-value">{{ $order->grn_no ?? '-' }}</div>
                            </div>
                            <div class="col-md-6 so-detail-row">
                                <span class="so-label">Customer Reference No:</span>
                                <div class="so-value">{{ $order->customer_ref_no ?? '-' }}</div>
                            </div>
                            <div class="col-md-6 so-detail-row">
                                <span class="so-label">Company Name:</span>
                                <div class="so-value">{{ $order->customer->company ?? '-' }}</div>
                            </div>
                            <div class="col-md-6 so-detail-row">
                                <span class="so-label">GSTN:</span>
                                <div class="so-value">{{ $order->company_gstn }}</div>
                            </div>
                            <div class="col-md-6 so-detail-row">
                                <span class="so-label">Phone:</span>
                                <div class="so-value">{{ $order->company_phone }}</div>
                            </div>
                            <div class="col-md-6 so-detail-row">
                                <span class="so-label">Email:</span>
                                <div class="so-value">{{ $order->company_email }}</div>
                            </div>
                            <div class="col-md-6 so-detail-row">
                                <span class="so-label">Quotation No:</span>
                                <div class="so-value">{{ $order->quotation_no ?? '-' }}</div>
                            </div>
                            <div class="col-md-6 so-detail-row">
                                <span class="so-label">Quotation Date:</span>
                                <div class="so-value">{{ $order->quotation_date ? \Carbon\Carbon::parse($order->quotation_date)->format('d M Y') : '-' }}</div>
                            </div>
                            <div class="col-md-6 so-detail-row">
                                <span class="so-label">RFQ No:</span>
                                <div class="so-value">{{ $order->rfq_no ?? '-' }}</div>
                            </div>
                            <div class="col-md-6 so-detail-row">
                                <span class="so-label">RFQ Date:</span>
                                <div class="so-value">{{ $order->rfq_date ? \Carbon\Carbon::parse($order->rfq_date)->format('d M Y') : '-' }}</div>
                            </div>
                            <div class="col-md-6 so-detail-row">
                                <span class="so-label">Part No:</span>
                                <div class="so-value">{{ $order->part_no ?? '-' }}</div>
                            </div>
                            <div class="col-md-6 so-detail-row">
                                <span class="so-label">Project Material No:</span>
                                <div class="so-value">{{ $order->project_material_no ?? '-' }}</div>
                            </div>
                            <div class="col-md-6 so-detail-row">
                                <span class="so-label">Drawing No:</span>
                                <div class="so-value">{{ $order->drawing_no ?? '-' }}</div>
                            </div>
                            <div class="col-md-6 so-detail-row">
                                <span class="so-label">Drawing Revision:</span>
                                <div class="so-value">{{ $order->drawing_rev ?? '-' }}</div>
                            </div>
                            <div class="col-md-6 so-detail-row">
                                <span class="so-label">Product Type:</span>
                                <div class="so-value">{{ $order->product_type }}</div>
                            </div>
                            <div class="col-md-12 so-detail-row">
                                <span class="so-label">Description:</span>
                                <div class="so-value">{{ $order->description ?? '-' }}</div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 so-detail-row">
                                <span class="so-label">Bill Address:</span>
                                <div class="so-value">{{ $order->bill_address ?? '-' }}</div>
                            </div>
                            <div class="col-md-6 so-detail-row">
                                <span class="so-label">Ship Address:</span>
                                <div class="so-value">{{ $order->ship_address ?? '-' }}</div>
                            </div>
                        </div>
                        <hr class="my-4">

                        <div class="row">
                            <div class="col-md-12 so-detail-row">
                                <span class="so-label">Grand Total in Words:</span>
                                <div class="so-value">{{ $order->inr_in_words ?? '' }}</div>
                            </div>
                            <div class="col-md-4 so-detail-row">
                                <span class="so-label">Subtotal:</span>
                                <div class="so-value">₹{{ number_format($order->subtotal, 2) }}</div>
                            </div>
                            <div class="col-md-4 so-detail-row">
                                <span class="so-label">SGST Amount:</span>
                                <div class="so-value">₹{{ number_format($order->sgst_amount, 2) }}</div>
                            </div>
                            <div class="col-md-4 so-detail-row">
                                <span class="so-label">CGST Amount:</span>
                                <div class="so-value">₹{{ number_format($order->cgst_amount, 2) }}</div>
                            </div>
                            <div class="col-md-4 so-detail-row">
                                <span class="so-label">IGST Amount:</span>
                                <div class="so-value">₹{{ number_format($order->igst_amount, 2) }}</div>
                            </div>
                            <div class="col-md-4 so-detail-row">
                                <span class="so-label">Round Up:</span>
                                <div class="so-value">₹{{ number_format($order->round_up, 2) }}</div>
                            </div>
                             <div class="col-md-4 so-detail-row">
                                <span class="so-label">Grand Total:</span>
                                <div class="so-value">₹{{ number_format($order->grand_total, 2) }}</div>
                            </div>
                        </div>
                        <hr class="my-4">

                        <h5 class="mb-3"><i class="fas fa-cubes me-2"></i>Product Details</h5>
                        <div class="table-responsive">
                            <table class="table table-bordered align-middle">
                                <thead class="table-light">
                                    <tr class="text-center">
                                        <th>Sl No.</th>
                                        <th>Material Code</th>
                                        <th>HSN Code</th>
                                        <th>Description</th>
                                        <th>Additional Details</th>
                                        <th>Required By Date</th>
                                        <th>Quantity</th>
                                        <th>UOM</th>
                                        <th>Unit Rate</th>
                                        <th>Discount (%)</th>
                                        <th>Value (INR)</th>
                                        <th>SGST (%)</th>
                                        <th>CGST (%)</th>
                                        <th>IGST (%)</th>
                                        <th>Amount (INR)</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($order->items as $item)
                                        <tr>
                                            <td>{{ $item->sl_no }}</td>
                                            <td>{{ $item->material_code ?? '-' }}</td>
                                            <td>{{ $item->hsn_code ?? '-' }}</td>
                                            <td>{{ $item->material_description ?? '-' }}</td>
                                            <td>{{ $item->additional_details ?? '-' }}</td>
                                            <td>{{ $item->required_by_date ? \Carbon\Carbon::parse($item->required_by_date)->format('d M Y') : '-' }}</td>
                                            <td>{{ $item->quantity }}</td>
                                            <td>{{ $item->uom }}</td>
                                            <td>₹{{ number_format($item->unit_rate, 2) }}</td>
                                            <td>{{ $item->discount }}%</td>
                                            <td>₹{{ number_format($item->value, 2) }}</td>
                                            <td>{{ $item->sgst }}%</td>
                                            <td>{{ $item->cgst }}%</td>
                                            <td>{{ $item->igst }}%</td>
                                            <td>₹{{ number_format($item->amount, 2) }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <div class="d-flex justify-content-end mt-4">
                            <a href="{{ route('manager.sales.salesdetails') }}" class="btn btn-light so-back-btn">
                                <i class="fa fa-arrow-left"></i> Back to List
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    // Ensure tables are scrollable if they overflow
    $('.table-responsive').each(function() {
        var table = $(this).find('table');
        if (table.width() > $(this).width()) {
            $(this).css('overflow-x', 'auto');
        }
    });
});
</script>
@endsection
