@extends('layouts.dashboard.managerapp')

@section('title', 'Route Card Details')

@section('content')
<style>
    .rc-view-card {
        background: linear-gradient(120deg, #d4fc79 0%, #96e6a1 100%);
        border-radius: 1.2rem;
        box-shadow: 0 4px 24px rgba(0,0,0,0.09);
        border: none;
    }
    .rc-header {
        background: linear-gradient(120deg, #84fab0 0%, #8fd3f4 100%);
        padding: 1.5rem 2rem 1rem 2rem;
        color: #222;
        border-top-left-radius: 1.2rem;
        border-top-right-radius: 1.2rem;
        display: flex;
        align-items: center;
        justify-content: space-between;
    }
    .rc-header h3 {
        margin-bottom: 0;
        font-weight: 700;
        letter-spacing: 0.5px;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }
    .rc-body {
        background: #fff;
        border-bottom-left-radius: 1.2rem;
        border-bottom-right-radius: 1.2rem;
        padding: 2rem;
    }
    .rc-label { color: #4f4f4f; font-weight: 600; }
    .rc-value { color: #2b2b2b; font-weight: 700; }
    .rc-detail-row { margin-bottom: 1rem; }
    .rc-back-btn {
        min-width: 130px;
        border-radius: 2rem;
        font-size: 1.1rem;
        font-weight: 600;
        box-shadow: 0 3px 18px rgba(150,230,161,0.09);
    }
    @media (max-width: 991px) {
        .rc-body { padding: 1.2rem; }
        .rc-header { padding: 1rem 1rem 0.7rem 1rem; }
    }
    .process-table th, .process-table td {
        text-align: center;
        vertical-align: middle;
    }
</style>

<div class="container-fluid">
    <div class="row justify-content-center py-4">
        <div class="col-12 col-lg-10">
            <div class="card rc-view-card">
                <div class="rc-header">
                    <h3>
                        <i class="fas fa-project-diagram"></i> Route Card Details
                    </h3>
                    <a href="{{ route('manager.routecard.routecarddetails') }}" class="btn btn-light rc-back-btn">
                        <i class="fa fa-arrow-left"></i> Back
                    </a>
                </div>
                <div class="rc-body">
                    <div class="row">
                        <div class="col-md-6 rc-detail-row">
                            <span class="rc-label">RC No:</span>
                            <div class="rc-value">{{ $card->route_no }}</div>
                        </div>
                        <div class="col-md-6 rc-detail-row">
                            <span class="rc-label">RC Date:</span>
                            <div class="rc-value">{{ $card->route_date }}</div>
                        </div>
                        <div class="col-md-6 rc-detail-row">
                            <span class="rc-label">GRN No:</span>
                            <div class="rc-value">{{ $card->grn_no }}</div>
                        </div>
                        <div class="col-md-6 rc-detail-row">
                            <span class="rc-label">GRN Date:</span>
                            <div class="rc-value">{{ $card->grn_date }}</div>
                        </div>
                        <div class="col-md-6 rc-detail-row">
                            <span class="rc-label">Order No:</span>
                            <div class="rc-value">{{ $card->order_no }}</div>
                        </div>
                        <div class="col-md-6 rc-detail-row">
                            <span class="rc-label">Order Date:</span>
                            <div class="rc-value">{{ $card->order_date }}</div>
                        </div>
                        <div class="col-md-6 rc-detail-row">
                            <span class="rc-label">Company Name:</span>
                            <div class="rc-value">{{ $card->company_name }}</div>
                        </div>
                        <div class="col-md-6 rc-detail-row">
                            <span class="rc-label">Order Reference No:</span>
                            <div class="rc-value">{{ $card->order_ref_no }}</div>
                        </div>
                        <div class="col-md-6 rc-detail-row">
                            <span class="rc-label">Company Address:</span>
                            <div class="rc-value">{{ $card->company_address }}</div>
                        </div>
                        <div class="col-md-6 rc-detail-row">
                            <span class="rc-label">Company GSTN:</span>
                            <div class="rc-value">{{ $card->company_gstn }}</div>
                        </div>
                        <div class="col-md-6 rc-detail-row">
                            <span class="rc-label">Company Email:</span>
                            <div class="rc-value">{{ $card->company_email }}</div>
                        </div>
                        <div class="col-md-6 rc-detail-row">
                            <span class="rc-label">Company Phone:</span>
                            <div class="rc-value">{{ $card->company_phone }}</div>
                        </div>
                        <div class="col-md-6 rc-detail-row">
                            <span class="rc-label">Quotation No:</span>
                            <div class="rc-value">{{ $card->quotation_no }}</div>
                        </div>
                        <div class="col-md-6 rc-detail-row">
                            <span class="rc-label">Quotation Date:</span>
                            <div class="rc-value">{{ $card->quotation_date }}</div>
                        </div>
                        <div class="col-md-6 rc-detail-row">
                            <span class="rc-label">RFQ No:</span>
                            <div class="rc-value">{{ $card->rfq_no }}</div>
                        </div>
                        <div class="col-md-6 rc-detail-row">
                            <span class="rc-label">RFQ Date:</span>
                            <div class="rc-value">{{ $card->rfq_date }}</div>
                        </div>
                        <div class="col-md-6 rc-detail-row">
                            <span class="rc-label">Part No:</span>
                            <div class="rc-value">{{ $card->part_no }}</div>
                        </div>
                        <div class="col-md-6 rc-detail-row">
                            <span class="rc-label">Project Material No:</span>
                            <div class="rc-value">{{ $card->project_material_no }}</div>
                        </div>
                        <div class="col-md-6 rc-detail-row">
                            <span class="rc-label">Drawing No:</span>
                            <div class="rc-value">{{ $card->drawing_no }}</div>
                        </div>
                        <div class="col-md-6 rc-detail-row">
                            <span class="rc-label">Drawing Revision:</span>
                            <div class="rc-value">{{ $card->drawing_rev }}</div>
                        </div>
                        <div class="col-md-12 rc-detail-row">
                            <span class="rc-label">Description:</span>
                            <div class="rc-value">{{ $card->description }}</div>
                        </div>
                        <div class="col-md-6 rc-detail-row">
                            <span class="rc-label">Product Type:</span>
                            <div class="rc-value">{{ $card->product_type }}</div>
                        </div>
                       
                        <div class="col-md-6 rc-detail-row">
                            <span class="rc-label">Expected Project Start:</span>
                            <div class="rc-value">{{ date("d-m-Y:h-m",strtotime($card->project_start_date)) }}</div>
                        </div>
                      
                    </div>
                    <hr class="my-4">

                    <h5 class="mb-3"><i class="fas fa-tasks me-2"></i> Process Details</h5>
                    <div class="table-responsive">
                        <table class="table table-bordered process-table">
                            <thead class="table-light">
                                <tr>
                                    <th>Sl No.</th>
                                    <th>Process</th>
                                    <th>Source</th>
                                    <th>Previous Process</th>
                                    <th>Machine</th>
                                    <th>Operator</th>
                                    <th>Cycle Time (h:m)</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($card->processes as $i => $proc)
<tr>
    <td>{{ $i+1 }}</td>
    <td>{{ $proc->process }}</td>
    <td style="text-transform: capitalize">{{ $proc->source }}</td>
    <td>
        @if(empty($proc->previous_process_id))
            -
        @else
            @php
                $prev = collect($card->processes)->firstWhere('id', $proc->previous_process_id);
            @endphp
            {{ $prev ? $prev->process : '-' }}
        @endif
    </td>
    <td>
        @php
            $machine = $machines->firstWhere('machine_id', $proc->machine) ?? null;
        @endphp
        {{ $machine ? $machine->machine_name : $proc->machine }}
    </td>
    <td>
        @php
            $operator = $employees->firstWhere('id', $proc->operator) ?? null;
        @endphp
        {{ $operator ? $operator->name : $proc->operator }}
    </td>
    <td>
        {{ str_pad($proc->cycle_hours,2,'0',STR_PAD_LEFT) }}:{{ str_pad($proc->cycle_minutes,2,'0',STR_PAD_LEFT) }}
    </td>
</tr>
@endforeach
                            </tbody>
                        </table>
                    </div>

                    <div class="d-flex justify-content-end mt-4">
                        <a href="{{ route('manager.routecard.routecarddetails') }}" class="btn btn-light rc-back-btn">
                            <i class="fa fa-arrow-left"></i> Back to List
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
