@extends('layouts.dashboard.managerapp')

@section('title', 'RFQ List')

@section('content')
    <style>
        div.dt-buttons {
            float: left;
            display: flex !important;
            margin-bottom: 1rem;
        }

        .dataTable {
            overflow-x: auto !important;
            display: table !important;
        }

        .dt-buttons .btn {
            margin-right: 0.5rem !important;
            padding: 0.25rem 0.75rem !important;
            font-size: 0.95rem !important;
        }

        .btn-delete {
            min-width: 80px;
        }

        .page-header-icon {
            font-size: 2rem;
            color: #506690;
            vertical-align: middle;
        }
    </style>

    <!-- Page Heading -->
    <div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h5 mb-0 text-gray-800 pl-2">UEPL | RFQ List</h1>
        <div class="display-date">
            <span id="day">day</span>,
            <span id="daynum">00</span>
            <span id="month">month</span>
            <span id="year">0000</span>
        </div>
        <div class="display-time"></div>
    </div>

    <!-- New Button -->


    <!-- Table Section -->
    <div class="card shadow mb-4">
        <div class="card-header">
            <div class="mb-3">
                <!--<a href="{{ route('manager.rfq.rfq') }}" style="float: right" class="btn btn-primary btn-sm">-->
                <!--    <i class="fa fa-plus"></i> Add RFQ-->
                <!--</a>-->
                <a href="{{ route('manager.rfq.rfq') }}" class="btn btn-primary btn-sm ms-2" style="float: right" title="Add New"><i class="fa fa-plus-square" aria-hidden="true"></i></a>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered align-middle" id="rfqTable" width="100%" cellspacing="0">
                    <thead class="table-light">
                        <tr class="text-center">
                            <th>RFQ ID</th>
                            <th>RFQ Date</th>
                            <th>Customer</th>
                            <th>RFQ Type</th>
                            <th>Product Type</th>
                            <th>Part No</th>
                            <th>Quantity</th>
                            <th>UOM</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($rfqs as $rfq)
                            <tr id="row-{{ $rfq->id }}">
                                <td>{{ $rfq->rfq_no }}</td>
                                <td>{{ $rfq->rfq_date }}</td>
                                <td>{{ $rfq->customerInfo ? $rfq->customerInfo->company : '-' }}</td>
                                <td>{{ $rfq->rfq_type }}</td>
                                <td>{{ $rfq->product_type }}</td>
                                <td>{{ $rfq->part_no }}</td>
                                <td>{{ $rfq->quantity }}</td>
                                <td>{{ $rfq->uom }}</td>
                                <td class="text-center">
                                    <a href="{{ route('manager.rfq.print', $rfq->id) }}"
                                        class="btn btn-success btn-sm rfq-back-btn" target="_blank">
                                        <i class="fa fa-print" title="Print"></i>
                                    </a>
                                    <a href="{{ route('manager.rfq.view', $rfq->id) }}"
                                        class="btn btn-info btn-sm btn-action" title="View">
                                        <i class="fa fa-eye"></i>
                                    </a>
                                    <a href="{{ route('manager.rfq.edit', $rfq->id) }}"
                                        class="btn btn-warning btn-sm me-1 btn-action" title="Edit">
                                        <i class="fa fa-edit"></i>
                                    </a>
                                    <button class="btn btn-danger btn-sm btn-action delete-btn"
                                        data-id="{{ $rfq->id }}" title="Delete">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(document).ready(function() {
            $('#rfqTable').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'copy',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'csv',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'excel',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'pdf',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'print',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'colvis',
                        className: 'btn btn-secondary btn-sm'
                    }
                ],
                pageLength: 10,
                ordering: true,
                searching: true,
                responsive: true,
            });

            // Delete RFQ with SweetAlert2 confirm
            $(document).on('click', '.delete-btn', function() {
                var id = $(this).data('id');
                Swal.fire({
                    title: 'Are you sure?',
                    text: "You want to delete this RFQ!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Yes, Delete!',
                    reverseButtons: true
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: "{{ url('manager/rfq') }}/" + id,
                            type: 'DELETE',
                            data: {
                                _token: "{{ csrf_token() }}"
                            },
                            success: function(response) {
                                $('#row-' + id).fadeOut(500, function() {
                                    $(this).remove();
                                });
                                Swal.fire('Deleted!', 'RFQ deleted successfully.',
                                    'success');
                                location.reload(); // reload page after alert closes
                            },
                            error: function(xhr) {
                                Swal.fire('Error', 'Error occurred while deleting.',
                                    'error');
                                location.reload(); // reload page after alert closes
                            }
                        });
                    }
                });
            });
        });
    </script>
@endsection
