@extends('layouts.dashboard.managerapp')
@section('title', 'Quality Control Management')

@section('content')
<meta name="csrf-token" content="{{ csrf_token() }}">

<div class="container py-4">
    <h2 class="mb-4 fw-bold">Quality Control Management</h2>
    <div class="card shadow-sm">
        <div class="card-body">
            <table class="table table-bordered table-hover">
                <thead class="thead-light">
                    <tr>
                        <th>Route Card No</th>
                        <th>Customer</th>
                        <th>Project</th>
                        <th>QC Processes</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                @foreach($routeCards as $rc)
                    <tr>
                        <td>{{ $rc->route_no }}</td>
                        <td>{{ $rc->company_name }}</td>
                        <td>{{ $rc->project_no }}</td>
                        <td>
                            {{ $rc->qc_count }}
                        </td>
                        <td>
                            <a href="{{ url('manager/quality/qualitycontrol/'.$rc->id) }}" class="btn btn-sm btn-info">
                                <i class="fas fa-eye"></i> QC Board
                            </a>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
