@extends('layouts.dashboard.managerapp')

@section('title', 'Project Planning')

@section('content')

<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
                        <h1 class="h5 mb-0 text-gray-800"><a href="index.html">UEPL</a>/<a href="manufacturing-planning.html">Manufacturing Planning</a>/Project Planning</h1>
                        <div class="display-date">
                            <span id="day">day</span>,
                            <span id="daynum">00</span>
                            <span id="month">month</span>
                            <span id="year">0000</span>
                        </div>
                        <div class="display-time"></div>
                    </div>
                    <div class="mp-btn-board" style="justify-content: end;">
                        <div class="col-xl-2">
                            <button class="btn-danger hidden" type="button" id="delete-plan">Delete Plan</button>
                        </div>
                        <div class="col-xl-2">
                            <button class="btn-success" type="submit" id="save-plan">Save Plan</button>
                        </div>
                    </div><br>
                    <!-- Content Row -->
                    <div id="manufacturing-planning" class="manufacturing-bg">
                        <div class="board"></div>
                        <!-- New Task Popup -->
                        <div class="mp-popup" id="new-task">
                            <div class="mp-popup-content">
                                <div class="mp-d-flex heading">
                                    <h4>New Process Details</h4>
                                    <span class="mp-close">✖</span>
                                </div>
                                <form id="add-task">
                                    <!-- <label for="task-title">Task Name</label>
                                    <input type="text" name="title" id="task-title" autocomplete="off" placeholder="Task title" required> -->

                                    <!-- Process Select Field -->
                                    <label for="process">Process <span class="required" title="required">*</span></label>
                                    <select id="processSelect" required>
                                        <option value="">Select Process</option>
                                        <!-- <option value="Process A">Process A</option>
                                        <option value="Process B">Process B</option>
                                        <option value="Process C">Process C</option> -->
                                    </select>

                                    <!-- Machine Select Field -->
                                    <label for="machine-name">Machine <span class="required" title="required">*</span></label>
                                    <select id="machineNameSelect" required>
                                        <option value="">Select Machine</option>
                                    </select>
                                    <!-- Operator Select Field -->
                                    <label for="operator">Operator</label>
                                    <select id="operatorSelect">
                                        <option value="">Select Operator</option>
                                    </select>
                                    <div class="row">
                                        <!-- Start Date Field -->
                                        <!-- <label for="cycleTime">Cycle Time</label>
                                        <input type="time" id="cycleTime" required> -->
                                        <div class="col-md-6">
                                            <!-- Start Cycle Time -->
                                            <label for="hours">Cycle Time (Hours) <span class="required" title="required">*</span></label>
                                            <input type="number" id="ctHours" min="0" required placeholder="Hours">
                                        </div>
                                        <div class="col-md-6">
                                            <label for="minutes">Cycle Time (Minutes) <span class="required" title="required">*</span></label>
                                            <input type="number" id="ctMinutes" min="0" max="59" required placeholder="Minutes">
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <!-- Start Date Field -->
                                            <label for="startTimer">Start Date</label>
                                            <input type="datetime-local" id="startTime">
                                        </div>
                                        <div class="col-md-6">
                                            <!-- End Date Field -->
                                            <label for="endTimer">End Date</label>
                                            <input type="datetime-local" id="endTime" readonly>
                                        </div>
                                    </div>

                                    <label for="task-desc">Description</label>
                                    <textarea name="desc" id="task-desc" cols="30" rows="4" placeholder="Task description"></textarea>
                                </form>
                                <div class="footer">
                                    <button type="submit" class="col-md-3 btn-success" id="bt-task">Add</button>
                                    <button type="button" class="col-md-3 btn-danger mp-close">Cancel</button>
                                </div>
                            </div>
                        </div>
                        <!-- Edit Task Popup -->
                        <div class="mp-popup" id="edit-task">
                            <div class="mp-popup-content">
                                <div class="mp-d-flex heading">
                                    <h4>Edit Process Details</h4>
                                    <span class="mp-close">✖</span>
                                </div>
                                <form id="editfrm-task">
                                    <label for="edit-process">Process</label>
                                    <!-- <select id="edit-process" required disabled>
                                        <option value="">Select Process</option>
                                    </select> -->
                                    <input type="text" id="edit-process" name="edit-process" readonly>
                                    
                                    <label for="edit-source">Source</label>
                                    <select id="edit-source" onchange="toggleFields()">
                                        <option value="">Select Source</option>
                                        <option value="Inhouse">Inhouse</option>
                                        <option value="Outsourced">Outsourced</option>
                                    </select>

                                    <label for="edit-machine-name">Machine</label>
                                    <select id="edit-machine-name">
                                        <option value="">Select Machine</option>
                                    </select>
                                    
                                    <!-- Operator Select Field -->
                                    <label for="editOperator">Operator</label>
                                    <select id="editOperatorSelect">
                                        <option value="">Select Operator</option>
                                    </select>
                                    <div class="row">
                                        <!-- Start Date Field -->
                                        <!-- <label for="cycleTime">Cycle Time</label>
                                        <input type="time" id="cycleTime" required> -->
                                        <div class="col-md-6">
                                            <!-- Start Cycle Time -->
                                            <label for="hours">Cycle Time (Hours) <span class="required" title="required">*</span></label>
                                            <input type="number" id="editctHours" min="0" name="editctHours" required placeholder="Hours">
                                        </div>
                                        <div class="col-md-6">
                                            <label for="minutes">Cycle Time (Minutes) <span class="required" title="required">*</span></label>
                                            <input type="number" id="editctMinutes" name="editctMinutes" min="0" max="59" required placeholder="Minutes">
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <label for="edit-start-time">Start Date</label>
                                            <input type="datetime-local" id="edit-start-time">
                                        </div>
                                        <div class="col-md-6">
                                            <label for="edit-end-time">End Date</label>
                                            <input type="datetime-local" id="edit-end-time" readonly>
                                        </div>
                                    </div>
                                    <label for="edit-task-desc">Description</label>
                                    <textarea name="desc" id="edit-task-desc" cols="30" rows="4" placeholder="Task description"></textarea>
                                </form>
                                <div class="footer">
                                    <button type="submit" class="col-md-3 btn-success" id="update-task">Update</button>
                                    <button type="button" class="col-md-3 btn-danger mp-close">Cancel</button>
                                </div>
                            </div>
                        </div>
                        <!-- New Task Board Popup -->
                        <div class="mp-popup" id="new-task-board">
                            <div class="mp-popup-content">
                                <div class="mp-d-flex heading">
                                    <h4>New Job</h4>
                                    <span class="mp-close">✖</span>
                                </div>
                                <form id="mp-add-task-board">
                                    <label for="task-board-title">Title <span class="required" title="required">*</span></label>
                                    <input type="text" name="task-board-title" id="task-board-title" autocomplete="off" required>
                                    <div class="footer">
                                        <button type="submit" class="col-md-3 btn-success" id="bt-task-board">Add</button>
                                        <button type="button" class="col-md-3 btn-danger mp-close">Cancel</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <!-- Edit Task Board Popup -->
                        <div class="mp-popup" id="edit-task-board">
                            <div class="mp-popup-content">
                                <div class="mp-d-flex heading">
                                    <h4>Edit Job</h4>
                                    <span class="mp-close">✖</span>
                                </div>
                                <form id="mp-editfrm-task-board">
                                    <label for="task-board-title">Title <span class="required" title="required">*</span></label>
                                    <input type="text" name="edit-task-board-title" id="edit-task-board-title" autocomplete="off" required>
                                    <div class="footer">
                                        <button type="submit" class="col-md-3 btn-success" id="update-task-board">Update</button>
                                        <button type="button" class="col-md-3 btn-danger mp-close">Cancel</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    
    <!-- Logout Modal-->
    <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-primary" href="login.html">Logout</a>
                </div>
            </div>
        </div>
    </div>

@endsection