@extends('layouts.dashboard.superadminapp')

@section('title', 'Company Types')
<style>
    .btn{
        width: auto;
    }
</style>
@section('content')
    @if (session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    @if (session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif
    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h5 mb-0 text-gray-800">UEPL / Company Types</h1>
        <div class="display-date">
            <span id="day">day</span>, <span id="daynum">00</span> <span id="month">month</span> <span id="year">0000</span>
        </div>
        <div class="display-time"></div>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header d-flex justify-content-between align-items-center gap-3">
            <span class="fw-bold"></span>
            <button class="btn btn-primary btn-sm" id="addCompanyTypeBtn" style="width: auto;" title="Add Company Type">
                <i class="fa fa-plus-square" aria-hidden="true"></i>
            </button>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover text-dark w-100" id="companyTypeTable">
                    <thead class="table-light">
                        <tr class="text-center align-middle">
                            <th>ID</th>
                            <th>Company Type</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- AJAX content -->
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Add/Edit Modal -->
    <div class="modal fade" id="companyTypeModal" tabindex="-1" aria-labelledby="companyTypeModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <form id="companyTypeForm">
                @csrf
                <input type="hidden" name="companytype_id" id="companytype_id">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="companyTypeModalLabel">Add/Edit Company Type</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span>&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group mb-2">
                            <label>Company Type</label>
                            <input name="company_type" id="company_type" class="form-control" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Save</button>
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Delete Modal -->
    <div class="modal fade" id="deleteCompanyTypeModal" tabindex="-1" aria-labelledby="deleteCompanyTypeLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Company Type</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span>&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this Company Type?
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" id="confirmDeleteBtn">Delete</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
<script>
$(document).ready(function(){
    function loadCompanyType() {
        $.get('{{ route('superadmin.companytype.list') }}', function(res){
            let rows = '';
            $.each(res.data, function(i, companytype){
                rows += `<tr class="text-center align-middle">
                    <td>${companytype.id}</td>
                    <td>${companytype.companytype}</td>
                    <td>
                        <button class="btn btn-sm btn-info editCompanyTypeBtn mb-1" 
                                data-id="${companytype.id}"
                                data-companytype="${companytype.companytype}" title="Edit">
                            <i class="fas fa-edit"></i>
                        </button>
                        <button class="btn btn-sm btn-danger deleteCompanyTypeBtn mb-1" 
                                data-id="${companytype.id}" title-"Delete">
                            <i class="fas fa-trash-alt"></i>
                        </button>
                    </td>
                </tr>`;
            });
            $('#companyTypeTable tbody').html(rows);
        });
    }

    loadCompanyType();

    $('#addCompanyTypeBtn').on('click', function(){
        $('#companyTypeForm')[0].reset();
        $('#companytype_id').val('');
        $('#companyTypeModalLabel').text('Add Company Type');
        $('#companyTypeModal').modal('show');
    });

    $('#companyTypeTable').on('click', '.editCompanyTypeBtn', function(){
        $('#companyTypeForm')[0].reset();
        $('#companytype_id').val($(this).data('id'));
        $('#company_type').val($(this).data('companytype'));
        $('#companyTypeModalLabel').text('Edit Company Type');
        $('#companyTypeModal').modal('show');
    });

    $('#companyTypeForm').submit(function(e){
        e.preventDefault();
        let id = $('#companytype_id').val();
        let url = id ? `/superadmin/companytypes/update/${id}` : `{{ route('superadmin.companytype.store') }}`;
        let type = 'POST';
        let data = $(this).serialize();
        $.ajax({
            url: url,
            type: type,
            data: data,
            success: function(res){
                $('#companyTypeModal').modal('hide');
                loadCompanyType();
            },
            error: function(err){
                alert('Error: ' + (err.responseJSON?.message || 'Check your input!'));
            }
        });
    });

    let deleteId = null;
    $('#companyTypeTable').on('click', '.deleteCompanyTypeBtn', function(){
        deleteId = $(this).data('id');
        $('#deleteCompanyTypeModal').modal('show');
    });

    $('#confirmDeleteBtn').on('click', function(){
        if(deleteId){
            $.ajax({
                url: `/superadmin/companytypes/delete/${deleteId}`,
                type: 'DELETE',
                data: {'_token': '{{ csrf_token() }}'},
                success: function(res){
                    $('#deleteCompanyTypeModal').modal('hide');
                    loadCompanyType();
                }
            });
        }
    });
});
</script>
@endsection
