@extends('layouts.dashboard.managerapp')

@section('title', 'Route Card View')

@section('content')
<div class="container-fluid py-4">
    <!-- Header Controls -->
    <div class="d-flex justify-content-between align-items-center mb-4 no-print">
        <h1 class="h3 mb-0 text-gray-800">Production Route Card</h1>
        <div>
            <button onclick="window.print()" class="btn btn-secondary btn-sm">
                <i class="fas fa-print"></i> Print
            </button>
            <a href="{{ url()->previous() }}" class="btn btn-light btn-sm ml-2">Back</a>
        </div>
    </div>

    <!-- Printable Area -->
    <div class="card shadow-sm border-0 printable-area">
        <div class="card-body p-5">
            <!-- Header Section -->
            <div class="row mb-4 border-bottom pb-4">
                <div class="col-6">
                    <h2 class="text-primary font-weight-bold">ROUTE CARD</h2>
                    <p class="text-muted mb-0">Production Execution Document</p>
                </div>
                <div class="col-6 text-right">
                    <h4 class="mb-1">RC No: {{ $routeCard->route_no }}</h4>
                    <p class="mb-0">Date: {{ $routeCard->route_date }}</p>
                </div>
            </div>

            <!-- Job Details -->
            <div class="row mb-5">
                <div class="col-md-6">
                    <h5 class="text-uppercase text-secondary font-weight-bold mb-3" style="font-size: 0.85rem; letter-spacing: 1px;">Job Information</h5>
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td class="text-muted" style="width: 140px;">Order No:</td>
                            <td class="font-weight-bold">{{ $routeCard->order_no ?? '-' }}</td>
                        </tr>
                        <tr>
                            <td class="text-muted">Company:</td>
                            <td class="font-weight-bold">{{ $routeCard->company_name ?? '-' }}</td>
                        </tr>
                        <tr>
                            <td class="text-muted">Project Material:</td>
                            <td class="font-weight-bold">{{ $routeCard->project_material_no ?? '-' }}</td>
                        </tr>
                        <tr>
                            <td class="text-muted">Part No:</td>
                            <td class="font-weight-bold">{{ $routeCard->part_no ?? '-' }}</td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <h5 class="text-uppercase text-secondary font-weight-bold mb-3" style="font-size: 0.85rem; letter-spacing: 1px;">Technical Details</h5>
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td class="text-muted" style="width: 140px;">Drawing No:</td>
                            <td class="font-weight-bold">{{ $routeCard->drawing_no ?? '-' }}</td>
                        </tr>
                        <tr>
                            <td class="text-muted">Revision:</td>
                            <td class="font-weight-bold">{{ $routeCard->drawing_rev ?? '-' }}</td>
                        </tr>
                        <tr>
                            <td class="text-muted">Product Type:</td>
                            <td class="font-weight-bold">{{ $routeCard->product_type ?? '-' }}</td>
                        </tr>
                         <tr>
                            <td class="text-muted">Description:</td>
                            <td class="font-weight-bold">{{ $routeCard->description ?? '-' }}</td>
                        </tr>
                    </table>
                </div>
            </div>

            <!-- Process Table -->
            <div class="mb-4">
                <h5 class="text-uppercase text-secondary font-weight-bold mb-3" style="font-size: 0.85rem; letter-spacing: 1px;">Process Sequence</h5>
                <div class="table-responsive">
                    <table class="table table-bordered table-striped">
                        <thead class="thead-light">
                            <tr>
                                <th style="width: 5%">#</th>
                                <th style="width: 25%">Process</th>
                                <th style="width: 15%">Machine</th>
                                <th style="width: 15%">Operator</th>
                                <th style="width: 15%">Planned Start</th>
                                <th style="width: 15%">Planned End</th>
                                <th style="width: 10%">Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($routeCard->processes as $index => $process)
                            <tr>
                                <td class="text-center">{{ $index + 1 }}</td>
                                <td class="font-weight-bold">{{ $process->process }}</td>
                                <td>{{ $process->machine }}</td>
                                <td>{{ $employees[$process->operator] ?? '-' }}</td>
                                <td>{{ $process->start_date }}</td>
                                <td>{{ $process->end_date }}</td>
                                <td>
                                    <span class="badge badge-{{ $process->status == 'completed' ? 'success' : ($process->status == 'in_progress' ? 'warning' : 'secondary') }}">
                                        {{ ucfirst(str_replace('_', ' ', $process->status ?? 'Planned')) }}
                                    </span>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Signatures -->
             <div class="row mt-5 pt-5">
                <div class="col-4 text-center">
                    <p class="border-top pt-2 font-weight-bold">Prepared By</p>
                </div>
                <div class="col-4 text-center">
                    <p class="border-top pt-2 font-weight-bold">Production Manager</p>
                </div>
                <div class="col-4 text-center">
                    <p class="border-top pt-2 font-weight-bold">Quality Inspector</p>
                </div>
            </div>
        </div>
    </div>
</div>

<style media="print">
    .no-print { display: none !important; }
    .card { border: none !important; box-shadow: none !important; }
    body { background: #fff !important; }
    .container-fluid { padding: 0 !important; }
</style>
@endsection
