@extends('layouts.dashboard.managerapp')

@section('title', 'Tax Invoice List')

<style>
    div.dt-buttons {
        float: left;
        display: flex !important;
    }
    .dataTable {
        overflow-x: auto !important;
        display: table !important;
    }
</style>

@section('content')
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">Tax Invoice List</h1>
    <a href="{{ route('admin.invoice.invoiceorder') }}" class="btn btn-primary btn-sm" title=" Add Tax Invoice"><i class="fa fa-plus-square" aria-hidden="true"></i></a>
</div>

<div class="card shadow mb-4">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered" id="customerTable" width="100%" cellspacing="0">
                <thead>
                    <tr>
                        <th>Invoice ID</th>
                        <th>Invoice Date</th>
                        <th>Company Name</th>
                        <th>Company Email</th>
                        <th>Company Contact No</th>
                        <th>GST No</th>
                        <th>Reference No</th>
                        <th>Reference Date</th>
                        <th>Buyers Order No</th>
                        <th>Destination</th>
                        <th>Vehicle No</th>
                        <th>Total Amount</th>
                        <th>Total Tax Amount</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($invoices as $invoice)
                    <tr id="row-{{ $invoice->id }}">
                        <td>{{ $invoice->invoice_no }}</td>
                        <td>{{ \Carbon\Carbon::parse($invoice->invoice_date)->format('d-m-Y') }}</td>
                        <td>{{ $invoice->company->company ?? '-' }}</td>
                        <td>{{ $invoice->company->email ?? '-' }}</td>
                        <td>{{ $invoice->company->mobile ?? '-' }}</td>
                        <td>{{ $invoice->company->gstno ?? '-' }}</td>
                        <td>{{ $invoice->reference_no }}</td>
                        <td>{{ \Carbon\Carbon::parse($invoice->reference_date)->format('d-m-Y') }}</td>
                        <td>{{ $invoice->buyer_order_no }}</td>
                        <td>{{ $invoice->destination }}</td>
                        <td>{{ $invoice->vehicle_no }}</td>
                        <td>{{ number_format($invoice->total_amount, 2) }}</td>
                        <td>{{ number_format($invoice->total_tax_amount, 2) }}</td>
                        <td>
                            <a href="{{ route('manager.invoice.print', $invoice->id) }}" target="_blank" class="btn btn-info btn-sm" title="Print"><i class="fas fa-print"></i></a>
                            <a href="{{ route('manager.invoice.edit', $invoice->id) }}" class="btn btn-warning btn-sm" title="Edit"><i class="fa fa-edit"></i></a>
                            <button class="btn btn-danger btn-sm delete-btn" data-id="{{ $invoice->id }}" title="Delete"><i class="fa fa-trash"></i></button>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    var table = $('#customerTable').DataTable({
        dom: 'Bfrtip',
        buttons: ['copy', 'csv', 'excel', 'pdf', 'print'],
        pageLength: 10,
        responsive: true,
    });

    $(document).on('click', '.delete-btn', function() {
        var id = $(this).data('id');
        if (confirm('Are you sure you want to delete this invoice?')) {
            $.ajax({
                url: '/admin/invoices/' + id, // Adjust route if needed
                type: 'DELETE',
                data: {
                    _token: "{{ csrf_token() }}"
                },
                success: function(response) {
                    $('#row-' + id).fadeOut(500, function() {
                        $(this).remove();
                    });
                }
            });
        }
    });
});
</script>
@endsection
