@extends('layouts.dashboard.managerapp')

@section('title','Machine Dashboard')

@section('content')

<div class="container-fluid">

<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">UEPL / Machine Dashboard </h1>
    <div class="display-date">
        <span id="day">day</span>,
        <span id="daynum">00</span>
        <span id="month">month</span>
        <span id="year">0000</span>
    </div>
    <div class="display-time"></div>
</div>

<!-- Content Row -->
<div class="row bg-white">
    <div class="col-lg-12">
        <h1>Machine Dashboard</h1><br><br>

        <!-- Cards Container -->
        <div class="row">

            <!-- Total Machines -->
            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-primary shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-md font-weight-bold text-primary text-uppercase mb-1">
                                    Total Machines</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $totalMachines }}</div>
                                <div class="card-body">{{ $totalMachines > 0 ? ($totalMachines - 5) . ' more than last month' : '' }}</div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-industry fa-3x text-primary"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Running Now -->
            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-success shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-md font-weight-bold text-success text-uppercase mb-1">
                                    Running Now</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $runningNow }}</div>
                                <div class="card-body">
                                    @php
                                        $capacity = $totalMachines > 0 ? round(($runningNow / $totalMachines) * 100) : 0;
                                    @endphp
                                    {{ $capacity }}% of total capacity
                                </div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-play fa-3x text-success"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Under Maintenance -->
            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-info shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-md font-weight-bold text-info text-uppercase mb-1">
                                    Under Maintenance
                                </div>
                                <div class="row no-gutters align-items-center">
                                    <div class="col-auto">
                                        <div class="h5 mb-0 mr-3 font-weight-bold text-gray-800">{{ $underMaintenance }}</div>
                                        <div class="card-body">
                                            {{ $underMaintenance }} scheduled, 0 emergency
                                            {{-- Adjust if you have emergency/scheduled split --}}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-tools fa-3x text-info" style="color:red;"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Issues Today -->
            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-danger shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-md font-weight-bold text-danger text-uppercase mb-1">
                                    Issues Today</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $issuesToday }}</div>
                                <div class="card-body">{{ $issuesToday }} critical, 0 minor
                                    {{-- Adjust split if you have --}}
                                </div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-exclamation-triangle fa-3x text-danger"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>

        <!-- Charts -->
        <div class="row">
            <div class="col-md-6">
                <div class="chart-card">
                    <div class="chart-title">Production Output (Last 7 Days)</div>
                    <canvas id="productionChart"></canvas>
                </div>
            </div>
            <div class="col-md-6">
                <div class="chart-card">
                    <div class="chart-title">Machine Status</div>
                    <canvas id="statusChart"></canvas>
                </div>
            </div>
        </div>

        <!-- Operators -->
        <div class="row mt-4">
            <div class="current-operators-container">
                <h2 class="current-operators-title">Current Shift Operators</h2>
                <div class="current-operators-grid d-flex flex-wrap">
                    @forelse($currentOperators as $operator)
                        <div class="current-operator-card m-2 p-2 border rounded">
                            <img src="{{ $operator['profile_picture'] }}" alt="Operator" class="current-operator-avatar mb-2" style="width:60px;">
                            <div class="current-operator-name font-weight-bold">{{ $operator['name'] }}</div>
                            <div class="current-operator-role">{{ $operator['role'] }}</div>
                            <div class="current-operator-status {{ strtolower($operator['status']) }}">{{ $operator['status'] }}</div>
                        </div>
                    @empty
                        <div class="text-muted">No operators on shift.</div>
                    @endforelse
                </div>
            </div>
        </div>
        <!-- Project Planning End-->
    </div>
    <!-- /.container-fluid -->
</div>

</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/moment@2.29.1/moment.min.js"></script>

{{-- Pass PHP data to JS --}}
<script>
    window.productionLast7 = @json($productionLast7);
    window.machineStatus = @json($machineStatus);
</script>

<script>
// Production Output Chart
const prodLabels = Object.keys(window.productionLast7).map(date => moment(date).format('DD MMM'));
const prodData = Object.values(window.productionLast7);

const prodCtx = document.getElementById('productionChart').getContext('2d');
new Chart(prodCtx, {
    type: 'line',
    data: {
        labels: prodLabels,
        datasets: [{
            label: 'Output',
            data: prodData,
            fill: false,
            borderColor: 'rgba(54, 162, 235, 1)',
            tension: 0.2
        }]
    },
    options: { responsive: true }
});

// Machine Status Pie Chart
const statusLabels = Object.keys(window.machineStatus);
const statusData = Object.values(window.machineStatus);

const statusCtx = document.getElementById('statusChart').getContext('2d');
new Chart(statusCtx, {
    type: 'pie',
    data: {
        labels: statusLabels,
        datasets: [{
            data: statusData,
            backgroundColor: [
                'rgba(75, 192, 192, 0.7)',
                'rgba(255, 205, 86, 0.7)',
                'rgba(201, 203, 207, 0.7)'
            ]
        }]
    },
    options: { responsive: true }
});

// Dynamic Date
function updateDateTime() {
    const now = new Date();
    document.getElementById('day').textContent = now.toLocaleString('en-us', { weekday:'long' });
    document.getElementById('daynum').textContent = now.getDate();
    document.getElementById('month').textContent = now.toLocaleString('en-us', { month:'long' });
    document.getElementById('year').textContent = now.getFullYear();
    document.querySelector('.display-time').textContent = now.toLocaleTimeString();
}
updateDateTime();
setInterval(updateDateTime, 1000);

</script>

@endsection
