@props(['title', 'value', 'icon', 'border', 'progress' => null])
<div class="col-xl-3 col-md-6 mb-4">
    <div class="card border-left-{{ $border }} shadow h-100 py-2">
        <div class="card-body">
            <div class="row no-gutters align-items-center">
                <div class="col mr-2">
                    <div class="text-md font-weight-bold text-{{ $border }} text-uppercase mb-1">{{ $title }}</div>
                    <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $value }}</div>
                    @if($progress)
                        <div class="progress progress-sm mr-2">
                            <div class="progress-bar bg-{{ $border }}" role="progressbar"
                                style="width: {{ $progress }}%" aria-valuenow="{{ $progress }}" aria-valuemin="0"
                                aria-valuemax="100"></div>
                        </div>
                    @endif
                </div>
                <div class="col-auto">
                    <i class="fas fa-{{ $icon }} fa-3x text-gray-300"></i>
                </div>
            </div>
        </div>
    </div>
</div>
