@extends('layouts.dashboard.managerapp')

@section('title', 'All Dashboard')

@section('content')

<div class="container-fluid">
<style>
button{
    width: auto;
}
    </style>
<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">UEPL / Account Dashboard </h1>
    <div class="display-date">
        <span id="day">day</span>,
        <span id="daynum">00</span>
        <span id="month">month</span>
        <span id="year">0000</span>
    </div>
    <div class="display-time"></div>
</div>

<div class="dashboard-content">

    <!-- Summary Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100">
                <div class="card-body d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-md font-weight-bold text-success text-uppercase mb-1">Revenue</div>
                        <div class="ruppee-symbol h5 mb-0 font-weight-bold text-gray-800">₹{{ number_format($revenue ?? 0) }}</div>
                    </div>
                    <div class="col-auto ms-3">
                        <i class="fas fa-money-bill fa-3x text-success"></i>
                    </div>
                </div>
                <div class="card-footer border-0">
                    <span class="text-success">{{ $revenueGrowth ?? '' }}</span> vs last month
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100">
                <div class="card-body d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-md font-weight-bold text-info text-uppercase mb-1">Expenses</div>
                        <div class="ruppee-symbol h5 mb-0 font-weight-bold text-gray-800">₹{{ number_format($expenses ?? 0) }}</div>
                    </div>
                    <div class="col-auto ms-3">
                        <i class="fas fa-receipt fa-3x text-info"></i>
                    </div>
                </div>
                <div class="card-footer border-0">
                    <span class="text-info">{{ $expensesGrowth ?? '' }}</span> vs last month
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100">
                <div class="card-body d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-md font-weight-bold text-warning text-uppercase mb-1">Gross Profit</div>
                        <div class="ruppee-symbol h5 mb-0 font-weight-bold text-gray-800">₹{{ number_format($grossProfit ?? 0) }}</div>
                    </div>
                    <div class="col-auto ms-3">
                        <i class="fas fa-chart-pie fa-3x text-warning"></i>
                    </div>
                </div>
                <div class="card-footer border-0">
                    <span class="text-warning">{{ $profitGrowth ?? '' }}</span> vs last month
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-secondary shadow h-100">
                <div class="card-body d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="text-md font-weight-bold text-secondary text-uppercase mb-1">Production Cost</div>
                        <div class="ruppee-symbol h5 mb-0 font-weight-bold text-gray-800">₹{{ number_format($productionCost ?? 0) }}</div>
                    </div>
                    <div class="col-auto ms-3">
                        <i class="fas fa-cogs fa-3x text-secondary"></i>
                    </div>
                </div>
                <div class="card-footer border-0">
                    <span class="text-warning">{{ $prodCostGrowth ?? '' }}</span> vs last month
                </div>
            </div>
        </div>
    </div>

    <!-- Charts Row -->
    <div class="row mb-4">
        <div class="col-lg-8 mb-4">
            <div class="card h-100">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h6 class="mb-0">Revenue vs Expenses</h6>
                    <div>
                        <button class="btn btn-sm btn-primary me-1" onclick="filterData('daily')">Daily</button>
                        <button class="btn btn-sm btn-outline-primary me-1" onclick="filterData('monthly')">Monthly</button>
                        <button class="btn btn-sm btn-outline-primary me-1" onclick="filterData('quarterly')">Quarterly</button>
                        <button class="btn btn-sm btn-outline-primary" onclick="filterData('yearly')">Yearly</button>
                    </div>
                </div>
                <div class="card-body">
                    <canvas id="accountingChart"></canvas>
                </div>
            </div>
        </div>
        <div class="col-lg-4 mb-4">
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="mb-0">Cost Breakdown</h6>
                </div>
                <div class="card-body">
                    <canvas id="costChart"></canvas>
                </div>
            </div>
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">Financial Summary</h6>
                </div>
                <div class="card-body" id="summary">
                    @foreach($summary as $row)
                        <div class="d-flex justify-content-between border-bottom py-2">
                            <span>{{ $row['title'] }}</span>
                            <span class="fw-bold">{{ $row['value'] }}</span>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>

    <!-- Pending Invoices/Bills Table -->
    <div class="card mb-4">
        <div class="card-header"><h6 class="mb-0">Pending Invoices/Bills</h6></div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-striped mb-0" id="invoicesTable">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Date</th>
                            <th>Description</th>
                            <th>Amount</th>
                            <th>Due Date</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($pendingInvoices as $invoice)
                            <tr>
                                <td>{{ $invoice->invoice_no }}</td>
                                <td>{{ \Carbon\Carbon::parse($invoice->invoice_date)->format('d M Y') }}</td>
                                <td>{{ $invoice->reference_no ?? '-' }}</td>
                                <td class="ruppee-symbol">₹{{ number_format($invoice->total_amount) }}</td>
                                <td>-</td>
                                <td><span class="badge bg-warning text-dark">Pending</span></td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center">No pending invoices.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Revenue vs Expenses Chart
    const accountingChart = document.getElementById('accountingChart').getContext('2d');
    new Chart(accountingChart, {
        type: 'line',
        data: {
            labels: @json($months),
            datasets: [
                {
                    label: 'Revenue',
                    data: @json($chartRevenue),
                    borderColor: '#1d4ed8',
                    backgroundColor: 'rgba(59,130,246,0.07)',
                    fill: true,
                    tension: 0.4
                },
                {
                    label: 'Expenses',
                    data: @json($chartExpenses),
                    borderColor: '#e11d48',
                    backgroundColor: 'rgba(225,29,72,0.07)',
                    fill: true,
                    tension: 0.4
                }
            ]
        }
    });

    // Cost Breakdown Pie Chart
    const costChart = document.getElementById('costChart').getContext('2d');
    new Chart(costChart, {
        type: 'pie',
        data: {
            labels: {!! json_encode(array_keys($costBreakdown)) !!},
            datasets: [{
                data: {!! json_encode(array_values($costBreakdown)) !!},
                backgroundColor: ['#fbbf24','#1d4ed8','#22d3ee','#fb7185']
            }]
        }
    });

    // Date and Time update
    function updateDateTime() {
        const now = new Date();
        document.getElementById('day').textContent = now.toLocaleString('en-us', { weekday:'long' });
        document.getElementById('daynum').textContent = now.getDate();
        document.getElementById('month').textContent = now.toLocaleString('en-us', { month:'long' });
        document.getElementById('year').textContent = now.getFullYear();
        document.querySelector('.display-time').textContent = now.toLocaleTimeString();
    }
    updateDateTime();
    setInterval(updateDateTime, 1000);

    // Filters (stub, add AJAX/data change logic as needed)
    function filterData(type) {
        alert('Filter: ' + type + ' (implement logic as needed)');
    }
</script>

@endsection
