<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Login Page">
    <meta name="author" content="Your Company">

    <title>Umbrey Engineering Private Limited - Login</title>

    <!-- Custom fonts -->
    <link href="{{ asset('vendor/fontawesome-free/css/all.min.css') }}" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">

    <!-- Custom styles -->
    <link href="{{ asset('css/style.min.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.12.0/css/all.css">
</head>

<body class="bg-gradient-light">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-12 col-md-9">
                <div class="o-hidden my-4">
                    <div class="card-body">
                        <div class="row" style="height: 482.53px;">
                            <div class="col-lg-6 bg-gradient-primary card">
                                <div class="logo"><img src="{{ asset('img/INDUS-PRO-LOGO.png') }}" alt="Logo"></div>
                                <div class="m-text">Industries Solution</div>
                                <div class="paragraph-login">Boost Productivity, Reduce Waste – Smarter Manufacturing Starts Here</div>
                            </div>
                            <div class="col-lg-6 login-bg">
                                <div class="p-4">
                                    <div class="text-left">
                                        <h1 class="h5 text-white mb-2">Welcome Indus Pro!</h1>
                                        <h1 class="h3 text-white mb-3">Sign In</h1>
                                    </div>

                                    <!-- Laravel Login Form -->
                                    <form method="POST" action="{{ route('login') }}" class="user">
                                        @csrf

                                        <!-- Email Input -->
                                        <div class="form-group">
                                            <input type="email"
                                                class="form-control form-control-user @error('email') is-invalid @enderror"
                                                name="email" value="{{ old('email') }}" required autofocus
                                                placeholder="Username">
                                            @error('email')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>

                                        <!-- Password Input -->
                                        <div class="form-group">
                                            <input type="password"
                                                class="form-control form-control-user @error('password') is-invalid @enderror"
                                                name="password" required placeholder="Password"
                                                style="height: 59.56px;">
                                                <i class="login-toggle-password fa fa-fw fa-eye-slash"></i>
                                               
                                            @error('password')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                            <div class="text-right mb-2">
                                                <a class="small" href="{{ route('password.request') }}">Forgot
                                                    Password?</a>
                                            </div>
                                        </div>

                                        <!-- Submit Button -->
                                        <button type="submit" class="btn btn-primary btn-user btn-block mt-3">
                                            Login
                                        </button>
                                    </form>

                                    <hr>

                                    <div class="text-center small">
                                        Don’t have an account? |
                                        <!--<a class="small" href="{{ route('register') }}">Create Account</a>-->
                                        Contact Admin
                                    </div>
                                </div>
                            </div>
                        </div> <!-- End Row -->
                    </div> <!-- End Card Body -->
                </div> <!-- End Outer Div -->
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer class="sticky-footer">
        <div class="container my-auto">
            <div class="copyright text-center my-auto">
                <span>Copyright &copy; SRIIN5NET 2025</span>
            </div>
        </div>
    </footer>

    <!-- Scripts -->
    <script src="{{ asset('vendor/jquery/jquery.min.js') }}"></script>
    <script src="{{ asset('vendor/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('vendor/jquery-easing/jquery.easing.min.js') }}"></script>
    <script defer src="{{ asset('js/sb-admin-2.min.js') }}"></script>
    <script src="{{ asset('js/login_validation.js') }}"></script>

</body>

</html>
