@extends('layouts.dashboard.adminapp')

@section('title', 'Purchase Order List')

@section('styles')
    <!-- DataTables Bootstrap 5 styling for buttons -->
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.bootstrap5.min.css">
    <style>
        div.dt-buttons {
            float: left;
            display: flex !important;
        }

        .dataTable {
            overflow-x: auto !important;
            display: table !important;
        }

        .dt-buttons .btn {
            margin-right: 0.5rem !important;
            padding: 0.25rem 0.75rem !important;
            font-size: 0.95rem !important;
        }
    </style>
@endsection

@section('content')
    <div class="container-fluid bg-white">
        <!-- Page Heading -->
        <div class="p-2 d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h5 mb-0 text-gray-800">
                UEPL | Purchase Order List
            </h1>
            <div class="display-date">
                <span id="day">day</span>,
                <span id="daynum">00</span>
                <span id="month">month</span>
                <span id="year">0000</span>
            </div>
            <div class="display-time"></div>
        </div>
 <div class="row mt-4">
            <div class="col-lg-12">
        <div class="card mb-5">
            

            <div class="card-header d-flex align-items-center justify-content-between" style="float: left;flex-direction: row-reverse;">
                <a href="{{ route('admin.purchase.purchaseorder') }}" 
                    class="btn btn-primary btn-sm" style="float: right; margin-right: 10px;" title="Add Purchase Order">
                    <i class="fas fa-plus-square"></i> 
                </a>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered" id="purchaseOrderTable" width="100%"
                        cellspacing="0">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Purchase Order No.</th>
                                <th>Date</th>
                                <th>Vendor Name</th>
                                <th>GRN No.</th>
                                <th>Grand Total</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($purchaseOrders as $po)
                                <tr id="row-{{ $po->id }}">
                                    <td>{{ $po->id }}</td>
                                    <td>{{ $po->purchase_order_no }}</td>
                                    <td>{{ \Carbon\Carbon::parse($po->purchase_order_date)->format('d M Y') }}</td>
                                    <td>
                                        {{-- Show Vendor Name (using relationship if exists, fallback to id) --}}
                                        {{ $po->vendor ? $po->vendor->company : $po->company_name }}
                                    </td>
                                    <td>{{ $po->grn_no }}</td>
                                    <td>₹{{ number_format($po->grand_total, 2) }}</td>
                                    <td>
                                        @if ($po->status == 'Inactive')
                                            <span class="badge bg-secondary text-white">Inactive</span>
                                        @else
                                            <span class="badge bg-success text-white">Active</span>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('admin.purchase.order.show', $po->id) }}" title="View"
                                            class="btn btn-info btn-sm me-1"><i class="fa fa-eye"></i></a>
                                        <a href="{{ route('admin.purchase.order.print', $po->id) }}" title="Print PDF" target="_blank"
                                            class="btn btn-secondary btn-sm me-1">
                                            <i class="fa fa-print"></i>
                                        </a>
                                        <a href="{{ route('admin.purchase.order.edit', $po->id) }}"
                                            class="btn btn-warning btn-sm me-1" title="Edit"><i class="fa fa-edit"></i></a>
                                        <button class="btn btn-danger btn-sm delete-btn"
                                            data-id="{{ $po->id }}" title="Delete"><i class="fa fa-trash"></i> </button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.bootstrap5.min.js"></script>
    <script>
        $(document).ready(function() {
            var table = $('#purchaseOrderTable').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'copy',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'csv',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'excel',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'pdf',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'print',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'colvis',
                        className: 'btn btn-secondary btn-sm'
                    }
                ],
                pageLength: 10,
                responsive: true,
                language: {
                    "emptyTable": "No purchase orders found"
                }
            });

            // Delete with confirmation
            $(document).on('click', '.delete-btn', function() {
                var id = $(this).data('id');
                if (confirm('Are you sure you want to delete this Purchase Order?')) {
                    $.ajax({
                        url: '/admin/purchase/order/' + id,
                        type: 'DELETE',
                        data: {
                            _token: "{{ csrf_token() }}"
                        },
                        success: function(response) {
                            table.row('#row-' + id).remove().draw(false);
                            toastr.success(response.message || "Deleted successfully");
                        },
                        error: function(xhr) {
                            toastr.error("Failed to delete purchase order.");
                        }
                    });
                }
            });
        });
    </script>
@endsection
