@extends('layouts.dashboard.adminapp')

@section('title', 'Production In Progress List')

@section('content')
<div class="container py-4">
    <h2 class="mb-4">Production - In Progress</h2>
    <div class="table-responsive">
        <table class="table table-bordered table-hover bg-white">
            <thead>
                <tr>
                    <th>RC No</th>
                    <th>Company</th>
                    <th>RC Date</th>
                    <th>Status</th>
                    <th>Planned By</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @forelse($routeCards as $rc)
                <tr>
                    <td>{{ $rc->route_no }}</td>
                    <td>{{ $rc->company_name }}</td>
                    <td>{{ $rc->route_date }}</td>
                    <td>
                        <span class="badge badge-info text-uppercase">{{ $rc->status }}</span>
                    </td>
                    <td>{{ optional($rc->approved_by)->name ?? 'Admin' }}</td>
                    <td>
                        <a href="{{ route('admin.production.board', $rc->id) }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-cogs"></i> View Production
                        </a>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="6" class="text-center text-muted">No production in progress.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
@endsection
