@extends('layouts.dashboard.adminapp')

@section('title','Stock Dashboard')

@section('content')
<div class="container-fluid">
<style>
    button{
        width: auto;
    }
    </style>
<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">UEPL / Stock Dashboard </h1>
    <div class="display-date">
        <span id="day">day</span>,
        <span id="daynum">00</span>
        <span id="month">month</span>
        <span id="year">0000</span>
    </div>
    <div class="display-time"></div>
</div>

<!-- Cards Row -->
<div class="row mb-4">
    <div class="col-12 col-sm-6 col-lg-4 mb-4">
        <div class="card border-left-primary shadow h-100">
            <div class="card-body d-flex align-items-center">
                <div class="flex-grow-1">
                    <div class="text-md font-weight-bold text-primary text-uppercase mb-1">Total Items</div>
                    <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($totalItems ?? 0) }}</div>
                    <div class="small text-muted mt-1"><i class="bi bi-arrow-up"></i> &nbsp;12% from last month</div>
                </div>
                <div class="col-auto ms-3">
                    <i class="fas fa-boxes fa-3x text-primary"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-12 col-sm-6 col-lg-4 mb-4">
        <div class="card border-left-success shadow h-100">
            <div class="card-body d-flex align-items-center">
                <div class="flex-grow-1">
                    <div class="text-md font-weight-bold text-success text-uppercase mb-1">Low Stock</div>
                    <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($lowStock ?? 0) }}</div>
                    <div class="small text-muted mt-1"><i class="bi bi-arrow-down"></i> &nbsp;5% from last month</div>
                </div>
                <div class="col-auto ms-3">
                    <i class="fas fa-exclamation-triangle fa-3x text-success"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-12 col-sm-6 col-lg-4 mb-4">
        <div class="card border-left-danger shadow h-100">
            <div class="card-body d-flex align-items-center">
                <div class="flex-grow-1">
                    <div class="text-md font-weight-bold text-info text-uppercase mb-1">Out of Stock</div>
                    <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($outOfStock ?? 0) }}</div>
                    <div class="small text-muted mt-1"><i class="bi bi-arrow-up"></i> &nbsp;3% from last month</div>
                </div>
                <div class="col-auto ms-3">
                    <i class="fas fa-store-slash fa-3x text-danger"></i>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Charts Row -->
<div class="row charts-row">
    <div class="col-md-8 mb-4">
        <div class="card h-100">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h6 class="mb-0">Stock Movement</h6>
                <div>
                    <button class="btn btn-sm btn-primary me-1" onclick="filterData('daily')">Daily</button>
                    <button class="btn btn-sm btn-outline-primary me-1" onclick="filterData('monthly')">Monthly</button>
                    <button class="btn btn-sm btn-outline-primary me-1" onclick="filterData('quarterly')">Quarterly</button>
                    <button class="btn btn-sm btn-outline-primary" onclick="filterData('yearly')">Yearly</button>
                </div>
            </div>
            <div class="card-body">
                <canvas id="movementChart"></canvas>
            </div>
        </div>
    </div>
    <div class="col-md-4 mb-4">
        <div class="card mb-4">
            <div class="card-header">
                <h6 class="mb-0">Stock Distribution</h6>
            </div>
            <div class="card-body">
                <canvas id="distributionChart"></canvas>
            </div>
        </div>
       
    </div>
</div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/moment@2.29.1/moment.min.js"></script>
<script>
    // Prepare PHP data for JS
    window.movementData = @json($movementData ?? []);
    window.distribution = @json($distribution ?? []);

    // Stock Movement Chart
    const movementLabels = Object.keys(window.movementData).map(date => moment(date).format('DD MMM'));
    const movementValues = Object.values(window.movementData);
    new Chart(document.getElementById('movementChart'), {
        type: 'line',
        data: {
            labels: movementLabels,
            datasets: [{
                label: 'Net Movement',
                data: movementValues,
                borderColor: 'rgba(54,162,235,1)',
                backgroundColor: 'rgba(54,162,235,0.2)',
                fill: true,
                tension: 0.2
            }]
        }
    });

    // Stock Distribution Pie Chart
    new Chart(document.getElementById('distributionChart'), {
        type: 'pie',
        data: {
            labels: Object.keys(window.distribution),
            datasets: [{
                data: Object.values(window.distribution),
                backgroundColor: ['#60a5fa', '#34d399', '#fbbf24', '#f472b6', '#a78bfa', '#fdba74']
            }]
        }
    });

    // Date and Time update
    function updateDateTime() {
        const now = new Date();
        document.getElementById('day').textContent = now.toLocaleString('en-us', { weekday:'long' });
        document.getElementById('daynum').textContent = now.getDate();
        document.getElementById('month').textContent = now.toLocaleString('en-us', { month:'long' });
        document.getElementById('year').textContent = now.getFullYear();
        document.querySelector('.display-time').textContent = now.toLocaleTimeString();
    }
    updateDateTime();
    setInterval(updateDateTime, 1000);

    // Stock movement filters (stub for your logic)
    function filterData(type) {
        // Implement AJAX or chart update based on type if you want
        alert('Filtering: ' + type + ' (demo only, implement as needed)');
    }
</script>
@endsection
