@extends('layouts.dashboard.superadminapp')

@section('title', 'Payable Details - ' . $payable->purchase_no)

@section('styles')
<style>
    .detail-card {
        border-left: 4px solid #e74a3b;
    }
    .payment-card {
        border-left: 4px solid #1cc88a;
    }
    .detail-row {
        padding: 8px 0;
        border-bottom: 1px solid #e3e6f0;
    }
    .detail-row:last-child {
        border-bottom: none;
    }
    .detail-label {
        font-weight: 600;
        color: #858796;
        font-size: 0.8rem;
        text-transform: uppercase;
    }
    .detail-value {
        color: #5a5c69;
    }
    .status-badge-pending { background-color: #f6c23e; color: #000; }
    .status-badge-partial { background-color: #36b9cc; color: #fff; }
    .status-badge-paid { background-color: #1cc88a; color: #fff; }
</style>
@endsection

@section('content')

<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">
        <a href="{{ route('superadmin.accounts.payable.index') }}" class="text-decoration-none">
            <i class="fas fa-arrow-left mr-2"></i>
        </a>
        Payable: {{ $payable->purchase_no }}
    </h1>
    @php
        $status = $payable->payment_status ?? 'pending';
    @endphp
    <span class="badge status-badge-{{ $status }} px-3 py-2" style="font-size: 1rem;">
        {{ ucfirst($status) }}
    </span>
</div>

<div class="row">
    <!-- Bill Details -->
    <div class="col-lg-6 mb-4">
        <div class="card shadow detail-card">
            <div class="card-header py-3" style="background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-file-invoice mr-2"></i> Bill Details
                </h6>
            </div>
            <div class="card-body">
                <div class="detail-row">
                    <div class="detail-label">Bill Number</div>
                    <div class="detail-value">{{ $payable->purchase_no }}</div>
                </div>
                <div class="detail-row">
                    <div class="detail-label">Bill Date</div>
                    <div class="detail-value">{{ \Carbon\Carbon::parse($payable->purchase_date)->format('d M Y') }}</div>
                </div>
                <div class="detail-row">
                    <div class="detail-label">PO Number</div>
                    <div class="detail-value">{{ $payable->purchase_order_no ?? 'N/A' }}</div>
                </div>
                <div class="detail-row">
                    <div class="detail-label">Vendor Invoice No</div>
                    <div class="detail-value">{{ $payable->vendor_invoice_no ?? 'N/A' }}</div>
                </div>
                <div class="detail-row">
                    <div class="detail-label">Payment Terms</div>
                    <div class="detail-value">{{ $payable->payment_terms ?? 'N/A' }}</div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Vendor Details -->
    <div class="col-lg-6 mb-4">
        <div class="card shadow">
            <div class="card-header py-3" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-building mr-2"></i> Vendor Details
                </h6>
            </div>
            <div class="card-body">
                <div class="detail-row">
                    <div class="detail-label">Vendor Name</div>
                    <div class="detail-value">{{ $payable->vendor->company_name ?? $payable->company_name ?? 'N/A' }}</div>
                </div>
                <div class="detail-row">
                    <div class="detail-label">Phone</div>
                    <div class="detail-value">{{ $payable->vendor->phone ?? $payable->company_phone ?? 'N/A' }}</div>
                </div>
                <div class="detail-row">
                    <div class="detail-label">Email</div>
                    <div class="detail-value">{{ $payable->vendor->email ?? $payable->company_email ?? 'N/A' }}</div>
                </div>
                <div class="detail-row">
                    <div class="detail-label">GSTN</div>
                    <div class="detail-value">{{ $payable->vendor->gstn ?? $payable->company_gstn ?? 'N/A' }}</div>
                </div>
                <div class="detail-row">
                    <div class="detail-label">Address</div>
                    <div class="detail-value">{{ $payable->vendor->address ?? $payable->company_address ?? 'N/A' }}</div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Amount Summary -->
<div class="row">
    <div class="col-lg-6 mb-4">
        <div class="card shadow">
            <div class="card-header py-3" style="background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-calculator mr-2"></i> Amount Summary
                </h6>
            </div>
            <div class="card-body">
                <table class="table table-sm mb-0">
                    <tr>
                        <td>Subtotal</td>
                        <td class="text-right">₹{{ number_format($payable->subtotal ?? 0, 2) }}</td>
                    </tr>
                    <tr>
                        <td>SGST</td>
                        <td class="text-right">₹{{ number_format($payable->sgst_amount ?? 0, 2) }}</td>
                    </tr>
                    <tr>
                        <td>CGST</td>
                        <td class="text-right">₹{{ number_format($payable->cgst_amount ?? 0, 2) }}</td>
                    </tr>
                    <tr>
                        <td>IGST</td>
                        <td class="text-right">₹{{ number_format($payable->igst_amount ?? 0, 2) }}</td>
                    </tr>
                    <tr>
                        <td>Additional Charges</td>
                        <td class="text-right">₹{{ number_format($payable->additional_charges ?? 0, 2) }}</td>
                    </tr>
                    <tr>
                        <td>TDS</td>
                        <td class="text-right text-danger">-₹{{ number_format($payable->tds_amount ?? 0, 2) }}</td>
                    </tr>
                    <tr class="font-weight-bold" style="background-color: #f8f9fc;">
                        <td>Grand Total</td>
                        <td class="text-right">₹{{ number_format($payable->grand_total ?? 0, 2) }}</td>
                    </tr>
                    <tr class="text-success">
                        <td>Paid Amount</td>
                        <td class="text-right">₹{{ number_format($payable->paid_amount ?? 0, 2) }}</td>
                    </tr>
                    <tr class="font-weight-bold text-danger">
                        <td>Balance Due</td>
                        <td class="text-right">₹{{ number_format($payable->balance_amount ?? $payable->grand_total, 2) }}</td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
    
    <!-- Record Payment -->
    @if(($payable->payment_status ?? 'pending') !== 'paid')
    <div class="col-lg-6 mb-4">
        <div class="card shadow payment-card">
            <div class="card-header py-3" style="background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-money-bill-wave mr-2"></i> Record Payment
                </h6>
            </div>
            <div class="card-body">
                @if(session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                @endif
                @if(session('error'))
                    <div class="alert alert-danger">{{ session('error') }}</div>
                @endif
                
                <form method="POST" action="{{ route('superadmin.accounts.payable.payment', $payable->id) }}">
                    @csrf
                    <div class="form-group">
                        <label class="font-weight-bold">Payment Amount (₹) <span class="text-danger">*</span></label>
                        <input type="number" step="0.01" name="payment_amount" class="form-control" 
                               max="{{ $payable->balance_amount ?? $payable->grand_total }}"
                               placeholder="Enter amount" required>
                        <small class="text-muted">Max: ₹{{ number_format($payable->balance_amount ?? $payable->grand_total, 2) }}</small>
                    </div>
                    <div class="form-group">
                        <label class="font-weight-bold">Payment Date <span class="text-danger">*</span></label>
                        <input type="date" name="payment_date" class="form-control" 
                               value="{{ date('Y-m-d') }}" required>
                    </div>
                    <div class="form-group">
                        <label class="font-weight-bold">Payment Method</label>
                        <select name="payment_method" class="form-control">
                            <option value="">Select Method</option>
                            <option value="Cash">Cash</option>
                            <option value="Cheque">Cheque</option>
                            <option value="Bank Transfer">Bank Transfer</option>
                            <option value="UPI">UPI</option>
                            <option value="NEFT/RTGS">NEFT/RTGS</option>
                            <option value="Credit Card">Credit Card</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="font-weight-bold">Reference No</label>
                        <input type="text" name="reference_no" class="form-control" 
                               placeholder="Transaction/Cheque No">
                    </div>
                    <div class="form-group">
                        <label class="font-weight-bold">Notes</label>
                        <textarea name="notes" class="form-control" rows="2" 
                                  placeholder="Optional notes"></textarea>
                    </div>
                    <button type="submit" class="btn btn-success btn-block">
                        <i class="fas fa-check mr-2"></i> Record Payment
                    </button>
                </form>
            </div>
        </div>
    </div>
    @endif
</div>

<!-- Bill Items -->
@if($payable->items && $payable->items->count() > 0)
<div class="card shadow mb-4">
    <div class="card-header py-3" style="background: linear-gradient(135deg, #858796 0%, #5a5c69 100%);">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-list mr-2"></i> Bill Items
        </h6>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-sm">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        <th>Description</th>
                        <th>HSN/SAC</th>
                        <th class="text-right">Qty</th>
                        <th class="text-right">Rate</th>
                        <th class="text-right">Amount</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($payable->items as $index => $item)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>{{ $item->description ?? $item->item_name ?? 'N/A' }}</td>
                            <td>{{ $item->hsn_code ?? '-' }}</td>
                            <td class="text-right">{{ $item->quantity ?? 0 }}</td>
                            <td class="text-right">₹{{ number_format($item->rate ?? $item->unit_price ?? 0, 2) }}</td>
                            <td class="text-right">₹{{ number_format($item->amount ?? ($item->quantity * ($item->rate ?? $item->unit_price ?? 0)), 2) }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endif

@endsection
