
//Get today's date in YYYY-MM-DD format
const today = new Date().toISOString().split('T')[0];
// Set the default value of the date input to today's date
document.getElementById('ackDate').value = today;

document.getElementById('invoiceDate').value = today;

document.getElementById('referenceDate').value = today;



document.getElementById('Tax-Invoice-form').addEventListener('submit', function(event) {
    event.preventDefault();

    // Collect all form data
    const formData = {
        // irnNo: document.getElementById('irnNo').value,
        // ackNo: document.getElementById('ackNo').value,
        // ackDate: document.getElementById('ackDate').value,
        invoiceDate: document.getElementById('invoiceDate').value,
        deliveryNote: document.getElementById('deliveryNote').value,
        termsPayment: document.getElementById('termsPayment').value,
        referenceNo: document.getElementById('ReferenceNo').value,
        otherReference: document.getElementById('otherreference').value,
        companyName: document.getElementById('companyNameSelect').value,
        companyAddress: document.getElementById('cCompanyAddress').value,
        companyGst: document.getElementById('cCompanyGst').value,
        companyPhone: document.getElementById('cCompanyPhone').value,
        companyEmail: document.getElementById('cCompanyEmail').value,
        buyersOrderNo: document.getElementById('buyersOrderNo').value,
        referenceDate: document.getElementById('referenceDate').value,
        dispatchThrough: document.getElementById('dispatchthrough').value,
        destination: document.getElementById('destination').value,
        vehicleNo: document.getElementById('vehicleNo').value,
        termsDelivery: document.getElementById('termsDelivery').value,
        grandTotal: document.getElementById('grandTotal').value,
        amountInWords: document.getElementById('amountInWords').value,
        totalAmount: document.getElementById('totalAmount').value,
        sgst: document.getElementById('sgst').value,
        cgst: document.getElementById('cgst').value,
        igst: document.getElementById('igst').value,
        totalTax: document.getElementById('totalTax').value,
        pdfDataUrl: null, // Placeholder for PDF data
        items: []
    };

    // Collect item table data
    const rows = document.querySelectorAll('#invoiceTable tbody tr');
    rows.forEach(row => {
        const item = {
            description: row.querySelector('.description').value,
            hsn: row.querySelector('.hsn').value,
            quantity: row.querySelector('.quantity').value,
            rate: row.querySelector('.rate').value,
            per: row.querySelector('.per').value,
            sgst: row.querySelector('.sgst').value,
            cgst: row.querySelector('.cgst').value,
            igst: row.querySelector('.igst').value,
            amount: row.querySelector('.amount').value
        };
        formData.items.push(item);
    });

    
});


// Add a new row in the invoice table
function addRow() {
    const table = document.getElementById("invoiceTable").getElementsByTagName("tbody")[0];
    const rowCount = table.rows.length;
    const newRow = table.insertRow(rowCount);

    newRow.innerHTML = `
        <td>${rowCount + 1}</td>
        <td><textarea id="description" cols="30" rows="1" class="description" required></textarea></td>
        <td><input type="text" class="hsn" required></td>
        <td><input type="number" class="quantity" required min="0" oninput="calculateRow(this)"></td>
        <td><input type="number" class="rate" required min="0" oninput="calculateRow(this)"></td>
        <td><input type="text" class="per" required></td>
        <td><input type="number" class="sgst" min="0" max="100" oninput="calculateRow(this)"></td>
        <td><input type="number" class="cgst" min="0" max="100" oninput="calculateRow(this)"></td>
        <td><input type="number" class="igst" min="0" max="100" oninput="calculateRow(this)"></td>
        <td><input type="text" class="amount" readonly></td>
        <td><button class="btn btn-danger" type="button" onclick="deleteRow(this)"><i class="fa fa-trash"></i></button></td>
    `;
}

// Delete a row in the invoice table
function deleteRow(button) {
    const row = button.parentNode.parentNode;
    row.parentNode.removeChild(row);
    updateTotal();
}

// Calculate row-wise total and update total calculations
function calculateRow(element) {
    const row = element.closest("tr");
    const quantity = parseFloat(row.querySelector(".quantity").value) || 0;
    const rate = parseFloat(row.querySelector(".rate").value) || 0;
    const sgst = parseFloat(row.querySelector(".sgst").value) || 0;
    const cgst = parseFloat(row.querySelector(".cgst").value) || 0;
    const igst = parseFloat(row.querySelector(".igst").value) || 0;

    const baseAmount = quantity * rate;
    const totalTax = baseAmount * (sgst + cgst + igst) / 100;
    const amount = baseAmount + totalTax;
    row.querySelector(".amount").value = amount.toFixed(2);

    updateTotal();
}

// Update total calculation based on all rows
function updateTotal() {
    let taxableTotal = 0, totalAmount = 0, totalSgst = 0, totalCgst = 0, totalIgst = 0, totalTax = 0;

    document.querySelectorAll("#invoiceTable tbody tr").forEach(row => {
        const quantity = parseFloat(row.querySelector(".quantity").value) || 0;
        const rate = parseFloat(row.querySelector(".rate").value) || 0;
        const sgst = parseFloat(row.querySelector(".sgst").value) || 0;
        const cgst = parseFloat(row.querySelector(".cgst").value) || 0;
        const igst = parseFloat(row.querySelector(".igst").value) || 0;
        
        const baseAmount = quantity * rate;
        taxableTotal += baseAmount
        totalAmount += baseAmount + (baseAmount * (sgst + cgst + igst) / 100);
        totalSgst += baseAmount * (sgst / 100);
        totalCgst += baseAmount * (cgst / 100);
        totalIgst += baseAmount * (igst / 100);
        totalTax += (baseAmount * (sgst + cgst + igst) / 100);
    });

    document.getElementById("totalAmount").value = taxableTotal.toFixed(2);
    // document.getElementById("grandTotal").value = Math.round(totalAmount).toFixed(2);
    document.getElementById("sgst").value = totalSgst.toFixed(2);
    document.getElementById("cgst").value = totalCgst.toFixed(2);
    document.getElementById("igst").value = totalIgst.toFixed(2);
    document.getElementById("totalTax").value = totalTax.toFixed(2);
    const roundUpAmount = Math.ceil(totalAmount) - totalAmount; // Round to next whole number
    // Final grand total with round-up
    const grandTotal = totalAmount + roundUpAmount;
    document.getElementById('grandTotal').value = grandTotal.toFixed(2);
    updateGrandTotalInWords();

}

// Convert number to words (simplified version for demo)
function convertNumberToWords(num) {
    const ones = ["", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine"];
    const teens = ["", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eighteen", "Nineteen"];
    const tens = ["", "Ten", "Twenty", "Thirty", "Forty", "Fifty", "Sixty", "Seventy", "Eighty", "Ninety"];
    const higherUnits = ["", "Thousand", "Lakh", "Crore"];

    if (isNaN(num) || num === 0) return 'Zero';

    let word = '';

    function processHundred(number) {
        let result = '';
        if (number > 99) {
            result += ones[Math.floor(number / 100)] + ' Hundred ';
            number %= 100;
        }
        if (number > 10 && number < 20) {
            result += teens[number - 10] + ' ';
        } else {
            result += tens[Math.floor(number / 10)] + ' ';
            result += ones[number % 10] + ' ';
        }
        return result.trim();
    }

    // Process the number in pairs for Indian format (thousands, lakhs, crores)
    const crorePart = Math.floor(num / 10000000);
    const lakhPart = Math.floor((num % 10000000) / 100000);
    const thousandPart = Math.floor((num % 100000) / 1000);
    const hundredPart = num % 1000;

    if (crorePart > 0) {
        word += processHundred(crorePart) + ' Crore ';
    }
    if (lakhPart > 0) {
        word += processHundred(lakhPart) + ' Lakh ';
    }
    if (thousandPart > 0) {
        word += processHundred(thousandPart) + ' Thousand ';
    }
    if (hundredPart > 0) {
        word += processHundred(hundredPart) + ' Only';
    }

    return word.trim();
}

// Function to update the 'GT-in-letters' field
function updateGrandTotalInWords() {
  const grandTotal = parseFloat(document.getElementById('grandTotal').value) || 0;
  document.getElementById('amountInWords').value = convertNumberToWords(grandTotal);
}

// Save invoice as PDF
function saveInvoice() {
    const invoiceElement = document.getElementById("Tax-Invoice-form");
    html2canvas(invoiceElement).then(canvas => {
        const imgData = canvas.toDataURL("image/png");
        const pdf = new jsPDF();
        pdf.addImage(imgData, 'PNG', 0, 0);
        pdf.save("Tax_Invoice.pdf");
    });
}

// Populate unique company names
async function populateCompanyNames() {

    try {
        const response = await fetch('https://umbreyengineering.com/api/customer/');
        if (!response.ok) {
            throw new Error(`HTTP error! Status: ${response.status}`);
        }
        const companyData = await response.json();

        const companyNameSelect = document.getElementById("companyNameSelect");
        companyData.forEach(company => {
            const companyId1 = company.companyId1;
            if (companyId1 && (companyId1.startsWith('UEPL/CUS/') || companyId1.startsWith('UEPL/VEN/') || companyId1.startsWith('UEPL/CV/'))) {
                const option = document.createElement("option");
                option.value = company.companyName;
                option.textContent = company.companyName;
                companyNameSelect.appendChild(option);
            }
        });
    } catch (error) {
        console.error("Error fetching company data:", error);
    }
}

// Handle company selection and populate related fields
async function handleCompanySelection() {
    const selectedCompany = document.getElementById('companyNameSelect').value;
    
    try {
        const response = await fetch('https://umbreyengineering.com/api/customer/');
        if (!response.ok) {
            throw new Error(`HTTP error! Status: ${response.status}`);
        }
        const CustomerDataList = await response.json();

        const filteredData = CustomerDataList.filter(data => data.companyName === selectedCompany);

        if (filteredData.length > 0) {
            const {gstNo, companyContact, companyEmail, billingAddress, shippingAddress} = filteredData[0];
            document.getElementById('cCompanyAddress').value = billingAddress;
            document.getElementById('cCompanyGst').value = gstNo;
            document.getElementById('cCompanyPhone').value = companyContact;
            document.getElementById('cCompanyEmail').value = companyEmail;
            // document.getElementById('billAddress').value = billingAddress;
            // document.getElementById('shipAddress').value = shippingAddress;
        }else{
            document.getElementById('cCompanyAddress').value = '';
            document.getElementById('cCompanyGst').value = '';
            document.getElementById('cCompanyPhone').value = '';
            document.getElementById('cCompanyEmail').value = '';
        }
    } catch (error) {
        console.error("Error fetching company data:", error);
    }
}

function printInvoice() {
    const bodyElements = document.body.children;
    const InvContent = document.getElementById("Tax-Invoice-form");

    // Hide all elements except the quotation content
    for (let i = 0; i < bodyElements.length; i++) {
        if (bodyElements[i] !== InvContent) {
            bodyElements[i].style.visibility = "hidden";
        }
    }

    // Hide all buttons inside the quotation content
    const buttons = InvContent.getElementsByTagName("button");
    for (let i = 0; i < buttons.length; i++) {
        buttons[i].style.visibility = "hidden";
    }

    // Make quotation content and its children visible
    InvContent.style.visibility = "visible";
    for (let i = 0; i < InvContent.children.length; i++) {
        InvContent.children[i].style.visibility = "visible";
    }

    // Print the page with only the quotation content visible
    window.print();

    // Restore visibility of other elements after printing
    for (let i = 0; i < bodyElements.length; i++) {
        if (bodyElements[i] !== InvContent) {
            bodyElements[i].style.visibility = "";
        }
    }

    // Restore visibility of buttons in the quotation content
    for (let i = 0; i < buttons.length; i++) {
        buttons[i].style.visibility = "";
    }
}

function generateAndSaveTaxInvoicePDF() {
    return new Promise((resolve, reject) => {
        const bodyElements = document.body.children;
        const InvContent = document.getElementById("Tax-Invoice-form");  // Update content ID to poContent
        const originalDisplay = InvContent.style.display;

        let options = {
            margin: [0, 0, 0, 0],
            filename: 'Tax-Invoice.pdf',
            image: { type: 'jpeg', quality: 0.98 }, // Lower quality to reduce size
            html2canvas: { scale: 1.5 }, // Lower scale to reduce size
            jsPDF: { unit: 'in', format: 'a4', orientation: 'portrait' }
        };        

        // Hide all elements except the purchase order content
        for (let i = 0; i < bodyElements.length; i++) {
            if (bodyElements[i] !== InvContent) {
                bodyElements[i].style.visibility = "hidden";
            }
        }

        // Hide buttons within purchase order content to avoid including them in PDF
        const buttons = InvContent.getElementsByTagName("button");
        for (let i = 0; i < buttons.length; i++) {
            buttons[i].style.visibility = "hidden";
        }

        // Adjust scaling and add specific classes based on product type
        InvContent.style.width = "1920px";
        InvContent.style.height = "100%";
        
        // InvContent.style.transform = "scale(0.36)";
        InvContent.style.transform = "scale(0.36, 0.32)"; 
        InvContent.style.transformOrigin = "5% -8%";
        options.margin = [-10, 0, 0, -5];

        // Generate PDF and convert to base64
        html2pdf()
            .set(options)
            .from(InvContent)
            .output('blob')
            .then((pdfBlob) => {
                const reader = new FileReader();
                reader.readAsDataURL(pdfBlob);
                reader.onloadend = () => {
                    resolve(reader.result); // Resolve promise with base64 PDF data
                };
            })
            .catch(err => {
                reject(err); // Reject promise if there's an error
            })
            .finally(() => {
                // Restore visibility for all elements
                for (let i = 0; i < bodyElements.length; i++) {
                    if (bodyElements[i] !== InvContent) {
                        bodyElements[i].style.visibility = "";
                    }
                }

                for (let i = 0; i < buttons.length; i++) {
                    buttons[i].style.visibility = "";
                }

                // Reset scaling and styling adjustments
                InvContent.style.transform = "";
                InvContent.style.transformOrigin = "";
                InvContent.style.width = "";
                InvContent.style.height = "";
                InvContent.style.display = originalDisplay;
            });
    });
}

// Function to populate the item table with data
function populateInvoiceTable(tableId, items) {
    const tableBody = document.getElementById(tableId).querySelector('tbody');
    tableBody.innerHTML = ''; // Clear existing rows

    items.forEach((item, index) => {
        const row = document.createElement('tr');
        
        row.innerHTML = `
            <td>${index + 1}</td> <!-- Sl No. based on index -->
            <td><input type="text" class="description" value="${item.description || ''}"></td>
            <td><input type="text" class="hsn" value="${item.hsn || ''}"></td>
            <td><input type="number" class="quantity" value="${item.quantity || ''}" oninput="calculateRow(this)"></td>
            <td><input type="number" class="rate" value="${item.rate || ''}" oninput="calculateRow(this)"></td>
            <td><input type="text" class="per" value="${item.per || ''}"></td>
            <td><input type="number" class="sgst" value="${item.sgst || ''}" oninput="calculateRow(this)"></td>
            <td><input type="number" class="cgst" value="${item.cgst || ''}" oninput="calculateRow(this)"></td>
            <td><input type="number" class="igst" value="${item.igst || ''}" oninput="calculateRow(this)"></td>
            <td><input type="number" class="amount" value="${item.amount || ''}"></td>
        `;
        
        tableBody.appendChild(row);
    });
}