
/**
 * -----------------------------Start of the script for Purchase Order page-------------------------------------------------------------------
 */

window.addEventListener('load', () => {

    // localStorage.removeItem('SODataList');

    document.getElementById('sOrderNo').value = generateSOId();
    // document.getElementById('grnNo').value = generateGRNId();
    // Get today's date in YYYY-MM-DD format
    const today = new Date().toISOString().split('T')[0];
    // Set the default value of the date input to today's date
    document.getElementById('sOrderDate').value = today;

    populateCompanyNames();
    // populateQuotationNumbers();

    document.getElementById('companyNameSelect').addEventListener('change', handleCompanySelection);
    // document.getElementById('quotationNo').addEventListener('change', handleQuotationSelection);

    // Retrieve the QT data from session storage
    const currentQtoSId = sessionStorage.getItem('convertQtoSId');

    // Retrieve QT data from localStorage
    const qtDataList = JSON.parse(localStorage.getItem('quotationDataList')) || [];
    const currentQt = qtDataList.find(qt => qt.quotationNo1 === currentQtoSId);

    if (currentQt) {
        // Populate the form fields with the RFQ data
        document.getElementById('companyNameSelect').value = currentQt.companyName || '';
        document.getElementById('quotationNo').value = currentQt.quotationNo1 || '';
        document.getElementById('quotationDate').value = currentQt.quotationDate || '';
        document.getElementById('soCompanyEmail').value = currentQt.companyEmail || '';
        document.getElementById('soCompanyPhone').value = currentQt.companyPhone || '';
        document.getElementById('soCompanyGSTN').value = currentQt.gstNo || '';
        document.getElementById('soCompanyAddress').value = currentQt.address || '';
        document.getElementById('custRefNo').value = currentQt.custRefNo || '';
        document.getElementById('rfqNo').value = currentQt.rfqNo || '';
        document.getElementById('rfqDate').value = currentQt.rfqDate || '';
        document.getElementById('partNo').value = currentQt.partNo || '';
        document.getElementById('project-materialNo').value = currentQt.projectMaterialNo || '';
        document.getElementById('drawingNo').value = currentQt.drawingId || '';
        document.getElementById('drawingRev').value = currentQt.drawingRevision || '';
        document.getElementById('description').value = currentQt.projectDescription || '';
        // document.getElementById('billAddress').value = currentQt.billAddress || '';
        // document.getElementById('shipAddress').value = currentQt.shipAddress || '';
        document.getElementById('productType').value = currentQt.productType || '';

        // Populate the product table with the necessary data from currentQt
        const productTableBody = document.getElementById('productTable').querySelector("tbody");
        productTableBody.innerHTML = '';
        let index = productTableBody.rows.length;
        const row = document.createElement("tr");

        row.innerHTML = `
            <td>${index + 1}</td>
            <td><input type="text" class="material-code"></td>
            <td><input type="text" class="hsn-code"></td>
            <td><textarea class="description" rows="2">${currentQt.projectDescription || ''}</textarea></td>
            <td><textarea class="additional-details" rows="2"></textarea></td>
            <td><input type="date" class="req-by-date"></td>
            <td><input type="number" class="quantity" value="${currentQt.quantity || 0}" oninput="calculateRowValue(this)"></td>
            <td><input type="text" class="uom" value="${currentQt.quantityUOM || ''}"></td>
            <td><input type="number" class="rate" oninput="calculateRowValue(this)"></td>
            <td><input type="number" class="discount" oninput="calculateRowValue(this)"></td>
            <td><input type="number" class="value" readonly></td>
            <td><input type="number" class="sgst" oninput="calculateRowValue(this)"></td>
            <td><input type="number" class="cgst" oninput="calculateRowValue(this)"></td>
            <td><input type="number" class="igst" oninput="calculateRowValue(this)"></td>
            <td><input type="number" class="amount" readonly></td>
            <td><button class="btn btn-danger" type="button" onclick="deleteRow(this)"><i class="fa fa-trash"></i></button></td>
        `;

        productTableBody.appendChild(row);
        index++;
        handleBillShip(currentQt.companyName);
    }

    const soId = sessionStorage.getItem('currentSOId');

    if (soId) {
        // Retrieve the list from local storage
        const savedData = JSON.parse(localStorage.getItem('SODataList')) || [];
        const soData = savedData.find(item => item.soNo1 === soId); // Ensure you find the correct item

        if (soData) {
            // Populate the form fields
            document.getElementById('sOrderNo').value = soData.soNo1 || '';
            document.getElementById('sOrderDate').value = soData.soDate || '';
            document.getElementById('grnNo').value = soData.grnNo1 || '';
            document.getElementById('companyNameSelect').value = soData.companyName || '';
            document.getElementById('quotationNo').value = soData.quotationNo2 || '';
            document.getElementById('quotationDate').value = soData.quotationDate || '';
            document.getElementById('soCompanyEmail').value = soData.companyEmail || '';
            document.getElementById('soCompanyPhone').value = soData.companyPhone || '';
            document.getElementById('soCompanyGSTN').value = soData.gstNo || '';
            document.getElementById('soCompanyAddress').value = soData.address || '';
            document.getElementById('custRefNo').value = soData.custRefSoNo || '';
            document.getElementById('rfqNo').value = soData.rfqNo || '';
            document.getElementById('rfqDate').value = soData.rfqDate || '';
            document.getElementById('partNo').value = soData.partNo || '';
            document.getElementById('project-materialNo').value = soData.projectMaterialNo || '';
            document.getElementById('drawingNo').value = soData.drawingId || '';
            document.getElementById('drawingRev').value = soData.drawingRevision || '';
            document.getElementById('description').value = soData.projectDescription || '';
            document.getElementById('billAddress').value = soData.billAddress || '';
            document.getElementById('shipAddress').value = soData.shipAddress || '';
            document.getElementById('productType').value = soData.productType || '';
            document.getElementById('totalAmount').value = soData.totalAmount || '';
            document.getElementById('sgstA').value = soData.sgst || '';
            document.getElementById('cgstA').value = soData.cgst || '';
            document.getElementById('IgstA').value = soData.igst || '';
            document.getElementById('roundUp').value = soData.roundUp || '';
            document.getElementById('grandTotal').value = soData.grandTotal || '';

            console.log(soData.soNo1); // Debugging line to see stored data

            // Populate the product tables
            const productTableBody = document.getElementById('productTable').querySelector("tbody");
            productTableBody.innerHTML = ''; // Clear existing rows
            populateProductTable('productTable', soData.tableProducts || []);
        }
    }


    // Add event listeners to initial rows in #productTable
    document.querySelectorAll("#productTable tbody tr").forEach(row => {
        addRowEventListeners(row);
    });

    //   let quotationNo = 1;  // Starting ID number

    // Function to generate the SO ID
    function generateSOId() {
        const savedData = JSON.parse(localStorage.getItem('SODataList')) || [];
        const lastSO = savedData.length ? savedData[savedData.length - 1].soNo1 : "UEPL/SO/0000";
        const lastIdNumber = parseInt(lastSO.split('/').pop(), 10);
        const newIdNumber = (lastIdNumber + 1).toString().padStart(4, '0');
        return `UEPL/SO/${newIdNumber}`;
    }

    // Function to generate the GRN ID
    function generateGRNId() {
        const savedData = JSON.parse(localStorage.getItem('SODataList')) || [];
        const lastGRN = savedData.length ? savedData[savedData.length - 1].grnNo1 : "UEPL/GRN/0000";
        const lastIdNumber = parseInt(lastGRN.split('/').pop(), 10);
        const newIdNumber = (lastIdNumber + 1).toString().padStart(4, '0');
        return `UEPL/GRN/${newIdNumber}`;
    }

    // Set the quotationNo ID when the form loads
    //   document.getElementById('sOrderNo').value = generateSOId();

    updateGrandTotalInWords();
});

// Save form data to local storage on form submission
document.getElementById('soContent').addEventListener('submit', function(event) {
    event.preventDefault();
     
    // Gather form data
    const formData = {
        orderType : 'sales',
        soNo1: document.getElementById('sOrderNo').value,
        soDate: document.getElementById('sOrderDate').value,
        grnNo1: document.getElementById('grnNo').value,
        quotationNo2: document.getElementById('quotationNo').value,
        quotationDate: document.getElementById('quotationDate').value,
        companyName: document.getElementById('companyNameSelect').value,
        companyEmail: document.getElementById('soCompanyEmail').value,
        companyPhone: document.getElementById('soCompanyPhone').value,
        gstNo: document.getElementById('soCompanyGSTN').value,
        address: document.getElementById('soCompanyAddress').value,
        custRefSoNo: document.getElementById('custRefNo').value,
        rfqNo: document.getElementById('rfqNo').value,
        rfqDate: document.getElementById('rfqDate').value,
        partNo: document.getElementById('partNo').value,
        projectMaterialNo: document.getElementById('project-materialNo').value,
        drawingId: document.getElementById('drawingNo').value,
        drawingRevision: document.getElementById('drawingRev').value,
        projectDescription: document.getElementById('description').value,
        billAddress: document.getElementById('billAddress').value,
        shipAddress: document.getElementById('shipAddress').value,
        productType: document.getElementById('productType').value,
        tableProducts: getTableData('productTable'),
        totalAmount: document.getElementById('totalAmount').value,
        sgst: document.getElementById('sgstA').value,
        cgst: document.getElementById('cgstA').value,
        igst: document.getElementById('IgstA').value,
        roundUp: document.getElementById('roundUp').value,
        grandTotal: document.getElementById('grandTotal').value,
        pdfDataUrl: null,
        customerSO: null
        // pdfDataUrl: generateAndSavePDF()
    };
    // Get the vendor SO file input element
    const fileInput = document.getElementById('customerSO');

    // Call the fileToBase64 function to process the uploaded PDF
    fileToBase64(fileInput.files[0]).then((base64PDF) => {
        formData.customerSO = base64PDF; // Save the base64 PDF to formData
    })
    // Generate the PDF and add it to formData
    generateAndSavePurchaseOrderPDF().then((pdfDataUrl) => {
        formData.pdfDataUrl = pdfDataUrl; // Add the generated PDF data to formData

        // Retrieve existing quotations from local storage
        let savedData = JSON.parse(localStorage.getItem('SODataList')) || [];

        // Check if a quotation with the same number already exists
        const existingIndex = savedData.findIndex(item => item.soNo1 === formData.soNo1);

        if (existingIndex !== -1) {
            // Quotation with the same number exists
            const userConfirmation = confirm(`A data with same SO number already exists. Press 'OK' to override it?`);

            if (userConfirmation) {
                // User confirmed to override, so replace the old data at the found index
                savedData[existingIndex] = formData;
                alert(`SO data has been updated successfully.`);
            } else {
                // User canceled, so don't save
                alert("The data was not saved.");
                return;
            }
        } else {
        // No existing data with the same quotation number, so add as new
        savedData.push(formData);
        }

        // Save the updated data list back to local storage
        localStorage.setItem('SODataList', JSON.stringify(savedData));
        console.log(`SO data saved successfully.`);



        // Increment quotation number for the next form
        // document.getElementById('pOrderNo').value = generateSOId();

        // Reset the form
        document.getElementById('soForm').reset();

        sessionStorage.removeItem('currentSOId');
        sessionStorage.removeItem('convertQtoSId');

        // Redirect to the data table page
        window.location.href = "sales-order-datatable.html";

    }).catch((error) => {
    console.error("PDF generation failed:", error);
    alert("Error generating PDF. Please try again.");
    })
    // location.reload();

});

// PO Functions

function generateAndSavePurchaseOrderPDF() {
    return new Promise((resolve, reject) => {
        const bodyElements = document.body.children;
        const poContent = document.getElementById("soContent");  // Update content ID to poContent
        const originalDisplay = poContent.style.display;

        let options = {
            margin: [0, 0, 0, 0],
            filename: 'sales_order.pdf',
            image: { type: 'jpeg', quality: 0.98 }, // Lower quality to reduce size
            html2canvas: { scale: 1.5 }, // Lower scale to reduce size
            jsPDF: { unit: 'in', format: 'a4', orientation: 'portrait' }
        };        

        // Hide all elements except the purchase order content
        for (let i = 0; i < bodyElements.length; i++) {
            if (bodyElements[i] !== poContent) {
                bodyElements[i].style.visibility = "hidden";
            }
        }

        // Hide buttons within purchase order content to avoid including them in PDF
        const buttons = poContent.getElementsByTagName("button");
        for (let i = 0; i < buttons.length; i++) {
            buttons[i].style.visibility = "hidden";
        }

        // Adjust scaling and add specific classes based on product type
        poContent.style.width = "1920px";
        poContent.style.height = "100%";
        
        
        poContent.style.transform = "scale(0.36)";
        poContent.style.transformOrigin = "-15% -5%";
        options.margin = [-14, 1, 0, 0];
        // opt.html2canvas.scale = 2;

        // Generate PDF and convert to base64
        html2pdf()
            .set(options)
            .from(poContent)
            .output('blob')
            .then((pdfBlob) => {
                const reader = new FileReader();
                reader.readAsDataURL(pdfBlob);
                reader.onloadend = () => {
                    resolve(reader.result); // Resolve promise with base64 PDF data
                };
            })
            .catch(err => {
                reject(err); // Reject promise if there's an error
            })
            .finally(() => {
                // Restore visibility for all elements
                for (let i = 0; i < bodyElements.length; i++) {
                    if (bodyElements[i] !== poContent) {
                        bodyElements[i].style.visibility = "";
                    }
                }

                for (let i = 0; i < buttons.length; i++) {
                    buttons[i].style.visibility = "";
                }

                // Reset scaling and styling adjustments
                poContent.classList.remove("scale-round", "scale-rib", "scale-manual");
                poContent.style.transform = "";
                poContent.style.transformOrigin = "";
                poContent.style.width = "";
                poContent.style.height = "";
                poContent.style.display = originalDisplay;
            });
    });
}

function getTableData(tableId) {
    const table = document.getElementById(tableId);
    const rows = table.getElementsByTagName("tbody")[0].getElementsByTagName("tr");
    let slNo = 1;
    const data = [];
  
    for (let row of rows) {
        const rowData = {
            slNo: slNo,
            materialCode: row.cells[1].getElementsByTagName("input")[0].value,
            hsnCode: row.cells[2].getElementsByTagName("input")[0].value,
            description: row.cells[3].getElementsByTagName("textarea")[0].value,
            additionalDetails: row.cells[4].getElementsByTagName("textarea")[0].value,
            reqByDate: row.cells[5].getElementsByTagName("input")[0].value,
            quantity: row.cells[6].getElementsByTagName("input")[0].value,
            uom: row.cells[7].getElementsByTagName("input")[0].value,
            unitRate: row.cells[8].getElementsByTagName("input")[0].value,
            discount: row.cells[9].getElementsByTagName("input")[0].value,
            value: row.cells[10].getElementsByTagName("input")[0].value,
            sgst: row.cells[11].getElementsByTagName("input")[0].value,
            cgst: row.cells[12].getElementsByTagName("input")[0].value,
            igst: row.cells[13].getElementsByTagName("input")[0].value,
            amount: row.cells[14].getElementsByTagName("input")[0].value,
        };
        data.push(rowData);
        slNo++;
    }
  
    return data;
}

// Show the appropriate product table based on selection
function showProductTable() {
    const productType = document.getElementById('productType').value;
    document.getElementById('roundTable').style.display = 'none';
    document.getElementById('ribTable').style.display = 'none';
    document.getElementById('manualTable').style.display = 'none';

    if (productType === 'round') {
        document.getElementById('roundTable').style.display = 'block';
    } else if (productType === 'rib') {
        document.getElementById('ribTable').style.display = 'block';
    } else if (productType === 'manual') {
        document.getElementById('manualTable').style.display = 'block';
    }
    // Hide all tables
    document.querySelectorAll('.product-table').forEach(table => {
    table.style.display = 'none';
    });

    // Reset summary fields
    document.getElementById('totalAmount').value = '';
    document.getElementById('sgstA').value = '';
    document.getElementById('cgstA').value = '';
    document.getElementById('IgstA').value = '';
    document.getElementById('grandTotal').value = '';
    document.getElementById('roundUp').value = '';
    document.getElementById('GT-in-letters').value = '';

    // Show the selected table based on the product type
    const selectedType = document.getElementById('productType').value;
    if (selectedType) {
        document.getElementById(selectedType + 'Table').style.display = 'block';
    }
}
// Function to add event listeners to a row in the product table
function addRowEventListeners(row) {
    row.querySelector(".quantity").addEventListener("input", function() {
        calculateRowValue(this);
    });
    row.querySelector(".rate").addEventListener("input", function() {
        calculateRowValue(this);
    });
    row.querySelector(".discount").addEventListener("input", function() {
        calculateRowValue(this);
    });
}
// Function to add a new row with event listeners
function addRow() {
    const productTableBody = document.querySelector("#productTable tbody");
    const newRow = document.createElement("tr");

    newRow.innerHTML = `
        <td>${productTableBody.rows.length + 1}</td>
        <td><input type="text" class="material-code"></td>
        <td><input type="text" class="hsn-code"></td>
        <td><textarea class="description" rows="1"></textarea></td>
        <td><textarea class="additional-details" rows="1"></textarea></td>
        <td><input type="date" class="req-by-date"></td>
        <td><input type="number" class="quantity" oninput="calculateRowValue(this)"></td>
        <td><input type="text" class="uom"></td>
        <td><input type="number" class="rate" oninput="calculateRowValue(this)"></td>
        <td><input type="number" class="discount" oninput="calculateRowValue(this)"></td>
        <td><input type="number" class="value" readonly></td>
        <td><input type="number" class="sgst" oninput="calculateRowValue(this)"></td>
        <td><input type="number" class="cgst" oninput="calculateRowValue(this)"></td>
        <td><input type="number" class="igst" oninput="calculateRowValue(this)"></td>
        <td><input type="number" class="amount" readonly></td>
        <td><button class="btn btn-danger" type="button" onclick="deleteRow(this)"><i class="fa fa-trash"></i></button></td>
    `;

    productTableBody.appendChild(newRow);
    addRowEventListeners(newRow); // Add event listeners to the new row
}
// Delete a row from the product table
function deleteRow(button) {
const row = button.parentNode.parentNode;
row.parentNode.removeChild(row);
calculateTotal();
}
function calculateRowValue(input) {
    const row = input.closest("tr");
    
    // Correct indexing based on your table structure
    const quantity = parseFloat(row.cells[6].querySelector('input').value) || 0; // column 6 for Quantity
    const rate = parseFloat(row.cells[8].querySelector('input').value) || 0; // column 8 for Unit Rate
    const discount = parseFloat(row.cells[9].querySelector('input').value) || 0; // column 9 for Discount
    const sgst = parseFloat(row.cells[11].querySelector('input').value) || 0; // column 11 for SGST
    const cgst = parseFloat(row.cells[12].querySelector('input').value) || 0; // column 12 for CGST
    const igst = parseFloat(row.cells[13].querySelector('input').value) || 0; // column 13 for IGST

    // Calculate the base value for the row (quantity * rate - discount)
    const baseValue = (quantity * rate) - discount;
    row.cells[10].querySelector('input').value = baseValue.toFixed(2); // column 10 for Value

    // Calculate the total amount for the row, including GST
    const amount = baseValue * (1 + (sgst + cgst + igst) / 100);
    row.cells[14].querySelector('input').value = amount.toFixed(2); // column 14 for Amount

    // Update the totals after calculating the row value
    calculateTotal();
}
function calculateTotal() {
    let total = 0;

    // Sum up all the 'value' fields in the table
    document.querySelectorAll('#productTable tbody input[placeholder="Value"]').forEach(input => {
        total += parseFloat(input.value) || 0;
    });

    // Update subtotal field
    document.getElementById('totalAmount').value = total.toFixed(2);

    // Update GST and grand total
    calculateAllTotals();
}
// Print the quotation
function printSO() {
    const bodyElements = document.body.children;
    const poContent = document.getElementById("soContent");

    // Hide all elements except the quotation content
    for (let i = 0; i < bodyElements.length; i++) {
        if (bodyElements[i] !== poContent) {
            bodyElements[i].style.visibility = "hidden";
        }
    }

    // Hide all buttons inside the quotation content
    const buttons = poContent.getElementsByTagName("button");
    for (let i = 0; i < buttons.length; i++) {
        buttons[i].style.visibility = "hidden";
    }

    // Make quotation content and its children visible
    poContent.style.visibility = "visible";
    for (let i = 0; i < poContent.children.length; i++) {
        poContent.children[i].style.visibility = "visible";
    }

    // Print the page with only the quotation content visible
    window.print();

    // Restore visibility of other elements after printing
    for (let i = 0; i < bodyElements.length; i++) {
        if (bodyElements[i] !== poContent) {
            bodyElements[i].style.visibility = "";
        }
}

// Restore visibility of buttons in the quotation content
for (let i = 0; i < buttons.length; i++) {
    buttons[i].style.visibility = "";
}
}
// Save the quotation (basic simulation)
function saveSO() {
//   alert('Quotation saved successfully!');
  // generatePDF();
}
function fileToBase64(file) {
    return new Promise((resolve, reject) => {
        const reader = new FileReader();
        reader.onload = function (event) {
            resolve(event.target.result); // Base64 encoded string
        };
        reader.onerror = function (error) {
            reject(error);
        };
        reader.readAsDataURL(file);
    });
}

// Quotation auto-generate

// Function to format the current date as dd-mm-yyyy
function formatDate(date) {
const day = String(date.getDate()).padStart(2, '0');
const month = String(date.getMonth() + 1).padStart(2, '0'); // Months are zero-based
const year = date.getFullYear();
return `${day}-${month}-${year}`;
}


// Function to calculate all totals and update fields
function calculateAllTotals() {
  let subTotal = 0.00, sgstTotal = 0.00, cgstTotal = 0.00, igstTotal = 0.00;
  const productTableBody = document.getElementById("productTable").querySelector("tbody");

  // Calculate totals for each row in the product table
  productTableBody.querySelectorAll("tr").forEach(row => {
    // Get input values from each column
    const quantity = parseFloat(row.cells[6].querySelector('input').value) || 0;
    const rate = parseFloat(row.cells[8].querySelector('input').value) || 0;
    const discount = parseFloat(row.cells[9].querySelector('input').value) || 0;
    const sgst = parseFloat(row.cells[11].querySelector('input').value) || 0;
    const cgst = parseFloat(row.cells[12].querySelector('input').value) || 0;
    const igst = parseFloat(row.cells[13].querySelector('input').value) || 0;

    // Calculate value after discount
    const baseValue = quantity * rate * (1 - discount / 100);
    row.cells[10].querySelector('input').value = baseValue.toFixed(2);

    // Calculate total amount with GST
    const amount = baseValue * (1 + (sgst + cgst + igst) / 100);
    row.cells[14].querySelector('input').value = amount.toFixed(2);

    // Accumulate totals
    subTotal += baseValue;
    sgstTotal += (baseValue * sgst) / 100;
    cgstTotal += (baseValue * cgst) / 100;
    igstTotal += (baseValue * igst) / 100;
  });

  // Update summary fields
  document.getElementById('totalAmount').value = subTotal.toFixed(2);
  document.getElementById('sgstA').value = sgstTotal.toFixed(2);
  document.getElementById('cgstA').value = cgstTotal.toFixed(2);
  document.getElementById('IgstA').value = igstTotal.toFixed(2);

  // Calculate grand total and round-up amount
  const grandTotalRaw = subTotal + sgstTotal + cgstTotal + igstTotal;
  const roundUpAmount = Math.ceil(grandTotalRaw) - grandTotalRaw; // Round to next whole number
  document.getElementById('roundUp').value = roundUpAmount.toFixed(2);

  // Final grand total with round-up
  const grandTotal = grandTotalRaw + roundUpAmount;
  document.getElementById('grandTotal').value = grandTotal.toFixed(2);

  // Update 'GT-in-letters' field
  updateGrandTotalInWords();
}

// Helper function to convert numbers to words (Indian numbering format)
function convertNumberToWords(num) {
    const ones = ["", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine"];
    const teens = ["", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eighteen", "Nineteen"];
    const tens = ["", "Ten", "Twenty", "Thirty", "Forty", "Fifty", "Sixty", "Seventy", "Eighty", "Ninety"];
    const higherUnits = ["", "Thousand", "Lakh", "Crore"];

    if (isNaN(num) || num === 0) return 'Zero';

    let word = '';

    function processHundred(number) {
        let result = '';
        if (number > 99) {
            result += ones[Math.floor(number / 100)] + ' Hundred ';
            number %= 100;
        }
        if (number > 10 && number < 20) {
            result += teens[number - 10] + ' ';
        } else {
            result += tens[Math.floor(number / 10)] + ' ';
            result += ones[number % 10] + ' ';
        }
        return result.trim();
    }

    // Process the number in pairs for Indian format (thousands, lakhs, crores)
    const crorePart = Math.floor(num / 10000000);
    const lakhPart = Math.floor((num % 10000000) / 100000);
    const thousandPart = Math.floor((num % 100000) / 1000);
    const hundredPart = num % 1000;

    if (crorePart > 0) {
        word += processHundred(crorePart) + ' Crore ';
    }
    if (lakhPart > 0) {
        word += processHundred(lakhPart) + ' Lakh ';
    }
    if (thousandPart > 0) {
        word += processHundred(thousandPart) + ' Thousand ';
    }
    if (hundredPart > 0) {
        word += processHundred(hundredPart) + ' Only';
    }

    return word.trim();
}

// Function to update the 'GT-in-letters' field
function updateGrandTotalInWords() {
  const grandTotal = parseFloat(document.getElementById('grandTotal').value) || 0;
  document.getElementById('GT-in-letters').value = convertNumberToWords(grandTotal);
}

// Populate unique company names
async function populateCompanyNames() {

    try {
        const response = await fetch('https://umbreyengineering.com/api/customer/');
        if (!response.ok) {
            throw new Error(`HTTP error! Status: ${response.status}`);
        }
        const companyData = await response.json();

        const companyNameSelect = document.getElementById("companyNameSelect");
        companyData.forEach(company => {
            const companyId1 = company.companyId1;
            if (companyId1 && (companyId1.startsWith('UEPL/CUS/') || companyId1.startsWith('UEPL/CV/'))) {
                const option = document.createElement("option");
                option.value = company.companyName;
                option.textContent = company.companyName;
                companyNameSelect.appendChild(option);
            }
        });
    } catch (error) {
        console.error("Error fetching company data:", error);
    }
}

// Handle company selection and populate related fields
async function handleCompanySelection() {
    const selectedCompany = document.getElementById('companyNameSelect').value;
    const quotationDataList = JSON.parse(localStorage.getItem('quotationDataList')) || [];
    const filteredQuatData = quotationDataList.filter(data => data.companyName === selectedCompany);    

    try {
        const response = await fetch('https://umbreyengineering.com/api/customer/');
        if (!response.ok) {
            throw new Error(`HTTP error! Status: ${response.status}`);
        }
        const CustomerDataList = await response.json();

        const filteredData = CustomerDataList.filter(data => data.companyName === selectedCompany);

        if (filteredData.length > 0) {
            const {gstNo, companyContact, companyEmail, billingAddress, shippingAddress} = filteredData[0];
            document.getElementById('soCompanyAddress').value = billingAddress;
            document.getElementById('soCompanyGSTN').value = gstNo;
            document.getElementById('soCompanyPhone').value = companyContact;
            document.getElementById('soCompanyEmail').value = companyEmail;
            document.getElementById('billAddress').value = billingAddress;
            document.getElementById('shipAddress').value = shippingAddress;
        }
    } catch (error) {
        console.error("Error fetching company data:", error);
    }
}

function handleBillShip(selectedCompany) {
    const CustomerDataList = JSON.parse(localStorage.getItem('CustomerDataList')) || [];
    const filteredData = CustomerDataList.filter(data => data.companyName === selectedCompany);
    if (filteredData.length > 0) {
        const { billingAddress, shippingAddress} = filteredData[0];
        document.getElementById('billAddress').value = billingAddress;
        document.getElementById('shipAddress').value = shippingAddress;
    }
}

// Handle quotation selection and populate product table and total fields
function handleQuotationSelection() {
    const selectedQuotationNo = document.getElementById('quotationNo').value;
    const quotationDataList = JSON.parse(localStorage.getItem('quotationDataList')) || [];
    const quotationData = quotationDataList.find(data => data.quotationNo1 === selectedQuotationNo);

    if (quotationData) {
        // Set product type and display relevant table
        document.getElementById('quotationDate').value = quotationData.quotationDate || '';
        document.getElementById('companyNameSelect').value = quotationData.companyName || '';
        document.getElementById('soCompanyAddress').value = quotationData.address || '';
        document.getElementById('soCompanyGSTN').value = quotationData.gstNo || '';
        document.getElementById('soCompanyPhone').value = quotationData.companyPhone || '';
        document.getElementById('soCompanyEmail').value = quotationData.companyEmail || '';
        document.getElementById('productType').value = quotationData.productType || '';
        document.getElementById('custRefNo').value = quotationData.custRefNo || '';
        // Populate the form fields with the RFQ data
        document.getElementById("rfqNo").value = quotationData.rfqNo || '';
        document.getElementById("rfqDate").value = quotationData.rfqDate || '';
        document.getElementById("partNo").value = quotationData.partNo || '';
        document.getElementById("project-materialNo").value = quotationData.projectMaterialNo || '';
        document.getElementById("drawingNo").value = quotationData.drawingId || '';
        document.getElementById("drawingRev").value = quotationData.drawingRevision || '';
        document.getElementById("description").value = quotationData.projectDescription || '';
        
        // showProductTable(quotationData.productType);
        document.getElementById('productTable').querySelector("tbody").innerHTML = '';
        // Populate product table
        if (quotationData.rawMaterialCharges && quotationData.rawMaterialCharges.length > 0) {
            populateProductTable1('productTable', quotationData.rawMaterialCharges);
        }
        if (quotationData.conversionCosts && quotationData.conversionCosts.length > 0) {
            populateProductTable('productTable', quotationData.conversionCosts);
        }
        if (quotationData.packingCharges && quotationData.packingCharges.length > 0) {
            populateProductTable('productTable', quotationData.packingCharges);
        }else {
            console.log('No products to display.');
        }
        calculateAllTotals();

        // // Populate totals
        // document.getElementById('totalAmount').value = quotationData.totalAmount;
        // document.getElementById('sgstA').value = quotationData.sgst;
        // document.getElementById('cgstA').value = quotationData.cgst;
        // document.getElementById('IgstA').value = quotationData.igst;
        // document.getElementById('roundUp').value = quotationData.roundUp;
        // document.getElementById('grandTotal').value = quotationData.grandTotal;
    }
    
    updateGrandTotalInWords();
}

// Function to populate the product table based on selected quotation data
function populateProductTable(tableId, products) {
    const productTableBody = document.getElementById(tableId).querySelector("tbody");
    let index = productTableBody.rows.length;

    products.forEach((product) => {
        const row = document.createElement("tr");

        row.innerHTML = `
            <td>${index + 1}</td>
            <td><input type="text" class="material-code" value="${product.materialCode || ''}"></td>
            <td><input type="text" class="hsn-code" value="${product.hsnCode || ''}"></td>
            <td><textarea class="description" rows="1">${product.description || ''}</textarea></td>
            <td><textarea class="additional-details" rows="1">${product.additionalDetails || ''}</textarea></td>
            <td><input type="date" class="req-by-date" value="${product.reqByDate || ''}"></td>
            <td><input type="number" class="quantity" value="${product.quantity || 0}" oninput="calculateRowValue(this)"></td>
            <td><input type="text" class="uom" value="${product.uom || ''}"></td>
            <td><input type="number" class="rate" value="${product.unitRate || 0}" oninput="calculateRowValue(this)"></td>
            <td><input type="number" class="discount" value="${product.discount || 0}" oninput="calculateRowValue(this)"></td>
            <td><input type="number" class="value" value="${product.value || 0}" readonly></td>
            <td><input type="number" class="sgst" value="${product.sgst || 0}" oninput="calculateRowValue(this)"></td>
            <td><input type="number" class="cgst" value="${product.cgst || 0}" oninput="calculateRowValue(this)"></td>
            <td><input type="number" class="igst" value="${product.igst || 0}" oninput="calculateRowValue(this)"></td>
            <td><input type="number" class="amount" value="${product.amount || 0}" readonly></td>
            <td><button class="btn btn-danger" type="button" onclick="deleteRow(this)"><i class="fa fa-trash"></i></button></td>
        `;

        productTableBody.appendChild(row);
        index++;
        calculateRowValue(row);  // Update row value calculations after populating
    });
}


// Add event listeners to relevant input fields in productTable for real-time calculations
function setupEventListeners() {
    const productTable = document.getElementById("productTable");

    // Add listener to all input fields in the table's rows that affect totals
    productTable.querySelectorAll("tbody input").forEach(input => {
        input.addEventListener("input", () => calculateAllTotals());
    });
}

// Initialize event listeners when the document is loaded
document.addEventListener("DOMContentLoaded", () => {
    setupEventListeners();
});
