RCid = sessionStorage.getItem("newPlanRCid");
if(RCid){
    $("#delete-plan").removeClass("hidden");
}
editId = sessionStorage.getItem("editPlanId");
viewId = sessionStorage.getItem("viewPlanId");
console.log(RCid, editId, viewId);

let countTask = 0, taskItem = 0;
let draggedBoardId = null; // Track dragged board's ID
let taskList = localStorage.getItem("PlannedProjectsData") ? JSON.parse(localStorage.getItem("PlannedProjectsData")) : {};
let subTaskList = localStorage.getItem("TaskData") ? JSON.parse(localStorage.getItem("TaskData")) : {};
countTask = Object.keys(taskList).length;

// Save taskList to localStorage
// function setTask(value) {
//     localStorage.setItem("task_board", JSON.stringify(value));
// }

// Function to create a new task board element
function createTaskboard(title, id) {
    let taskBoard = document.createElement("div");
    taskBoard.className = "mp-task-list";
    taskBoard.draggable = false;
    taskBoard.setAttribute("data-board-id", id);

    taskBoard.innerHTML = `
        <div class="header">
            <h4 title="Project Name">${title}</h4>
            <div class="mp-d-flex">
                <button id="${id}" class="add-task-btn add-task" alt="Add Task" title="Add Process">+</button>
                <button class="close-task-board-btn task-close" title="Remove Project">✖</button>
            </div>
        </div>
        <ul task-board="${id}" class="mp-list" ondrop="drop(event)" ondragover="allowDrop(event)"></ul>
    `;
    countTask++;
    return taskBoard;
}
// Constants for status and their corresponding colors
const statusColors = {
    "Assigned": "#4287f5",
    "Inprogress": "#fa6b05",
    "Work Done": "#faee05",
    "Approved": "#0a6905",
    "Cancelled": "#ff0000",
    "Hold": "#A020F0"
};
// Updated createTask function to select color based on task status
function createTask({ process, desc, machine, operator,ctHours,ctMinutes, startDate, endDate, source, previousProcess}, id) {
    let li = document.createElement("li");
    li.id = id;
    li.className = "mp-task-item";
    li.draggable = false;
    li.innerHTML = `
    ${process ? `<h4 title="Process Name"><strong>Process : </strong> ${process}</h4>` : ''}
    <span class="task-item-close" title="Remove Process">✖</span>
    ${machine ? `<p><strong>Machine : </strong> ${machine}</p>` : ''}
    ${source ? `<p class="source"><strong>Source : </strong> ${source}</p>` : ''}
    ${operator ? `<p><strong>Operator : </strong> ${operator}</p>` : ''}
    ${previousProcess ? `<p class="previous"><strong>Previous Process : </strong> ${previousProcess}</p>` : ''}
    ${ctHours && ctMinutes ? `<p><strong>Cycle Time :</strong> ${ctHours} Hrs   ${ctMinutes} Mins</p>` : ''}
    ${startDate ? `<p><strong>Start Date : </strong> ${formatDateWithCustomLocale(startDate)}</p>` : ''}
    ${endDate ? `<p><strong>End Date : </strong> ${formatDateWithCustomLocale(endDate)}</p>` : ''}
    ${desc ? `<p><strong>Description : </strong>${desc}</p>` : ''}
    `;
    taskItem++;
    return li;
}
// Initialize task boards and tasks from taskList
function Init(taskList) {
    if (RCid) {
        const boardData = taskList[RCid];
        console.log("boardData", boardData);
        const title = (editId || viewId) 
        ? (boardData.projectName || boardData.rcId)
        : boardData.rcId;
        const taskBoard = createTaskboard(title, RCid);
        $(".board").append(taskBoard);

        for (let taskId in boardData.productProcesses) {
            const taskData = boardData.productProcesses[taskId];
            const transformedTaskData = {
                process: taskData.process,
                desc: taskData.desc,
                machine: taskData.occupancy.machine,
                operator: taskData.occupancy.operator,
                ctHours: taskData.ctHours,
                ctMinutes: taskData.ctMinutes,
                startDate: taskData.occupancy.startDate,
                endDate: taskData.occupancy.endDate,
                source: taskData.source,
                previousProcess: taskData.previousProcess
            };
            const taskElement = createTask(transformedTaskData, taskId);
            $(`[task-board="${RCid}"]`).append(taskElement);
        }        
    }

    const processSelect = document.getElementById("processSelect");
    // Get the processes for the selected RCid
    const processes = taskList[RCid].productProcesses;

    // Loop through the processes and create option elements
    for (let key in processes) {
        const processName = processes[key].process;
        const option = document.createElement("option");
        option.value = processName;
        option.textContent = processName;

        // Append the option to the select field
        processSelect.appendChild(option);
    }
}
$(document).ready(() => {
    console.log("RCid1", RCid);
    if (RCid){
        for(let i in taskList){
            if(taskList[i].rcId == RCid){
                RCid = i;
                break;
            }
        }
    }
    console.log("RCid2", RCid);
    if (!RCid) {
        if(!editId){
            if(!viewId){
                window.location.href = "manufacturing-planning.html";
            }else{
                RCid = viewId;
            }
        }else{
            RCid = editId;
        }
    }
    console.log("RCid3", RCid);
    // Initial loading of saved tasks and boards
    Init(taskList);
    if(viewId){
        $('.mp-task-item').css('cursor', 'not-allowed');
    }

    // Open New Task Board popup
    $(".mp-add-task-board").click(() => $("#new-task-board").show());

    // Close popup when clicking on close icon
    $(".mp-popup .mp-close").click(() => $(".mp-popup").hide());

    // Add new task board
    $("#mp-add-task-board").on("submit", (event) => {
        event.preventDefault(); // Prevent form from submitting and reloading the page

        const title = $("#task-board-title").val();
        const id = "task_board-" + countTask;
        $(".board").append(createTaskboard(title, id));
        taskList[id] = { name: title, task_items: {} };
        setTask(taskList);

        // Reset the form and hide the popup
        $("#task-board-title").val("");
        $("#new-task-board").hide();
    });

    // Update the task board title
    $("#mp-editfrm-task-board").on("submit", (event) => {
        event.preventDefault(); // Prevent form from submitting and reloading the page

        const boardId = $("#edit-task-board").data("board-id");
        const newTitle = $("#edit-task-board-title").val().trim();

        if (newTitle) {
            $(`[data-board-id="${boardId}"]`).find(".header h4").text(newTitle);
            taskList[boardId].name = newTitle;
            setTask(taskList);

            // Hide the edit popup
            $("#edit-task-board").hide();
        }
    });

    // Add new task
    $("#bt-task").click(() => {
        const form = $("#add-task")[0];
        if (form.checkValidity()) {
            const target = $("#new-task").data("target");
    
            const values = {
                process: $("#processSelect").val(),
                desc: $("#task-desc").val(),
                priority: $("#task-priority").val(),
                machine: $("#machineNameSelect").val(),
                operator: $("#operatorSelect").val(),
                ctHours: $("#ctHours").val(),
                ctMinutes: $("#ctMinutes").val(),
                startDate: $("#startTime").val(),
                endDate: $("#endTime").val(),
                progressPercentage: 0, // Example default value
                progressColor: "grey"  // Example default color
            };
    
            const taskId = "task-" + Date.now();
    
            $(`[task-board="${target}"]`).append(createTask(values, taskId));
    
            if (!taskList[target].task_items) {
                taskList[target].task_items = {};
            }
            taskList[target].task_items[taskId] = values;
            setTask(taskList);
            // Recalculate the stage progress bar
            $("#add-task").trigger("reset");
            $("#new-task").hide();
        } else {
            form.reportValidity();
        }
        
    });

    // Update an existing task
    $("#update-task").click(() => {
        const form = $("#editfrm-task")[0];
        if (!form.checkValidity()) {
            form.reportValidity();
            return;
        }

        const RCid = sessionStorage.getItem("newPlanRCid");
        const taskList = JSON.parse(localStorage.getItem("PlannedProjectsData"));
        const taskId = $("#update-task").data("editIndex");
        console.log(taskId);
        const oldTask = taskList[RCid].productProcesses[taskId];

        const newStartDateIST = $("#edit-start-time").val();
        const newStartDate = new Date(convertIstToUtc(newStartDateIST));

        // Shift timings (09:30 AM to 06:30 PM)
        const shiftStartTime = new Date();
        shiftStartTime.setHours(9, 30, 0, 0); // 09:30 AM

        const shiftEndTime = new Date();
        shiftEndTime.setHours(18, 30, 0, 0); // 06:30 PM

        // Check if newStartDate is within the shift timings
        if ($("#edit-start-time").val() < shiftStartTime || $("#edit-start-time").val() > shiftEndTime) {
            alert("Start date must be between 09:30 AM and 06:30 PM.");
            return;
        }
        if(taskId == 0){
            let previousEndDate = new Date (taskList[RCid].productProcesses[taskId].startDate);
            if(newStartDate.getTime() < previousEndDate.getTime()){
                alert(`Start date cannot be earlier than ${previousEndDate}.`);
                return;
            }
        }else{
            let previousEndDate = new Date (taskList[RCid].productProcesses[taskId-1].endDate);
            if(newStartDate.getTime() < previousEndDate.getTime()){
                alert(`Start date cannot be earlier than ${previousEndDate}.`);
                return;
            }
        }

        const updatedTask = {
            ...oldTask,
            source: $("#edit-source").val(),
            machine: $("#edit-machine-name").val(),
            operator: $("#editOperatorSelect").val(),
            ctHours: $("#editctHours").val(),
            ctMinutes: $("#editctMinutes").val(),
            startDate: newStartDate.toISOString(),
            desc: $("#edit-task-desc").val(),
        };

        onUserEditTask(RCid, taskId, updatedTask);

        $("#update-task").removeData("editIndex");
        $("#editfrm-task").trigger("reset");
        $("#edit-task").hide();
    });    
    
    // Event delegation for dynamic elements in task boards
    $(".board")
        .on("click", ".add-task", function () {
            const target = $(this).attr("id");
            $("#new-task").data("target", target).show();
        })
        .on("click", ".task-close", function () {
            const board = $(this).closest(".mp-task-list");
            const id = board.find("[task-board]").attr("task-board");
            const title = board.find(".header h4").text();
            if (confirm(`Are you sure you want to delete the stage "${title}"?`)) {
                delete taskList[id];
                board.remove();
                setTask(taskList);
            }
        })
        .on("click", ".task-item-close", function () {
            const taskItem = $(this).closest(".mp-task-item");
            const boardId = taskItem.closest("ul").attr("task-board");
            const taskId = taskItem.attr("id");
            const taskData = taskList[boardId].task_items[taskId];
            const taskTitle = taskData.name;
            if (confirm(`Are you sure you want to delete the task "${taskTitle}"?`)) {
                delete taskList[boardId].task_items[taskId];
                taskItem.remove();
                setTask(taskList);
            }
        })
        .on("click", ".mp-task-item", function () {

            if(viewId){
                return;
            }
            const taskId = $(this).attr("id");
            // Find the closest <ul> with 'task-board' attribute from the clicked task
            const boardElement = $(this).closest("ul[task-board]");
            const boardId = boardElement.attr("task-board") || null;
            if (boardId) {
                // Retrieve task data from taskList
                const projetData = taskList[boardId];
                const taskData = projetData.productProcesses[taskId];
                if (taskData) {
                    // Set data attributes for target board and task ID
                    // $("#edit-task").data("target", taskData).data("task-id", taskId);
                    editMachineOptions(taskData.process);
                    editOperatorOptions(taskData.occupancy.machine);        
                    // Check and populate additional fields if they exist in taskData
                    if (taskData.source) $("#edit-source").val(taskData.source);
                    if (taskData.process) $("#edit-process").val(taskData.process);
                    if (taskData.occupancy.machine) $("#edit-machine-name").val(taskData.occupancy.machine);
                    if (taskData.occupancy.operator) $("#editOperatorSelect").val(taskData.occupancy.operator);
                    if (taskData.ctHours) $("#editctHours").val(taskData.ctHours);
                    if (taskData.ctMinutes) $("#editctMinutes").val(taskData.ctMinutes);
                    if (taskData.occupancy.startDate) $("#edit-start-time").val(formatDateForDatetimeLocal(taskData.occupancy.startDate));
                    if (taskData.occupancy.endDate) $("#edit-end-time").val(formatDateForDatetimeLocal(taskData.occupancy.endDate));
                    if (taskData.desc) $("#edit-task-desc").val(taskData.desc);

                    $("#update-task").data("editIndex", taskId);
                    
                    toggleFields();
                    // Show the edit task popup
                    $("#edit-task").show();
                } else {
                    console.error("Task data not found in taskList. Check your data structure.");
                }
            } else {
                console.error("Board ID not found: Closest <ul> with 'task-board' attribute is missing.");
            }
        })
        .on("click", ".header h4", function () {
            const board = $(this).closest(".mp-task-list");
            const boardId = board.find("[task-board]").attr("task-board");
            const currentTitle = $(this).text();
            $("#edit-task-board-title").val(currentTitle);
            $("#edit-task-board").data("board-id", boardId).show();
        });
        //populate machine name dropdown
        const machineData = JSON.parse(localStorage.getItem('MachineData')) || [];
        const machineNameSelect = document.getElementById("machineNameSelect");
        const editmachineSelect = document.getElementById("edit-machine-name");
        machineData.forEach(machine => {
            const option = document.createElement("option");
            option.value = machine.machineId;
            option.textContent = machine.machineId;
            machineNameSelect.appendChild(option);
        });
        machineData.forEach(machine => {
            const option = document.createElement("option");
            option.value = machine.machineId;
            option.textContent = machine.machineId;
            editmachineSelect.appendChild(option);
        });
});
function formatDateWithCustomLocale(dateStr) {
    const date = new Date(dateStr);
  
    const options = {
      weekday: 'short',   // 'short' is optional; you can remove it if you don't want the weekday name
      year: 'numeric',
      month: '2-digit',   // '2-digit' ensures the month and day are always two digits
      day: '2-digit',
      hour: '2-digit',
      minute: '2-digit',
      second: '2-digit',
      hour12: true        // Ensures 12-hour format with AM/PM
    };
  
    // Format using toLocaleString and specify the 'en-GB' locale for DD/MM/YYYY format
    return date.toLocaleString('en-GB', options).replace(',', '').replace(/\//g, '/');
}
// Function to format date to 'YYYY-MM-DDTHH:mm' format for datetime-local
function formatDateForDatetimeLocal(dateStr) {
    const date = new Date(dateStr);

    // Convert UTC to IST (UTC + 5:30)
    date.setMinutes(date.getMinutes() + 330); // 330 minutes = 5 hours 30 minutes

    // Return the formatted date in 'YYYY-MM-DDTHH:mm' format
    return date.toISOString().slice(0, 16);  // ISO string format (YYYY-MM-DDTHH:mm)
}
// Assuming the machineOptions and operatorOptions are already defined
const machineOptions = {
    // "RM Testing": ["Testing Machine", "Metrology Equipment"],
    "RM Cutting": ["Laser Cutter", "Waterjet Cutter"],
    "Facing & Centering": ["CNC Milling Machine", "Centering Machine"],
    "Pre Turning": ["CNC Lathe", "Manual Lathe"],
    "CNC Turning": ["CNC Lathe", "CNC Mill"],
    "Face Hole / Cross Hole / Deep Hole Drilling": ["CNC Drilling Machine", "Radial Drill"],
    "Re Centring": ["CNC Lathe", "CNC Milling Machine"],
    "Key Way Milling": ["CNC Milling Machine", "Manual Milling Machine"],
    "Grinding": ["Surface Grinder", "Cylindrical Grinder"],
    "Furnishing": ["Polishing Machine", "Grinding Machine"],
    "Face Hole Tapping": ["CNC Milling Machine", "Tapping Machine"],
    "Deburring & Cleaning": ["Deburring Machine", "Pressure Washer"],

    // Rib Process Machines
    "Plate Cutting": ["Plasma Cutter", "Laser Cutter"],
    "Plate Drilling": ["CNC Drilling Machine", "Manual Drill"],
    "Chamfering": ["CNC Milling Machine", "Chamfering Machine"],
    "RIB Setting": ["Rib Setting Machine", "Rib Placement Machine"],
    "Root Welding": ["MIG Welder", "TIG Welder"],
    "Saw Welding": ["Plasma Cutter", "Sawing Machine"],
    "DP Testing 1": ["Inspection Machine", "Visual Inspection Station"],
    "Face Welding": ["MIG Welder", "TIG Welder"],
    "Grinding": ["Cylindrical Grinder", "Surface Grinder"],
    "Stress Relieving": ["Stress Relieving Furnace", "Thermal Processing Oven"],
    "Shot Blasting": ["Shot Blasting Machine", "Blasting Station"],
    "DP Testing 2": ["Ultrasonic Testing Machine", "Magnetic Testing Machine"],
    "CNC Turning 2": ["CNC Lathe", "CNC Mill"],
    "Re Centring": ["CNC Lathe", "CNC Milling Machine"],
    "Key Way Milling": ["CNC Milling Machine", "Manual Milling Machine"]
};
const operatorOptions = {
    "Laser Cutter": ["John Doe", "Alice Brown"],
    "Waterjet Cutter": ["Bob White", "Eve Adams"],
    "CNC Milling Machine": ["Charlie Green", "Grace Hall"],
    "CNC Lathe": ["David Black", "Frank Wilson"],
    "Surface Grinder": ["Ivy Clark", "Jack Lewis"],
    "Radial Drill": ["Kevin Young", "Sophia Mitchell"],
    "Manual Lathe": ["Liam Turner", "Noah Wright"],
    "Plasma Cutter": ["Olivia Walker", "Paul Evans"],
    "CNC Drilling Machine": ["Quinn Baker", "Ryan Carter"],
    "Polishing Machine": ["Sophia Mitchell", "Tom Rogers"],
    "Tapping Machine": ["Uma Lopez", "Victor Perez"],
    "Deburring Machine": ["Walter Scott", "Zara Lee"],
    "MIG Welder": ["Mia Harris", "Noah Wright"],
    "TIG Welder": ["Olivia Walker", "Paul Evans"],
    "Shot Blasting Machine": ["Grace Hall", "Henry Scott"],
    "Stress Relieving Furnace": ["Ivy Clark", "Jack Lewis"],
    "Testing Machine": ["Liam Turner", "Mia Harris"],
    "Metrology Equipment": ["Liam Turner", "Mia Harris"],
    "Ultrasonic Testing Machine": ["Liam Turner", "Mia Harris"],
    "Magnetic Testing Machine": ["Sophia Mitchell", "Tom Rogers"],
    "Cylindrical Grinder": ["Alice Brown", "Bob White"],
    "Manual Milling Machine": ["Frank Wilson", "Kevin Young"],
    "Rib Setting Machine": ["Paul Evans", "Olivia Walker"],
    "Injection Molder": ["Ivy Clark", "Tom Rogers"],
    "Sawing Machine": ["Grace Hall", "Henry Scott"]
};
// Function to populate the machine options based on the selected process
function populateMachineOptions(selectedProcess) {
    const machineNameSelect = document.getElementById("machineNameSelect");
    machineNameSelect.innerHTML = '<option value="">Select Machine</option>'; // Reset options

    if (selectedProcess && machineOptions[selectedProcess]) {
        const machines = machineOptions[selectedProcess];
        machines.forEach(machine => {
            const option = document.createElement("option");
            option.value = machine;
            option.textContent = machine;
            machineNameSelect.appendChild(option);
        });
    }
}
// Function to populate the operator options based on the selected machine
function populateOperatorOptions(selectedMachine) {
    const operatorSelect = document.getElementById("operatorSelect");
    operatorSelect.innerHTML = '<option value="">Select Operator</option>'; // Reset options

    if (selectedMachine && operatorOptions[selectedMachine]) {
        const operators = operatorOptions[selectedMachine];
        operators.forEach(operator => {
            const option = document.createElement("option");
            option.value = operator;
            option.textContent = operator;
            operatorSelect.appendChild(option);
        });
    }
}
function editMachineOptions(selectedProcess) {
    const machineNameSelect = document.getElementById("edit-machine-name");
    machineNameSelect.innerHTML = '<option value="">Select Machine</option>'; // Reset options

    if (selectedProcess && machineOptions[selectedProcess]) {
        const machines = machineOptions[selectedProcess];
        machines.forEach(machine => {
            const option = document.createElement("option");
            option.value = machine;
            option.textContent = machine;
            machineNameSelect.appendChild(option);
        });
    }
}
// Function to populate the operator options based on the selected machine
function editOperatorOptions(selectedMachine) {
    const operatorSelect = document.getElementById("editOperatorSelect");
    operatorSelect.innerHTML = '<option value="">Select Operator</option>'; // Reset options

    if (selectedMachine && operatorOptions[selectedMachine]) {
        const operators = operatorOptions[selectedMachine];
        operators.forEach(operator => {
            const option = document.createElement("option");
            option.value = operator;
            option.textContent = operator;
            operatorSelect.appendChild(option);
        });
    }
}
// Handle Process Select change event
document.getElementById("processSelect").addEventListener("change", function() {
    const selectedProcess = this.value;
    // Populate machine options based on selected process
    populateMachineOptions(selectedProcess);

    // Clear the operator select since a new machine needs to be selected
    document.getElementById("operatorSelect").innerHTML = '<option value="">Select Operator</option>';
});
// Handle Machine Select change event
document.getElementById("edit-machine-name").addEventListener("change", function() {
    const selectedMachine = this.value;
    // Populate operator options based on selected machine
    editOperatorOptions(selectedMachine);
});
document.getElementById("machineNameSelect").addEventListener("change", function() {
    const selectedMachine = this.value;
    // Populate operator options based on selected machine
    populateOperatorOptions(selectedMachine);
});
// Function to toggle the disabled state of form elements
function toggleFields() {
    var source = document.getElementById('edit-source').value;

    // Get all the relevant form elements
    var machineName = document.getElementById('edit-machine-name');
    var operatorSelect = document.getElementById('editOperatorSelect');

    // Disable or enable fields based on the selected source
    if (source === 'Outsourced') {
        machineName.disabled = true;
        operatorSelect.disabled = true;
        machineName.value = '';
        operatorSelect.value = '';
    } else {
        machineName.disabled = false;
        operatorSelect.disabled = false;
    }
}
function convertIstToUtc(dateStr) {
    const date = new Date(dateStr);

    // Convert IST to UTC (UTC - 5:30)
    date.setMinutes(date.getMinutes()); // 330 minutes = 5 hours 30 minutes

    // Return the UTC date in ISO string format (YYYY-MM-DDTHH:mm:ss.sssZ)
    return date.toISOString();  // This returns the date in ISO format with UTC (Z)
}
// function calculateEndTime(startDate, ctHours, ctMinutes) {
//     let workStart = new Date();
//     workStart.setHours(9, 30, 0, 0); // 9:30 AM

//     let workEnd = new Date();
//     workEnd.setHours(18, 30, 0, 0); // 6:30 PM

//     let start = new Date(startDate);
//     let totalMinutes = parseInt(ctHours) * 60 + parseInt(ctMinutes);

//     while (totalMinutes > 0) {
//         let currentMinutes = start.getHours() * 60 + start.getMinutes();
//         let remainingWorkDay = (workEnd.getHours() * 60 + workEnd.getMinutes()) - currentMinutes;

//         if (remainingWorkDay >= totalMinutes) {
//             start.setMinutes(start.getMinutes() + totalMinutes);
//             totalMinutes = 0;
//         } else {
//             totalMinutes -= remainingWorkDay;
//             start.setDate(start.getDate() + 1);
//             start.setHours(9, 30, 0, 0);

//             // Skip Sundays by checking the day and moving to Monday if it's Sunday
//             if (start.getDay() === 0) {
//                 start.setDate(start.getDate() + 1);
//                 start.setHours(9, 30, 0, 0);
//             }
//         }
//     }
//     return start;
// }
// Event listener for 'edit-start-time', 'editctHours', and 'editctMinutes'
document.getElementById('edit-start-time').addEventListener('input', calculateEndTimeAndSet);
document.getElementById('editctHours').addEventListener('input', calculateEndTimeAndSet);
document.getElementById('editctMinutes').addEventListener('input', calculateEndTimeAndSet);

// Function to check if all values are present and calculate end time
function calculateEndTimeAndSet() {
    const startDate = document.getElementById('edit-start-time').value;
    const ctHours = document.getElementById('editctHours').value || 0;
    const ctMinutes = document.getElementById('editctMinutes').value || 0;

    // Check if all three inputs have values
    if (startDate && ctHours && ctMinutes) {
        const endTime = calculateEndTime(startDate, ctHours, ctMinutes);
        const endDateField = document.getElementById('edit-end-time');
        newEndDate =  formatDateForDatetimeLocal(endTime.toISOString());
        const formattedEndTime = newEndDate.slice(0, 16);
        endDateField.value = formattedEndTime;
    }
}

// -------------------------------start of edit task-------------------



// --------------------------end of update task and reschedule-------------------

console.log(JSON.parse(localStorage.getItem("PlannedProjectsData")));

let taskData = JSON.parse(localStorage.getItem("TaskData")) || {};

console.log(taskData);

// console.log(formatDateWithCustomLocale(taskData[`UEPL/RC/0001`][2].startDate));
