// document.getElementById('new-employer-popup-overlay').style.display = 'block';
// localStorage.removeItem('employeeIndividualAttendanceData');

window.onload = function() {
    var today = new Date();
    var month = today.getMonth() + 1;
    var year = today.getFullYear();
    month = month < 10 ? '0' + month : month;
    document.getElementById("monthYear").value = year + '-' + month;
    populateEmployeeNameDropdown();

    loadEmployeesAttendance();
    populateEmployeeIds();

    //Get today's date in YYYY-MM-DD format
    const today1 = new Date().toISOString().split('T')[0];
    // Set the default value of the date input to today's date
    document.getElementById('attendanceDate').value = today1;
    
    // Set up event listener for input changes or selection
    // document.getElementById('employeeId').addEventListener('input', fillEmployeeName);

    // Listen for input changes on the employeeId field
    document.getElementById('employeeId').addEventListener('input', function() {
        const employeeId = this.value; // Get the entered Employee ID

        // Retrieve the employee data from localStorage
        const existingEmployees = JSON.parse(localStorage.getItem('employeesData')) || [];

        // Find the employee based on the employeeId
        const employee = existingEmployees.find(emp => emp.employeeId1 === employeeId);

        // If the employee is found, prefill the employee name field
        if (employee) {
            document.getElementById('employeeName').value = employee.employeeName;
        } else {
            // If no matching employee, clear the employee name field
            document.getElementById('employeeName').value = '';
        }
    });
}

// Open the popup when clicking on the "New" button
document.getElementById('openPopupButton').addEventListener('click', function(event) {
    event.preventDefault(); // Prevent default behavior of the link (if any)
    // Show the popup by changing its display style
    document.getElementById('new-employer-popup-overlay').style.display = 'block';
});

// Close the popup when clicking on the "Close" button inside the popup
document.getElementById('closePopup').addEventListener('click', function() {
    // Hide the popup by setting display to 'none'
    document.getElementById('newEmployerForm').reset();
    document.getElementById('new-employer-popup-overlay').style.display = 'none';
});

/**
 * ----------------------------- script for "View" button-------------------------------------------------------------------
 */

// Event listener for the "View" button in the RFQ Details table
document.getElementById('dataTable').addEventListener('click', function(event) {
    // Check if the clicked element is the view button
    if (event.target && event.target.id === 'employee-pdf') {
        const pdfUrl = event.target.dataset.pdfUrl; // Get the PDF URL from the button's data attribute
        if (pdfUrl) {
            // Set the PDF URL in the iframe for viewing
            document.getElementById('pdfViewer').src = pdfUrl;
            // Display the modal
            $('#pdfModal').modal('show');
        } else {
            alert("No PDF file found for this entry.");
        }
    }
});

/**
 * ----------------------------- script for import details-------------------------------------------------------------------
 */

// Trigger the modal when the Import button is clicked
document.getElementById('import-button').addEventListener('click', function() {
    $('#importModal').modal('show');
});

// Handle the Excel file import
document.getElementById('importDataBtn').addEventListener('click', function () {
    const fileInput = document.getElementById('excelFile');
    const file = fileInput.files[0];

    if (file) {
        const reader = new FileReader();
        reader.onload = function (e) {
            const data = e.target.result;
            const workbook = XLSX.read(data, { type: 'binary' });
            const sheetName = workbook.SheetNames[0];
            const sheet = workbook.Sheets[sheetName];
            const excelData = XLSX.utils.sheet_to_json(sheet);

            // Convert Excel data to match table structure
            const formattedData = excelData.map(row => {
                return {
                    date: excelDateToJSDate(row['Date']) || '',
                    employeeId: row['Employee ID'] || '',
                    shift: row['Shift'] || '',
                    inSpfid1: row['IN-SPFID-1'] || '',
                    outSpfid1: row['OUT-SPFID-1'] || '',
                    inSpfid2: row['IN-SPFID-2'] || '',
                    outSpfid2: row['OUT-SPFID-2'] || '',
                    firstHalf: row['1st Half'] || '',
                    secondHalf: row['2nd Half'] || '',
                    lateIn: row['Late-IN'] || '',
                    earlyOut: row['Early-OUT'] || '',
                    hourlyPaidLeave: row['Hourly Paid Leave'] || '',
                    hourlyUnpaidLeave: row['Hourly Unpaid Leave'] || '',
                    overTime: row['Over Time'] || '',
                    authOT: row['Auth OT'] || '',
                    authCOff: row['Auth C-Off'] || '',
                    workHrs: row['Work Hrs'] || '',
                    manEntry: row['Man Entry'] || '',
                    reason: row['Reason'] || ''
                };
            });

            // Save the data in localStorage (if needed)
            const existingData = JSON.parse(localStorage.getItem('employeeIndividualAttendanceData')) || [];
            const mergedData = mergeEmployeeData(existingData, formattedData);
            localStorage.setItem('employeeIndividualAttendanceData', JSON.stringify(mergedData));

            // Append the new data to the DataTable
            loadEmployeesAttendance();

            // Close the modal and notify the user
            $('#importModal').modal('hide');
            alert('Employee attendance details imported successfully!');
            window.location.reload();
        };

        reader.readAsBinaryString(file);
    } else {
        alert('Please choose an Excel file.');
    }
});



/**
 * ----------------------------- script for export-buttons-------------------------------------------------------------------
 */

$(document).ready(function () {

    // Initialize the DataTable
    // $('#dataTable').DataTable();

    // Initialize dropdown behavior
    $('#columnVisibility').on('click', function(event) {
        event.preventDefault();
        const $dropdownMenu = $(this).next('.dropdown-menu');
        $('.dropdown-menu').not($dropdownMenu).hide();
        $dropdownMenu.toggle();
    });

    // Close dropdown when clicking outside
    $(document).on('click', function(e) {
        if (!$(e.target).closest('.dropdown').length) {
            $('.dropdown-menu').hide();
        }
    });

    // Handle column visibility when the checkbox state changes
    $(document).on('change', '.column-toggle', function () {
        updateColumnVisibility();
    });

    // Initial column visibility update
    updateColumnVisibility();

    // Function to copy visible table data
    $("#copy").click(function () {
        const table = document.getElementById("dataTable");
        const rows = table.querySelectorAll("tbody tr");
        let textToCopy = "";
    
        // Get the value from the 'monthYear' input field
        const monthYear = document.getElementById('monthYear').value;
        const [year, month] = monthYear.split('-');
    
        // Map the month number to the month name
        const monthNames = [
            "January", "February", "March", "April", "May", "June",
            "July", "August", "September", "October", "November", "December"
        ];
        const monthName = monthNames[parseInt(month) - 1];
        const formattedMonthYear = `${monthName}, ${year}`;
    
        // Get headers for copying
        const headers = ['Month & Year'];
        table.querySelectorAll("thead th").forEach((header) => {
            const headerText = header.innerText.trim();
            if (headerText !== 'Image' && headerText !== 'Actions' && headerText !== 'View Details' && $(header).is(':visible')) {
                headers.push(headerText);
            }
        });
        textToCopy += headers.join("\t") + "\n";
    
        // Get data from the rows, including the formatted 'Month, YYYY' in the first column
        rows.forEach(row => {
            const cols = row.querySelectorAll("td");
            const rowData = [formattedMonthYear];
    
            cols.forEach((col) => {
                const headerText = table.querySelectorAll("th")[col.cellIndex].innerText.trim();
    
                // Exclude the 'Image', 'Actions', and 'View Details' columns and check for visibility
                if (headerText !== 'Image' && headerText !== 'Actions' && headerText !== 'View Details' && $(col).is(':visible')) {
                    rowData.push(col.innerText.trim());
                }
            });
            textToCopy += rowData.join("\t") + "\n"; 
        });
    
        // Copy the table data to the clipboard
        navigator.clipboard.writeText(textToCopy.trim());
        alert("Table data copied to clipboard!");
    });    

    // Function to export visible table data as PDF
    $("#export-pdf").click(function () {
        const { jsPDF } = window.jspdf;
        const doc = new jsPDF({ orientation: 'landscape' }); // Set orientation to landscape
        const table = document.getElementById("dataTable");
        const headers = [];
        const data = [];
    
        // Get the value from the 'monthYear' input field
        const monthYear = document.getElementById('monthYear').value;
        const [year, month] = monthYear.split('-'); // Split into year and month
    
        // Map the month number to the month name
        const monthNames = [
            "January", "February", "March", "April", "May", "June",
            "July", "August", "September", "October", "November", "December"
        ];
        const monthName = monthNames[parseInt(month) - 1]; // Get the month name (month is 1-based, array is 0-based)
        const formattedMonthYear = `${monthName}, ${year}`; // Format as 'Month, YYYY'
    
        // Add 'Month & Year' header as the first column in the PDF
        headers.push('Month & Year');
        
        // Get headers from the table, excluding the 'Status' column
        const headerCols = table.querySelectorAll("thead th");
        headerCols.forEach((header) => {
            const headerText = header.innerText.trim();
            // Exclude the 'Status' column and check for visibility
            if (headerText !== 'Image' && headerText !== 'Actions' && headerText !== 'View Details' && $(header).is(':visible')) {
                headers.push(headerText); // Push other headers after the "Month & Year"
            }
        });
    
        // Get data from the table rows, including the formatted 'Month & Year' as the first column in each row
        const rows = table.querySelectorAll("tbody tr");
        rows.forEach(row => {
            const rowData = [formattedMonthYear]; // Add the formatted Month, YYYY as the first column in each row
            const cols = row.querySelectorAll("td");
            cols.forEach((col) => {
                const headerText = table.querySelectorAll("thead th")[col.cellIndex].innerText.trim();
                // Exclude the 'Status' column by comparing header text and check for visibility
                if (headerText !== 'Image' && headerText !== 'Actions' && headerText !== 'View Details' && $(col).is(':visible')) {
                    rowData.push(col.innerText); // Add other column data
                }
            });
            if (rowData.length > 0) { // Add only if the row has data
                data.push(rowData); // Push row data to be included in the table
            }
        });
    
        // Generate the PDF using autoTable plugin
        doc.autoTable({
            head: [headers],
            body: data,
            theme: 'grid',
            styles: { fontSize: 10 }
        });
    
        // Save the PDF
        doc.save('EmployeeAttendance.pdf');
    });
    
    // Function to export visible table data as Excel
    $("#export-excel").click(function () {
        const table = document.getElementById("dataTable");
        const wb = XLSX.utils.book_new();
        const ws = XLSX.utils.aoa_to_sheet([]);
    
        const headerRow = [];
        const headerCells = table.querySelectorAll("thead th");
        headerCells.forEach((headerCell) => {
            const headerText = headerCell.innerText.trim();
            if (headerText !== 'Image' && headerText !== 'Actions' && headerText !== 'View Details' && $(headerCell).is(':visible')) {
                headerRow.push(headerText); // Add other headers
            }
        });
        XLSX.utils.sheet_add_aoa(ws, [headerRow], { origin: "A1" });
    
        // Get data from the table rows, excluding the 'Status' column
        const rows = table.querySelectorAll("tbody tr");
        rows.forEach((row, rowIndex) => {
            const rowData = []; // Add the formatted Month, YYYY as the first column in each row
            const cols = row.querySelectorAll("td");
            cols.forEach((col) => {
                const headerText = table.querySelectorAll("thead th")[col.cellIndex].innerText.trim();
                if (headerText !== 'Image' && headerText !== 'Actions' && headerText !== 'View Details' && $(col).is(':visible')) {
                    rowData.push(col.innerText);
                }
            });
            if (rowData.length > 0) { // Add only if the row has data
                XLSX.utils.sheet_add_aoa(ws, [rowData], { origin: `A${rowIndex + 2}` });
            }
        });
    
        XLSX.utils.book_append_sheet(wb, ws, "Sheet1");
        XLSX.writeFile(wb, "EmployeeAttendance.xlsx"); // Set the default filename
    });

    // Function to print the visible table data
    $("#print").click(function () {
    const table = document.getElementById("dataTable");
    const newWindow = window.open("");
    newWindow.document.write("<html><head><title>Print</title></head><body>");
    newWindow.document.write("<table border='1' style='border-collapse: collapse;'>");

    // Get the value from the 'monthYear' input field
    const monthYear = document.getElementById('monthYear').value;
    const [year, month] = monthYear.split('-'); // Split into year and month

    // Map the month number to the month name
    const monthNames = [
        "January", "February", "March", "April", "May", "June",
        "July", "August", "September", "October", "November", "December"
    ];
    const monthName = monthNames[parseInt(month) - 1]; // Get the month name (month is 1-based, array is 0-based)
    const formattedMonthYear = `${monthName}, ${year}`; // Format as 'Month, YYYY'

    // Add 'Month & Year' header as the first column in the print view
    newWindow.document.write("<tr><th>Month & Year</th>");
    table.querySelectorAll("thead th").forEach(header => {
        const headerText = header.innerText.trim();
        // Exclude the 'Status' column and check for visibility
        if (headerText !== 'Image' && headerText !== 'Actions' && headerText !== 'View Details' && $(header).is(':visible')) {
            newWindow.document.write(`<th>${headerText}</th>`);
        }
    });
    newWindow.document.write("</tr>");

    // Get data from the table rows
    const rows = table.querySelectorAll("tbody tr");
    rows.forEach(row => {
        newWindow.document.write("<tr>");
        newWindow.document.write(`<td>${formattedMonthYear}</td>`); // Add formatted Month, YYYY as the first column in each row
        const cols = row.querySelectorAll("td");
        cols.forEach((col) => {
            const headerText = table.querySelectorAll("thead th")[col.cellIndex].innerText.trim();
            // Exclude the 'Status' column by comparing header text and check for visibility
            if (headerText !== 'Image' && headerText !== 'Actions' && headerText !== 'View Details' && $(col).is(':visible')) {
                newWindow.document.write(`<td>${col.innerText}</td>`);
            }
        });
        newWindow.document.write("</tr>");
    });

    newWindow.document.write("</table>");
    newWindow.document.write("</body></html>");
    newWindow.document.close();
    newWindow.print();
});


});
// Function to update column visibility based on checkbox state
function updateColumnVisibility() {
    $(".column-toggle").each(function () {
        const columnIndex = $(this).val();
        const isChecked = $(this).is(":checked");
        const table = $("#dataTable"); // Ensure this ID matches your actual table ID

        // Show or hide the column based on checkbox state
        table.find(`tr`).each(function () {
            $(this).find(`td:eq(${columnIndex}), th:eq(${columnIndex})`).css('display', isChecked ? '' : 'none');
        });
    });
}


/**
 * ----------------------------- script for -------------------------------------------------------------------
 */

// Function to load employee data from local storage
function loadEmployeesAttendance() {
    const selectedEmployeeId = document.getElementById('employee_name').value;
    const selectedMonthYear = document.getElementById('monthYear').value;
    const employees = JSON.parse(localStorage.getItem('employeeIndividualAttendanceData')) || [];
    const tableBody = document.querySelector('#dataTable tbody');

    // Check if DataTable is initialized, if not initialize it
    if (!$.fn.dataTable.isDataTable('#dataTable')) {
        $('#dataTable').DataTable();
    }

    // Get the DataTable instance
    const dataTable = $('#dataTable').DataTable();

    // Clear the table before adding new rows
    dataTable.clear();

    // Filter employees based on the selected employee ID and month-year
    const filteredEmployees = employees.filter(employee => {
        if (!employee.date) return false;
        const [day, month, year] = employee.date.split('-');
        const employeeFormattedMonthYear = `${year}-${month}`;
        return employee.employeeId === selectedEmployeeId && employeeFormattedMonthYear === selectedMonthYear;
    });

    // Add rows for each filtered employee
    filteredEmployees.forEach((employee) => {
        dataTable.row.add([
            employee.date,
            employee.employeeId,
            employee.shift,
            employee.inSpfid1,
            employee.outSpfid1,
            employee.inSpfid2,
            employee.outSpfid2,
            employee.firstHalf,
            employee.secondHalf,
            employee.lateIn,
            employee.earlyOut,
            employee.hourlyPaidLeave,
            employee.hourlyUnpaidLeave,
            employee.overTime,
            employee.authOT,
            employee.authCOff,
            employee.workHrs,
            employee.manEntry,
            employee.reason,
            `<div class="row">
                <button class="emp-action-btn emp-action-edit" data-index="${employee.employeeId}">
                    <span class="icon" title="Edit"><i class="fas fa-pencil-alt"></i></span>
                </button>
                <button class="emp-action-btn emp-action-delete" data-index="${employee.employeeId}">
                    <span class="icon" title="Delete"><i class="fas fa-trash-alt"></i></span>
                </button>
            </div>`
        ]);
    });

    // Redraw the table after adding new rows
    dataTable.draw();

    // Add event listeners for edit and delete buttons
    attachEventListeners();
}

// Add event listeners to the dynamically added buttons
function attachEventListeners() {
    // Edit button click listener
    document.querySelectorAll('.emp-action-edit').forEach((btn) =>
        btn.addEventListener('click', handleEditEmployee)
    );
    
    // Delete button click listener
    document.querySelectorAll('.emp-action-delete').forEach((btn) =>
        btn.addEventListener('click', handleDeleteEmployee)
    );
}


// Function to handle the edit button click for employee salary
function handleEditEmployee(event) {
    // const index = event.target.closest('button').dataset.index;
    const selectedEmployeeId = document.getElementById('employee_name').value;
    const row = event.target.closest('tr');
    const editDate = row.cells[0].innerText;
    const selectedOption = document.getElementById('employee_name').selectedOptions[0];
    const optionText = selectedOption.textContent;
    const employeeName = optionText.split('-')[1].trim();
    const employees = JSON.parse(localStorage.getItem('employeeIndividualAttendanceData')) || [];
    const employee = employees.find(emp => emp.employeeId === selectedEmployeeId && emp.date === editDate);

    // Prefill the popup form with employee attendance data
    document.getElementById('attendanceDate').value = convertDateToISO(employee.date);
    document.getElementById('employeeId').value = employee.employeeId;
    document.getElementById('employeeName').value = employeeName;
    document.getElementById('shift').value = employee.shift;
    document.getElementById('in_spfid_1').value = employee.inSpfid1;
    document.getElementById('out_spfid_1').value = employee.outSpfid1;
    document.getElementById('in_spfid_2').value = employee.inSpfid2;
    document.getElementById('out_spfid_2').value = employee.outSpfid2;
    document.getElementById('first_half').value = employee.firstHalf;
    document.getElementById('second_half').value = employee.secondHalf;
    document.getElementById('late_in').value = employee.lateIn;
    document.getElementById('early_out').value = employee.earlyOut;
    document.getElementById('hourly_paid_leave').value = employee.hourlyPaidLeave;
    document.getElementById('hourly_unpaid_leave').value = employee.hourlyUnpaidLeave;
    document.getElementById('over_time').value = employee.overTime;
    document.getElementById('auth_ot').value = employee.authOT;
    document.getElementById('auth_coff').value = employee.authCOff;
    document.getElementById('work_hours').value = employee.workHrs;
    document.getElementById('man_entry').value = employee.manEntry;
    document.getElementById('reason').value = employee.reason;

    // Show the popup to edit the employee attendance details
    document.getElementById('new-employer-popup-overlay').style.display = 'block';
}



// Function to handle delete button click
function handleDeleteEmployee(event) {
    const index = event.target.closest('button').dataset.index;
    const employees = JSON.parse(localStorage.getItem('employeeIndividualAttendanceData')) || [];
    const employeeId = employees[index].employeeId;

    // Show confirmation alert
    const confirmDelete = confirm(`Are you sure you want to delete the data of Employee ID: ${employeeId}?`);

    if (confirmDelete) {
        // Remove employee from the list
        employees.splice(index, 1);

        // Save updated employee list to local storage
        localStorage.setItem('employeeIndividualAttendanceData', JSON.stringify(employees));

        // Reload the employee list in the table
        loadEmployeesAttendance(); // This reloads the employee data without needing a full page refresh
    }
}


// Load employees on page load
// document.addEventListener('DOMContentLoaded', loadEmployeesAttendance);
// const AllEmployees = JSON.parse(localStorage.getItem('employeeIndividualAttendanceData')) || [];
// $('#dataTable').DataTable().clear().rows.add(AllEmployees).draw();

// Event listener for adding a new employee
document.getElementById('newEmployerForm').addEventListener('submit', function (event) {
    event.preventDefault();

    saveEmployeeAttendance();

    // Reload the table
    // loadEmployeesAttendance();
    window.location.reload();

    // Clear the form and hide the popup
    document.getElementById('newEmployerForm').reset();
    document.getElementById('new-employer-popup-overlay').style.display = 'none';
});


function saveEmployeeAttendance() {
    // Get all employee details from the form
    let employee = {
        date: convertDateToddmmyyyy(document.getElementById('attendanceDate').value) || '',
        employeeId: document.getElementById('employeeId').value || '',
        employeeName: document.getElementById('employeeName').value || '',
        // dateOfBirth: document.getElementById('dob').value || '',
        shift: document.getElementById('shift').value || '',
        inSpfid1: document.getElementById('in_spfid_1').value || '',
        outSpfid1: document.getElementById('out_spfid_1').value || '',
        inSpfid2: document.getElementById('in_spfid_2').value || '',
        outSpfid2: document.getElementById('out_spfid_2').value || '',
        firstHalf: document.getElementById('first_half').value || '',
        secondHalf: document.getElementById('second_half').value || '',
        lateIn: document.getElementById('late_in').value || '',
        earlyOut: document.getElementById('early_out').value || '',
        hourlyPaidLeave: document.getElementById('hourly_paid_leave').value || '',
        hourlyUnpaidLeave: document.getElementById('hourly_unpaid_leave').value || '',
        overTime: document.getElementById('over_time').value || '',
        authOT: document.getElementById('auth_ot').value || '',
        authCOff: document.getElementById('auth_coff').value || '',
        workHrs: document.getElementById('work_hours').value || '',
        manEntry: document.getElementById('man_entry').value || '',
        reason: document.getElementById('reason').value || ''
    };
    saveAttendanceData(employee);
}

function saveAttendanceData(employee) {
    const existingEmployees = JSON.parse(localStorage.getItem('employeeIndividualAttendanceData')) || [];

    // Check if an employee with the same ID already exists
    const existingIndex = existingEmployees.findIndex(item => (item.employeeId === employee.employeeId) && (item.date === employee.date));

    if (existingIndex !== -1) {
        // Employee with the same ID exists, ask for confirmation to overwrite
        const userConfirmation = confirm(`Press 'OK' to overwrite the attendance data of employee ID: ${employee.employeeId} of date ${employee.date}?`);
        
        if (userConfirmation) {
            existingEmployees[existingIndex] = employee; // Overwrite existing data
            alert(`Employee attendance data has been updated successfully.`);
        } else {
            alert("The data was not saved.");
            return;
        }
    } else {
        // No existing data with the same ID, add new employee
        existingEmployees.push(employee);
        alert(`Employee attendance data saved successfully.`);
    }

    // Save the updated employee list to local storage
    localStorage.setItem('employeeIndividualAttendanceData', JSON.stringify(existingEmployees));
}

// Merge new employee data with existing, avoiding duplicates
function mergeEmployeeData(existingData, newData) {
    newData.forEach(newEmployee => {
        const existingIndex = existingData.findIndex(emp => (emp.employeeId === newEmployee.employeeId)&&(emp.date === newEmployee.date));
        if (existingIndex !== -1) {
            // Replace existing employee data with the new one
            existingData[existingIndex] = newEmployee;
        } else {
            // Add new employee data
            existingData.push(newEmployee);
        }
    });
    return existingData;
}

// Function to convert Excel numeric date to JavaScript Date
function excelDateToJSDate(excelDate) {
    if (!excelDate) return '';
    const parsedDate = new Date((excelDate - 25569) * 86400 * 1000);
    const day = String(parsedDate.getDate()).padStart(2, '0');
    const month = String(parsedDate.getMonth() + 1).padStart(2, '0'); // Months are 0-indexed
    const year = parsedDate.getFullYear();
    return `${day}-${month}-${year}`;
}
// Utility function to convert DD-MM-YYYY to YYYY-MM-DD
function convertDateToISO(dateString) {
    if (!dateString) return ''; // Return empty string for invalid or empty date
    const [day, month, year] = dateString.split('-');
    return `${year}-${month}-${day}`;
}
// Utility function to convert DD-MM-YYYY to YYYY-MM-DD
function convertDateToddmmyyyy(dateString) {
    if (!dateString) return ''; // Return empty string for invalid or empty date
    const [year, month, day] = dateString.split('-');
    return `${day}-${month}-${year}`;
}
// Convert Excel serial number to JavaScript Date object
function excelSerialToDate(serial) {
    const startDate = new Date(1899, 11, 30); // Excel uses 1900 as the starting date, but there's an off-by-one error (Excel starts from 1 instead of 0)
    startDate.setDate(startDate.getDate() + serial);
    return startDate;
}

function clearForm() {
    document.querySelectorAll('input').forEach(input => input.value = '');
}

// function handleEditEmployee(event) {
//     const row = event.target.closest('tr');
//     const editEmployeeId = row.cells[1].innerText;
//     const monthYear = document.getElementById('monthYear').value || ''; 
//     let formattedMonthYear = '';
//     const [year, month] = monthYear.split('-');
//     formattedMonthYear = new Date(year, month - 1).toLocaleString('default', { month: 'long', year: 'numeric' });
//     const employees = JSON.parse(localStorage.getItem('employeeIndividualAttendanceData')) || [];
//     const index = employees.findIndex(emp => (emp.employeeId === editEmployeeId)&&(emp.month_year === formattedMonthYear));

//     // const index = event.target.closest('button').dataset.index;
//     const employee = employees[index];

//     console.log(formattedMonthYear);

//     // Prefill the popup form with employee attendance data
//     document.getElementById('editMonthYear').value = document.getElementById('monthYear').value;
//     document.getElementById('employeeId').value = employee.employeeId;
//     document.getElementById('employeeName').value = employee.employeeName;
//     document.getElementById('gender').value = employee.gender;
//     document.getElementById('dob').value = convertDateToISO(employee.dateOfBirth);
//     document.getElementById('doj').value = convertDateToISO(employee.dateOfJoining);
//     document.getElementById('department').value = employee.department;
//     document.getElementById('designation').value = employee.designation;
//     document.getElementById('daysWorked').value = employee.daysWorked;
//     document.getElementById('sundaysEligible').value = employee.sundaysEligible;
//     document.getElementById('holidays').value = employee.holidays;
//     document.getElementById('leaveEnjoyed').value = employee.leaveEnjoyed;
//     document.getElementById('totalPaidDays').value = employee.totalPaidDays;
//     document.getElementById('absent').value = employee.absent;
//     document.getElementById('firstShift').value = employee.firstShifts;
//     document.getElementById('nightShift').value = employee.nightShifts;
//     document.getElementById('otHours').value = employee.otHours;
//     document.getElementById('shortageHours').value = employee.shortageHours;

//     // Show the popup to edit the employee attendance details
//     document.getElementById('new-employer-popup-overlay').style.display = 'block';
// }

//--------------------------------------------------------------------------------------------------


// Get references to the Employee Name dropdown and Employee ID field

const employeeNameDropdown = document.getElementById('employee_name');

// Retrieve employeesData from local storage
const employeesData = JSON.parse(localStorage.getItem('employeesData')) || [];

// Populate Employee Name dropdown on page load
function populateEmployeeNameDropdown() {
    // Clear existing options
    employeeNameDropdown.innerHTML = '<option value="">Select Employee Name</option>';

    // Add options dynamically from employeesData
    employeesData.forEach(employee => {
        const option = document.createElement('option');
        option.value = employee.employeeId1;
        option.textContent = employee.employeeId1+'-'+employee.employeeName;
        employeeNameDropdown.appendChild(option);
    });
}

// Event listener to update Employee ID field when Employee Name is selected
employeeNameDropdown.addEventListener('change', function () {
    const selectedName = employeeNameDropdown.value;
    const selectedEmployee = employeesData.find(emp => emp.employeeName === selectedName);
});



// Function to populate the employee IDs in the datalist
function populateEmployeeIds() {
    const employeeIdsData = JSON.parse(localStorage.getItem('employeesData')) || [];
    const dataList = document.getElementById('employeeIdList');
    
    // Clear the current options
    dataList.innerHTML = '';

    // Add new options for each employee ID
    employeeIdsData.forEach(id => {
        const option = document.createElement('option');
        option.value = id.employeeId1;
        option.textContent = `${id.employeeName}`;
        dataList.appendChild(option);
    });
}

// Function to fill employeeName based on employeeId selection or entry
function fillEmployeeName() {
    const employeeId = document.getElementById('employeeId').value;
    const employeeData = JSON.parse(localStorage.getItem('employeesData')) || []; // Retrieve employee data from localStorage
    const employeeNameField = document.getElementById('employeeName'); // The field where employee name will be populated

    // Find the employee by employeeId1
    const employee = employeeData.find(e => e.employeeId1 === employeeId);
    // If a matching employee is found, set the employeeName field's value
    if (employee) {
        employeeNameField.value = employee.employeeName;
    } else {
        employeeNameField.value = ''; // Clear the field if no match is found
    }
}

console.log(JSON.parse(localStorage.getItem('employeeIndividualAttendanceData')));  // Check the structure of the existing data
