// Count-Up Animation
document.addEventListener("DOMContentLoaded", () => {
    const counters = document.querySelectorAll(".h5[data-target]");
    counters.forEach(counter => {
        let start = 0;
        const target = +counter.getAttribute("data-target");
        const increment = target / 100;

        function updateCounter() {
            if (start < target) {
                start += increment;
                counter.innerText = `${Math.ceil(start)}`;
                setTimeout(updateCounter, 15);
            } else {
                counter.innerText = `${target}`;
            }
        }
        updateCounter();
    });

    // Progress Bar Animation
    setTimeout(() => {
        document.querySelector(".progress-bar").style.width = "50%";
    }, 500);
});




const ctx = document.getElementById('machineChart').getContext('2d');
const machineChart = new Chart(ctx, {
    type: 'pie',
    data: {
        labels: ['Running', 'Idle', 'Maintenance', 'Stopped'],
        datasets: [{
            data: [30, 15, 4, 1],
            backgroundColor: ['#4CAF50', '#FFEB3B', '#FF9800', '#F44336'],
            borderColor: '#fff',
            borderWidth: 2
        }]
    },
    options: {
        responsive: true,
        plugins: {
            legend: {
                labels: {
                    color: '#000',
                    font: { size: 14 }
                }
            }
        }
    }
});


document.addEventListener("DOMContentLoaded", function () {
    const data = [
        { company: "Company A", customers: 120, revenue: 50 },
        { company: "Company B", customers: 190, revenue: 80 },
        { company: "Company C", customers: 300, revenue: 150 },
        { company: "Company D", customers: 150, revenue: 70 },
        { company: "Company E", customers: 220, revenue: 120 },
        { company: "Company F", customers: 180, revenue: 90 },
        { company: "Company G", customers: 250, revenue: 130 },
        { company: "Company H", customers: 210, revenue: 110 }
    ];

    const companies = data.map(item => item.company);
    const customers = data.map(item => item.customers);
    const revenue = data.map(item => item.revenue);
    
    // Apply condition: Highlight companies with high revenue
    const backgroundColors = data.map(item => 
        item.revenue > 100 ? "rgba(102, 243, 7, 0.92)" : "rgb(245, 201, 4)"
    );

    const ctx = document.getElementById("customerRevenueChart").getContext("2d");
    new Chart(ctx, {
        type: "bar",
        data: {
            labels: companies,
            datasets: [
                {
                    label: "Customers",
                    data: customers,
                    backgroundColor: "rgba(54, 162, 235, 0.7)",
                    borderColor: "rgba(54, 162, 235, 1)",
                    borderWidth: 1
                },
                {
                    label: "Revenue (₹K)",
                    data: revenue,
                    backgroundColor: backgroundColors,
                    borderColor: "rgba(255, 99, 132, 1)",
                    borderWidth: 1
                }
            ]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: "top",
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    title: {
                        display: true,
                        text: "Values"
                    }
                },
                x: {
                    title: {
                        display: true,
                        text: "Companies"
                    }
                }
            }
        }
    });
});