window.addEventListener('load', () => {

    // localStorage.removeItem('grnDataList');

    document.getElementById('grnNo').value = generateGRNId();
    
    populateCompanyNames();
    document.getElementById('companyNameSelect').addEventListener('change', handlecompanySelection);

    //Get today's date in YYYY-MM-DD format
    const today = new Date().toISOString().split('T')[0];
    // Set the default value of the date input to today's date
    document.getElementById('grnDate').value = today;

    let savedData = [];
    let grnData = null;
    let editGrnData = null;

    const editGrnId = sessionStorage.getItem('currentgrnId');

    if (editGrnId) {
        // Retrieve the grn data list from local storage
        savedData = JSON.parse(localStorage.getItem('grnDataList')) || [];

        grnData = savedData.find(item => item.grnNo1 === editGrnId);
        if (grnData){
            editGrnData = grnData;
        }
    }
    if (editGrnData) {
        document.getElementById('grnNo').value = editGrnData.grnNo1 || '';
        document.getElementById('grnDate').value = editGrnData.grnDate1 || '';
        document.getElementById('orderNo').value = editGrnData.orderNo || '';
        document.getElementById('orderDate').value = editGrnData.orderDate || '';
        document.getElementById('orderRefNo').value = editGrnData.orderRefNo || '';
        document.getElementById('companyNameSelect').value = editGrnData.companyName || '';
        document.getElementById('companyAddress').value = editGrnData.companyAddress || '';
        document.getElementById('companyGSTN').value = editGrnData.companyGSTN || '';
        document.getElementById('companyPhone').value = editGrnData.companyPhone || '';
        document.getElementById('companyEmail').value = editGrnData.companyEmail || '';
        document.getElementById('quotationNo').value = editGrnData.quotationNo || '';
        document.getElementById('quotationDate').value = editGrnData.quotationDate || '';
        document.getElementById('rfqNo').value = editGrnData.rfqNo || '';
        document.getElementById('rfqDate').value = editGrnData.rfqDate || '';
        document.getElementById('partNo').value = editGrnData.partNo || '';
        document.getElementById('project-materialNo').value = editGrnData.projectMaterialNo || '';
        document.getElementById('drawingNo').value = editGrnData.drawingNo || '';
        document.getElementById('drawingRev').value = editGrnData.drawingRev || '';
        document.getElementById('description').value = editGrnData.description || '';
        document.getElementById('productType').value = editGrnData.productType || '';
        // document.getElementById('grnChallan').value = editGrnData.challan || '';
        populateTableDetails(editGrnData.productDetails || []);
    }
    
    // printSavedGRNData();
});

// Event listener for the submit button to save the form data
document.getElementById('grnForm').addEventListener('submit', function(event) {
    event.preventDefault();
    saveGRNData();
    resetForm();
    sessionStorage.removeItem('currentgrnId');
    window.location.href = 'grn-datatable.html';
});

document.getElementById('grnContent').addEventListener('keydown', function(event) {
    // Check if the pressed key is "Enter" (keyCode 13 or event.code 'Enter')
    if (event.key === "Enter") {
        // Prevent form submission
        event.preventDefault();

        // Move focus to the next input field (you can customize this if needed)
        let currentInput = document.activeElement;
        let nextInput = currentInput.nextElementSibling;

        // If the next input exists and it's an input field, focus on it
        while (nextInput && nextInput.tagName.toLowerCase() !== 'input') {
            nextInput = nextInput.nextElementSibling;
        }

        if (nextInput) {
            nextInput.focus();
        }
    }
});

// Function to generate the GRN ID
function generateGRNId() {
    const savedData = JSON.parse(localStorage.getItem('grnDataList')) || [];
    const lastGrn = savedData.length ? savedData[savedData.length - 1].grnNo1 : "UEPL/GRN/0000";
    const lastIdNumber = parseInt(lastGrn.split('/').pop(), 10);
    const newIdNumber = (lastIdNumber + 1).toString().padStart(4, '0');
    return `UEPL/GRN/${newIdNumber}`;
}

function resetForm(){
    document.getElementById('grnForm').reset();
    document.querySelector(".product-table tbody").innerHTML = '';
    addRow();
}

async function populateCompanyNames() {
    try {
        const response = await fetch('https://umbreyengineering.com/api/customer/');
        if (!response.ok) {
            throw new Error(`HTTP error! Status: ${response.status}`);
        }
        const companyData = await response.json();

        const companyNameSelect = document.getElementById("companyNameSelect");
        companyData.forEach(company => {
            const companyId1 = company.companyId1;
            if (companyId1 && (companyId1.startsWith('UEPL/CUS/') || companyId1.startsWith('UEPL/VEN/') || companyId1.startsWith('UEPL/CV/'))) {
                const option = document.createElement("option");
                option.value = company.companyName;
                option.textContent = company.companyName;
                companyNameSelect.appendChild(option);
            }
        });
    } catch (error) {
        console.error("Error fetching company data:", error);
    }
}

// Function to add a new row with event listeners
function addRow() {
    const productTableBody = document.querySelector(".product-table tbody");
    const newRow = document.createElement("tr");

    newRow.innerHTML = `
        <td>${productTableBody.rows.length + 1}</td>
        <td><input type="text" class="description"></td>
        <td><input type="number" class="quantity"></td>
        <td><input type="text" class="unit"></td>
        <td><input type="date" class="date"></td>
        <td><input type="text" class="supplier"></td>
        <td><input type="text" class="remarks"></td>
        <td><button class="btn btn-danger" type="button" onclick="deleteRow(this)"><i class="fa fa-trash"></i></button></td>
    `;

    productTableBody.appendChild(newRow);
}

// Delete a row from the product table
function deleteRow(button) {
const row = button.parentNode.parentNode;
row.parentNode.removeChild(row);
}

// Print the GRN
function printGRN() {
    const bodyElements = document.body.children;
    const grnContent = document.getElementById("grnContent");

    // Hide all elements except the quotation content
    for (let i = 0; i < bodyElements.length; i++) {
        if (bodyElements[i] !== grnContent) {
            bodyElements[i].style.visibility = "hidden";
        }
    }

    // Hide all buttons inside the quotation content
    const buttons = grnContent.getElementsByTagName("button");
    for (let i = 0; i < buttons.length; i++) {
        buttons[i].style.visibility = "hidden";
    }

    // Make quotation content and its children visible
    grnContent.style.visibility = "visible";
    for (let i = 0; i < grnContent.children.length; i++) {
        grnContent.children[i].style.visibility = "visible";
    }

    // Print the page with only the quotation content visible
    window.print();

    // Restore visibility of other elements after printing
    for (let i = 0; i < bodyElements.length; i++) {
        if (bodyElements[i] !== grnContent) {
            bodyElements[i].style.visibility = "";
        }
}

// Restore visibility of buttons in the quotation content
for (let i = 0; i < buttons.length; i++) {
    buttons[i].style.visibility = "";
}
}
// Save the GRN (basic simulation)

// Function to convert file to Base64
function fileToBase64(file) {
    return new Promise((resolve, reject) => {
        const reader = new FileReader();
        reader.onload = function (event) {
            resolve(event.target.result); // Base64 encoded string
        };
        reader.onerror = function (error) {
            reject(error);
        };
        reader.readAsDataURL(file);
    });
}
// Function to format the current date as dd-mm-yyyy
function formatDate(date) {
    const day = String(date.getDate()).padStart(2, '0');
    const month = String(date.getMonth() + 1).padStart(2, '0'); // Months are zero-based
    const year = date.getFullYear();
    return `${day}-${month}-${year}`;
}

// Handle company selection and populate related fields
async function handlecompanySelection() {
    const selectedCompany = document.getElementById('companyNameSelect').value;    

    try {
        const response = await fetch('https://umbreyengineering.com/api/customer/');
        if (!response.ok) {
            throw new Error(`HTTP error! Status: ${response.status}`);
        }
        const dataList = await response.json();
        const filteredData = dataList.filter(data => data.companyName === selectedCompany);

        if (filteredData && filteredData.length > 0) {
            const { billingAddress, gstNo, companyContact, companyEmail } = filteredData[0];
            document.getElementById('companyAddress').value = billingAddress;
            document.getElementById('companyGSTN').value = gstNo;
            document.getElementById('companyPhone').value = companyContact;
            document.getElementById('companyEmail').value = companyEmail;
        }
        else{
            document.getElementById('companyAddress').value = '';
            document.getElementById('companyGSTN').value = '';
            document.getElementById('companyPhone').value = '';
            document.getElementById('companyEmail').value = '';
        }
    } catch (error) {
        console.error("Error fetching company data:", error);
    }
}
// Function to handle form submission and save data to localStorage
function saveGRNData() {
    let grnData;
    let existingIndex;

    grnData = {
        grnNo1: document.getElementById('grnNo').value,
        grnDate1: document.getElementById('grnDate').value,
        orderNo: document.getElementById('orderNo').value,
        orderDate: document.getElementById('orderDate').value,
        companyName: document.getElementById('companyNameSelect').value,
        companyAddress: document.getElementById('companyAddress').value,
        orderRefNo: document.getElementById('orderRefNo').value,
        companyGSTN: document.getElementById('companyGSTN').value,
        companyPhone: document.getElementById('companyPhone').value,
        companyEmail: document.getElementById('companyEmail').value,
        quotationNo: document.getElementById('quotationNo').value,
        quotationDate: document.getElementById('quotationDate').value,
        rfqNo: document.getElementById('rfqNo').value,
        rfqDate: document.getElementById('rfqDate').value,
        partNo: document.getElementById('partNo').value,
        projectMaterialNo: document.getElementById('project-materialNo').value,
        drawingNo: document.getElementById('drawingNo').value,
        drawingRev: document.getElementById('drawingRev').value,
        description: document.getElementById('description').value,
        productType: document.getElementById('productType').value,
        productDetails: collectTableDetails(),
        challan: null // Default to null if no file
    };

    // Get the challan file input element
    const fileInput = document.getElementById('grnChallan');

    // Check if a file is selected before processing
    if (fileInput.files && fileInput.files[0]) {
        // Call the fileToBase64 function to process the uploaded PDF
        fileToBase64(fileInput.files[0]).then((base64PDF) => {
            grnData.challan = base64PDF; // Save the base64 PDF to grnData
            saveToLocalStorage(grnData); // Now save to localStorage
        }).catch((error) => {
            console.error("Error processing the file:", error);
            alert("Error processing the file.");
        });
    } else {
        // If no file is selected, just save the data
        saveToLocalStorage(grnData);
    }
}

// Function to save GRN data to localStorage
function saveToLocalStorage(grnData) {
    // Retrieve existing data from localStorage or initialize an empty array
    let savedData = JSON.parse(localStorage.getItem('grnDataList')) || [];

    let existingIndex = savedData.findIndex(item => item.grnNo1 === grnData.grnNo1);

    if (existingIndex !== -1) {
        // GRN with the same number exists
        const userConfirmation = confirm(`A data with the same GRN number already exists. Press 'OK' to override it?`);
        if (userConfirmation) {
            // User confirmed to override, so replace the old data at the found index
            savedData[existingIndex] = grnData;
            alert(`GRN data has been updated successfully.`);
        } else {
            // User canceled, so don't save
            alert("The data was not saved.");
            return;
        }
    } else {
        // No existing data with the same GRN number, so add as new
        savedData.push(grnData);
        alert('GRN Data Saved Successfully!');
    }

    // Save the updated list back to localStorage
    localStorage.setItem('grnDataList', JSON.stringify(savedData));
}

// function saveGRNData() {
//     return new Promise((resolve, reject) => {
//         let grnData;
//         let existingIndex;

//         grnData = {
//             grnNo1: document.getElementById('grnNo').value,
//             grnDate1: document.getElementById('grnDate').value,
//             orderNo: document.getElementById('orderNo').value,
//             orderDate: document.getElementById('orderDate').value,
//             companyName: document.getElementById('companyNameSelect').value,
//             companyAddress: document.getElementById('companyAddress').value,
//             orderRefNo: document.getElementById('orderRefNo').value,
//             companyGSTN: document.getElementById('companyGSTN').value,
//             companyPhone: document.getElementById('companyPhone').value,
//             companyEmail: document.getElementById('companyEmail').value,
//             quotationNo: document.getElementById('quotationNo').value,
//             quotationDate: document.getElementById('quotationDate').value,
//             rfqNo: document.getElementById('rfqNo').value,
//             rfqDate: document.getElementById('rfqDate').value,
//             partNo: document.getElementById('partNo').value,
//             projectMaterialNo: document.getElementById('project-materialNo').value,
//             drawingNo: document.getElementById('drawingNo').value,
//             drawingRev: document.getElementById('drawingRev').value,
//             description: document.getElementById('description').value,
//             productType: document.getElementById('productType').value,
//             productDetails: collectTableDetails(),
//             totalAmount: document.getElementById('totalAmount').value,
//             sgstA: document.getElementById('sgstA').value,
//             cgstA: document.getElementById('cgstA').value,
//             igstA: document.getElementById('IgstA').value,
//             roundUp: document.getElementById('roundUp').value,
//             grandTotal: document.getElementById('grandTotal').value,
//             challan: null
//         };

//         const fileInput = document.getElementById('grnChallan');
//         fileToBase64(fileInput.files[0]).then((base64PDF) => {
//             grnData.challan = base64PDF; // Save the base64 PDF to grnData

//             let savedData = JSON.parse(localStorage.getItem('grnDataList')) || [];
//             existingIndex = savedData.findIndex(item => item.grnNo1 === grnData.grnNo1);

//             if (existingIndex !== -1) {
//                 const userConfirmation = confirm(`A data with same GRN number already exists. Press 'OK' to override it?`);
//                 if (userConfirmation) {
//                     savedData[existingIndex] = grnData;
//                     alert(`GRN data has been updated successfully.`);
//                 } else {
//                     alert("The data was not saved.");
//                     return reject("User cancelled saving");
//                 }
//             } else {
//                 savedData.push(grnData);
//                 alert('GRN Data Saved Successfully!');
//             }
//             localStorage.setItem('grnDataList', JSON.stringify(savedData));
//             resolve(); // Resolve the promise when saving is done
//         }).catch(error => {
//             alert("Error processing the file.");
//             reject(error);
//         });
//     });
// }

// Function to collect product details from the product table
function collectTableDetails() {
    const productRows = document.querySelectorAll('.product-table tbody tr');
    const productDetails = [];

    productRows.forEach((row, index) => {
        const productData = {
            slNo: index + 1,
            description: row.querySelector('.description').value,
            quantity: row.querySelector('.quantity').value,
            unit: row.querySelector('.unit').value,
            date: row.querySelector('.date').value,
            supplier: row.querySelector('.supplier').value,
            remarks: row.querySelector('.remarks').value
        };
        productDetails.push(productData);
    });
    return productDetails;
}

function populateTableDetails(products) {
    const productTableBody = document.querySelector('.product-table tbody');
    productTableBody.innerHTML = '';
    
    products.forEach((product, index) => {
        const row = document.createElement("tr");

        row.innerHTML = `
            <td>${index + 1}</td>
            <td><input type="text" class="description" value="${product.description || ''}"></td>
            <td><input type="number" class="quantity" value="${product.quantity || 0}"></td>
            <td><input type="text" class="unit" value="${product.unit || ''}"></td>
            <td><input type="date" class="date" value="${product.date || ''}"></td>
            <td><input type="text" class="supplier" value="${product.supplier || ''}"></td>
            <td><input type="text" class="remarks" value="${product.remarks || ''}"></td>
            <td><button class="btn btn-danger" type="button" onclick="deleteRow(this)"><i class="fa fa-trash"></i></button></td>
        `;

        productTableBody.appendChild(row);
    });
}

// window.location.reload();
// Function to print the saved GRN data from localStorage
function printSavedGRNData() {
    // Retrieve the saved data from localStorage
    const grnDataList = JSON.parse(localStorage.getItem('grnDataList'));

    // Check if there is any saved data
    if (grnDataList && grnDataList.length > 0) {
        // Print the saved GRN data in the console
        console.log("Saved GRN Data:", grnDataList);
    } else {
        // If no data is found, print a message
        console.log("No GRN data found in localStorage.");
    }
}

//------------

// Sample data for PO IDs and SO IDs
const pOrderData = JSON.parse(localStorage.getItem('PODataList')) || [];
const sOrderData = JSON.parse(localStorage.getItem('SODataList')) || [];

// Function to filter order IDs based on user input
function filterOrderIds() {
    const input = document.getElementById('orderNo').value.toLowerCase();
    const filteredPOrders = pOrderData.filter(order => order.poNo1.toLowerCase().includes(input));
    const filteredSOrders = sOrderData.filter(order => order.soNo1.toLowerCase().includes(input));

    const orderList = document.getElementById('orderList');
    orderList.innerHTML = "";  // Clear current list

    if ((filteredPOrders.length > 0 && input !== "") || (filteredSOrders.length > 0 && input !== "")) {
        orderList.style.display = "block"; // Show the dropdown
        filteredPOrders.forEach(order => {
            const listItem = document.createElement('li');
            listItem.textContent = order.poNo1;
            listItem.onclick = () => selectPOrder(order);
            orderList.appendChild(listItem);
        });
        filteredSOrders.forEach(order => {
            const listItem = document.createElement('li');
            listItem.textContent = order.soNo1;
            listItem.onclick = () => selectSOrder(order);
            orderList.appendChild(listItem);
        });
    } else {
        orderList.style.display = "none"; // Hide if no matching IDs
    }
}

// Function to handle order selection and fill the form fields
function selectPOrder(order) {
    document.getElementById('orderNo').value = order.poNo1;
    document.getElementById('orderDate').value = order.poDate || '';
    document.getElementById('companyNameSelect').value = order.companyName || '';
    document.getElementById('orderRefNo').value = order.custRefPoNo || '';
    document.getElementById('companyAddress').value = order.address || '';
    document.getElementById('companyGSTN').value = order.gstNo || '';
    document.getElementById('companyPhone').value = order.companyPhone || '';
    document.getElementById('companyEmail').value = order.companyEmail || '';
    document.getElementById('quotationNo').value = order.quotationNo2 || '';
    document.getElementById('quotationDate').value = order.quotationDate || '';
    document.getElementById('rfqNo').value = order.rfqNo || '';
    document.getElementById('rfqDate').value = order.rfqDate || '';
    document.getElementById('partNo').value = order.partNo || '';
    document.getElementById('project-materialNo').value = order.projectMaterialNo || '';
    document.getElementById('drawingNo').value = order.drawingId || '';
    document.getElementById('drawingRev').value = order.drawingRevision || '';
    document.getElementById('description').value = order.projectDescription || '';
    document.getElementById('productType').value = order.productType || '';
    // populateTableDetails(order.tableProducts || []);

    document.getElementById('orderList').style.display = "none";  // Hide dropdown after selection
}
function selectSOrder(order) {
    document.getElementById('orderNo').value = order.soNo1;
    document.getElementById('orderDate').value = order.soDate || '';
    document.getElementById('companyNameSelect').value = order.companyName || '';
    document.getElementById('orderRefNo').value = order.custRefSoNo || '';
    document.getElementById('companyAddress').value = order.address || '';
    document.getElementById('companyGSTN').value = order.gstNo || '';
    document.getElementById('companyPhone').value = order.companyPhone || '';
    document.getElementById('companyEmail').value = order.companyEmail || '';
    document.getElementById('quotationNo').value = order.quotationNo2 || '';
    document.getElementById('quotationDate').value = order.quotationDate || '';
    document.getElementById('rfqNo').value = order.rfqNo || '';
    document.getElementById('rfqDate').value = order.rfqDate || '';
    document.getElementById('partNo').value = order.partNo || '';
    document.getElementById('project-materialNo').value = order.projectMaterialNo || '';
    document.getElementById('drawingNo').value = order.drawingId || '';
    document.getElementById('drawingRev').value = order.drawingRevision || '';
    document.getElementById('description').value = order.projectDescription || '';
    document.getElementById('productType').value = order.productType || '';
    // populateTableDetails(order.tableProducts || []);

    document.getElementById('orderList').style.display = "none";  // Hide dropdown after selection
}