// localStorage.removeItem('employeeSalaryData');

// Open the popup when clicking on the "New" button
document.getElementById('openPopupButton').addEventListener('click', function(event) {
    event.preventDefault(); // Prevent default behavior of the link (if any)
    // Show the popup by changing its display style
    document.getElementById('new-employer-popup-overlay').style.display = 'block';
});

// Close the popup when clicking on the "Close" button inside the popup
document.getElementById('closePopup').addEventListener('click', function() {
    // Hide the popup by setting display to 'none'
    document.getElementById('newEmployerForm').reset();
    document.getElementById('new-employer-popup-overlay').style.display = 'none';
});

/**
 * ----------------------------- script for "View" button-------------------------------------------------------------------
 */

// Event listener for the "View" button in the RFQ Details table
document.getElementById('dataTable').addEventListener('click', function(event) {
    // Check if the clicked element is the view button
    if (event.target && event.target.id === 'employee-pdf') {
        const pdfUrl = event.target.dataset.pdfUrl; // Get the PDF URL from the button's data attribute
        if (pdfUrl) {
            // Set the PDF URL in the iframe for viewing
            document.getElementById('pdfViewer').src = pdfUrl;
            // Display the modal
            $('#pdfModal').modal('show');
        } else {
            alert("No PDF file found for this entry.");
        }
    }
});

/**
 * ----------------------------- script for import details-------------------------------------------------------------------
 */

// Trigger the modal when the Import button is clicked
document.getElementById('import-button').addEventListener('click', function() {
    $('#importModal').modal('show');
});

// Handle the Excel file import
document.getElementById('importDataBtn').addEventListener('click', function () {
    const fileInput = document.getElementById('excelFile');
    const file = fileInput.files[0];

    if (file) {
        const reader = new FileReader();
        reader.onload = function (e) {
            const data = e.target.result;
            const workbook = XLSX.read(data, { type: 'binary' });
            const sheetName = workbook.SheetNames[0];
            const sheet = workbook.Sheets[sheetName];
            const excelData = XLSX.utils.sheet_to_json(sheet);

            // Convert Excel data to the required format for your API
            const formattedData = excelData.map(row => ({
                employeeId: row['Employee ID'] || '',
                employeeName: row['Employee Name'] || '',
                monthYear: row['Month & Year'] || '',
                basicDA: row['Basic & DA'] || 0,
                hra: row['HRA'] || 0,
                conveyance: row['Conveyance'] || 0,
                washingAllowance: row['Washing Allowance'] || 0,
                fixedSalary: row['Fixed Salary'] || 0,
                daysWorked: row['No. of Days Worked'] || 0,
                leaveGiven: row['Leave Given'] || 0,
                totalDays: row['Total Days for Salary'] || 0,
                drawnSalary: row['Drawn Salary'] || 0,
                incentiveHrs: row['Incentive Hrs'] || 0,
                incentiveRate: row['Incentive Rate'] || 0,
                incentiveAmount: row['Incentive Amount'] || 0,
                attendanceBonus: row['Attendance Bonus'] || 0,
                grossSalary: row['Gross Salary'] || 0,
                esi: row['ESI'] || 0,
                pf: row['PF'] || 0,
                pt: row['PT'] || 0,
                advanceDeduction: row['Advance Deduction'] || 0,
                netSalary: row['Net Salary'] || 0,
                paymentMode: row['Payment Mode'] || '',
            }));

            // Send data to the API
            formattedData.forEach(employeeData => {
                fetch('https://umbreyengineering.com/api/employesalary/', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify(employeeData),
                })
                .then(response => response.json())
                .then(data => {
                    console.log('Employee data successfully posted:', data);
                })
                .catch(error => {
                    console.error('Error posting employee data:', error);
                });
            });

            // Append the new data to the DataTable
            $('#dataTable').DataTable();
            loadEmployeesSalary();

            // Close the modal and notify the user
            $('#importModal').modal('hide');
            alert('Employee salary details imported successfully!');
            // window.location.reload();
        };

        reader.readAsBinaryString(file);
    } else {
        alert('Please choose an Excel file.');
    }
});

/**
 * ----------------------------- script for export-buttons-------------------------------------------------------------------
 */

$(document).ready(function () {

    // Initialize the DataTable
    $('#dataTable').DataTable();

    // Initialize dropdown behavior
    $('#columnVisibility').on('click', function(event) {
        event.preventDefault(); // Prevent default action
        const $dropdownMenu = $(this).next('.dropdown-menu'); // Target the specific dropdown menu
        $('.dropdown-menu').not($dropdownMenu).hide(); // Hide other dropdowns
        $dropdownMenu.toggle(); // Toggle the associated dropdown menu
    });

    // Close dropdown when clicking outside
    $(document).on('click', function(e) {
        if (!$(e.target).closest('.dropdown').length) {
            $('.dropdown-menu').hide(); // Hide all dropdowns
        }
    });

    // Handle column visibility when the checkbox state changes
    $(document).on('change', '.column-toggle', function () {
        updateColumnVisibility();
    });

    // Initial column visibility update
    updateColumnVisibility();

    // Function to copy visible table data
    $("#copy").click(function () {
        const table = document.getElementById("dataTable");
        const rows = table.querySelectorAll("tr");
        let textToCopy = "";

        // Get headers for copying
        const headers = [];
        table.querySelectorAll("thead th").forEach((header) => {
            const headerText = header.innerText.trim(); // Moved headerText here
            if (headerText !== 'Image' && headerText !== 'Actions' && headerText !== 'View Details' && $(header).is(':visible')) {
                headers.push(headerText);
            }
        });
        textToCopy += headers.join("\t") + "\n"; // Add headers

        // Get data
        rows.forEach(row => {
            const cols = row.querySelectorAll("td, th");

            cols.forEach((col) => {
                const headerText = table.querySelectorAll("th")[col.cellIndex].innerText.trim();

                // Exclude the 'Status' column and check for visibility
                if (headerText !== 'Image' && headerText !== 'Actions' && headerText !== 'View Details' && $(col).is(':visible')) {
                    textToCopy += col.innerText.trim() + "\t"; // Add a tab between columns
                }
            });
            textToCopy += "\n"; // New line after each row
        });

        navigator.clipboard.writeText(textToCopy.trim());
        alert("Table data copied to clipboard!");
    });

    // Function to export visible table data as CSV
    $("#export-csv").click(function () {
        let csv = [];
        const rows = document.querySelectorAll("#dataTable tr");

        // Get headers for CSV
        const headers = [];
        document.querySelectorAll("#dataTable thead th").forEach((header) => {
            const headerText = header.innerText.trim(); // Moved headerText here
            if (headerText !== 'Image' && headerText !== 'Actions' && headerText !== 'View Details' && $(header).is(':visible')) {
                headers.push(headerText);
            }
        });
        csv.push(headers.join(",")); // Add header row

        // Get data
        rows.forEach(row => {
            const cols = row.querySelectorAll("td, th");
            const csvRow = [];
            cols.forEach((col) => {
                const headerText = document.querySelectorAll("#dataTable th")[col.cellIndex].innerText.trim();

                // Exclude the 'Status' column and check for visibility
                if (headerText !== 'Image' && headerText !== 'Actions' && headerText !== 'View Details' && $(col).is(':visible')) {
                    csvRow.push(col.innerText.replace(/,/g, " ")); // Replace commas to avoid issues
                }
            });
            if (csvRow.length > 0) { // Add only if the row has data
                csv.push(csvRow.join(",")); // Join the row values with a comma
            }
        });

        const csvString = csv.join("\n"); // Join rows with a new line
        const blob = new Blob([csvString], { type: "text/csv;charset=utf-8;" });
        const link = document.createElement("a");
        link.href = URL.createObjectURL(blob);
        link.setAttribute("download", "EmployeeSalarydata.csv"); // Set the default filename
        link.click(); // Trigger the download
    });

    // Function to export visible table data as PDF
    $("#export-pdf").click(function () {
        const { jsPDF } = window.jspdf;
        const doc = new jsPDF({ orientation: 'landscape' }); // Set orientation to landscape
        const table = document.getElementById("dataTable");
        const headers = [];
        const data = [];

        // Get headers from the table
        const headerCols = table.querySelectorAll("thead th");
        headerCols.forEach((header) => {
            const headerText = header.innerText.trim(); // Moved headerText here
            // Exclude the 'Status' column and check for visibility
            if (headerText !== 'Image' && headerText !== 'Actions' && headerText !== 'View Details' && $(header).is(':visible')) {
                headers.push(headerText);
            }
        });

        // Get data from the table rows
        const rows = table.querySelectorAll("tbody tr");
        rows.forEach(row => {
            const rowData = [];
            const cols = row.querySelectorAll("td");
            cols.forEach((col) => {
                const headerText = table.querySelectorAll("thead th")[col.cellIndex].innerText.trim();

                // Exclude the 'Status' column by comparing header text and check for visibility
                if (headerText !== 'Image' && headerText !== 'Actions' && headerText !== 'View Details' && $(col).is(':visible')) {
                    rowData.push(col.innerText);
                }
            });
            if (rowData.length > 0) { // Add only if the row has data
                data.push(rowData);
            }
        });

        // Generate the PDF using autoTable plugin
        doc.autoTable({
            head: [headers],
            body: data,
            theme: 'grid',
            styles: { fontSize: 10 }
        });

        // Save the PDF
        doc.save('EmployeeSalaryData.pdf');
    });

    // Function to export visible table data as Excel
    $("#export-excel").click(function () {
        const table = document.getElementById("dataTable");
        const wb = XLSX.utils.book_new();
        const ws = XLSX.utils.aoa_to_sheet([]);

        // Get headers from the table, excluding the 'Status' column
        const headerRow = [];
        const headerCells = table.querySelectorAll("thead th");
        headerCells.forEach((headerCell) => {
            const headerText = headerCell.innerText.trim(); // Moved headerText here
            // Exclude the 'Status' column and check for visibility
            if (headerText !== 'Image' && headerText !== 'Actions' && headerText !== 'View Details' && $(headerCell).is(':visible')) {
                headerRow.push(headerText); // Include only relevant headers
            }
        });
        XLSX.utils.sheet_add_aoa(ws, [headerRow], { origin: "A1" });

        // Get data from the table rows, excluding the 'Status' column
        const rows = table.querySelectorAll("tbody tr");
        rows.forEach((row, rowIndex) => {
            const rowData = [];
            const cols = row.querySelectorAll("td");
            cols.forEach((col) => {
                const headerText = table.querySelectorAll("thead th")[col.cellIndex].innerText.trim();

                // Exclude the 'Status' column by comparing header text and check for visibility
                if (headerText !== 'Image' && headerText !== 'Actions' && headerText !== 'View Details' && $(col).is(':visible')) {
                    rowData.push(col.innerText);
                }
            });
            if (rowData.length > 0) { // Add only if the row has data
                XLSX.utils.sheet_add_aoa(ws, [rowData], { origin: `A${rowIndex + 2}` });
            }
        });

        XLSX.utils.book_append_sheet(wb, ws, "Sheet1");
        XLSX.writeFile(wb, "EmployeeSalaryData.xlsx"); // Set the default filename
    });

    // Function to print the visible table data
    $("#print").click(function () {
        const table = document.getElementById("dataTable");
        const newWindow = window.open("");
        newWindow.document.write("<html><head><title>Print</title></head><body>");
        newWindow.document.write("<table border='1' style='border-collapse: collapse;'>");

        // Get headers for print
        newWindow.document.write("<tr>");
        table.querySelectorAll("thead th").forEach(header => {
            const headerText = header.innerText.trim(); // Moved headerText here
            // Exclude the 'Status' column and check for visibility
            if (headerText !== 'Image' && headerText !== 'Actions' && headerText !== 'View Details' && $(header).is(':visible')) {
                newWindow.document.write(`<th>${headerText}</th>`);
            }
        });
        newWindow.document.write("</tr>");

        // Get data
        const rows = table.querySelectorAll("tbody tr");
        rows.forEach(row => {
            newWindow.document.write("<tr>");
            const cols = row.querySelectorAll("td");
            cols.forEach((col) => {
                const headerText = table.querySelectorAll("thead th")[col.cellIndex].innerText.trim();

                // Exclude the 'Status' column by comparing header text and check for visibility
                if (headerText !== 'Image' && headerText !== 'Actions' && headerText !== 'View Details' && $(col).is(':visible')) {
                    newWindow.document.write(`<td>${col.innerText}</td>`);
                }
            });
            newWindow.document.write("</tr>");
        });

        newWindow.document.write("</table>");
        newWindow.document.write("</body></html>");
        newWindow.document.close();
        newWindow.print();
    });

});
// Function to update column visibility based on checkbox state
function updateColumnVisibility() {
    $(".column-toggle").each(function () {
        const columnIndex = $(this).val();
        const isChecked = $(this).is(":checked");
        const table = $("#dataTable"); // Ensure this ID matches your actual table ID

        // Show or hide the column based on checkbox state
        table.find(`tr`).each(function () {
            $(this).find(`td:eq(${columnIndex}), th:eq(${columnIndex})`).css('display', isChecked ? '' : 'none');
        });
    });
}

/**
 * ----------------------------- script for -------------------------------------------------------------------
 */

// Function to load employee data from local storage
function loadEmployeesSalary() {
    fetch('https://umbreyengineering.com/api/employesalary/')
        .then(response => response.json())
        .then(employees => {
            const tableBody = document.querySelector('#dataTable tbody');
            tableBody.innerHTML = ''; // Clear the table before adding new rows

            employees.forEach((employee, index) => {
                const newRow = document.createElement('tr');
                newRow.innerHTML = `
                    <td>${employee.monthYear}</td>
                    <td>${employee.employeeId}</td>
                    <td>${employee.employeeName}</td>
                    <td>${employee.basicDA}</td>
                    <td>${employee.hra}</td>
                    <td>${employee.conveyance}</td>
                    <td>${employee.washingAllowance}</td>
                    <td>${employee.fixedSalary}</td>
                    <td>${employee.daysWorked}</td>
                    <td>${employee.leaveGiven}</td>
                    <td>${employee.totalDays}</td>
                    <td>${employee.drawnSalary}</td>
                    <td>${employee.incentiveHrs}</td>
                    <td>${employee.incentiveRate}</td>
                    <td>${employee.incentiveAmount}</td>
                    <td>${employee.attendanceBonus}</td>
                    <td>${employee.grossSalary}</td>
                    <td>${employee.esi}</td>
                    <td>${employee.pf}</td>
                    <td>${employee.pt}</td>
                    <td>${employee.advanceDeduction}</td>
                    <td>${employee.netSalary}</td>
                    <td>${employee.paymentMode}</td>
                    <td>
                        <div class="row">
                            <button class="emp-action-btn emp-action-edit" data-id="${employee.id}">
                                <span class="icon" title="Edit"><i class="fas fa-pencil-alt"></i></span>
                            </button>
                            <button class="emp-action-btn emp-action-delete" data-id="${employee.id}">
                                <span class="icon" title="Delete"><i class="fas fa-trash-alt"></i></span>
                            </button>
                        </div>
                    </td>
                `;
                tableBody.appendChild(newRow);
            });

            // $('#dataTable').DataTable(); // Reinitialize DataTable
            //  Reinitialize DataTable after dynamically updating the table body
            const dataTable = $('#dataTable').DataTable(); // Initialize DataTable instance
            dataTable.clear(); // Clear existing data
            dataTable.rows.add($('#dataTable tbody tr')); // Add new rows
            dataTable.draw(); // Redraw the table to apply changes

            document.querySelectorAll('.emp-action-edit').forEach((btn) =>
                btn.addEventListener('click', handleEditEmployee)
            );
            document.querySelectorAll('.emp-action-delete').forEach((btn) =>
                btn.addEventListener('click', handleDeleteEmployee)
            );
        })
        .catch(error => console.error('Error fetching employees:', error));
}

// Function to handle the edit button click for employee salary
function handleEditEmployee(event) {
    const employeeId = event.target.closest('button').dataset.id; // Get Employee ID from dataset

    // Fetch employee salary details from the API
    fetch(`https://umbreyengineering.com/api/employesalary/${employeeId}/`)
        .then(response => response.json())
        .then(employee => {
            if (!employee) {
                alert('Employee data not found.');
                return;
            }

            // Prefill the popup form with employee salary data
            document.getElementById('monthYear').value = employee.monthYear || '';
            document.getElementById('employeeId').value = employee.employeeId || '';
            document.getElementById('employeeName').value = employee.employeeName || '';
            document.getElementById('basicDA').value = employee.basicDA || '';
            document.getElementById('hra').value = employee.hra || '';
            document.getElementById('conveyance').value = employee.conveyance || '';
            document.getElementById('washingAllowance').value = employee.washingAllowance || '';
            document.getElementById('fixedSalary').value = employee.fixedSalary || '';
            document.getElementById('daysWorked').value = employee.daysWorked || '';
            document.getElementById('leaveGiven').value = employee.leaveGiven || '';
            document.getElementById('totalDays').value = employee.totalDays || '';
            document.getElementById('drawnSalary').value = employee.drawnSalary || '';
            document.getElementById('incentiveHrs').value = employee.incentiveHrs || '';
            document.getElementById('incentiveRate').value = employee.incentiveRate || '';
            document.getElementById('incentiveAmount').value = employee.incentiveAmount || '';
            document.getElementById('attendanceBonus').value = employee.attendanceBonus || '';
            document.getElementById('grossSalary').value = employee.grossSalary || '';
            document.getElementById('esi').value = employee.esi || '';
            document.getElementById('pf').value = employee.pf || '';
            document.getElementById('pt').value = employee.pt || '';
            document.getElementById('advanceDeduction').value = employee.advanceDeduction || '';
            document.getElementById('netSalary').value = employee.netSalary || '';
            document.getElementById('payMode').value = employee.paymentMode || '';

            // Show the popup to edit the employee salary details
            document.getElementById('new-employer-popup-overlay').style.display = 'block';

            // Store the employee ID in a hidden input or variable to update the record after editing
            document.getElementById('employeeIdHidden').value = employeeId;

        })
        .catch(error => {
            console.error('Error fetching employee data:', error);
            alert('Failed to fetch employee data. Please try again.');
        });
}


// Function to handle delete button click
function handleDeleteEmployee(event) {
    const employeeId = event.target.closest('button').dataset.id;

    let deleteId; // Declare deleteId outside the condition to ensure it's in the right scope

    const row = event.target.closest('tr');
    deleteId = row.cells[1].innerText; // Extract the employee ID from the row's second cell (adjust as needed)

    // Now confirm with deleteId in the confirmation message
    const confirmDelete = confirm(`Are you sure you want to delete Employee ID: ${deleteId}?`);

    if (confirmDelete) {
        // Proceed with delete operation
        fetch(`https://umbreyengineering.com/api/employesalary/${employeeId}/`, {
            method: 'DELETE'
        })
        .then(response => {
            if (response.ok) {
                alert('Employee deleted successfully.');
                loadEmployeesSalary(); // Reload employees
            } else {
                alert('Failed to delete employee.');
            }
        })
        .catch(error => console.error('Error deleting employee:', error));
    }
}


// Load employees on page load
document.addEventListener('DOMContentLoaded', loadEmployeesSalary);
// const AllEmployees = JSON.parse(localStorage.getItem('employeeSalaryData')) || [];
// $('#dataTable').DataTable().clear().rows.add(AllEmployees).draw();

// Event listener for adding a new employee
document.getElementById('newEmployerForm').addEventListener('submit', function (event) {
    event.preventDefault();

    saveEmployeeSalary();

    // Reload the table
    // loadEmployeesSalary();
    // window.location.reload();

    // Clear the form and hide the popup
    document.getElementById('newEmployerForm').reset();
    document.getElementById('new-employer-popup-overlay').style.display = 'none';
});


function saveEmployeeSalary() {
    // Get all employee details from the form
    const employeeId = document.getElementById('employeeId').value;
    const employeeName = document.getElementById('employeeName').value;
    const monthYear = document.getElementById('monthYear').value;
    const basicDA = parseFloat(document.getElementById('basicDA').value) || 0;
    const hra = parseFloat(document.getElementById('hra').value) || 0;
    const conveyance = parseFloat(document.getElementById('conveyance').value) || 0;
    const washingAllowance = parseFloat(document.getElementById('washingAllowance').value) || 0;
    const fixedSalary = basicDA + hra + conveyance + washingAllowance;
    const daysWorked = parseInt(document.getElementById('daysWorked').value) || 0;
    const leaveGiven = parseInt(document.getElementById('leaveGiven').value) || 0;
    const totalDays = daysWorked - leaveGiven;
    const drawnSalary = parseFloat(document.getElementById('drawnSalary').value) || 0;
    const incentiveHrs = parseFloat(document.getElementById('incentiveHrs').value) || 0;
    const incentiveRate = parseFloat(document.getElementById('incentiveRate').value) || 0;
    const incentiveAmount = incentiveHrs * incentiveRate;
    const attendanceBonus = parseFloat(document.getElementById('attendanceBonus').value) || 0;
    const grossSalary = fixedSalary + incentiveAmount + attendanceBonus;
    const esi = parseFloat(document.getElementById('esi').value) || 0;
    const pf = parseFloat(document.getElementById('pf').value) || 0;
    const pt = parseFloat(document.getElementById('pt').value) || 0;
    const advanceDeduction = parseFloat(document.getElementById('advanceDeduction').value) || 0;
    const netSalary = grossSalary - esi - pf - pt - advanceDeduction;
    const paymentMode = document.getElementById('payMode').value;

    // Check if we're updating existing data or adding new data
    const employeeIdHidden = document.getElementById('employeeIdHidden').value;

    let employee = {
        employeeIdHidden,
        employeeId,
        employeeName,
        monthYear,
        basicDA,
        hra,
        conveyance,
        washingAllowance,
        fixedSalary,
        daysWorked,
        leaveGiven,
        totalDays,
        drawnSalary,
        incentiveHrs,
        incentiveRate,
        incentiveAmount,
        attendanceBonus,
        grossSalary,
        esi,
        pf,
        pt,
        advanceDeduction,
        netSalary,
        paymentMode
    };
    saveSalaryData(employee);
}


function saveSalaryData(employee) {
    // Check if the employee already exists in the database
    fetch(`https://umbreyengineering.com/api/employesalary/${employee.employeeIdHidden}/`)
        .then(response => {
            if (response.status === 404) {
                // Employee not found, proceed with new entry
                return null;
            }
            return response.json();
        })
        .then(existingEmployee => {
            if (existingEmployee) {
                // Employee exists, ask for confirmation to overwrite
                const userConfirmation = confirm(`Press 'OK' to overwrite the data of employee ID: ${employee.employeeId}?`);
                
                if (userConfirmation) {
                    // Update existing employee data using PUT request
                    return fetch(`https://umbreyengineering.com/api/employesalary/${employee.employeeIdHidden}/`, {
                        method: 'PUT',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify(employee)
                    });
                } else {
                    alert("The data was not saved.");
                    return;
                }
            } else {
                // Employee does not exist, create a new entry using POST request
                return fetch(`https://umbreyengineering.com/api/employesalary/`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(employee)
                });
            }
        })
        .then(response => {
            if (response && response.ok) {
                alert(`Employee salary data saved successfully.`);
                loadEmployeesSalary(); // Reload data from API
            } else if (response) {
                return response.json().then(errorData => {
                    throw new Error(errorData.message || 'Failed to save employee data.');
                });
            }
        })
        .catch(error => {
            alert('Failed to save employee data. Please try again.');
            console.error('Error saving employee data:', error);
        });
}

// Merge new employee data with existing, avoiding duplicates
function mergeEmployeeData(existingData, newData) {
    newData.forEach(newEmployee => {
        const existingIndex = existingData.findIndex(emp => emp.employeeId === newEmployee.employeeId);
        if (existingIndex !== -1) {
            // Replace existing employee data with the new one
            existingData[existingIndex] = newEmployee;
        } else {
            // Add new employee data
            existingData.push(newEmployee);
        }
    });
    return existingData;
}

// function mergeEmployeeData(existingData, newData) {
//     newData.forEach(newEmployee => {
//         const existingIndex = existingData.findIndex(emp => emp.employeeId1 === newEmployee.employeeId1);

//         if (existingIndex !== -1) {
//             // Optional: Ask for confirmation before overwriting existing data
//             const confirmOverwrite = confirm(`Employee ID ${newEmployee.employeeId1} already exists. Do you want to overwrite the data?`);
//             if (confirmOverwrite) {
//                 // Replace existing employee data with the new one
//                 existingData[existingIndex] = newEmployee;
//             }
//         } else {
//             // Add new employee data if not already present
//             existingData.push(newEmployee);
//         }
//     });

//     return existingData;
// }

// Function to convert Excel numeric date to JavaScript Date
function excelDateToJSDate(excelDate) {
    if (!excelDate) return '';
    const parsedDate = new Date((excelDate - 25569) * 86400 * 1000);
    const day = String(parsedDate.getDate()).padStart(2, '0');
    const month = String(parsedDate.getMonth() + 1).padStart(2, '0'); // Months are 0-indexed
    const year = parsedDate.getFullYear();
    return `${day}-${month}-${year}`;
}
// Utility function to convert DD-MM-YYYY to YYYY-MM-DD
function convertDateToISO(dateString) {
    if (!dateString) return ''; // Return empty string for invalid or empty date
    const [day, month, year] = dateString.split('-');
    return `${year}-${month}-${day}`;
}
// Utility function to convert DD-MM-YYYY to YYYY-MM-DD
function convertDateToddmmyyyy(dateString) {
    if (!dateString) return ''; // Return empty string for invalid or empty date
    const [year, month, day] = dateString.split('-');
    return `${day}-${month}-${year}`;
}
function calculateSalary() {
    let basicDA = parseFloat(document.getElementById('basicDA').value) || 0;
    let hra = parseFloat(document.getElementById('hra').value) || 0;
    let conveyance = parseFloat(document.getElementById('conveyance').value) || 0;
    let washingAllowance = parseFloat(document.getElementById('washingAllowance').value) || 0;
    let daysWorked = parseFloat(document.getElementById('daysWorked').value) || 0;
    let leaveGiven = parseFloat(document.getElementById('leaveGiven').value) || 0;
    let totalDays = daysWorked + leaveGiven;
    document.getElementById('totalDays').value = totalDays;
    let fixedSalary = basicDA + hra + conveyance + washingAllowance;
    document.getElementById('fixedSalary').value = fixedSalary;
    let drawnSalary = (fixedSalary / 30) * totalDays;
    document.getElementById('drawnSalary').value = drawnSalary;
    let incentiveHrs = parseFloat(document.getElementById('incentiveHrs').value) || 0;
    let incentiveRate = parseFloat(document.getElementById('incentiveRate').value) || 0;
    let incentiveAmount = incentiveHrs * incentiveRate;
    document.getElementById('incentiveAmount').value = incentiveAmount;
    let attendanceBonus = parseFloat(document.getElementById('attendanceBonus').value) || 0;
    let grossSalary = drawnSalary + incentiveAmount + attendanceBonus;
    document.getElementById('grossSalary').value = grossSalary;
    let esi = parseFloat(document.getElementById('esi').value) || 0;
    let pf = parseFloat(document.getElementById('pf').value) || 0;
    let pt = parseFloat(document.getElementById('pt').value) || 0;
    let advanceDeduction = parseFloat(document.getElementById('advanceDeduction').value) || 0;
    let netSalary = grossSalary - (esi + pf + pt + advanceDeduction);
    document.getElementById('netSalary').value = netSalary;
}
function generatePDF() {
    let element = document.getElementById('salarySlip');
    html2pdf().from(element).save('Salary_Slip.pdf');
}

function clearForm() {
    document.querySelectorAll('input').forEach(input => input.value = '');
}

// Function to populate the employee IDs in the datalist
function populateEmployeeIds() {
    const employeeIdsData = JSON.parse(localStorage.getItem('employeesData')) || [];
    const dataList = document.getElementById('employeeIdList');
    
    // Clear the current options
    dataList.innerHTML = '';

    // Add new options for each employee ID
    employeeIdsData.forEach(id => {
        const option = document.createElement('option');
        option.value = id.employeeId1;
        dataList.appendChild(option);
    });
}

// Function to fill employeeName based on employeeId selection or entry
function fillEmployeeName() {
    const employeeId = document.getElementById('employeeId').value;
    const employeeData = JSON.parse(localStorage.getItem('employeesData')) || []; // Retrieve employee data from localStorage
    const employeeNameField = document.getElementById('employeeName'); // The field where employee name will be populated

    // Find the employee by employeeId1
    const employee = employeeData.find(e => e.employeeId1 === employeeId);
    // If a matching employee is found, set the employeeName field's value
    if (employee) {
        employeeNameField.value = employee.employeeName;
    } else {
        employeeNameField.value = ''; // Clear the field if no match is found
    }
}

// Call the populateEmployeeIds function on page load to add options
window.onload = function() {
    populateEmployeeIds();
    
    // Set up event listener for input changes or selection
    // document.getElementById('employeeId').addEventListener('input', fillEmployeeName);

    // Listen for input changes on the employeeId field
    document.getElementById('employeeId').addEventListener('input', function() {
        const employeeId = this.value; // Get the entered Employee ID

        // Retrieve the employee data from localStorage
        const existingEmployees = JSON.parse(localStorage.getItem('employeesData')) || [];

        // Find the employee based on the employeeId
        const employee = existingEmployees.find(emp => emp.employeeId1 === employeeId);

        // If the employee is found, prefill the employee name field
        if (employee) {
            document.getElementById('employeeName').value = employee.employeeName;
        } else {
            // If no matching employee, clear the employee name field
            document.getElementById('employeeName').value = '';
        }
    });

};


// console.log(JSON.parse(localStorage.getItem('employeeSalaryData')));  // Check the structure of the existing data