 // Wait for DOM to be fully loaded
    document.addEventListener('DOMContentLoaded', function() {
        // Attendance Chart - with null check
        const attendanceCtx = document.getElementById('attendanceChart');
        if (attendanceCtx) {
            new Chart(attendanceCtx.getContext('2d'), {
                type: 'bar',
                data: {
                    labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
                    datasets: [
                        {
                            label: 'Present',
                            data: [120, 125, 130, 135, 138, 118],
                            backgroundColor: '#4cc9f0',
                            borderRadius: 5
                        },
                        {
                            label: 'Absent',
                            data: [22, 17, 12, 7, 4, 24],
                            backgroundColor: '#f72585',
                            borderRadius: 5
                        }
                    ]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: {
                        x: {
                            grid: {
                                display: false
                            }
                        },
                        y: {
                            beginAtZero: true,
                            grid: {
                                borderDash: [5]
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            position: 'top',
                        },
                        tooltip: {
                            mode: 'index',
                            intersect: false
                        }
                    }
                }
            });
        }

        // Department Chart - with null check
        const departmentCtx = document.getElementById('departmentChart');
        if (departmentCtx) {
            new Chart(departmentCtx.getContext('2d'), {
                type: 'doughnut',
                data: {
                    labels: ['Development', 'Marketing', 'Sales', 'HR', 'Operations'],
                    datasets: [{
                        data: [45, 22, 30, 15, 30],
                        backgroundColor: [
                            '#4361ee',
                            '#4cc9f0',
                            '#f72585',
                            '#4895ef',
                            '#3f37c9'
                        ],
                        borderWidth: 0
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            position: 'right',
                        },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    const label = context.label || '';
                                    const value = context.raw || 0;
                                    const total = context.dataset.data.reduce((a, b) => a + b, 0);
                                    const percentage = Math.round((value / total) * 100);
                                    return `${label}: ${value} (${percentage}%)`;
                                }
                            }
                        }
                    }
                }
            });
        }

        // Improved mobile menu toggle
        const menuItems = document.querySelectorAll('.menu-item');
        if (menuItems.length > 0) {
            menuItems.forEach(item => {
                item.addEventListener('click', function(e) {
                    // Prevent default only if it's an anchor tag
                    if (this.tagName === 'A') {
                        e.preventDefault();
                    }
                    
                    // Remove active class from all items
                    menuItems.forEach(i => i.classList.remove('active'));
                    
                    // Add active class to clicked item
                    this.classList.add('active');
                    
                    // If it's a link, navigate after a small delay
                    if (this.tagName === 'A') {
                        setTimeout(() => {
                            window.location.href = this.href;
                        }, 300);
                    }
                });
            });
        }
    });