// document.getElementById('new-employer-popup-overlay').style.display = 'block';
// localStorage.removeItem('employeeAttendanceData');  

window.onload = function() {
    var today = new Date();    
    var month = today.getMonth() + 1;
    var year = today.getFullYear();
    month = month < 10 ? '0' + month : month;
    document.getElementById("monthYear").value = year + '-' + month;
    loadEmployeesAttendance();
}

// Close the popup when clicking on the "Close" button inside the popup
document.getElementById('closePopup').addEventListener('click', function() {
    // Hide the popup by setting display to 'none'
    document.getElementById('newEmployerForm').reset();
    document.getElementById('new-employer-popup-overlay').style.display = 'none';
});

/**
 * ----------------------------- script for "View" button-------------------------------------------------------------------
 */

// Event listener for the "View" button in the RFQ Details table
document.getElementById('dataTable').addEventListener('click', function(event) {
    // Check if the clicked element is the view button
    if (event.target && event.target.id === 'employee-pdf') {
        const pdfUrl = event.target.dataset.pdfUrl; // Get the PDF URL from the button's data attribute
        if (pdfUrl) {
            // Set the PDF URL in the iframe for viewing
            document.getElementById('pdfViewer').src = pdfUrl;
            // Display the modal
            $('#pdfModal').modal('show');
        } else {
            alert("No PDF file found for this entry.");
        }
    }
});

/**
 * ----------------------------- script for import details-------------------------------------------------------------------
 */

// Trigger the modal when the Import button is clicked
document.getElementById('import-button').addEventListener('click', function() {
    $('#importModal').modal('show');
});

// Handle the Excel file import
document.getElementById('importDataBtn').addEventListener('click', function () {
    const fileInput = document.getElementById('excelFile');
    const file = fileInput.files[0];

    if (file) {
        const reader = new FileReader();
        reader.onload = function (e) {
            const data = e.target.result;
            const workbook = XLSX.read(data, { type: 'binary' });
            const sheetName = workbook.SheetNames[0];
            const sheet = workbook.Sheets[sheetName];
            const excelData = XLSX.utils.sheet_to_json(sheet);

            // Convert Excel data to the required format for your table
            const formattedData = excelData.map(row => {
                const monthYear = row['Month & Year'] || ''; 

                // If it's an Excel serial number (numeric value), convert it
                let formattedMonthYear = '';
                if (!isNaN(monthYear) && monthYear > 0) {
                    const date = excelSerialToDate(monthYear);
                    // Convert the Date to Month, YYYY format
                    formattedMonthYear = date.toLocaleString('default', { month: 'long', year: 'numeric' });
                } else {
                    // If it's already in the MM-YYYY format (string), split and format it
                    const [month, year] = monthYear.split('-');
                    formattedMonthYear = new Date(year, month - 1).toLocaleString('default', { month: 'long', year: 'numeric' });
                }
                return {
                    month_year: formattedMonthYear,  // Format Month & Year as "Month, YYYY"
                    employeeName: row['Employee Name'] || '',
                    employeeId: row['Employee ID'] || '',
                    gender: row['Gender'] || '',
                    dateOfBirth: excelDateToJSDate(row['Date of Birth']) || '',
                    dateOfJoining: excelDateToJSDate(row['Date of Joining']) || '',
                    department: row['Department'] || '',
                    designation: row['Designation'] || '',
                    daysWorked: row['Days Worked'] || '',
                    sundaysEligible: row['Sundays Eligible'] || '',
                    holidays: row['Holidays'] || '',
                    leaveEnjoyed: row['Leave Enjoyed'] || '',
                    totalPaidDays: row['Total Paid Days'] || '',
                    absent: row['Absent'] || '',
                    firstShifts: row['1st Shifts'] || '',
                    nightShifts: row['Night Shifts'] || '',
                    otHours: row['OT Hours'] || '',
                    shortageHours: row['Shortage Hours'] || '',
                };
            });

            // Save the data in localStorage (if needed)
            const existingData = JSON.parse(localStorage.getItem('employeeAttendanceData')) || [];
            const mergedData = mergeEmployeeData(existingData, formattedData);
            localStorage.setItem('employeeAttendanceData', JSON.stringify(mergedData));

            // Append the new data to the DataTable
            // $('#dataTable').DataTable();
            loadEmployeesAttendance();

            // Close the modal and notify the user
            $('#importModal').modal('hide');
            alert('Employee attendance details imported successfully!');
            window.location.reload();
        };

        reader.readAsBinaryString(file);
    } else {
        alert('Please choose an Excel file.');
    }
});


/**
 * ----------------------------- script for export-buttons-------------------------------------------------------------------
 */

$(document).ready(function () {

    // Initialize the DataTable
    // $('#dataTable').DataTable();

    // Initialize dropdown behavior
    $('#columnVisibility').on('click', function(event) {
        event.preventDefault(); // Prevent default action
        const $dropdownMenu = $(this).next('.dropdown-menu'); // Target the specific dropdown menu
        $('.dropdown-menu').not($dropdownMenu).hide(); // Hide other dropdowns
        $dropdownMenu.toggle(); // Toggle the associated dropdown menu
    });

    // Close dropdown when clicking outside
    $(document).on('click', function(e) {
        if (!$(e.target).closest('.dropdown').length) {
            $('.dropdown-menu').hide(); // Hide all dropdowns
        }
    });

    // Handle column visibility when the checkbox state changes
    $(document).on('change', '.column-toggle', function () {
        updateColumnVisibility();
    });

    // Initial column visibility update
    updateColumnVisibility();

    // Function to copy visible table data
    $("#copy").click(function () {
        const table = document.getElementById("dataTable");
        const rows = table.querySelectorAll("tbody tr");
        let textToCopy = "";
    
        // Get the value from the 'monthYear' input field
        const monthYear = document.getElementById('monthYear').value;
        const [year, month] = monthYear.split('-'); // Split into year and month
    
        // Map the month number to the month name
        const monthNames = [
            "January", "February", "March", "April", "May", "June",
            "July", "August", "September", "October", "November", "December"
        ];
        const monthName = monthNames[parseInt(month) - 1]; // Get the month name (month is 1-based, array is 0-based)
        const formattedMonthYear = `${monthName}, ${year}`; // Format as 'Month, YYYY'
    
        // Get headers for copying
        const headers = ['Month & Year']; // Add 'Month & Year' as the first column header
        table.querySelectorAll("thead th").forEach((header) => {
            const headerText = header.innerText.trim();
            if (headerText !== 'Image' && headerText !== 'Actions' && headerText !== 'View Details' && $(header).is(':visible')) {
                headers.push(headerText);
            }
        });
        textToCopy += headers.join("\t") + "\n"; // Add headers with 'Month & Year'
    
        // Get data from the rows, including the formatted 'Month, YYYY' in the first column
        rows.forEach(row => {
            const cols = row.querySelectorAll("td");
            const rowData = [formattedMonthYear]; // Add the formatted 'Month, YYYY' as the first column in each row
    
            cols.forEach((col) => {
                const headerText = table.querySelectorAll("th")[col.cellIndex].innerText.trim();
    
                // Exclude the 'Image', 'Actions', and 'View Details' columns and check for visibility
                if (headerText !== 'Image' && headerText !== 'Actions' && headerText !== 'View Details' && $(col).is(':visible')) {
                    rowData.push(col.innerText.trim()); // Add data for the row, separated by tab
                }
            });
            textToCopy += rowData.join("\t") + "\n"; // Join the row data and add to the text
        });
    
        // Copy the table data to the clipboard
        navigator.clipboard.writeText(textToCopy.trim());
        alert("Table data copied to clipboard!");
    });    

    // Function to export visible table data as PDF
    $("#export-pdf").click(function () {
        const { jsPDF } = window.jspdf;
        const doc = new jsPDF({ orientation: 'landscape' }); // Set orientation to landscape
        const table = document.getElementById("dataTable");
        const headers = [];
        const data = [];
    
        // Get the value from the 'monthYear' input field
        const monthYear = document.getElementById('monthYear').value;
        const [year, month] = monthYear.split('-'); // Split into year and month
    
        // Map the month number to the month name
        const monthNames = [
            "January", "February", "March", "April", "May", "June",
            "July", "August", "September", "October", "November", "December"
        ];
        const monthName = monthNames[parseInt(month) - 1]; // Get the month name (month is 1-based, array is 0-based)
        const formattedMonthYear = `${monthName}, ${year}`; // Format as 'Month, YYYY'
    
        // Add 'Month & Year' header as the first column in the PDF
        headers.push('Month & Year');
        
        // Get headers from the table, excluding the 'Status' column
        const headerCols = table.querySelectorAll("thead th");
        headerCols.forEach((header) => {
            const headerText = header.innerText.trim();
            // Exclude the 'Status' column and check for visibility
            if (headerText !== 'Image' && headerText !== 'Actions' && headerText !== 'View Details' && $(header).is(':visible')) {
                headers.push(headerText); // Push other headers after the "Month & Year"
            }
        });
    
        // Get data from the table rows, including the formatted 'Month & Year' as the first column in each row
        const rows = table.querySelectorAll("tbody tr");
        rows.forEach(row => {
            const rowData = [formattedMonthYear]; // Add the formatted Month, YYYY as the first column in each row
            const cols = row.querySelectorAll("td");
            cols.forEach((col) => {
                const headerText = table.querySelectorAll("thead th")[col.cellIndex].innerText.trim();
                // Exclude the 'Status' column by comparing header text and check for visibility
                if (headerText !== 'Image' && headerText !== 'Actions' && headerText !== 'View Details' && $(col).is(':visible')) {
                    rowData.push(col.innerText); // Add other column data
                }
            });
            if (rowData.length > 0) { // Add only if the row has data
                data.push(rowData); // Push row data to be included in the table
            }
        });
    
        // Generate the PDF using autoTable plugin
        doc.autoTable({
            head: [headers],
            body: data,
            theme: 'grid',
            styles: { fontSize: 10 }
        });
    
        // Save the PDF
        doc.save('EmployeeAttendance.pdf');
    });
    
    // Function to export visible table data as Excel
    $("#export-excel").click(function () {
        const table = document.getElementById("dataTable");
        const wb = XLSX.utils.book_new();
        const ws = XLSX.utils.aoa_to_sheet([]);
    
        // Get the value from the 'monthYear' input field
        const monthYear = document.getElementById('monthYear').value;
        const [year, month] = monthYear.split('-'); // Split into year and month
    
        // Map the month number to the month name
        const monthNames = [
            "January", "February", "March", "April", "May", "June",
            "July", "August", "September", "October", "November", "December"
        ];
        const monthName = monthNames[parseInt(month) - 1]; // Get the month name (month is 1-based, array is 0-based)
    
        // const formattedMonthYear = `${monthName}, ${year}`; // Format as 'Month, YYYY'
        const formattedMonthYear = `${month}-${year}`;
    
        // Get headers from the table, excluding the 'Status' column
        const headerRow = ['Month & Year']; // Add 'Month & Year' as the first header
        const headerCells = table.querySelectorAll("thead th");
        headerCells.forEach((headerCell) => {
            const headerText = headerCell.innerText.trim();
            if (headerText !== 'Image' && headerText !== 'Actions' && headerText !== 'View Details' && $(headerCell).is(':visible')) {
                headerRow.push(headerText); // Add other headers
            }
        });
        XLSX.utils.sheet_add_aoa(ws, [headerRow], { origin: "A1" });
    
        // Get data from the table rows, excluding the 'Status' column
        const rows = table.querySelectorAll("tbody tr");
        rows.forEach((row, rowIndex) => {
            const rowData = [formattedMonthYear]; // Add the formatted Month, YYYY as the first column in each row
            const cols = row.querySelectorAll("td");
            cols.forEach((col) => {
                const headerText = table.querySelectorAll("thead th")[col.cellIndex].innerText.trim();
                if (headerText !== 'Image' && headerText !== 'Actions' && headerText !== 'View Details' && $(col).is(':visible')) {
                    rowData.push(col.innerText);
                }
            });
            if (rowData.length > 0) { // Add only if the row has data
                XLSX.utils.sheet_add_aoa(ws, [rowData], { origin: `A${rowIndex + 2}` });
            }
        });
    
        XLSX.utils.book_append_sheet(wb, ws, "Sheet1");
        XLSX.writeFile(wb, "EmployeeAttendance.xlsx"); // Set the default filename
    });

    // Function to print the visible table data
    $("#print").click(function () {
    const table = document.getElementById("dataTable");
    const newWindow = window.open("");
    newWindow.document.write("<html><head><title>Print</title></head><body>");
    newWindow.document.write("<table border='1' style='border-collapse: collapse;'>");

    // Get the value from the 'monthYear' input field
    const monthYear = document.getElementById('monthYear').value;
    const [year, month] = monthYear.split('-'); // Split into year and month

    // Map the month number to the month name
    const monthNames = [
        "January", "February", "March", "April", "May", "June",
        "July", "August", "September", "October", "November", "December"
    ];
    const monthName = monthNames[parseInt(month) - 1]; // Get the month name (month is 1-based, array is 0-based)
    const formattedMonthYear = `${monthName}, ${year}`; // Format as 'Month, YYYY'

    // Add 'Month & Year' header as the first column in the print view
    newWindow.document.write("<tr><th>Month & Year</th>");
    table.querySelectorAll("thead th").forEach(header => {
        const headerText = header.innerText.trim();
        // Exclude the 'Status' column and check for visibility
        if (headerText !== 'Image' && headerText !== 'Actions' && headerText !== 'View Details' && $(header).is(':visible')) {
            newWindow.document.write(`<th>${headerText}</th>`);
        }
    });
    newWindow.document.write("</tr>");

    // Get data from the table rows
    const rows = table.querySelectorAll("tbody tr");
    rows.forEach(row => {
        newWindow.document.write("<tr>");
        newWindow.document.write(`<td>${formattedMonthYear}</td>`); // Add formatted Month, YYYY as the first column in each row
        const cols = row.querySelectorAll("td");
        cols.forEach((col) => {
            const headerText = table.querySelectorAll("thead th")[col.cellIndex].innerText.trim();
            // Exclude the 'Status' column by comparing header text and check for visibility
            if (headerText !== 'Image' && headerText !== 'Actions' && headerText !== 'View Details' && $(col).is(':visible')) {
                newWindow.document.write(`<td>${col.innerText}</td>`);
            }
        });
        newWindow.document.write("</tr>");
    });

    newWindow.document.write("</table>");
    newWindow.document.write("</body></html>");
    newWindow.document.close();
    newWindow.print();
});


});
// Function to update column visibility based on checkbox state
function updateColumnVisibility() {
    $(".column-toggle").each(function () {
        const columnIndex = $(this).val();
        const isChecked = $(this).is(":checked");
        const table = $("#dataTable"); // Ensure this ID matches your actual table ID

        // Show or hide the column based on checkbox state
        table.find(`tr`).each(function () {
            $(this).find(`td:eq(${columnIndex}), th:eq(${columnIndex})`).css('display', isChecked ? '' : 'none');
        });
    });
}

/**
 * ----------------------------- script for -------------------------------------------------------------------
 */

// Function to load employee data from local storage
function loadEmployeesAttendance() {
    // var today = new Date();    
    // var month = today.getMonth() + 1;
    // var year = today.getFullYear();
    // month = month < 10 ? '0' + month : month;
    // const currentMonth= year + '-' + month;


    const selectedMonthYear = document.getElementById('monthYear').value;// || currentMonth;
    const employees = JSON.parse(localStorage.getItem('employeeAttendanceData')) || [];
    const tableBody = document.querySelector('#dataTable tbody');

    // Clear the table before adding new rows
    tableBody.innerHTML = ''; // This clears the table before populating it with filtered data

    // Filter employees based on the selected month-year
    const filteredEmployees = employees.filter(employee => {
        const employeeMonthYear = employee.month_year || ''; // Get employee's 'month_year'

        // Convert 'employeeMonthYear' (like 'June 2025') to 'YYYY-MM' format
        const employeeDate = new Date(employeeMonthYear);
        const employeeFormattedMonthYear = `${employeeDate.getFullYear()}-${(employeeDate.getMonth() + 1).toString().padStart(2, '0')}`;

        // Compare employeeFormattedMonthYear with selectedMonthYear (which is in 'YYYY-MM' format)
        return employeeFormattedMonthYear === selectedMonthYear;
    });
    // console.log(employeeFormattedMonthYear +'='+ selectedMonthYear);
    // console.log(filteredEmployees);

    // Add rows for each filtered employee
    filteredEmployees.forEach((employee, index) => {
        const newRow = document.createElement('tr');
        
        newRow.innerHTML = `
            <td>${employee.employeeName}</td>
            <td>${employee.employeeId}</td>
            <td>${employee.gender}</td>
            <td>${employee.dateOfBirth}</td>
            <td>${employee.dateOfJoining}</td>
            <td>${employee.department}</td>
            <td>${employee.designation}</td>
            <td>${employee.daysWorked}</td>
            <td>${employee.sundaysEligible}</td>
            <td>${employee.holidays}</td>
            <td>${employee.leaveEnjoyed}</td>
            <td>${employee.totalPaidDays}</td>
            <td>${employee.absent}</td>
            <td>${employee.firstShifts}</td>
            <td>${employee.nightShifts}</td>
            <td>${employee.otHours}</td>
            <td>${employee.shortageHours}</td>
            <td>
                <div class="row">
                    <button class="emp-action-btn emp-action-edit" data-index="${index}">
                        <span class="icon" title="Edit"><i class="fas fa-pencil-alt"></i></span>
                    </button>
                    <button class="emp-action-btn emp-action-delete" data-index="${index}">
                        <span class="icon" title="Delete"><i class="fas fa-trash-alt"></i></span>
                    </button>
                </div>
            </td>
        `;
        tableBody.appendChild(newRow);
    });

    // Reinitialize DataTable to apply the changes after filtering
    $('#dataTable').DataTable();

    // Add event listeners for edit and delete buttons
    document.querySelectorAll('.emp-action-edit').forEach((btn) =>
        btn.addEventListener('click', handleEditEmployee)
    );
    document.querySelectorAll('.emp-action-delete').forEach((btn) =>
        btn.addEventListener('click', handleDeleteEmployee)
    );
}

// Function to handle the edit button click for employee salary
function handleEditEmployee(event) {
    const index = event.target.closest('button').dataset.index;
    const employees = JSON.parse(localStorage.getItem('employeeAttendanceData')) || [];
    const employee = employees[index];

    // Prefill the popup form with employee attendance data
    document.getElementById('editMonthYear').value = document.getElementById('monthYear').value;
    document.getElementById('employeeId').value = employee.employeeId;
    document.getElementById('employeeName').value = employee.employeeName;
    document.getElementById('gender').value = employee.gender;
    document.getElementById('dob').value = convertDateToISO(employee.dateOfBirth);
    document.getElementById('doj').value = convertDateToISO(employee.dateOfJoining);
    document.getElementById('department').value = employee.department;
    document.getElementById('designation').value = employee.designation;
    document.getElementById('daysWorked').value = employee.daysWorked;
    document.getElementById('sundaysEligible').value = employee.sundaysEligible;
    document.getElementById('holidays').value = employee.holidays;
    document.getElementById('leaveEnjoyed').value = employee.leaveEnjoyed;
    document.getElementById('totalPaidDays').value = employee.totalPaidDays;
    document.getElementById('absent').value = employee.absent;
    document.getElementById('firstShift').value = employee.firstShifts;
    document.getElementById('nightShift').value = employee.nightShifts;
    document.getElementById('otHours').value = employee.otHours;
    document.getElementById('shortageHours').value = employee.shortageHours;

    // Show the popup to edit the employee attendance details
    document.getElementById('new-employer-popup-overlay').style.display = 'block';

    // Store the index in a hidden input or variable to update the employee after editing
    // This will help with updating the data after clicking 'Save'
    // document.getElementById('employeeIndex').value = index;

    console.log(document.getElementById('editMonthYear').value);
}


// Function to handle delete button click
function handleDeleteEmployee(event) {
    // const row = event.target.closest('tr');
    // const deleteEmployeeId = row.cells[1].innerText;
    // const monthYear = document.getElementById('monthYear').value || ''; 
    // let formattedMonthYear = '';
    // const [year, month] = monthYear.split('-');
    // formattedMonthYear = new Date(year, month - 1).toLocaleString('default', { month: 'long', year: 'numeric' });
    // const employees = JSON.parse(localStorage.getItem('employeeAttendanceData')) || [];
    // const index = employees.findIndex(emp => (emp.employeeId === deleteEmployeeId)&&(emp.month_year === formattedMonthYear));


    const index = event.target.closest('button').dataset.index;
    const employees = JSON.parse(localStorage.getItem('employeeAttendanceData')) || [];
    const employeeId = employees[index].employeeId;

    // Show confirmation alert
    const confirmDelete = confirm(`Are you sure you want to delete the data of Employee ID: ${employeeId}?`);

    if (confirmDelete) {
        // Remove employee from the list
        employees.splice(index, 1);

        // Save updated employee list to local storage
        localStorage.setItem('employeeAttendanceData', JSON.stringify(employees));

        // Reload the employee list in the table
        loadEmployeesAttendance(); // This reloads the employee data without needing a full page refresh
    }
}


// Load employees on page load
// document.addEventListener('DOMContentLoaded', loadEmployeesAttendance);
// const AllEmployees = JSON.parse(localStorage.getItem('employeeAttendanceData')) || [];
// $('#dataTable').DataTable().clear().rows.add(AllEmployees).draw();

// Event listener for adding a new employee
document.getElementById('newEmployerForm').addEventListener('submit', function (event) {
    event.preventDefault();

    saveEmployeeAttendance();

    // Reload the table
    // loadEmployeesAttendance();
    window.location.reload();

    // Clear the form and hide the popup
    document.getElementById('newEmployerForm').reset();
    document.getElementById('new-employer-popup-overlay').style.display = 'none';
});


function saveEmployeeAttendance() {
    // Get all employee details from the form
    const monthYear = document.getElementById('editMonthYear').value || ''; 
    let formattedMonthYear = '';
    const [year, month] = monthYear.split('-');
    formattedMonthYear = new Date(year, month - 1).toLocaleString('default', { month: 'long', year: 'numeric' });

    const month_year = formattedMonthYear;
    const employeeName = document.getElementById('employeeName').value || '';
    const employeeId = document.getElementById('employeeId').value || '';
    const gender = document.getElementById('gender').value || '';
    const dateOfBirth = convertDateToddmmyyyy(document.getElementById('dob').value) || '';
    const dateOfJoining = convertDateToddmmyyyy(document.getElementById('doj').value) || '';
    const department = document.getElementById('department').value || '';
    const designation = document.getElementById('designation').value || '';
    const daysWorked = document.getElementById('daysWorked').value || '';
    const sundaysEligible = document.getElementById('sundaysEligible').value || '';
    const holidays = document.getElementById('holidays').value || '';
    const leaveEnjoyed = document.getElementById('leaveEnjoyed').value || '';
    const totalPaidDays = document.getElementById('totalPaidDays').value || '';
    const absent = document.getElementById('absent').value || '';
    const firstShifts = document.getElementById('firstShift').value || '';
    const nightShifts = document.getElementById('nightShift').value || '';
    const otHours = document.getElementById('otHours').value || '';
    const shortageHours = document.getElementById('shortageHours').value || '';

    let employee = {
        month_year,
        employeeName,        
        employeeId,
        gender,
        dateOfBirth,
        dateOfJoining,
        department,
        designation,
        daysWorked,
        sundaysEligible,
        holidays,
        leaveEnjoyed,
        totalPaidDays,
        absent,
        firstShifts,
        nightShifts,
        otHours,
        shortageHours,
    };
    saveAttendanceData(employee);
}

function saveAttendanceData(employee) {
    const existingEmployees = JSON.parse(localStorage.getItem('employeeAttendanceData')) || [];

    // Check if an employee with the same ID already exists
    const existingIndex = existingEmployees.findIndex(item => (item.employeeId === employee.employeeId) && (item.month_year === employee.month_year));

    if (existingIndex !== -1) {
        // Employee with the same ID exists, ask for confirmation to overwrite
        const userConfirmation = confirm(`Press 'OK' to overwrite the attendance data of employee ID: ${employee.employeeId} of month ${employee.month_year}?`);
        
        if (userConfirmation) {
            existingEmployees[existingIndex] = employee; // Overwrite existing data
            alert(`Employee attendance data has been updated successfully.`);
        } else {
            alert("The data was not saved.");
            return;
        }
    } else {
        // No existing data with the same ID, add new employee
        existingEmployees.push(employee);
        alert(`Employee attendance data saved successfully.`);
    }

    // Save the updated employee list to local storage
    localStorage.setItem('employeeAttendanceData', JSON.stringify(existingEmployees));
}

// Merge new employee data with existing, avoiding duplicates
function mergeEmployeeData(existingData, newData) {
    newData.forEach(newEmployee => {
        const existingIndex = existingData.findIndex(emp => (emp.employeeId === newEmployee.employeeId)&&(emp.month_year === newEmployee.month_year));
        if (existingIndex !== -1) {
            // Replace existing employee data with the new one
            existingData[existingIndex] = newEmployee;
        } else {
            // Add new employee data
            existingData.push(newEmployee);
        }
    });
    return existingData;
}

// Function to convert Excel numeric date to JavaScript Date
function excelDateToJSDate(excelDate) {
    if (!excelDate) return '';
    const parsedDate = new Date((excelDate - 25569) * 86400 * 1000);
    const day = String(parsedDate.getDate()).padStart(2, '0');
    const month = String(parsedDate.getMonth() + 1).padStart(2, '0'); // Months are 0-indexed
    const year = parsedDate.getFullYear();
    return `${day}-${month}-${year}`;
}
// Utility function to convert DD-MM-YYYY to YYYY-MM-DD
function convertDateToISO(dateString) {
    if (!dateString) return ''; // Return empty string for invalid or empty date
    const [day, month, year] = dateString.split('-');
    return `${year}-${month}-${day}`;
}
// Utility function to convert DD-MM-YYYY to YYYY-MM-DD
function convertDateToddmmyyyy(dateString) {
    if (!dateString) return ''; // Return empty string for invalid or empty date
    const [year, month, day] = dateString.split('-');
    return `${day}-${month}-${year}`;
}
// Convert Excel serial number to JavaScript Date object
function excelSerialToDate(serial) {
    const startDate = new Date(1899, 11, 30); // Excel uses 1900 as the starting date, but there's an off-by-one error (Excel starts from 1 instead of 0)
    startDate.setDate(startDate.getDate() + serial);
    return startDate;
}

function clearForm() {
    document.querySelectorAll('input').forEach(input => input.value = '');
}
// function handleEditEmployee(event) {
//     const row = event.target.closest('tr');
//     const editEmployeeId = row.cells[1].innerText;
//     const monthYear = document.getElementById('monthYear').value || ''; 
//     let formattedMonthYear = '';
//     const [year, month] = monthYear.split('-');
//     formattedMonthYear = new Date(year, month - 1).toLocaleString('default', { month: 'long', year: 'numeric' });
//     const employees = JSON.parse(localStorage.getItem('employeeAttendanceData')) || [];
//     const index = employees.findIndex(emp => (emp.employeeId === editEmployeeId)&&(emp.month_year === formattedMonthYear));

//     // const index = event.target.closest('button').dataset.index;
//     const employee = employees[index];

//     console.log(formattedMonthYear);

//     // Prefill the popup form with employee attendance data
//     document.getElementById('editMonthYear').value = document.getElementById('monthYear').value;
//     document.getElementById('employeeId').value = employee.employeeId;
//     document.getElementById('employeeName').value = employee.employeeName;
//     document.getElementById('gender').value = employee.gender;
//     document.getElementById('dob').value = convertDateToISO(employee.dateOfBirth);
//     document.getElementById('doj').value = convertDateToISO(employee.dateOfJoining);
//     document.getElementById('department').value = employee.department;
//     document.getElementById('designation').value = employee.designation;
//     document.getElementById('daysWorked').value = employee.daysWorked;
//     document.getElementById('sundaysEligible').value = employee.sundaysEligible;
//     document.getElementById('holidays').value = employee.holidays;
//     document.getElementById('leaveEnjoyed').value = employee.leaveEnjoyed;
//     document.getElementById('totalPaidDays').value = employee.totalPaidDays;
//     document.getElementById('absent').value = employee.absent;
//     document.getElementById('firstShift').value = employee.firstShifts;
//     document.getElementById('nightShift').value = employee.nightShifts;
//     document.getElementById('otHours').value = employee.otHours;
//     document.getElementById('shortageHours').value = employee.shortageHours;

//     // Show the popup to edit the employee attendance details
//     document.getElementById('new-employer-popup-overlay').style.display = 'block';
// }

console.log(JSON.parse(localStorage.getItem('employeeAttendanceData')));  // Check the structure of the existing data