window.addEventListener('load', () => {
    // localStorage.removeItem('CustomerDataList');

    // Set the customer ID when the form loads
    // document.getElementById('customerId').value = generateCustomerId();
    // console.log('edit Id - '+ sessionStorage.getItem('currentCustId'));
    
});

const editComapanyId = sessionStorage.getItem('currentCustId');

document.addEventListener('DOMContentLoaded', async function () {
    // const editComapanyId = sessionStorage.getItem('currentCustId');

    if (editComapanyId) {
        // Fetch customer data by companyId
        const response = await fetch(`https://umbreyengineering.com/api/customer/${editComapanyId}`);
        const companyData = await response.json();

        if (companyData) {

            if (companyData.companyId1.startsWith("UEPL/CUS/")) {
                document.getElementById('customer').checked = true;
                document.getElementById('vendorCompanyRole').classList.add('hidden');
            } else if (companyData.companyId1.startsWith("UEPL/VEN/")) {
                document.getElementById('vendor').checked = true;
                document.getElementById('customerCompanyRole').classList.add('hidden');
            } else if (companyData.companyId1.startsWith("UEPL/CV/")) {
                document.getElementById('Both').checked = true;
                document.getElementById('vendorCompanyRole').classList.add('hidden');
                document.getElementById('customerCompanyRole').classList.add('hidden');
            }
            // Prefill form fields with the existing data
            document.getElementById('company-nickname').value = companyData.acronym || '';
            document.getElementById('company').value = companyData.companyName || '';
            document.getElementById('email').value = companyData.companyEmail || '';
            document.getElementById('company-contact-1').value = companyData.companyContact || '';
            document.getElementById('company-contact-2').value = companyData.secondaryContact || '';
            document.getElementById('gstno').value = companyData.gstNo || '';
            document.getElementById('panno').value = companyData.panNo || '';
            document.getElementById('msme-udyam').value = companyData.msmeNo || '';
            document.getElementById('iecno').value = companyData.iecNo || '';
            document.getElementById('url').value = companyData.websiteUrl || '';
            document.getElementById('billingAddress').value = companyData.billingAddress || '';
            document.getElementById('shippingAddress').value = companyData.shippingAddress || '';
            document.getElementById('bank-name').value = companyData.bankName || '';
            document.getElementById('branch-name').value = companyData.branchName || '';
            document.getElementById('account-number').value = companyData.accountNumber || '';
            document.getElementById('account-type').value = companyData.accountType || '';
            document.getElementById('account-holder-name').value = companyData.accountHolderName || '';
            document.getElementById('account-currency').value = companyData.accountCurrency || '';
            document.getElementById('ifsc-code').value = companyData.ifscCode || '';
            document.getElementById('swift-code').value = companyData.swiftCode || '';
            
            // Set company type
            const companyTypeElement = document.getElementById('company-type');
            const otherInputElement = document.getElementById('other-input');
            const otherCompanyTypeElement = document.getElementById('other-company-type');
            if (companyData.companyType === 'Other') {
                companyTypeElement.value = 'Other';
                otherInputElement.style.display = 'block';
                otherCompanyTypeElement.value = companyData.companyType;
            } else {
                companyTypeElement.value = companyData.companyType;
                otherInputElement.style.display = 'none';
                otherCompanyTypeElement.value = '';
            }

            // Prefill contact persons
            populateContactPersons('contact-person-container', companyData.ContactPerson || []);
        }
    }
    sessionStorage.removeItem('currentCustId');
});

// Function to populate contact persons dynamically
function populateContactPersons(containerId, contactPersons) {
    const container = document.getElementById(containerId);
    container.innerHTML = ''; // Clear existing contact persons
    
    contactPersons.forEach((person, index) => {
        const contactPersonHTML = `
            <div class="contact-person-block" id="contact-person-block-${index + 1}">
                <div class="row contact-person">
                    <div class="col-md-12">
                        <h6>Contact Person ${index + 1}</h6>
                        <button type="button" class="btn btn-sm delete-contact-person" data-contact-id="${index + 1}">X</button>
                    </div>
                    <div class="col-md-6">
                        <label for="contact-person">Name</label>
                        <input type="text" name="person-name" placeholder="Name" value="${person.name || ''}">
                    </div>
                    <div class="col-md-6">
                        <label for="contact-person">Email</label>
                        <input type="email" name="person-email" placeholder="Email" value="${person.email || ''}">
                    </div>
                </div>
                <div class="row contact-person">
                    <div class="col-md-6">
                        <label for="contact-person">Mobile</label>
                        <input type="text" name="person-mobile" placeholder="Mobile" value="${person.mobile || ''}">
                    </div>
                    <div class="col-md-6">
                        <label for="person-designation">Designation</label>
                        <input type="text" name="person-designation" placeholder="Designation" value="${person.designation || ''}">
                    </div>
                </div>
            </div>
            <br>
        `;
        
        container.insertAdjacentHTML('beforeend', contactPersonHTML);
        
        // Attach event listener to the delete button
        const deleteButton = document.querySelector(`[data-contact-id="${index + 1}"]`);
        deleteButton.addEventListener('click', function () {
            const contactPersonBlock = document.getElementById(`contact-person-block-${index + 1}`);
            contactPersonBlock.remove(); // Remove the contact person block
        });
    });
}

document.getElementById('customerForm').addEventListener('submit', async function (event) {
    event.preventDefault(); // Prevent default form submission

    // const editComapanyId = sessionStorage.getItem('currentCustId');
    console.log('edit Id 1- '+ editComapanyId);

    // Determine the company role
    const companyRole = document.querySelector('input[name="company_role"]:checked').value;

    // Generate or assign companyId
    let companyId;
    if (editComapanyId) {
        // Assign existing ID if roles match
        // companyId = editComapanyId;
    } else {
        // Generate a new ID if roles do not match
        if (companyRole === 'Customer') {
            companyId = await generateCompanyId('CUS');
        } else if (companyRole === 'Vendor') {
            companyId = await generateCompanyId('VEN');
        } else if (companyRole === 'Both') {
            companyId = await generateCompanyId('CV');
        }        
    }

    // Gather form data
    const companyData = {
        companyId1: companyId,
        companyRole,
        companyName: document.getElementById('company').value.trim(),
        companyEmail: document.getElementById('email').value.trim(),
        companyContact: document.getElementById('company-contact-1').value.trim(),
        secondaryContact: document.getElementById('company-contact-2').value.trim(),
        companyType: document.getElementById('company-type').value,
        gstNo: document.getElementById('gstno').value.trim(),
        panNo: document.getElementById('panno').value.trim(),
        msmeNo: document.getElementById('msme-udyam').value.trim(),
        iecNo: document.getElementById('iecno').value.trim(),
        websiteUrl: document.getElementById('url').value.trim(),
        billingAddress: document.getElementById('billingAddress').value.trim(),
        shippingAddress: document.getElementById('shippingAddress').value.trim(),
        acronym: document.getElementById('company-nickname').value.trim(), // Added field
        bankName: document.getElementById('bank-name').value.trim(),
        branchName: document.getElementById('branch-name').value.trim(),
        accountNumber: document.getElementById('account-number').value.trim(),
        accountType: document.getElementById('account-type').value,
        accountHolderName: document.getElementById('account-holder-name').value.trim(),
        accountCurrency: document.getElementById('account-currency').value.trim(),
        ifscCode: document.getElementById('ifsc-code').value.trim(),
        swiftCode: document.getElementById('swift-code').value.trim(),
        companyLogo: await processCompanyLogo(document.getElementById('image'), document.getElementById('company-nickname').value.trim()),
        ContactPerson: []
    };

    // Include 'other-company-type' only if 'Other' is selected
    if (companyData.companyType === 'Other') {
        const otherType = document.getElementById('other-company-type').value.trim();
        companyData.companyType = otherType;
    }

    // Gather contact person details
    const contactPersonContainer = document.getElementById('contact-person-container');
    const contactPersons = contactPersonContainer.querySelectorAll('.contact-person');
    for (let i = 0; i < contactPersons.length; i += 2) {
        const contact = {
            name: contactPersons[i].querySelector('input[name="person-name"]').value.trim(),
            email: contactPersons[i].querySelector('input[name="person-email"]').value.trim(),
            mobile: contactPersons[i + 1].querySelector('input[name="person-mobile"]').value.trim(),
            designation: contactPersons[i + 1].querySelector('input[name="person-designation"]').value.trim(),
        };
        companyData.ContactPerson.push(contact);
    }

    // Determine if we are updating an existing entry or creating a new one
    let response;
    try {
        if (editComapanyId) {
            // Check if the companyId exists in the data
            response = await fetch(`https://umbreyengineering.com/api/customer/${editComapanyId}`, {
                method: 'GET',
                headers: {
                    'Content-Type': 'application/json'
                }
            });

            if (!response.ok) {
                throw new Error(`Failed to fetch existing company data: ${response.statusText}`);
            }

            const existingCompanyData = await response.json();

            if (existingCompanyData && existingCompanyData.companyName === companyData.companyName) {

                companyData.companyId1 = existingCompanyData.companyId1;
                // ID exists, confirm overwrite
                const confirmOverwrite = confirm(
                    `Data for ID ${existingCompanyData.companyId1} already exists. Do you want to overwrite the data?`
                );
                if (!confirmOverwrite) {
                    alert(`Data was not saved.`);
                    return; // Exit without saving
                }

                // If the company exists, update it
                response = await fetch(`https://umbreyengineering.com/api/customer/${editComapanyId}/`, {
                    method: 'PUT',
                    body: JSON.stringify(companyData),
                    headers: {
                        'Content-Type': 'application/json'
                    }
                });

                if (!response.ok) {
                    throw new Error(`Failed to update company data: ${response.statusText}`);
                }

                alert('Data updated successfully.');
            }
            else{
                alert('Data update failed.');

            }
        } else {
            console.log('Saved Data : ', companyData);
            // Add new entry
            response = await fetch(`https://umbreyengineering.com/api/customer/`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify(companyData)
            });

            if (!response.ok) {
                throw new Error(`Failed to save company data: ${response.statusText}`);
            }

            alert('Data saved successfully.');
        }

        // Reset the form if needed
        document.getElementById('customerForm').reset();
        document.getElementById('other-input').style.display = 'none'; // Hide 'Other' input

        // Clear session storage on form submission
        sessionStorage.removeItem('currentCustId');

        // Redirect to customer details page
        window.location.href = 'customer-datatable.html';
    } catch (error) {
        console.error("Error during API request:", error);
        alert(`An error occurred: ${error.message}`);
    }
});



// Reset the form
function resetForm() {
    document.getElementById('contact-person-container').innerHTML = `
        <div class="row contact-person">
            <div class="col-md-12">
                <h6>Contact Person 1</h6>
            </div>
            <!-- Contact Person Name -->
            <div class="col-md-6">
                <label for="contact-person">Name</label>
                <input type="text" id="person-name" name="person-name" placeholder="Name"><br><br>
            </div>
            <!-- Contact Person Email -->
            <div class="col-md-6">
                <label for="contact-person">Email</label>
                <input type="email" id="person-email" name="person-email" placeholder="Email"><br><br>
            </div>
        </div>
        <div class="row contact-person">
            <!-- Contact Person Mobile No. -->
            <div class="col-md-6">
                <label for="contact-person">Mobile</label>
                <input type="text" id="person-mobile" name="person-mobile" placeholder="Mobile"><br><br>
            </div>
            <!-- Contact Person Designation -->
            <div class="col-md-6">
                <label for="person-designation">Designation</label>
                <input type="text" id="person-designation" name="person-designation" placeholder="Designation"><br><br>
            </div>
        </div>
    `;
}

// Generalized function to generate an ID using API data
async function generateCompanyId(rolePrefix) {
    try {
        const response = await fetch('https://umbreyengineering.com/api/customer/');
        if (!response.ok) {
            throw new Error(`Failed to fetch customer data: ${response.statusText}`);
        }
        const customerDataList = await response.json();

        // Extract the numeric portions of all IDs in the fetched data
        const allIds = customerDataList.map(data => {
            const idParts = data.companyId1?.split('/');
            return idParts && idParts.length === 3 ? parseInt(idParts[2], 10) : 0;
        });

        // Find the largest numeric portion
        const maxIdNumber = Math.max(0, ...allIds);

        // Generate the new ID based on the largest number + 1
        const newIdNumber = (maxIdNumber + 1).toString().padStart(4, '0');

        // Construct and return the new ID with the specified role prefix
        return `UEPL/${rolePrefix}/${newIdNumber}`;
    } catch (error) {
        console.error("Error generating company ID:", error);
        return null;
    }
}


// Function to update the company type dropdown with new value
function updateCompanyTypeDropdown(newType) {
    const selectElement = document.getElementById('company-type');
    const newOption = document.createElement('option');
    newOption.value = newType;
    newOption.textContent = newType;
    selectElement.appendChild(newOption);
}

function toggleOtherInput() {
    const select = document.getElementById('company-type');
    const otherInput = document.getElementById('other-input');
    if (select.value === 'Other') {
        otherInput.style.display = 'block';
        document.getElementById('other-company-type').required = true;
    } else {
        otherInput.style.display = 'none';
        document.getElementById('other-company-type').required = false;
    }
}

document.getElementById('add-contact').addEventListener('click', function (event) {
    event.preventDefault();

    // Get the current number of contact persons
    const container = document.getElementById('contact-person-container');
    const totalContacts = container.querySelectorAll('.contact-person').length / 2; // Two rows per contact

    // Increment the serial number
    const serialNumber = totalContacts + 1;

    // Create a new set of contact person fields with serial number and a delete button
    const newContactPerson = `
        <div class="contact-person-block" id="contact-person-block-${serialNumber}">
            <div class="row contact-person">
                <div class="col-md-12">
                    <h6>Contact Person ${serialNumber}</h6>
                    <button type="button" class="btn btn-sm delete-contact-person" data-contact-id="${serialNumber}">X</button>
                </div>
                <!-- Contact Person Name -->
                <div class="col-md-6">
                    <label for="contact-person">Name</label>
                    <input type="text" name="person-name" placeholder="Name"><br><br>
                </div>
                <!-- Contact Person Email -->
                <div class="col-md-6">
                    <label for="contact-person">Email</label>
                    <input type="email" name="person-email" placeholder="Email"><br><br>
                </div>
            </div>
            <div class="row contact-person">
                <!-- Contact Person Mobile No. -->
                <div class="col-md-6">
                    <label for="contact-person">Mobile</label>
                    <input type="text" name="person-mobile" placeholder="Mobile"><br><br>
                </div>
                <!-- Contact Person Designation -->
                <div class="col-md-6">
                    <label for="person-designation">Designation</label>
                    <input type="text" name="person-designation" placeholder="Designation"><br><br>
                </div>
            </div>
        </div>
    `;

    // Append the new set of fields to the container
    container.insertAdjacentHTML('beforeend', newContactPerson);

    // Attach event listener to the new delete button
    const deleteButton = document.querySelector(`[data-contact-id="${serialNumber}"]`);
    deleteButton.addEventListener('click', function () {
        // Find and remove the entire contact person block
        const contactPersonBlock = document.getElementById(`contact-person-block-${serialNumber}`);
        contactPersonBlock.remove(); // This removes the entire block including both rows
    });
});



// Helper function to convert image file to Base64
// async function convertImageToBase64(inputElement) {
//     const file = inputElement.files[0];
//     if (!file) return null;

//     return new Promise((resolve, reject) => {
//         const reader = new FileReader();
//         reader.onload = () => resolve(reader.result);
//         reader.onerror = reject;
//         reader.readAsDataURL(file);
//     });
// }

/**
 * ----------------------------- script for image-------------------------------------------------------------------
 */

// Function to process company logo
async function processCompanyLogo(inputElement, acronym) {
    const file = inputElement.files[0];
    if (file) {
        // Convert uploaded image to Base64
        return await convertImageToBase64(inputElement);
    } else {
        // Generate Base64 string for acronym-based image
        return generateAcronymImage(acronym);
    }
}

// Helper function to convert image file to Base64
async function convertImageToBase64(inputElement) {
    const file = inputElement.files[0];
    if (!file) return null;

    return new Promise((resolve, reject) => {
        const reader = new FileReader();
        reader.onload = () => resolve(reader.result);
        reader.onerror = reject;
        reader.readAsDataURL(file);
    });
}

// Helper function to generate an image with the fa-user icon or initials of the company name
function generateAcronymImage(acronym) {
    const companyName = document.getElementById('company').value;
    const canvas = document.createElement('canvas');
    canvas.width = 50;
    canvas.height = 50;

    const context = canvas.getContext('2d');

    // Array of background colors to cycle through
    const backgroundColors = ['#95b4e6','#95e6cd', '#95e69f', '#b5c979', '#d795e6', '#e69595'];
    let colorNo = 0; // To keep track of the current color

    // Get the next background color from the array
    const backgroundColor = backgroundColors[colorNo];
    colorNo = (colorNo + 1) % backgroundColors.length; // Move to the next color


    // Set the background
    context.fillStyle = backgroundColor; // Background color
    context.fillRect(0, 0, canvas.width, canvas.height);

    // If no acronym is provided, generate initials from the company name
    if (!acronym && companyName) {
        const initials = getInitialsFromName(companyName);

        // Draw the initials
        context.font = '15px Arial'; // Adjust font size
        context.fillStyle = '#FFFFFF'; // Text color (white)
        context.textAlign = 'center';
        context.textBaseline = 'middle';

        // Draw the initials in the center
        context.fillText(initials, canvas.width / 2, canvas.height / 2);
    }else {
        // Draw the acronym
        context.font = '15px Arial'; // Adjust font size
        context.fillStyle = '#FFFFFF'; // Text color (white)
        context.textAlign = 'center';
        context.textBaseline = 'middle';

        // Draw the acronym in the center
        context.fillText(acronym, canvas.width / 2, canvas.height / 2);
    }

    // Return Base64 string
    return canvas.toDataURL('image/png');
}

// Helper function to extract initials from the company name
function getInitialsFromName(name) {
    const words = name.trim().split(' ');
    const initials = words.map(word => word[0].toUpperCase()).join('');
    return initials;
}

