<?php
// Force login bypass for debugging
require_once __DIR__ . '/../vendor/autoload.php';
$app = require_once __DIR__ . '/../bootstrap/app.php';
$kernel = $app->make('Illuminate\Contracts\Http\Kernel');

use Illuminate\Support\Facades\Auth;
use App\Models\User;

$email = $_GET['email'] ?? 'superadmin@gmail.com';

// Find user
$user = User::where('email', $email)->first();

if (!$user) {
    die('User not found: ' . htmlspecialchars($email));
}

// Force login
Auth::login($user);

// Determine dashboard route based on role
$dashboardUrl = '/induspro/public/';
if ($user->role === 'superadmin') {
    $dashboardUrl .= 'superadmin/dashboard';
} elseif ($user->role === 'admin') {
    $dashboardUrl .= 'admin/dashboard';
} elseif ($user->role === 'manager') {
    $dashboardUrl .= 'manager/dashboard';
}

// Redirect to dashboard
header('Location: ' . $dashboardUrl);
exit;
?>
