<?php

use Illuminate\Database\Seeder;
use App\Models\ProductType;
use App\Models\Process;

class ProductTypeAndProcessSeeder extends Seeder
{
    public function run()
    {
        $types = [
            'Round Shaft' => [
                "RM Testing", "RM Cutting", "Facing & Centering", "Pre Turning", "CNC Turning", "Face Hole",
                "Cross Hole", "Deep Hole Drilling", "Re Centring", "Key Way Milling", "Grinding", "Burnishing",
                "Face Hole tapping", "Deburring & Cleaning", "Final Inspection", "Packing"
            ],
            'Rib Shaft' => [
                "RM Testing", "RM Cutting", "Facing & Centering", "Pre Turning", "Plate Cutting", "Plate Drilling", "Chamfering",
                "RIB Setting", "Root Welding", "SAW Welding", "DP Testing 1", "Face Welding", "Grinding", "Stress Relieving", "Shot Blasting",
                "DP Testing 2", "CNC Turning", "Face Hole", "Cross Hole", "Deep Hole Drilling", "Re Centring", "Key Way Milling", "Grinding",
                "Burnishing", "Face Hole tapping", "Deburring & Cleaning", "Final Inspection", "Packing"
            ]
        ];

        foreach ($types as $typeName => $processList) {
            $productType = ProductType::create(['name' => $typeName]);
            foreach ($processList as $order => $processName) {
                Process::create([
                    'product_type_id' => $productType->id,
                    'name' => $processName,
                    'order' => $order + 1
                ]);
            }
        }
    }
}