<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('employee_salary_structures', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('employee_id'); 
            // $table->foreignId('employee_id')->constrained('employees')->onDelete('cascade');
            $table->decimal('basic_da', 10, 2)->default(0);
            $table->decimal('hra', 10, 2)->default(0);
            $table->decimal('conveyance', 10, 2)->default(0);
            $table->decimal('washing_allowance', 10, 2)->default(0);
            $table->decimal('fixed_salary', 10, 2)->default(0);
            $table->decimal('pf_percentage', 5, 2)->nullable()->comment('Override global PF % if needed');
            $table->decimal('esi_percentage', 5, 2)->nullable()->comment('Override global ESI % if needed');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('employee_salary_structures');
    }
};
