<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('grn_product_details', function (Blueprint $table) {
            if (!Schema::hasColumn('grn_product_details', 'sku_id')) {
                $table->unsignedBigInteger('sku_id')->nullable()->after('grn_id');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('grn_product_details', function (Blueprint $table) {
            if (Schema::hasColumn('grn_product_details', 'sku_id')) {
                $table->dropColumn('sku_id');
            }
        });
    }
};
