<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('qc_approvals', function (Blueprint $table) {
            $table->enum('stage', ['before', 'during', 'after'])->default('after')->after('status');
            $table->json('parameters')->nullable()->after('stage');
            $table->text('rejection_reason')->nullable()->after('parameters');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('qc_approvals', function (Blueprint $table) {
            //
        });
    }
};
