<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('route_cards', function (Blueprint $table) {
            $table->enum('priority', ['High', 'Medium', 'Low'])->default('Medium')->after('status');
            $table->enum('approval_status', ['Draft', 'Pending', 'Approved'])->default('Draft')->after('priority');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('route_cards', function (Blueprint $table) {
            //
        });
    }
};
