<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('purchase_debit_notes', function (Blueprint $table) {
            $table->id();
            $table->date('date');
            $table->string('debit_note_no')->unique();
            $table->string('invoice_no');
            $table->unsignedBigInteger('party_id');
            $table->decimal('amount', 15, 2);
            $table->string('reason')->nullable();
            $table->text('description')->nullable();
            $table->timestamps();

            // $table->foreign('party_id')->references('id')->on('customer_vendors')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('purchase_debit_notes');
    }
};
