<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('sales_debit_notes', function (Blueprint $table) {
            $table->id();
            $table->string('debit_note_no')->unique();
            $table->date('date');
            $table->string('invoice_no');
            $table->unsignedBigInteger('party_id'); // Linked to CutomerVendor
            $table->decimal('amount', 15, 2);
            $table->string('reason')->nullable();
            $table->text('description')->nullable();
            $table->timestamps();

             // Foreign key constraint if desired, but invoice_no is string in other tables so maybe loose link?
             // party_id should be foreign key
             // $table->foreign('party_id')->references('id')->on('customer_vendors')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('sales_debit_notes');
    }
};
