<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('sales_credit_notes', function (Blueprint $table) {
            $table->id();
            $table->string('credit_note_no')->unique();
            $table->date('date');
            $table->string('invoice_no')->nullable();
            $table->foreignId('party_id')->constrained('customer_vendors')->onDelete('cascade');
            $table->decimal('amount', 15, 2);
            $table->string('reason')->nullable();
            $table->text('description')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('sales_credit_notes');
    }
};
