<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('purchase_rfq_items', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('rfq_id');
            $table->string('item')->nullable();
            $table->string('description')->nullable();
            $table->integer('quantity')->nullable();
            $table->string('uom')->nullable();
            $table->date('required_by')->nullable();
            $table->timestamps();

            $table->foreign('rfq_id')->references('id')->on('purchase_rfqs')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('purchase_rfq_items');
    }
};
